/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundResetScorePacket;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardDisplayObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardObjective;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardScore;
import net.minecraft.network.protocol.game.PacketPlayOutScoreboardTeam;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.saveddata.SavedDataType;
import net.minecraft.world.scores.DisplaySlot;
import net.minecraft.world.scores.PersistentScoreboard;
import net.minecraft.world.scores.PlayerScoreEntry;
import net.minecraft.world.scores.ScoreHolder;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;
import net.minecraft.world.scores.ScoreboardScore;
import net.minecraft.world.scores.ScoreboardTeam;
import net.minecraft.world.waypoints.WaypointTransmitter;

public class ScoreboardServer
extends Scoreboard {
    public static final SavedDataType<PersistentScoreboard> TYPE = new SavedDataType<PersistentScoreboard>("scoreboard", var0 -> var0.levelOrThrow().getScoreboard().createData(), var0 -> {
        ScoreboardServer var1 = var0.levelOrThrow().getScoreboard();
        return PersistentScoreboard.a.CODEC.xmap(var1::createData, PersistentScoreboard::pack);
    }, DataFixTypes.SAVED_DATA_SCOREBOARD);
    private final MinecraftServer server;
    private final Set<ScoreboardObjective> trackedObjectives = Sets.newHashSet();
    private final List<Runnable> dirtyListeners = Lists.newArrayList();

    public ScoreboardServer(MinecraftServer var0) {
        this.server = var0;
    }

    @Override
    protected void onScoreChanged(ScoreHolder var0, ScoreboardObjective var1, ScoreboardScore var2) {
        super.onScoreChanged(var0, var1, var2);
        if (this.trackedObjectives.contains(var1)) {
            this.server.getPlayerList().broadcastAll(new PacketPlayOutScoreboardScore(var0.getScoreboardName(), var1.getName(), var2.value(), Optional.ofNullable(var2.display()), Optional.ofNullable(var2.numberFormat())));
        }
        this.setDirty();
    }

    @Override
    protected void onScoreLockChanged(ScoreHolder var0, ScoreboardObjective var1) {
        super.onScoreLockChanged(var0, var1);
        this.setDirty();
    }

    @Override
    public void onPlayerRemoved(ScoreHolder var0) {
        super.onPlayerRemoved(var0);
        this.server.getPlayerList().broadcastAll(new ClientboundResetScorePacket(var0.getScoreboardName(), null));
        this.setDirty();
    }

    @Override
    public void onPlayerScoreRemoved(ScoreHolder var0, ScoreboardObjective var1) {
        super.onPlayerScoreRemoved(var0, var1);
        if (this.trackedObjectives.contains(var1)) {
            this.server.getPlayerList().broadcastAll(new ClientboundResetScorePacket(var0.getScoreboardName(), var1.getName()));
        }
        this.setDirty();
    }

    @Override
    public void setDisplayObjective(DisplaySlot var0, @Nullable ScoreboardObjective var1) {
        ScoreboardObjective var2 = this.getDisplayObjective(var0);
        super.setDisplayObjective(var0, var1);
        if (var2 != var1 && var2 != null) {
            if (this.getObjectiveDisplaySlotCount(var2) > 0) {
                this.server.getPlayerList().broadcastAll(new PacketPlayOutScoreboardDisplayObjective(var0, var1));
            } else {
                this.stopTrackingObjective(var2);
            }
        }
        if (var1 != null) {
            if (this.trackedObjectives.contains(var1)) {
                this.server.getPlayerList().broadcastAll(new PacketPlayOutScoreboardDisplayObjective(var0, var1));
            } else {
                this.startTrackingObjective(var1);
            }
        }
        this.setDirty();
    }

    @Override
    public boolean addPlayerToTeam(String var0, ScoreboardTeam var1) {
        if (super.addPlayerToTeam(var0, var1)) {
            this.server.getPlayerList().broadcastAll(PacketPlayOutScoreboardTeam.createPlayerPacket(var1, var0, PacketPlayOutScoreboardTeam.a.ADD));
            this.updatePlayerWaypoint(var0);
            this.setDirty();
            return true;
        }
        return false;
    }

    @Override
    public void removePlayerFromTeam(String var0, ScoreboardTeam var1) {
        super.removePlayerFromTeam(var0, var1);
        this.server.getPlayerList().broadcastAll(PacketPlayOutScoreboardTeam.createPlayerPacket(var1, var0, PacketPlayOutScoreboardTeam.a.REMOVE));
        this.updatePlayerWaypoint(var0);
        this.setDirty();
    }

    @Override
    public void onObjectiveAdded(ScoreboardObjective var0) {
        super.onObjectiveAdded(var0);
        this.setDirty();
    }

    @Override
    public void onObjectiveChanged(ScoreboardObjective var0) {
        super.onObjectiveChanged(var0);
        if (this.trackedObjectives.contains(var0)) {
            this.server.getPlayerList().broadcastAll(new PacketPlayOutScoreboardObjective(var0, 2));
        }
        this.setDirty();
    }

    @Override
    public void onObjectiveRemoved(ScoreboardObjective var0) {
        super.onObjectiveRemoved(var0);
        if (this.trackedObjectives.contains(var0)) {
            this.stopTrackingObjective(var0);
        }
        this.setDirty();
    }

    @Override
    public void onTeamAdded(ScoreboardTeam var0) {
        super.onTeamAdded(var0);
        this.server.getPlayerList().broadcastAll(PacketPlayOutScoreboardTeam.createAddOrModifyPacket(var0, true));
        this.setDirty();
    }

    @Override
    public void onTeamChanged(ScoreboardTeam var0) {
        super.onTeamChanged(var0);
        this.server.getPlayerList().broadcastAll(PacketPlayOutScoreboardTeam.createAddOrModifyPacket(var0, false));
        this.updateTeamWaypoints(var0);
        this.setDirty();
    }

    @Override
    public void onTeamRemoved(ScoreboardTeam var0) {
        super.onTeamRemoved(var0);
        this.server.getPlayerList().broadcastAll(PacketPlayOutScoreboardTeam.createRemovePacket(var0));
        this.updateTeamWaypoints(var0);
        this.setDirty();
    }

    public void addDirtyListener(Runnable var0) {
        this.dirtyListeners.add(var0);
    }

    protected void setDirty() {
        for (Runnable var1 : this.dirtyListeners) {
            var1.run();
        }
    }

    public List<Packet<?>> getStartTrackingPackets(ScoreboardObjective var0) {
        ArrayList var1 = Lists.newArrayList();
        var1.add(new PacketPlayOutScoreboardObjective(var0, 0));
        for (DisplaySlot var5 : DisplaySlot.values()) {
            if (this.getDisplayObjective(var5) != var0) continue;
            var1.add(new PacketPlayOutScoreboardDisplayObjective(var5, var0));
        }
        for (PlayerScoreEntry var3 : this.listPlayerScores(var0)) {
            var1.add(new PacketPlayOutScoreboardScore(var3.owner(), var0.getName(), var3.value(), Optional.ofNullable(var3.display()), Optional.ofNullable(var3.numberFormatOverride())));
        }
        return var1;
    }

    public void startTrackingObjective(ScoreboardObjective var0) {
        List<Packet<?>> var1 = this.getStartTrackingPackets(var0);
        for (EntityPlayer var3 : this.server.getPlayerList().getPlayers()) {
            for (Packet<?> var5 : var1) {
                var3.connection.send(var5);
            }
        }
        this.trackedObjectives.add(var0);
    }

    public List<Packet<?>> getStopTrackingPackets(ScoreboardObjective var0) {
        ArrayList var1 = Lists.newArrayList();
        var1.add(new PacketPlayOutScoreboardObjective(var0, 1));
        for (DisplaySlot var5 : DisplaySlot.values()) {
            if (this.getDisplayObjective(var5) != var0) continue;
            var1.add(new PacketPlayOutScoreboardDisplayObjective(var5, var0));
        }
        return var1;
    }

    public void stopTrackingObjective(ScoreboardObjective var0) {
        List<Packet<?>> var1 = this.getStopTrackingPackets(var0);
        for (EntityPlayer var3 : this.server.getPlayerList().getPlayers()) {
            for (Packet<?> var5 : var1) {
                var3.connection.send(var5);
            }
        }
        this.trackedObjectives.remove(var0);
    }

    public int getObjectiveDisplaySlotCount(ScoreboardObjective var0) {
        int var1 = 0;
        for (DisplaySlot var5 : DisplaySlot.values()) {
            if (this.getDisplayObjective(var5) != var0) continue;
            ++var1;
        }
        return var1;
    }

    private PersistentScoreboard createData() {
        PersistentScoreboard var0 = new PersistentScoreboard(this);
        this.addDirtyListener(var0::setDirty);
        return var0;
    }

    private PersistentScoreboard createData(PersistentScoreboard.a var0) {
        PersistentScoreboard var1 = this.createData();
        var1.loadFrom(var0);
        return var1;
    }

    private void updatePlayerWaypoint(String var0) {
        WorldServer worldServer;
        EntityPlayer var1 = this.server.getPlayerList().getPlayerByName(var0);
        if (var1 != null && (worldServer = var1.level()) instanceof WorldServer) {
            WorldServer var2 = worldServer;
            var2.getWaypointManager().remakeConnections(var1);
        }
    }

    private void updateTeamWaypoints(ScoreboardTeam var02) {
        for (WorldServer var2 : this.server.getAllLevels()) {
            var02.getPlayers().stream().map(var0 -> this.server.getPlayerList().getPlayerByName((String)var0)).filter(Objects::nonNull).forEach(var1 -> var2.getWaypointManager().remakeConnections((WaypointTransmitter)var1));
        }
    }
}

