/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.PermissionSource;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.ChaseCommand;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDebug;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.DialogCommand;
import net.minecraft.server.commands.FetchProfileCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PermissionCheck;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.RotateCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.VersionCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.WaypointCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.Profiler;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import org.slf4j.Logger;

public class CommandDispatcher {
    public static final String COMMAND_PREFIX = "/";
    private static final ThreadLocal<ExecutionContext<CommandListenerWrapper>> CURRENT_EXECUTION_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private static final PacketPlayOutCommands.e<CommandListenerWrapper> COMMAND_NODE_INSPECTOR = new PacketPlayOutCommands.e<CommandListenerWrapper>(){

        @Override
        @Nullable
        public MinecraftKey suggestionId(ArgumentCommandNode<CommandListenerWrapper, ?> var0) {
            SuggestionProvider var1 = var0.getCustomSuggestions();
            return var1 != null ? CompletionProviders.getName(var1) : null;
        }

        @Override
        public boolean isExecutable(CommandNode<CommandListenerWrapper> var0) {
            return var0.getCommand() != null;
        }

        @Override
        public boolean isRestricted(CommandNode<CommandListenerWrapper> var0) {
            PermissionCheck var1;
            Predicate predicate = var0.getRequirement();
            return predicate instanceof PermissionCheck && (var1 = (PermissionCheck)predicate).requiredLevel() > 0;
        }
    };
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher = new com.mojang.brigadier.CommandDispatcher();

    public CommandDispatcher(ServerType var0, CommandBuildContext var1) {
        CommandAdvancement.register(this.dispatcher);
        CommandAttribute.register(this.dispatcher, var1);
        CommandExecute.register(this.dispatcher, var1);
        CommandBossBar.register(this.dispatcher, var1);
        CommandClear.register(this.dispatcher, var1);
        CommandClone.register(this.dispatcher, var1);
        DamageCommand.register(this.dispatcher, var1);
        CommandData.register(this.dispatcher);
        CommandDatapack.register(this.dispatcher, var1);
        CommandDebug.register(this.dispatcher);
        CommandGamemodeDefault.register(this.dispatcher);
        DialogCommand.register(this.dispatcher, var1);
        CommandDifficulty.register(this.dispatcher);
        CommandEffect.register(this.dispatcher, var1);
        CommandMe.register(this.dispatcher);
        CommandEnchant.register(this.dispatcher, var1);
        CommandXp.register(this.dispatcher);
        CommandFill.register(this.dispatcher, var1);
        FillBiomeCommand.register(this.dispatcher, var1);
        CommandForceload.register(this.dispatcher);
        CommandFunction.register(this.dispatcher);
        CommandGamemode.register(this.dispatcher);
        CommandGamerule.register(this.dispatcher, var1);
        CommandGive.register(this.dispatcher, var1);
        CommandHelp.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, var1);
        CommandKick.register(this.dispatcher);
        CommandKill.register(this.dispatcher);
        CommandList.register(this.dispatcher);
        CommandLocate.register(this.dispatcher, var1);
        CommandLoot.register(this.dispatcher, var1);
        CommandTell.register(this.dispatcher);
        CommandParticle.register(this.dispatcher, var1);
        PlaceCommand.register(this.dispatcher);
        CommandPlaySound.register(this.dispatcher);
        RandomCommand.register(this.dispatcher);
        CommandReload.register(this.dispatcher);
        CommandRecipe.register(this.dispatcher);
        FetchProfileCommand.register(this.dispatcher);
        ReturnCommand.register(this.dispatcher);
        RideCommand.register(this.dispatcher);
        RotateCommand.register(this.dispatcher);
        CommandSay.register(this.dispatcher);
        CommandSchedule.register(this.dispatcher);
        CommandScoreboard.register(this.dispatcher, var1);
        CommandSeed.register(this.dispatcher, var0 != ServerType.INTEGRATED);
        VersionCommand.register(this.dispatcher, var0 != ServerType.INTEGRATED);
        CommandSetBlock.register(this.dispatcher, var1);
        CommandSpawnpoint.register(this.dispatcher);
        CommandSetWorldSpawn.register(this.dispatcher);
        CommandSpectate.register(this.dispatcher);
        CommandSpreadPlayers.register(this.dispatcher);
        CommandStopSound.register(this.dispatcher);
        CommandSummon.register(this.dispatcher, var1);
        CommandTag.register(this.dispatcher);
        CommandTeam.register(this.dispatcher, var1);
        CommandTeamMsg.register(this.dispatcher);
        CommandTeleport.register(this.dispatcher);
        CommandTellRaw.register(this.dispatcher, var1);
        GameTestHarnessTestCommand.register(this.dispatcher, var1);
        TickCommand.register(this.dispatcher);
        CommandTime.register(this.dispatcher);
        CommandTitle.register(this.dispatcher, var1);
        CommandTrigger.register(this.dispatcher);
        WaypointCommand.register(this.dispatcher, var1);
        CommandWeather.register(this.dispatcher);
        CommandWorldBorder.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.DEBUG_CHASE_COMMAND) {
            ChaseCommand.register(this.dispatcher);
        }
        if (SharedConstants.DEBUG_DEV_COMMANDS || SharedConstants.IS_RUNNING_IN_IDE) {
            RaidCommand.register(this.dispatcher, var1);
            DebugPathCommand.register(this.dispatcher);
            DebugMobSpawningCommand.register(this.dispatcher);
            WardenSpawnTrackerCommand.register(this.dispatcher);
            SpawnArmorTrimsCommand.register(this.dispatcher);
            ServerPackCommand.register(this.dispatcher);
            if (var0.includeDedicated) {
                DebugConfigCommand.register(this.dispatcher, var1);
            }
        }
        if (var0.includeDedicated) {
            CommandBanIp.register(this.dispatcher);
            CommandBanList.register(this.dispatcher);
            CommandBan.register(this.dispatcher);
            CommandDeop.register(this.dispatcher);
            CommandOp.register(this.dispatcher);
            CommandPardon.register(this.dispatcher);
            CommandPardonIP.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            CommandSaveAll.register(this.dispatcher);
            CommandSaveOff.register(this.dispatcher);
            CommandSaveOn.register(this.dispatcher);
            CommandIdleTimeout.register(this.dispatcher);
            CommandStop.register(this.dispatcher);
            TransferCommand.register(this.dispatcher);
            CommandWhitelist.register(this.dispatcher);
        }
        if (var0.includeIntegrated) {
            CommandPublish.register(this.dispatcher);
        }
        this.dispatcher.setConsumer(ExecutionCommandSource.resultConsumer());
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> var0, UnaryOperator<S> var1) {
        CommandContextBuilder var2 = var0.getContext();
        CommandContextBuilder var3 = var2.withSource(var1.apply(var2.getSource()));
        return new ParseResults(var3, var0.getReader(), var0.getExceptions());
    }

    public void performPrefixedCommand(CommandListenerWrapper var0, String var1) {
        var1 = CommandDispatcher.trimOptionalPrefix(var1);
        this.performCommand((ParseResults<CommandListenerWrapper>)this.dispatcher.parse(var1, (Object)var0), var1);
    }

    public static String trimOptionalPrefix(String var0) {
        return var0.startsWith(COMMAND_PREFIX) ? var0.substring(1) : var0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandListenerWrapper> var0, String var12) {
        CommandListenerWrapper var2 = (CommandListenerWrapper)var0.getContext().getSource();
        Profiler.get().push(() -> COMMAND_PREFIX + var12);
        ContextChain<CommandListenerWrapper> var32 = CommandDispatcher.finishParsing(var0, var12, var2);
        try {
            if (var32 != null) {
                CommandDispatcher.executeCommandInContext(var2, var3 -> ExecutionContext.queueInitialCommandExecution(var3, var12, var32, var2, CommandResultCallback.EMPTY));
            }
        }
        catch (Exception var4) {
            IChatMutableComponent var5 = IChatBaseComponent.literal(var4.getMessage() == null ? var4.getClass().getName() : var4.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Command exception: /{}", (Object)var12, (Object)var4);
                StackTraceElement[] var6 = var4.getStackTrace();
                for (int var7 = 0; var7 < Math.min(var6.length, 3); ++var7) {
                    var5.append("\n\n").append(var6[var7].getMethodName()).append("\n ").append(var6[var7].getFileName()).append(":").append(String.valueOf(var6[var7].getLineNumber()));
                }
            }
            var2.sendFailure(IChatBaseComponent.translatable("command.failed").withStyle(var1 -> var1.withHoverEvent(new ChatHoverable.e(var5))));
            if (SharedConstants.DEBUG_VERBOSE_COMMAND_ERRORS || SharedConstants.IS_RUNNING_IN_IDE) {
                var2.sendFailure(IChatBaseComponent.literal(SystemUtils.describeError(var4)));
                LOGGER.error("'/{}' threw an exception", (Object)var12, (Object)var4);
            }
        }
        finally {
            Profiler.get().pop();
        }
    }

    @Nullable
    private static ContextChain<CommandListenerWrapper> finishParsing(ParseResults<CommandListenerWrapper> var0, String var12, CommandListenerWrapper var2) {
        try {
            CommandDispatcher.validateParseResults(var0);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)var0.getContext().build(var12)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(var0.getReader()));
        }
        catch (CommandSyntaxException var3) {
            var2.sendFailure(ChatComponentUtils.fromMessage(var3.getRawMessage()));
            if (var3.getInput() != null && var3.getCursor() >= 0) {
                int var4 = Math.min(var3.getInput().length(), var3.getCursor());
                IChatMutableComponent var5 = IChatBaseComponent.empty().withStyle(EnumChatFormat.GRAY).withStyle(var1 -> var1.withClickEvent(new ChatClickable.SuggestCommand(COMMAND_PREFIX + var12)));
                if (var4 > 10) {
                    var5.append(CommonComponents.ELLIPSIS);
                }
                var5.append(var3.getInput().substring(Math.max(0, var4 - 10), var4));
                if (var4 < var3.getInput().length()) {
                    IChatMutableComponent var6 = IChatBaseComponent.literal(var3.getInput().substring(var4)).withStyle(EnumChatFormat.RED, EnumChatFormat.UNDERLINE);
                    var5.append(var6);
                }
                var5.append(IChatBaseComponent.translatable("command.context.here").withStyle(EnumChatFormat.RED, EnumChatFormat.ITALIC));
                var2.sendFailure(var5);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCommandInContext(CommandListenerWrapper var0, Consumer<ExecutionContext<CommandListenerWrapper>> var1) {
        block9: {
            boolean var4;
            MinecraftServer var2 = var0.getServer();
            ExecutionContext<CommandListenerWrapper> var3 = CURRENT_EXECUTION_CONTEXT.get();
            boolean bl = var4 = var3 == null;
            if (var4) {
                int var5 = Math.max(1, var2.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH));
                int var6 = var2.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_FORK_COUNT);
                try (ExecutionContext var7 = new ExecutionContext(var5, var6, Profiler.get());){
                    CURRENT_EXECUTION_CONTEXT.set(var7);
                    var1.accept(var7);
                    var7.runCommandQueue();
                    break block9;
                }
                finally {
                    CURRENT_EXECUTION_CONTEXT.set(null);
                }
            }
            var1.accept(var3);
        }
    }

    public void sendCommands(EntityPlayer var0) {
        HashMap var1 = new HashMap();
        RootCommandNode var2 = new RootCommandNode();
        var1.put((CommandNode)this.dispatcher.getRoot(), (CommandNode)var2);
        CommandDispatcher.fillUsableCommands(this.dispatcher.getRoot(), var2, var0.createCommandSourceStack(), var1);
        var0.connection.send(new PacketPlayOutCommands(var2, COMMAND_NODE_INSPECTOR));
    }

    private static <S> void fillUsableCommands(CommandNode<S> var0, CommandNode<S> var1, S var2, Map<CommandNode<S>, CommandNode<S>> var3) {
        for (CommandNode var5 : var0.getChildren()) {
            if (!var5.canUse(var2)) continue;
            ArgumentBuilder var6 = var5.createBuilder();
            if (var6.getRedirect() != null) {
                var6.redirect(var3.get(var6.getRedirect()));
            }
            CommandNode var7 = var6.build();
            var3.put(var5, var7);
            var1.addChild(var7);
            if (var5.getChildren().isEmpty()) continue;
            CommandDispatcher.fillUsableCommands(var5, var7, var2, var3);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> literal(String var0) {
        return LiteralArgumentBuilder.literal((String)var0);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> argument(String var0, ArgumentType<T> var1) {
        return RequiredArgumentBuilder.argument((String)var0, var1);
    }

    public static Predicate<String> createValidator(b var0) {
        return var1 -> {
            try {
                var0.parse(new StringReader(var1));
                return true;
            }
            catch (CommandSyntaxException var2) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> getDispatcher() {
        return this.dispatcher;
    }

    public static <S> void validateParseResults(ParseResults<S> var0) throws CommandSyntaxException {
        CommandSyntaxException var1 = CommandDispatcher.getParseException(var0);
        if (var1 != null) {
            throw var1;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> var0) {
        if (!var0.getReader().canRead()) {
            return null;
        }
        if (var0.getExceptions().size() == 1) {
            return (CommandSyntaxException)((Object)var0.getExceptions().values().iterator().next());
        }
        if (var0.getContext().getRange().isEmpty()) {
            return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(var0.getReader());
        }
        return CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(var0.getReader());
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.a var0) {
        return new CommandBuildContext(){

            @Override
            public FeatureFlagSet enabledFeatures() {
                return FeatureFlags.REGISTRY.allFlags();
            }

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> listRegistryKeys() {
                return var0.listRegistryKeys();
            }

            public <T> Optional<HolderLookup.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var02) {
                return var0.lookup(var02).map(this::createLookup);
            }

            private <T> HolderLookup.b.a<T> createLookup(final HolderLookup.b<T> var02) {
                return new HolderLookup.b.a<T>(this){

                    @Override
                    public HolderLookup.b<T> parent() {
                        return var02;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                        return Optional.of(this.getOrThrow(var0));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> var0) {
                        Optional<HolderSet.Named<HolderSet.Named>> var1 = this.parent().get(var0);
                        return var1.orElseGet(() -> HolderSet.emptyNamed(this.parent(), var0));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext var02 = CommandDispatcher.createValidationContext(VanillaRegistries.createLookup());
        com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> var12 = new CommandDispatcher(ServerType.ALL, var02).getDispatcher();
        RootCommandNode var22 = var12.getRoot();
        var12.findAmbiguities((var1, var2, var3, var4) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{var12.getPath(var2), var12.getPath(var3), var4}));
        Set<ArgumentType<?>> var32 = ArgumentUtils.findUsedArgumentTypes(var22);
        Set var42 = var32.stream().filter(var0 -> !ArgumentTypeInfos.isClassRecognized(var0.getClass())).collect(Collectors.toSet());
        if (!var42.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)var42.stream().map(var0 -> "\t" + String.valueOf(var0)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static <T extends PermissionSource> PermissionCheck<T> hasPermission(int var0) {
        return new PermissionSource.a(var0);
    }

    public static final class ServerType
    extends Enum<ServerType> {
        public static final /* enum */ ServerType ALL = new ServerType(true, true);
        public static final /* enum */ ServerType DEDICATED = new ServerType(false, true);
        public static final /* enum */ ServerType INTEGRATED = new ServerType(true, false);
        final boolean includeIntegrated;
        final boolean includeDedicated;
        private static final /* synthetic */ ServerType[] f;

        public static ServerType[] values() {
            return (ServerType[])f.clone();
        }

        public static ServerType valueOf(String var0) {
            return Enum.valueOf(ServerType.class, var0);
        }

        private ServerType(boolean var2, boolean var3) {
            this.includeIntegrated = var2;
            this.includeDedicated = var3;
        }

        private static /* synthetic */ ServerType[] a() {
            return new ServerType[]{ALL, DEDICATED, INTEGRATED};
        }

        static {
            f = ServerType.a();
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

