/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.waypoints;

import com.mojang.datafixers.util.Either;
import com.mojang.logging.LogUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.VarInt;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.waypoints.Waypoint;
import org.apache.commons.lang3.function.TriFunction;
import org.slf4j.Logger;

public abstract class TrackedWaypoint
implements Waypoint {
    static final Logger LOGGER = LogUtils.getLogger();
    public static StreamCodec<ByteBuf, TrackedWaypoint> STREAM_CODEC = StreamCodec.ofMember(TrackedWaypoint::write, TrackedWaypoint::read);
    protected final Either<UUID, String> identifier;
    private final Waypoint.a icon;
    private final g type;

    TrackedWaypoint(Either<UUID, String> var0, Waypoint.a var1, g var2) {
        this.identifier = var0;
        this.icon = var1;
        this.type = var2;
    }

    public Either<UUID, String> id() {
        return this.identifier;
    }

    public abstract void update(TrackedWaypoint var1);

    public void write(ByteBuf var0) {
        PacketDataSerializer var1 = new PacketDataSerializer(var0);
        var1.writeEither(this.identifier, UUIDUtil.STREAM_CODEC, PacketDataSerializer::writeUtf);
        Waypoint.a.STREAM_CODEC.encode(var1, this.icon);
        var1.writeEnum(this.type);
        this.writeContents(var0);
    }

    public abstract void writeContents(ByteBuf var1);

    private static TrackedWaypoint read(ByteBuf var0) {
        PacketDataSerializer var1 = new PacketDataSerializer(var0);
        Either<UUID, String> var2 = var1.readEither(UUIDUtil.STREAM_CODEC, PacketDataSerializer::readUtf);
        Waypoint.a var3 = (Waypoint.a)Waypoint.a.STREAM_CODEC.decode(var1);
        g var4 = var1.readEnum(g.class);
        return (TrackedWaypoint)var4.constructor.apply(var2, (Object)var3, (Object)var1);
    }

    public static TrackedWaypoint setPosition(UUID var0, Waypoint.a var1, BaseBlockPosition var2) {
        return new h(var0, var1, var2);
    }

    public static TrackedWaypoint setChunk(UUID var0, Waypoint.a var1, ChunkCoordIntPair var2) {
        return new c(var0, var1, var2);
    }

    public static TrackedWaypoint setAzimuth(UUID var0, Waypoint.a var1, float var2) {
        return new a(var0, var1, var2);
    }

    public static TrackedWaypoint empty(UUID var0) {
        return new d(var0);
    }

    public abstract double yawAngleToCamera(World var1, b var2);

    public abstract e pitchDirectionToCamera(World var1, f var2);

    public abstract double distanceSquared(Entity var1);

    public Waypoint.a icon() {
        return this.icon;
    }

    static final class g
    extends Enum<g> {
        public static final /* enum */ g EMPTY = new g(d::new);
        public static final /* enum */ g VEC3I = new g(h::new);
        public static final /* enum */ g CHUNK = new g(c::new);
        public static final /* enum */ g AZIMUTH = new g(a::new);
        final TriFunction<Either<UUID, String>, Waypoint.a, PacketDataSerializer, TrackedWaypoint> constructor;
        private static final /* synthetic */ g[] f;

        public static g[] values() {
            return (g[])f.clone();
        }

        public static g valueOf(String var0) {
            return Enum.valueOf(g.class, var0);
        }

        private g(TriFunction var2) {
            this.constructor = var2;
        }

        private static /* synthetic */ g[] a() {
            return new g[]{EMPTY, VEC3I, CHUNK, AZIMUTH};
        }

        static {
            f = g.a();
        }
    }

    static class h
    extends TrackedWaypoint {
        private BaseBlockPosition vector;

        public h(UUID var0, Waypoint.a var1, BaseBlockPosition var2) {
            super((Either<UUID, String>)Either.left((Object)var0), var1, g.VEC3I);
            this.vector = var2;
        }

        public h(Either<UUID, String> var0, Waypoint.a var1, PacketDataSerializer var2) {
            super(var0, var1, g.VEC3I);
            this.vector = new BaseBlockPosition(var2.readVarInt(), var2.readVarInt(), var2.readVarInt());
        }

        @Override
        public void update(TrackedWaypoint var0) {
            if (var0 instanceof h) {
                h var1 = (h)var0;
                this.vector = var1.vector;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", var0.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf var0) {
            VarInt.write(var0, this.vector.getX());
            VarInt.write(var0, this.vector.getY());
            VarInt.write(var0, this.vector.getZ());
        }

        private Vec3D position(World var02) {
            return this.identifier.left().map(var02::getEntity).map(var0 -> {
                if (var0.blockPosition().distManhattan(this.vector) > 3) {
                    return null;
                }
                return var0.getEyePosition();
            }).orElseGet(() -> Vec3D.atCenterOf(this.vector));
        }

        @Override
        public double yawAngleToCamera(World var0, b var1) {
            Vec3D var2 = var1.position().subtract(this.position(var0)).rotateClockwise90();
            float var3 = (float)MathHelper.atan2(var2.z(), var2.x()) * 57.295776f;
            return MathHelper.degreesDifference(var1.yaw(), var3);
        }

        @Override
        public e pitchDirectionToCamera(World var0, f var1) {
            double var4;
            Vec3D var2 = var1.projectPointToScreen(this.position(var0));
            boolean var3 = var2.z > 1.0;
            double d2 = var4 = var3 ? -var2.y : var2.y;
            if (var4 < -1.0) {
                return e.DOWN;
            }
            if (var4 > 1.0) {
                return e.UP;
            }
            if (var3) {
                if (var2.y > 0.0) {
                    return e.UP;
                }
                if (var2.y < 0.0) {
                    return e.DOWN;
                }
            }
            return e.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return var0.distanceToSqr(Vec3D.atCenterOf(this.vector));
        }
    }

    static class c
    extends TrackedWaypoint {
        private ChunkCoordIntPair chunkPos;

        public c(UUID var0, Waypoint.a var1, ChunkCoordIntPair var2) {
            super((Either<UUID, String>)Either.left((Object)var0), var1, g.CHUNK);
            this.chunkPos = var2;
        }

        public c(Either<UUID, String> var0, Waypoint.a var1, PacketDataSerializer var2) {
            super(var0, var1, g.CHUNK);
            this.chunkPos = new ChunkCoordIntPair(var2.readVarInt(), var2.readVarInt());
        }

        @Override
        public void update(TrackedWaypoint var0) {
            if (var0 instanceof c) {
                c var1 = (c)var0;
                this.chunkPos = var1.chunkPos;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", var0.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf var0) {
            VarInt.write(var0, this.chunkPos.x);
            VarInt.write(var0, this.chunkPos.z);
        }

        private Vec3D position(double var0) {
            return Vec3D.atCenterOf(this.chunkPos.getMiddleBlockPosition((int)var0));
        }

        @Override
        public double yawAngleToCamera(World var0, b var1) {
            Vec3D var2 = var1.position();
            Vec3D var3 = var2.subtract(this.position(var2.y())).rotateClockwise90();
            float var4 = (float)MathHelper.atan2(var3.z(), var3.x()) * 57.295776f;
            return MathHelper.degreesDifference(var1.yaw(), var4);
        }

        @Override
        public e pitchDirectionToCamera(World var0, f var1) {
            double var2 = var1.projectHorizonToScreen();
            if (var2 < -1.0) {
                return e.DOWN;
            }
            if (var2 > 1.0) {
                return e.UP;
            }
            return e.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return var0.distanceToSqr(Vec3D.atCenterOf(this.chunkPos.getMiddleBlockPosition(var0.getBlockY())));
        }
    }

    static class a
    extends TrackedWaypoint {
        private float angle;

        public a(UUID var0, Waypoint.a var1, float var2) {
            super((Either<UUID, String>)Either.left((Object)var0), var1, g.AZIMUTH);
            this.angle = var2;
        }

        public a(Either<UUID, String> var0, Waypoint.a var1, PacketDataSerializer var2) {
            super(var0, var1, g.AZIMUTH);
            this.angle = var2.readFloat();
        }

        @Override
        public void update(TrackedWaypoint var0) {
            if (var0 instanceof a) {
                a var1 = (a)var0;
                this.angle = var1.angle;
            } else {
                LOGGER.warn("Unsupported Waypoint update operation: {}", var0.getClass());
            }
        }

        @Override
        public void writeContents(ByteBuf var0) {
            var0.writeFloat(this.angle);
        }

        @Override
        public double yawAngleToCamera(World var0, b var1) {
            return MathHelper.degreesDifference(var1.yaw(), this.angle * 57.295776f);
        }

        @Override
        public e pitchDirectionToCamera(World var0, f var1) {
            double var2 = var1.projectHorizonToScreen();
            if (var2 < -1.0) {
                return e.DOWN;
            }
            if (var2 > 1.0) {
                return e.UP;
            }
            return e.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return Double.POSITIVE_INFINITY;
        }
    }

    static class d
    extends TrackedWaypoint {
        private d(Either<UUID, String> var0, Waypoint.a var1, PacketDataSerializer var2) {
            super(var0, var1, g.EMPTY);
        }

        d(UUID var0) {
            super((Either<UUID, String>)Either.left((Object)var0), Waypoint.a.NULL, g.EMPTY);
        }

        @Override
        public void update(TrackedWaypoint var0) {
        }

        @Override
        public void writeContents(ByteBuf var0) {
        }

        @Override
        public double yawAngleToCamera(World var0, b var1) {
            return Double.NaN;
        }

        @Override
        public e pitchDirectionToCamera(World var0, f var1) {
            return e.NONE;
        }

        @Override
        public double distanceSquared(Entity var0) {
            return Double.POSITIVE_INFINITY;
        }
    }

    public static interface b {
        public float yaw();

        public Vec3D position();
    }

    public static interface f {
        public Vec3D projectPointToScreen(Vec3D var1);

        public double projectHorizonToScreen();
    }

    public static final class e
    extends Enum<e> {
        public static final /* enum */ e NONE = new e();
        public static final /* enum */ e UP = new e();
        public static final /* enum */ e DOWN = new e();
        private static final /* synthetic */ e[] d;

        public static e[] values() {
            return (e[])d.clone();
        }

        public static e valueOf(String var0) {
            return Enum.valueOf(e.class, var0);
        }

        private static /* synthetic */ e[] a() {
            return new e[]{NONE, UP, DOWN};
        }

        static {
            d = e.a();
        }
    }
}

