/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record StorageValue(MinecraftKey storage, ArgumentNBTKey.g path) implements NumberProvider
{
    public static final MapCodec<StorageValue> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)MinecraftKey.CODEC.fieldOf("storage").forGetter(StorageValue::storage), (App)ArgumentNBTKey.g.CODEC.fieldOf("path").forGetter(StorageValue::path)).apply((Applicative)var0, StorageValue::new));

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.STORAGE;
    }

    private Number getNumericTag(LootTableInfo var0, Number var1) {
        NBTTagCompound var2 = var0.getLevel().getServer().getCommandStorage().get(this.storage);
        try {
            NBTBase nBTBase;
            List<NBTBase> var3 = this.path.get(var2);
            if (var3.size() == 1 && (nBTBase = var3.getFirst()) instanceof NBTNumber) {
                NBTNumber var4 = (NBTNumber)nBTBase;
                return var4.box();
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return var1;
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        return this.getNumericTag(var0, Float.valueOf(0.0f)).floatValue();
    }

    @Override
    public int getInt(LootTableInfo var0) {
        return this.getNumericTag(var0, 0).intValue();
    }
}

