/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.util.context.ContextKeySet;
import net.minecraft.world.IInventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootSelector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionUser;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import org.slf4j.Logger;

public class LootTable {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Codec<ResourceKey<LootTable>> KEY_CODEC = ResourceKey.codec(Registries.LOOT_TABLE);
    public static final ContextKeySet DEFAULT_PARAM_SET = LootContextParameterSets.ALL_PARAMS;
    public static final long RANDOMIZE_SEED = 0L;
    public static final Codec<LootTable> DIRECT_CODEC = Codec.lazyInitialized(() -> RecordCodecBuilder.create(var02 -> var02.group((App)LootContextParameterSets.CODEC.lenientOptionalFieldOf("type", (Object)DEFAULT_PARAM_SET).forGetter(var0 -> var0.paramSet), (App)MinecraftKey.CODEC.optionalFieldOf("random_sequence").forGetter(var0 -> var0.randomSequence), (App)LootSelector.CODEC.listOf().optionalFieldOf("pools", List.of()).forGetter(var0 -> var0.pools), (App)LootItemFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(var0 -> var0.functions)).apply((Applicative)var02, LootTable::new)));
    public static final Codec<Holder<LootTable>> CODEC = RegistryFileCodec.create(Registries.LOOT_TABLE, DIRECT_CODEC);
    public static final LootTable EMPTY = new LootTable(LootContextParameterSets.EMPTY, Optional.empty(), List.of(), List.of());
    private final ContextKeySet paramSet;
    private final Optional<MinecraftKey> randomSequence;
    private final List<LootSelector> pools;
    private final List<LootItemFunction> functions;
    private final BiFunction<ItemStack, LootTableInfo, ItemStack> compositeFunction;

    LootTable(ContextKeySet var0, Optional<MinecraftKey> var1, List<LootSelector> var2, List<LootItemFunction> var3) {
        this.paramSet = var0;
        this.randomSequence = var1;
        this.pools = var2;
        this.functions = var3;
        this.compositeFunction = LootItemFunctions.compose(var3);
    }

    public static Consumer<ItemStack> createStackSplitter(WorldServer var0, Consumer<ItemStack> var1) {
        return var2 -> {
            if (!var2.isItemEnabled(var0.enabledFeatures())) {
                return;
            }
            if (var2.getCount() < var2.getMaxStackSize()) {
                var1.accept((ItemStack)var2);
            } else {
                ItemStack var4;
                for (int var3 = var2.getCount(); var3 > 0; var3 -= var4.getCount()) {
                    var4 = var2.copyWithCount(Math.min(var2.getMaxStackSize(), var3));
                    var1.accept(var4);
                }
            }
        };
    }

    public void getRandomItemsRaw(LootParams var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(new LootTableInfo.Builder(var0).create(this.randomSequence), var1);
    }

    public void getRandomItemsRaw(LootTableInfo var0, Consumer<ItemStack> var1) {
        LootTableInfo.c<LootTable> var2 = LootTableInfo.createVisitedEntry(this);
        if (var0.pushVisitedElement(var2)) {
            Consumer<ItemStack> var3 = LootItemFunction.decorate(this.compositeFunction, var1, var0);
            for (LootSelector var5 : this.pools) {
                var5.addRandomItems(var3, var0);
            }
            var0.popVisitedElement(var2);
        } else {
            LOGGER.warn("Detected infinite loop in loot tables");
        }
    }

    public void getRandomItems(LootParams var0, long var1, Consumer<ItemStack> var3) {
        this.getRandomItemsRaw(new LootTableInfo.Builder(var0).withOptionalRandomSeed(var1).create(this.randomSequence), LootTable.createStackSplitter(var0.getLevel(), var3));
    }

    public void getRandomItems(LootParams var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(var0, LootTable.createStackSplitter(var0.getLevel(), var1));
    }

    public void getRandomItems(LootTableInfo var0, Consumer<ItemStack> var1) {
        this.getRandomItemsRaw(var0, LootTable.createStackSplitter(var0.getLevel(), var1));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams var0, RandomSource var1) {
        return this.getRandomItems(new LootTableInfo.Builder(var0).withOptionalRandomSource(var1).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams var0, long var1) {
        return this.getRandomItems(new LootTableInfo.Builder(var0).withOptionalRandomSeed(var1).create(this.randomSequence));
    }

    public ObjectArrayList<ItemStack> getRandomItems(LootParams var0) {
        return this.getRandomItems(new LootTableInfo.Builder(var0).create(this.randomSequence));
    }

    private ObjectArrayList<ItemStack> getRandomItems(LootTableInfo var0) {
        ObjectArrayList var1 = new ObjectArrayList();
        this.getRandomItems(var0, arg_0 -> ((ObjectArrayList)var1).add(arg_0));
        return var1;
    }

    public ContextKeySet getParamSet() {
        return this.paramSet;
    }

    public void validate(LootCollector var0) {
        int var1;
        for (var1 = 0; var1 < this.pools.size(); ++var1) {
            this.pools.get(var1).validate(var0.forChild(new ProblemReporter.d("pools", var1)));
        }
        for (var1 = 0; var1 < this.functions.size(); ++var1) {
            this.functions.get(var1).validate(var0.forChild(new ProblemReporter.d("functions", var1)));
        }
    }

    public void fill(IInventory var0, LootParams var1, long var2) {
        LootTableInfo var4 = new LootTableInfo.Builder(var1).withOptionalRandomSeed(var2).create(this.randomSequence);
        ObjectArrayList<ItemStack> var5 = this.getRandomItems(var4);
        RandomSource var6 = var4.getRandom();
        List<Integer> var7 = this.getAvailableSlots(var0, var6);
        this.shuffleAndSplitItems(var5, var7.size(), var6);
        for (ItemStack var9 : var5) {
            if (var7.isEmpty()) {
                LOGGER.warn("Tried to over-fill a container");
                return;
            }
            if (var9.isEmpty()) {
                var0.setItem(var7.remove(var7.size() - 1), ItemStack.EMPTY);
                continue;
            }
            var0.setItem(var7.remove(var7.size() - 1), var9);
        }
    }

    private void shuffleAndSplitItems(ObjectArrayList<ItemStack> var0, int var1, RandomSource var2) {
        ArrayList var3 = Lists.newArrayList();
        Object var4 = var0.iterator();
        while (var4.hasNext()) {
            ItemStack var5 = (ItemStack)var4.next();
            if (var5.isEmpty()) {
                var4.remove();
                continue;
            }
            if (var5.getCount() <= 1) continue;
            var3.add(var5);
            var4.remove();
        }
        while (var1 - var0.size() - var3.size() > 0 && !var3.isEmpty()) {
            var4 = (ItemStack)var3.remove(MathHelper.nextInt(var2, 0, var3.size() - 1));
            int var5 = MathHelper.nextInt(var2, 1, ((ItemStack)var4).getCount() / 2);
            ItemStack var6 = ((ItemStack)var4).split(var5);
            if (((ItemStack)var4).getCount() > 1 && var2.nextBoolean()) {
                var3.add(var4);
            } else {
                var0.add(var4);
            }
            if (var6.getCount() > 1 && var2.nextBoolean()) {
                var3.add(var6);
                continue;
            }
            var0.add((Object)var6);
        }
        var0.addAll((Collection)var3);
        SystemUtils.shuffle(var0, var2);
    }

    private List<Integer> getAvailableSlots(IInventory var0, RandomSource var1) {
        ObjectArrayList var2 = new ObjectArrayList();
        for (int var3 = 0; var3 < var0.getContainerSize(); ++var3) {
            if (!var0.getItem(var3).isEmpty()) continue;
            var2.add((Object)var3);
        }
        SystemUtils.shuffle(var2, var1);
        return var2;
    }

    public static a lootTable() {
        return new a();
    }

    public static class a
    implements LootItemFunctionUser<a> {
        private final ImmutableList.Builder<LootSelector> pools = ImmutableList.builder();
        private final ImmutableList.Builder<LootItemFunction> functions = ImmutableList.builder();
        private ContextKeySet paramSet = DEFAULT_PARAM_SET;
        private Optional<MinecraftKey> randomSequence = Optional.empty();

        public a withPool(LootSelector.a var0) {
            this.pools.add((Object)var0.build());
            return this;
        }

        public a setParamSet(ContextKeySet var0) {
            this.paramSet = var0;
            return this;
        }

        public a setRandomSequence(MinecraftKey var0) {
            this.randomSequence = Optional.of(var0);
            return this;
        }

        @Override
        public a apply(LootItemFunction.a var0) {
            this.functions.add((Object)var0.build());
            return this;
        }

        @Override
        public a unwrap() {
            return this;
        }

        public LootTable build() {
            return new LootTable(this.paramSet, this.randomSequence, (List<LootSelector>)this.pools.build(), (List<LootItemFunction>)this.functions.build());
        }

        @Override
        public /* synthetic */ LootItemFunctionUser unwrap() {
            return this.unwrap();
        }

        @Override
        public /* synthetic */ LootItemFunctionUser apply(LootItemFunction.a a2) {
            return this.apply(a2);
        }
    }
}

