/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.placement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.placement.PlacementContext;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.PlacementModifierType;

public class FixedPlacement
extends PlacementModifier {
    public static final MapCodec<FixedPlacement> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)BlockPosition.CODEC.listOf().fieldOf("positions").forGetter(var0 -> var0.positions)).apply((Applicative)var02, FixedPlacement::new));
    private final List<BlockPosition> positions;

    public static FixedPlacement of(BlockPosition ... var0) {
        return new FixedPlacement(List.of(var0));
    }

    private FixedPlacement(List<BlockPosition> var0) {
        this.positions = var0;
    }

    @Override
    public Stream<BlockPosition> getPositions(PlacementContext var0, RandomSource var1, BlockPosition var22) {
        int var3 = SectionPosition.blockToSectionCoord(var22.getX());
        int var4 = SectionPosition.blockToSectionCoord(var22.getZ());
        boolean var5 = false;
        for (BlockPosition var7 : this.positions) {
            if (!FixedPlacement.isSameChunk(var3, var4, var7)) continue;
            var5 = true;
            break;
        }
        if (!var5) {
            return Stream.empty();
        }
        return this.positions.stream().filter(var2 -> FixedPlacement.isSameChunk(var3, var4, var2));
    }

    private static boolean isSameChunk(int var0, int var1, BlockPosition var2) {
        return var0 == SectionPosition.blockToSectionCoord(var2.getX()) && var1 == SectionPosition.blockToSectionCoord(var2.getZ());
    }

    @Override
    public PlacementModifierType<?> type() {
        return PlacementModifierType.FIXED_PLACEMENT;
    }
}

