/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.chunk.storage;

import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Dynamic;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.storage.IOWorker;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public class SimpleRegionStorage
implements AutoCloseable {
    private final IOWorker worker;
    private final DataFixer fixerUpper;
    private final DataFixTypes dataFixType;

    public SimpleRegionStorage(RegionStorageInfo var0, Path var1, DataFixer var2, boolean var3, DataFixTypes var4) {
        this.fixerUpper = var2;
        this.dataFixType = var4;
        this.worker = new IOWorker(var0, var1, var3);
    }

    public CompletableFuture<Optional<NBTTagCompound>> read(ChunkCoordIntPair var0) {
        return this.worker.loadAsync(var0);
    }

    public CompletableFuture<Void> write(ChunkCoordIntPair var0, @Nullable NBTTagCompound var1) {
        return this.worker.store(var0, var1);
    }

    public NBTTagCompound upgradeChunkTag(NBTTagCompound var0, int var1) {
        int var2 = GameProfileSerializer.getDataVersion(var0, var1);
        NBTTagCompound var3 = this.dataFixType.updateToCurrentVersion(this.fixerUpper, var0, var2);
        return GameProfileSerializer.addCurrentDataVersion(var3);
    }

    public Dynamic<NBTBase> upgradeChunkTag(Dynamic<NBTBase> var0, int var1) {
        return this.dataFixType.updateToCurrentVersion(this.fixerUpper, var0, var1);
    }

    public CompletableFuture<Void> synchronize(boolean var0) {
        return this.worker.synchronize(var0);
    }

    @Override
    public void close() throws IOException {
        this.worker.close();
    }

    public RegionStorageInfo storageInfo() {
        return this.worker.storageInfo();
    }
}

