/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.item.context.BlockActionContext;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockGrowingTop;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.material.FluidTypes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class BlockKelp
extends BlockGrowingTop
implements IFluidContainer {
    public static final MapCodec<BlockKelp> CODEC = BlockKelp.simpleCodec(BlockKelp::new);
    private static final double GROW_PER_TICK_PROBABILITY = 0.14;
    private static final VoxelShape SHAPE = Block.column(16.0, 0.0, 9.0);

    public MapCodec<BlockKelp> codec() {
        return CODEC;
    }

    protected BlockKelp(BlockBase.Info var0) {
        super(var0, EnumDirection.UP, SHAPE, true, 0.14);
    }

    @Override
    protected boolean canGrowInto(IBlockData var0) {
        return var0.is(Blocks.WATER);
    }

    @Override
    protected Block getBodyBlock() {
        return Blocks.KELP_PLANT;
    }

    @Override
    protected boolean canAttachTo(IBlockData var0) {
        return !var0.is(Blocks.MAGMA_BLOCK);
    }

    @Override
    public boolean canPlaceLiquid(@Nullable EntityLiving var0, IBlockAccess var1, BlockPosition var2, IBlockData var3, FluidType var4) {
        return false;
    }

    @Override
    public boolean placeLiquid(GeneratorAccess var0, BlockPosition var1, IBlockData var2, Fluid var3) {
        return false;
    }

    @Override
    protected int getBlocksToGrowWhenBonemealed(RandomSource var0) {
        return 1;
    }

    @Override
    @Nullable
    public IBlockData getStateForPlacement(BlockActionContext var0) {
        Fluid var1 = var0.getLevel().getFluidState(var0.getClickedPos());
        if (var1.is(TagsFluid.WATER) && var1.getAmount() == 8) {
            return super.getStateForPlacement(var0);
        }
        return null;
    }

    @Override
    protected Fluid getFluidState(IBlockData var0) {
        return FluidTypes.WATER.getSource(false);
    }
}

