/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level;

import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Optional;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.VoxelShapeSpliterator;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import net.minecraft.world.phys.shapes.VoxelShapes;

public interface ICollisionAccess
extends IBlockAccess {
    public WorldBorder getWorldBorder();

    @Nullable
    public IBlockAccess getChunkForCollisions(int var1, int var2);

    default public boolean isUnobstructed(@Nullable Entity var0, VoxelShape var1) {
        return true;
    }

    default public boolean isUnobstructed(IBlockData var0, BlockPosition var1, VoxelShapeCollision var2) {
        VoxelShape var3 = var0.getCollisionShape(this, var1, var2);
        return var3.isEmpty() || this.isUnobstructed(null, var3.move(var1));
    }

    default public boolean isUnobstructed(Entity var0) {
        return this.isUnobstructed(var0, VoxelShapes.create(var0.getBoundingBox()));
    }

    default public boolean noCollision(AxisAlignedBB var0) {
        return this.noCollision(null, var0);
    }

    default public boolean noCollision(Entity var0) {
        return this.noCollision(var0, var0.getBoundingBox());
    }

    default public boolean noCollision(@Nullable Entity var0, AxisAlignedBB var1) {
        return this.noCollision(var0, var1, false);
    }

    default public boolean noCollision(@Nullable Entity var0, AxisAlignedBB var1, boolean var2) {
        Iterable<VoxelShape> var3 = var2 ? this.getBlockAndLiquidCollisions(var0, var1) : this.getBlockCollisions(var0, var1);
        for (VoxelShape var5 : var3) {
            if (var5.isEmpty()) continue;
            return false;
        }
        if (!this.getEntityCollisions(var0, var1).isEmpty()) {
            return false;
        }
        if (var0 != null) {
            VoxelShape var4 = this.borderCollision(var0, var1);
            return var4 == null || !VoxelShapes.joinIsNotEmpty(var4, VoxelShapes.create(var1), OperatorBoolean.AND);
        }
        return true;
    }

    default public boolean noBlockCollision(@Nullable Entity var0, AxisAlignedBB var1) {
        for (VoxelShape var3 : this.getBlockCollisions(var0, var1)) {
            if (var3.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public List<VoxelShape> getEntityCollisions(@Nullable Entity var1, AxisAlignedBB var2);

    default public Iterable<VoxelShape> getCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        List<VoxelShape> var2 = this.getEntityCollisions(var0, var1);
        Iterable var3 = this.getBlockCollisions(var0, var1);
        return var2.isEmpty() ? var3 : Iterables.concat(var2, var3);
    }

    default public Iterable<VoxelShape> getPreMoveCollisions(@Nullable Entity var0, AxisAlignedBB var1, Vec3D var2) {
        List<VoxelShape> var3 = this.getEntityCollisions(var0, var1);
        Iterable var4 = this.getBlockCollisionsFromContext(VoxelShapeCollision.withPosition(var0, var2.y), var1);
        return var3.isEmpty() ? var4 : Iterables.concat(var3, var4);
    }

    default public Iterable<VoxelShape> getBlockCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        return this.getBlockCollisionsFromContext(var0 == null ? VoxelShapeCollision.empty() : VoxelShapeCollision.of(var0), var1);
    }

    default public Iterable<VoxelShape> getBlockAndLiquidCollisions(@Nullable Entity var0, AxisAlignedBB var1) {
        return this.getBlockCollisionsFromContext(var0 == null ? VoxelShapeCollision.empty() : VoxelShapeCollision.of(var0, true), var1);
    }

    private Iterable<VoxelShape> getBlockCollisionsFromContext(VoxelShapeCollision var0, AxisAlignedBB var1) {
        return () -> new VoxelShapeSpliterator<VoxelShape>(this, var0, var1, false, (var0, var1) -> var1);
    }

    @Nullable
    private VoxelShape borderCollision(Entity var0, AxisAlignedBB var1) {
        WorldBorder var2 = this.getWorldBorder();
        return var2.isInsideCloseToBorder(var0, var1) ? var2.getCollisionShape() : null;
    }

    default public MovingObjectPositionBlock clipIncludingBorder(RayTrace var0) {
        MovingObjectPositionBlock var1 = this.clip(var0);
        WorldBorder var2 = this.getWorldBorder();
        if (var2.isWithinBounds(var0.getFrom()) && !var2.isWithinBounds(var1.getLocation())) {
            Vec3D var3 = var1.getLocation().subtract(var0.getFrom());
            EnumDirection var4 = EnumDirection.getApproximateNearest(var3.x, var3.y, var3.z);
            Vec3D var5 = var2.clampVec3ToBound(var1.getLocation());
            return new MovingObjectPositionBlock(var5, var4, BlockPosition.containing(var5), false, true);
        }
        return var1;
    }

    default public boolean collidesWithSuffocatingBlock(@Nullable Entity var02, AxisAlignedBB var12) {
        VoxelShapeSpliterator<VoxelShape> var2 = new VoxelShapeSpliterator<VoxelShape>(this, var02, var12, true, (var0, var1) -> var1);
        while (var2.hasNext()) {
            if (((VoxelShape)var2.next()).isEmpty()) continue;
            return true;
        }
        return false;
    }

    default public Optional<BlockPosition> findSupportingBlock(Entity var02, AxisAlignedBB var12) {
        BlockPosition var2 = null;
        double var3 = Double.MAX_VALUE;
        VoxelShapeSpliterator<BlockPosition> var5 = new VoxelShapeSpliterator<BlockPosition>(this, var02, var12, false, (var0, var1) -> var0);
        while (var5.hasNext()) {
            BlockPosition var6 = (BlockPosition)var5.next();
            double var7 = var6.distToCenterSqr(var02.position());
            if (!(var7 < var3) && (var7 != var3 || var2 != null && var2.compareTo(var6) >= 0)) continue;
            var2 = var6.immutable();
            var3 = var7;
        }
        return Optional.ofNullable(var2);
    }

    default public Optional<Vec3D> findFreePosition(@Nullable Entity var02, VoxelShape var1, Vec3D var2, double var3, double var5, double var7) {
        if (var1.isEmpty()) {
            return Optional.empty();
        }
        AxisAlignedBB var9 = var1.bounds().inflate(var3, var5, var7);
        VoxelShape var10 = StreamSupport.stream(this.getBlockCollisions(var02, var9).spliterator(), false).filter(var0 -> this.getWorldBorder() == null || this.getWorldBorder().isWithinBounds(var0.bounds())).flatMap(var0 -> var0.toAabbs().stream()).map(var6 -> var6.inflate(var3 / 2.0, var5 / 2.0, var7 / 2.0)).map(VoxelShapes::create).reduce(VoxelShapes.empty(), VoxelShapes::or);
        VoxelShape var11 = VoxelShapes.join(var1, var10, OperatorBoolean.ONLY_FIRST);
        return var11.closestPointTo(var2);
    }
}

