/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.enchantment;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryFixedCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.EnchantmentTags;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Unit;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ConditionalEffect;
import net.minecraft.world.item.enchantment.EnchantedItemInUse;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentTarget;
import net.minecraft.world.item.enchantment.TargetedConditionalEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentAttributeEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentEntityEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentLocationBasedEffect;
import net.minecraft.world.item.enchantment.effects.EnchantmentValueEffect;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3D;
import org.apache.commons.lang3.mutable.MutableFloat;

public record Enchantment(IChatBaseComponent description, c definition, HolderSet<Enchantment> exclusiveSet, DataComponentMap effects) {
    public static final int MAX_LEVEL = 255;
    public static final Codec<Enchantment> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ComponentSerialization.CODEC.fieldOf("description").forGetter(Enchantment::description), (App)c.CODEC.forGetter(Enchantment::definition), (App)RegistryCodecs.homogeneousList(Registries.ENCHANTMENT).optionalFieldOf("exclusive_set", HolderSet.direct(new Holder[0])).forGetter(Enchantment::exclusiveSet), (App)EnchantmentEffectComponents.CODEC.optionalFieldOf("effects", (Object)DataComponentMap.EMPTY).forGetter(Enchantment::effects)).apply((Applicative)var0, Enchantment::new));
    public static final Codec<Holder<Enchantment>> CODEC = RegistryFixedCodec.create(Registries.ENCHANTMENT);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<Enchantment>> STREAM_CODEC = ByteBufCodecs.holderRegistry(Registries.ENCHANTMENT);

    public static b constantCost(int var0) {
        return new b(var0, 0);
    }

    public static b dynamicCost(int var0, int var1) {
        return new b(var0, var1);
    }

    public static c definition(HolderSet<Item> var0, HolderSet<Item> var1, int var2, int var3, b var4, b var5, int var6, EquipmentSlotGroup ... var7) {
        return new c(var0, Optional.of(var1), var2, var3, var4, var5, var6, List.of(var7));
    }

    public static c definition(HolderSet<Item> var0, int var1, int var2, b var3, b var4, int var5, EquipmentSlotGroup ... var6) {
        return new c(var0, Optional.empty(), var1, var2, var3, var4, var5, List.of(var6));
    }

    public Map<EnumItemSlot, ItemStack> getSlotItems(EntityLiving var0) {
        EnumMap var1 = Maps.newEnumMap(EnumItemSlot.class);
        for (EnumItemSlot var3 : EnumItemSlot.VALUES) {
            ItemStack var4;
            if (!this.matchingSlot(var3) || (var4 = var0.getItemBySlot(var3)).isEmpty()) continue;
            var1.put(var3, var4);
        }
        return var1;
    }

    public HolderSet<Item> getSupportedItems() {
        return this.definition.supportedItems();
    }

    public boolean matchingSlot(EnumItemSlot var0) {
        return this.definition.slots().stream().anyMatch(var1 -> var1.test(var0));
    }

    public boolean isPrimaryItem(ItemStack var0) {
        return this.isSupportedItem(var0) && (this.definition.primaryItems.isEmpty() || var0.is(this.definition.primaryItems.get()));
    }

    public boolean isSupportedItem(ItemStack var0) {
        return var0.is(this.definition.supportedItems);
    }

    public int getWeight() {
        return this.definition.weight();
    }

    public int getAnvilCost() {
        return this.definition.anvilCost();
    }

    public int getMinLevel() {
        return 1;
    }

    public int getMaxLevel() {
        return this.definition.maxLevel();
    }

    public int getMinCost(int var0) {
        return this.definition.minCost().calculate(var0);
    }

    public int getMaxCost(int var0) {
        return this.definition.maxCost().calculate(var0);
    }

    @Override
    public String toString() {
        return "Enchantment " + this.description.getString();
    }

    public static boolean areCompatible(Holder<Enchantment> var0, Holder<Enchantment> var1) {
        return !var0.equals(var1) && !var0.value().exclusiveSet.contains(var1) && !var1.value().exclusiveSet.contains(var0);
    }

    public static IChatBaseComponent getFullname(Holder<Enchantment> var0, int var1) {
        IChatMutableComponent var2 = var0.value().description.copy();
        if (var0.is(EnchantmentTags.CURSE)) {
            ChatComponentUtils.mergeStyles(var2, ChatModifier.EMPTY.withColor(EnumChatFormat.RED));
        } else {
            ChatComponentUtils.mergeStyles(var2, ChatModifier.EMPTY.withColor(EnumChatFormat.GRAY));
        }
        if (var1 != 1 || var0.value().getMaxLevel() != 1) {
            var2.append(CommonComponents.SPACE).append(IChatBaseComponent.translatable("enchantment.level." + var1));
        }
        return var2;
    }

    public boolean canEnchant(ItemStack var0) {
        return this.definition.supportedItems().contains(var0.getItemHolder());
    }

    public <T> List<T> getEffects(DataComponentType<List<T>> var0) {
        return this.effects.getOrDefault(var0, List.of());
    }

    public boolean isImmuneToDamage(WorldServer var0, int var1, Entity var2, DamageSource var3) {
        LootTableInfo var4 = Enchantment.damageContext(var0, var1, var2, var3);
        for (ConditionalEffect var6 : this.getEffects(EnchantmentEffectComponents.DAMAGE_IMMUNITY)) {
            if (!var6.matches(var4)) continue;
            return true;
        }
        return false;
    }

    public void modifyDamageProtection(WorldServer var0, int var1, ItemStack var2, Entity var3, DamageSource var4, MutableFloat var5) {
        LootTableInfo var6 = Enchantment.damageContext(var0, var1, var3, var4);
        for (ConditionalEffect var8 : this.getEffects(EnchantmentEffectComponents.DAMAGE_PROTECTION)) {
            if (!var8.matches(var6)) continue;
            var5.setValue(((EnchantmentValueEffect)var8.effect()).process(var1, var3.getRandom(), var5.floatValue()));
        }
    }

    public void modifyDurabilityChange(WorldServer var0, int var1, ItemStack var2, MutableFloat var3) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.ITEM_DAMAGE, var0, var1, var2, var3);
    }

    public void modifyAmmoCount(WorldServer var0, int var1, ItemStack var2, MutableFloat var3) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.AMMO_USE, var0, var1, var2, var3);
    }

    public void modifyPiercingCount(WorldServer var0, int var1, ItemStack var2, MutableFloat var3) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.PROJECTILE_PIERCING, var0, var1, var2, var3);
    }

    public void modifyBlockExperience(WorldServer var0, int var1, ItemStack var2, MutableFloat var3) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.BLOCK_EXPERIENCE, var0, var1, var2, var3);
    }

    public void modifyMobExperience(WorldServer var0, int var1, ItemStack var2, Entity var3, MutableFloat var4) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.MOB_EXPERIENCE, var0, var1, var2, var3, var4);
    }

    public void modifyDurabilityToRepairFromXp(WorldServer var0, int var1, ItemStack var2, MutableFloat var3) {
        this.modifyItemFilteredCount(EnchantmentEffectComponents.REPAIR_WITH_XP, var0, var1, var2, var3);
    }

    public void modifyTridentReturnToOwnerAcceleration(WorldServer var0, int var1, ItemStack var2, Entity var3, MutableFloat var4) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.TRIDENT_RETURN_ACCELERATION, var0, var1, var2, var3, var4);
    }

    public void modifyTridentSpinAttackStrength(RandomSource var0, int var1, MutableFloat var2) {
        this.modifyUnfilteredValue(EnchantmentEffectComponents.TRIDENT_SPIN_ATTACK_STRENGTH, var0, var1, var2);
    }

    public void modifyFishingTimeReduction(WorldServer var0, int var1, ItemStack var2, Entity var3, MutableFloat var4) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.FISHING_TIME_REDUCTION, var0, var1, var2, var3, var4);
    }

    public void modifyFishingLuckBonus(WorldServer var0, int var1, ItemStack var2, Entity var3, MutableFloat var4) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.FISHING_LUCK_BONUS, var0, var1, var2, var3, var4);
    }

    public void modifyDamage(WorldServer var0, int var1, ItemStack var2, Entity var3, DamageSource var4, MutableFloat var5) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.DAMAGE, var0, var1, var2, var3, var4, var5);
    }

    public void modifyFallBasedDamage(WorldServer var0, int var1, ItemStack var2, Entity var3, DamageSource var4, MutableFloat var5) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.SMASH_DAMAGE_PER_FALLEN_BLOCK, var0, var1, var2, var3, var4, var5);
    }

    public void modifyKnockback(WorldServer var0, int var1, ItemStack var2, Entity var3, DamageSource var4, MutableFloat var5) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.KNOCKBACK, var0, var1, var2, var3, var4, var5);
    }

    public void modifyArmorEffectivness(WorldServer var0, int var1, ItemStack var2, Entity var3, DamageSource var4, MutableFloat var5) {
        this.modifyDamageFilteredValue(EnchantmentEffectComponents.ARMOR_EFFECTIVENESS, var0, var1, var2, var3, var4, var5);
    }

    public void doPostAttack(WorldServer var0, int var1, EnchantedItemInUse var2, EnchantmentTarget var3, Entity var4, DamageSource var5) {
        for (TargetedConditionalEffect var7 : this.getEffects(EnchantmentEffectComponents.POST_ATTACK)) {
            if (var3 != var7.enchanted()) continue;
            Enchantment.doPostAttack(var7, var0, var1, var2, var4, var5);
        }
    }

    public static void doPostAttack(TargetedConditionalEffect<EnchantmentEntityEffect> var0, WorldServer var1, int var2, EnchantedItemInUse var3, Entity var4, DamageSource var5) {
        if (var0.matches(Enchantment.damageContext(var1, var2, var4, var5))) {
            Entity var6;
            switch (var0.affected()) {
                default: {
                    throw new MatchException(null, null);
                }
                case ATTACKER: {
                    Entity entity = var5.getEntity();
                    break;
                }
                case DAMAGING_ENTITY: {
                    Entity entity = var5.getDirectEntity();
                    break;
                }
                case VICTIM: {
                    Entity entity = var6 = var4;
                }
            }
            if (var6 != null) {
                var0.effect().apply(var1, var2, var3, var6, var6.position());
            }
        }
    }

    public void modifyProjectileCount(WorldServer var0, int var1, ItemStack var2, Entity var3, MutableFloat var4) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.PROJECTILE_COUNT, var0, var1, var2, var3, var4);
    }

    public void modifyProjectileSpread(WorldServer var0, int var1, ItemStack var2, Entity var3, MutableFloat var4) {
        this.modifyEntityFilteredValue(EnchantmentEffectComponents.PROJECTILE_SPREAD, var0, var1, var2, var3, var4);
    }

    public void modifyCrossbowChargeTime(RandomSource var0, int var1, MutableFloat var2) {
        this.modifyUnfilteredValue(EnchantmentEffectComponents.CROSSBOW_CHARGE_TIME, var0, var1, var2);
    }

    public void modifyUnfilteredValue(DataComponentType<EnchantmentValueEffect> var0, RandomSource var1, int var2, MutableFloat var3) {
        EnchantmentValueEffect var4 = this.effects.get(var0);
        if (var4 != null) {
            var3.setValue(var4.process(var2, var1, var3.floatValue()));
        }
    }

    public void tick(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3) {
        Enchantment.applyEffects(this.getEffects(EnchantmentEffectComponents.TICK), Enchantment.entityContext(var0, var1, var3, var3.position()), var4 -> var4.apply(var0, var1, var2, var3, var3.position()));
    }

    public void onProjectileSpawned(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3) {
        Enchantment.applyEffects(this.getEffects(EnchantmentEffectComponents.PROJECTILE_SPAWNED), Enchantment.entityContext(var0, var1, var3, var3.position()), var4 -> var4.apply(var0, var1, var2, var3, var3.position()));
    }

    public void onHitBlock(WorldServer var0, int var1, EnchantedItemInUse var2, Entity var3, Vec3D var4, IBlockData var52) {
        Enchantment.applyEffects(this.getEffects(EnchantmentEffectComponents.HIT_BLOCK), Enchantment.blockHitContext(var0, var1, var3, var4, var52), var5 -> var5.apply(var0, var1, var2, var3, var4));
    }

    private void modifyItemFilteredCount(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> var0, WorldServer var1, int var2, ItemStack var32, MutableFloat var4) {
        Enchantment.applyEffects(this.getEffects(var0), Enchantment.itemContext(var1, var2, var32), var3 -> var4.setValue(var3.process(var2, var1.getRandom(), var4.getValue().floatValue())));
    }

    private void modifyEntityFilteredValue(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> var0, WorldServer var1, int var2, ItemStack var32, Entity var4, MutableFloat var5) {
        Enchantment.applyEffects(this.getEffects(var0), Enchantment.entityContext(var1, var2, var4, var4.position()), var3 -> var5.setValue(var3.process(var2, var4.getRandom(), var5.floatValue())));
    }

    private void modifyDamageFilteredValue(DataComponentType<List<ConditionalEffect<EnchantmentValueEffect>>> var0, WorldServer var1, int var2, ItemStack var32, Entity var4, DamageSource var5, MutableFloat var6) {
        Enchantment.applyEffects(this.getEffects(var0), Enchantment.damageContext(var1, var2, var4, var5), var3 -> var6.setValue(var3.process(var2, var4.getRandom(), var6.floatValue())));
    }

    public static LootTableInfo damageContext(WorldServer var0, int var1, Entity var2, DamageSource var3) {
        LootParams var4 = new LootParams.a(var0).withParameter(LootContextParameters.THIS_ENTITY, var2).withParameter(LootContextParameters.ENCHANTMENT_LEVEL, var1).withParameter(LootContextParameters.ORIGIN, var2.position()).withParameter(LootContextParameters.DAMAGE_SOURCE, var3).withOptionalParameter(LootContextParameters.ATTACKING_ENTITY, var3.getEntity()).withOptionalParameter(LootContextParameters.DIRECT_ATTACKING_ENTITY, var3.getDirectEntity()).create(LootContextParameterSets.ENCHANTED_DAMAGE);
        return new LootTableInfo.Builder(var4).create(Optional.empty());
    }

    private static LootTableInfo itemContext(WorldServer var0, int var1, ItemStack var2) {
        LootParams var3 = new LootParams.a(var0).withParameter(LootContextParameters.TOOL, var2).withParameter(LootContextParameters.ENCHANTMENT_LEVEL, var1).create(LootContextParameterSets.ENCHANTED_ITEM);
        return new LootTableInfo.Builder(var3).create(Optional.empty());
    }

    private static LootTableInfo locationContext(WorldServer var0, int var1, Entity var2, boolean var3) {
        LootParams var4 = new LootParams.a(var0).withParameter(LootContextParameters.THIS_ENTITY, var2).withParameter(LootContextParameters.ENCHANTMENT_LEVEL, var1).withParameter(LootContextParameters.ORIGIN, var2.position()).withParameter(LootContextParameters.ENCHANTMENT_ACTIVE, var3).create(LootContextParameterSets.ENCHANTED_LOCATION);
        return new LootTableInfo.Builder(var4).create(Optional.empty());
    }

    private static LootTableInfo entityContext(WorldServer var0, int var1, Entity var2, Vec3D var3) {
        LootParams var4 = new LootParams.a(var0).withParameter(LootContextParameters.THIS_ENTITY, var2).withParameter(LootContextParameters.ENCHANTMENT_LEVEL, var1).withParameter(LootContextParameters.ORIGIN, var3).create(LootContextParameterSets.ENCHANTED_ENTITY);
        return new LootTableInfo.Builder(var4).create(Optional.empty());
    }

    private static LootTableInfo blockHitContext(WorldServer var0, int var1, Entity var2, Vec3D var3, IBlockData var4) {
        LootParams var5 = new LootParams.a(var0).withParameter(LootContextParameters.THIS_ENTITY, var2).withParameter(LootContextParameters.ENCHANTMENT_LEVEL, var1).withParameter(LootContextParameters.ORIGIN, var3).withParameter(LootContextParameters.BLOCK_STATE, var4).create(LootContextParameterSets.HIT_BLOCK);
        return new LootTableInfo.Builder(var5).create(Optional.empty());
    }

    private static <T> void applyEffects(List<ConditionalEffect<T>> var0, LootTableInfo var1, Consumer<T> var2) {
        for (ConditionalEffect<T> var4 : var0) {
            if (!var4.matches(var1)) continue;
            var2.accept(var4.effect());
        }
    }

    public void runLocationChangedEffects(WorldServer var0, int var1, EnchantedItemInUse var2, EntityLiving var32) {
        EnumItemSlot var4 = var2.inSlot();
        if (var4 == null) {
            return;
        }
        Map<Enchantment, Set<EnchantmentLocationBasedEffect>> var5 = var32.activeLocationDependentEnchantments(var4);
        if (!this.matchingSlot(var4)) {
            Set<EnchantmentLocationBasedEffect> var6 = var5.remove(this);
            if (var6 != null) {
                var6.forEach(var3 -> var3.onDeactivated(var2, var32, var32.position(), var1));
            }
            return;
        }
        ObjectArraySet var6 = var5.get(this);
        for (ConditionalEffect var8 : this.getEffects(EnchantmentEffectComponents.LOCATION_CHANGED)) {
            boolean var10;
            EnchantmentLocationBasedEffect var9 = (EnchantmentLocationBasedEffect)var8.effect();
            boolean bl = var10 = var6 != null && var6.contains(var9);
            if (var8.matches(Enchantment.locationContext(var0, var1, var32, var10))) {
                if (!var10) {
                    if (var6 == null) {
                        var6 = new ObjectArraySet();
                        var5.put(this, (Set<EnchantmentLocationBasedEffect>)var6);
                    }
                    var6.add((EnchantmentLocationBasedEffect)var9);
                }
                var9.onChangedBlock(var0, var1, var2, var32, var32.position(), !var10);
                continue;
            }
            if (var6 == null || !var6.remove(var9)) continue;
            var9.onDeactivated(var2, var32, var32.position(), var1);
        }
        if (var6 != null && var6.isEmpty()) {
            var5.remove(this);
        }
    }

    public void stopLocationBasedEffects(int var0, EnchantedItemInUse var1, EntityLiving var2) {
        EnumItemSlot var3 = var1.inSlot();
        if (var3 == null) {
            return;
        }
        Set<EnchantmentLocationBasedEffect> var4 = var2.activeLocationDependentEnchantments(var3).remove(this);
        if (var4 == null) {
            return;
        }
        for (EnchantmentLocationBasedEffect var6 : var4) {
            var6.onDeactivated(var1, var2, var2.position(), var0);
        }
    }

    public static a enchantment(c var0) {
        return new a(var0);
    }

    public static final class c
    extends Record {
        final HolderSet<Item> supportedItems;
        final Optional<HolderSet<Item>> primaryItems;
        private final int weight;
        private final int maxLevel;
        private final b minCost;
        private final b maxCost;
        private final int anvilCost;
        private final List<EquipmentSlotGroup> slots;
        public static final MapCodec<c> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ITEM).fieldOf("supported_items").forGetter(c::supportedItems), (App)RegistryCodecs.homogeneousList(Registries.ITEM).optionalFieldOf("primary_items").forGetter(c::primaryItems), (App)ExtraCodecs.intRange(1, 1024).fieldOf("weight").forGetter(c::weight), (App)ExtraCodecs.intRange(1, 255).fieldOf("max_level").forGetter(c::maxLevel), (App)b.CODEC.fieldOf("min_cost").forGetter(c::minCost), (App)b.CODEC.fieldOf("max_cost").forGetter(c::maxCost), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("anvil_cost").forGetter(c::anvilCost), (App)EquipmentSlotGroup.CODEC.listOf().fieldOf("slots").forGetter(c::slots)).apply((Applicative)var0, c::new));

        public c(HolderSet<Item> var0, Optional<HolderSet<Item>> var1, int var2, int var3, b var4, b var5, int var6, List<EquipmentSlotGroup> var7) {
            this.supportedItems = var0;
            this.primaryItems = var1;
            this.weight = var2;
            this.maxLevel = var3;
            this.minCost = var4;
            this.maxCost = var5;
            this.anvilCost = var6;
            this.slots = var7;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "slots"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "slots"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{c.class, "supportedItems;primaryItems;weight;maxLevel;minCost;maxCost;anvilCost;slots", "supportedItems", "primaryItems", "weight", "maxLevel", "minCost", "maxCost", "anvilCost", "slots"}, this, var0);
        }

        public HolderSet<Item> supportedItems() {
            return this.supportedItems;
        }

        public Optional<HolderSet<Item>> primaryItems() {
            return this.primaryItems;
        }

        public int weight() {
            return this.weight;
        }

        public int maxLevel() {
            return this.maxLevel;
        }

        public b minCost() {
            return this.minCost;
        }

        public b maxCost() {
            return this.maxCost;
        }

        public int anvilCost() {
            return this.anvilCost;
        }

        public List<EquipmentSlotGroup> slots() {
            return this.slots;
        }
    }

    public record b(int base, int perLevelAboveFirst) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.INT.fieldOf("base").forGetter(b::base), (App)Codec.INT.fieldOf("per_level_above_first").forGetter(b::perLevelAboveFirst)).apply((Applicative)var0, b::new));

        public int calculate(int var0) {
            return this.base + this.perLevelAboveFirst * (var0 - 1);
        }
    }

    public static class a {
        private final c definition;
        private HolderSet<Enchantment> exclusiveSet = HolderSet.direct(new Holder[0]);
        private final Map<DataComponentType<?>, List<?>> effectLists = new HashMap();
        private final DataComponentMap.a effectMapBuilder = DataComponentMap.builder();

        public a(c var0) {
            this.definition = var0;
        }

        public a exclusiveWith(HolderSet<Enchantment> var0) {
            this.exclusiveSet = var0;
            return this;
        }

        public <E> a withEffect(DataComponentType<List<ConditionalEffect<E>>> var0, E var1, LootItemCondition.a var2) {
            this.getEffectsList(var0).add(new ConditionalEffect<E>(var1, Optional.of(var2.build())));
            return this;
        }

        public <E> a withEffect(DataComponentType<List<ConditionalEffect<E>>> var0, E var1) {
            this.getEffectsList(var0).add(new ConditionalEffect<E>(var1, Optional.empty()));
            return this;
        }

        public <E> a withEffect(DataComponentType<List<TargetedConditionalEffect<E>>> var0, EnchantmentTarget var1, EnchantmentTarget var2, E var3, LootItemCondition.a var4) {
            this.getEffectsList(var0).add(new TargetedConditionalEffect<E>(var1, var2, var3, Optional.of(var4.build())));
            return this;
        }

        public <E> a withEffect(DataComponentType<List<TargetedConditionalEffect<E>>> var0, EnchantmentTarget var1, EnchantmentTarget var2, E var3) {
            this.getEffectsList(var0).add(new TargetedConditionalEffect<E>(var1, var2, var3, Optional.empty()));
            return this;
        }

        public a withEffect(DataComponentType<List<EnchantmentAttributeEffect>> var0, EnchantmentAttributeEffect var1) {
            this.getEffectsList(var0).add(var1);
            return this;
        }

        public <E> a withSpecialEffect(DataComponentType<E> var0, E var1) {
            this.effectMapBuilder.set(var0, var1);
            return this;
        }

        public a withEffect(DataComponentType<Unit> var0) {
            this.effectMapBuilder.set(var0, Unit.INSTANCE);
            return this;
        }

        private <E> List<E> getEffectsList(DataComponentType<List<E>> var0) {
            return this.effectLists.computeIfAbsent(var0, var1 -> {
                ArrayList var2 = new ArrayList();
                this.effectMapBuilder.set(var0, var2);
                return var2;
            });
        }

        public Enchantment build(MinecraftKey var0) {
            return new Enchantment(IChatBaseComponent.translatable(SystemUtils.makeDescriptionId("enchantment", var0)), this.definition, this.exclusiveSet, this.effectMapBuilder.build());
        }
    }
}

