/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.item.component;

import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.PropertyMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.block.entity.TileEntitySkull;

public record ResolvableProfile(Optional<String> name, Optional<UUID> id, PropertyMap properties, GameProfile gameProfile) {
    private static final Codec<ResolvableProfile> FULL_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.PLAYER_NAME.optionalFieldOf("name").forGetter(ResolvableProfile::name), (App)UUIDUtil.CODEC.optionalFieldOf("id").forGetter(ResolvableProfile::id), (App)ExtraCodecs.PROPERTY_MAP.optionalFieldOf("properties", (Object)new PropertyMap()).forGetter(ResolvableProfile::properties)).apply((Applicative)var0, ResolvableProfile::new));
    public static final Codec<ResolvableProfile> CODEC = Codec.withAlternative(FULL_CODEC, ExtraCodecs.PLAYER_NAME, var0 -> new ResolvableProfile(Optional.of(var0), Optional.empty(), new PropertyMap()));
    public static final StreamCodec<ByteBuf, ResolvableProfile> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.stringUtf8(16).apply(ByteBufCodecs::optional), ResolvableProfile::name, UUIDUtil.STREAM_CODEC.apply(ByteBufCodecs::optional), ResolvableProfile::id, ByteBufCodecs.GAME_PROFILE_PROPERTIES, ResolvableProfile::properties, ResolvableProfile::new);

    public ResolvableProfile(Optional<String> var0, Optional<UUID> var1, PropertyMap var2) {
        this(var0, var1, var2, ResolvableProfile.createGameProfile(var1, var0, var2));
    }

    public ResolvableProfile(GameProfile var0) {
        this(Optional.of(var0.getName()), Optional.of(var0.getId()), var0.getProperties(), var0);
    }

    @Nullable
    public ResolvableProfile pollResolve() {
        if (this.isResolved()) {
            return this;
        }
        Optional var0 = this.id.isPresent() ? (Optional)TileEntitySkull.fetchGameProfile(this.id.get()).getNow(null) : (Optional)TileEntitySkull.fetchGameProfile(this.name.orElseThrow()).getNow(null);
        if (var0 != null) {
            return this.createProfile(var0);
        }
        return null;
    }

    public CompletableFuture<ResolvableProfile> resolve() {
        if (this.isResolved()) {
            return CompletableFuture.completedFuture(this);
        }
        if (this.id.isPresent()) {
            return TileEntitySkull.fetchGameProfile(this.id.get()).thenApply(this::createProfile);
        }
        return TileEntitySkull.fetchGameProfile(this.name.orElseThrow()).thenApply(this::createProfile);
    }

    private ResolvableProfile createProfile(Optional<GameProfile> var0) {
        return new ResolvableProfile(var0.orElseGet(() -> ResolvableProfile.createGameProfile(this.id, this.name)));
    }

    private static GameProfile createGameProfile(Optional<UUID> var0, Optional<String> var1) {
        return new GameProfile(var0.orElse(SystemUtils.NIL_UUID), var1.orElse(""));
    }

    private static GameProfile createGameProfile(Optional<UUID> var0, Optional<String> var1, PropertyMap var2) {
        GameProfile var3 = ResolvableProfile.createGameProfile(var0, var1);
        var3.getProperties().putAll((Multimap)var2);
        return var3;
    }

    public boolean isResolved() {
        if (!this.properties.isEmpty()) {
            return true;
        }
        return this.id.isPresent() == this.name.isPresent();
    }
}

