/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import java.util.List;
import net.minecraft.recipebook.AutoRecipe;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.inventory.InventoryCraftResult;
import net.minecraft.world.inventory.InventoryCrafting;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SlotResult;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.crafting.RecipeCrafting;
import net.minecraft.world.item.crafting.RecipeHolder;

public abstract class AbstractCraftingMenu
extends ContainerRecipeBook {
    private final int width;
    private final int height;
    public final InventoryCrafting craftSlots;
    public final InventoryCraftResult resultSlots = new InventoryCraftResult();

    public AbstractCraftingMenu(Containers<?> var0, int var1, int var2, int var3) {
        super(var0, var1);
        this.width = var2;
        this.height = var3;
        this.craftSlots = new TransientCraftingContainer(this, var2, var3);
    }

    protected Slot addResultSlot(EntityHuman var0, int var1, int var2) {
        return this.addSlot(new SlotResult(var0, this.craftSlots, this.resultSlots, 0, var1, var2));
    }

    protected void addCraftingGridSlots(int var0, int var1) {
        for (int var2 = 0; var2 < this.width; ++var2) {
            for (int var3 = 0; var3 < this.height; ++var3) {
                this.addSlot(new Slot(this.craftSlots, var3 + var2 * this.width, var0 + var3 * 18, var1 + var2 * 18));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ContainerRecipeBook.a handlePlacement(boolean var0, boolean var1, RecipeHolder<?> var2, WorldServer var3, PlayerInventory var4) {
        RecipeHolder<RecipeCrafting> var5 = var2;
        this.beginPlacingRecipe();
        try {
            List<Slot> var6 = this.getInputGridSlots();
            ContainerRecipeBook.a a2 = AutoRecipe.placeRecipe(new AutoRecipe.a<RecipeCrafting>(){

                @Override
                public void fillCraftSlotsStackedContents(StackedItemContents var0) {
                    AbstractCraftingMenu.this.fillCraftSlotsStackedContents(var0);
                }

                @Override
                public void clearCraftingContent() {
                    AbstractCraftingMenu.this.resultSlots.clearContent();
                    AbstractCraftingMenu.this.craftSlots.clearContent();
                }

                @Override
                public boolean recipeMatches(RecipeHolder<RecipeCrafting> var0) {
                    return var0.value().matches(AbstractCraftingMenu.this.craftSlots.asCraftInput(), AbstractCraftingMenu.this.owner().level());
                }
            }, this.width, this.height, var6, var6, var4, var5, var0, var1);
            return a2;
        }
        finally {
            this.finishPlacingRecipe(var3, var5);
        }
    }

    protected void beginPlacingRecipe() {
    }

    protected void finishPlacingRecipe(WorldServer var0, RecipeHolder<RecipeCrafting> var1) {
    }

    public abstract Slot getResultSlot();

    public abstract List<Slot> getInputGridSlots();

    public int getGridWidth() {
        return this.width;
    }

    public int getGridHeight() {
        return this.height;
    }

    protected abstract EntityHuman owner();

    @Override
    public void fillCraftSlotsStackedContents(StackedItemContents var0) {
        this.craftSlots.fillStackedContents(var0);
    }
}

