/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.vehicle;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.IInventory;
import net.minecraft.world.InventoryUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.monster.piglin.PiglinAI;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.entity.vehicle.ContainerEntity;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerChest;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.World;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootTable;

public abstract class AbstractChestBoat
extends AbstractBoat
implements HasCustomInventoryScreen,
ContainerEntity {
    private static final int CONTAINER_SIZE = 27;
    private NonNullList<ItemStack> itemStacks = NonNullList.withSize(27, ItemStack.EMPTY);
    @Nullable
    private ResourceKey<LootTable> lootTable;
    private long lootTableSeed;

    public AbstractChestBoat(EntityTypes<? extends AbstractChestBoat> var0, World var1, Supplier<Item> var2) {
        super(var0, var1, var2);
    }

    @Override
    protected float getSinglePassengerXOffset() {
        return 0.15f;
    }

    @Override
    protected int getMaxPassengers() {
        return 1;
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        this.addChestVehicleSaveData(var0);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.readChestVehicleSaveData(var0);
    }

    @Override
    public void destroy(WorldServer var0, DamageSource var1) {
        this.destroy(var0, this.getDropItem());
        this.chestVehicleDestroyed(var1, var0, this);
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        if (!this.level().isClientSide && var0.shouldDestroy()) {
            InventoryUtils.dropContents(this.level(), this, (IInventory)this);
        }
        super.remove(var0);
    }

    @Override
    public EnumInteractionResult interact(EntityHuman var0, EnumHand var1) {
        EnumInteractionResult var2 = super.interact(var0, var1);
        if (var2 != EnumInteractionResult.PASS) {
            return var2;
        }
        if (!this.canAddPassenger(var0) || var0.isSecondaryUseActive()) {
            World world;
            EnumInteractionResult var3 = this.interactWithContainerVehicle(var0);
            if (var3.consumesAction() && (world = var0.level()) instanceof WorldServer) {
                WorldServer var4 = (WorldServer)world;
                this.gameEvent(GameEvent.CONTAINER_OPEN, var0);
                PiglinAI.angerNearbyPiglins(var4, var0, true);
            }
            return var3;
        }
        return EnumInteractionResult.PASS;
    }

    @Override
    public void openCustomInventoryScreen(EntityHuman var0) {
        var0.openMenu(this);
        World world = var0.level();
        if (world instanceof WorldServer) {
            WorldServer var1 = (WorldServer)world;
            this.gameEvent(GameEvent.CONTAINER_OPEN, var0);
            PiglinAI.angerNearbyPiglins(var1, var0, true);
        }
    }

    @Override
    public void clearContent() {
        this.clearChestVehicleContent();
    }

    @Override
    public int getContainerSize() {
        return 27;
    }

    @Override
    public ItemStack getItem(int var0) {
        return this.getChestVehicleItem(var0);
    }

    @Override
    public ItemStack removeItem(int var0, int var1) {
        return this.removeChestVehicleItem(var0, var1);
    }

    @Override
    public ItemStack removeItemNoUpdate(int var0) {
        return this.removeChestVehicleItemNoUpdate(var0);
    }

    @Override
    public void setItem(int var0, ItemStack var1) {
        this.setChestVehicleItem(var0, var1);
    }

    @Override
    public SlotAccess getSlot(int var0) {
        return this.getChestVehicleSlot(var0);
    }

    @Override
    public void setChanged() {
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return this.isChestVehicleStillValid(var0);
    }

    @Override
    @Nullable
    public Container createMenu(int var0, PlayerInventory var1, EntityHuman var2) {
        if (this.lootTable == null || !var2.isSpectator()) {
            this.unpackLootTable(var1.player);
            return ContainerChest.threeRows(var0, var1, this);
        }
        return null;
    }

    public void unpackLootTable(@Nullable EntityHuman var0) {
        this.unpackChestVehicleLootTable(var0);
    }

    @Override
    @Nullable
    public ResourceKey<LootTable> getContainerLootTable() {
        return this.lootTable;
    }

    @Override
    public void setContainerLootTable(@Nullable ResourceKey<LootTable> var0) {
        this.lootTable = var0;
    }

    @Override
    public long getContainerLootTableSeed() {
        return this.lootTableSeed;
    }

    @Override
    public void setContainerLootTableSeed(long var0) {
        this.lootTableSeed = var0;
    }

    @Override
    public NonNullList<ItemStack> getItemStacks() {
        return this.itemStacks;
    }

    @Override
    public void clearItemStacks() {
        this.itemStacks = NonNullList.withSize(this.getContainerSize(), ItemStack.EMPTY);
    }

    @Override
    public void stopOpen(EntityHuman var0) {
        this.level().gameEvent(GameEvent.CONTAINER_CLOSE, this.position(), GameEvent.a.of(var0));
    }
}

