/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.level.pathfinder.PathEntity;

public class BehaviorMakeLove
extends Behavior<EntityVillager> {
    private long birthTimestamp;

    public BehaviorMakeLove() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.BREED_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT), MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 350, 350);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, EntityVillager var1) {
        return this.isBreedingPossible(var1);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, EntityVillager var1, long var2) {
        return var2 <= this.birthTimestamp && this.isBreedingPossible(var1);
    }

    @Override
    protected void start(WorldServer var0, EntityVillager var1, long var2) {
        EntityAgeable var4 = var1.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        BehaviorUtil.lockGazeAndWalkToEachOther(var1, var4, 0.5f, 2);
        var0.broadcastEntityEvent(var4, (byte)18);
        var0.broadcastEntityEvent(var1, (byte)18);
        int var5 = 275 + var1.getRandom().nextInt(50);
        this.birthTimestamp = var2 + (long)var5;
    }

    @Override
    protected void tick(WorldServer var0, EntityVillager var1, long var2) {
        EntityVillager var4 = (EntityVillager)var1.getBrain().getMemory(MemoryModuleType.BREED_TARGET).get();
        if (var1.distanceToSqr(var4) > 5.0) {
            return;
        }
        BehaviorUtil.lockGazeAndWalkToEachOther(var1, var4, 0.5f, 2);
        if (var2 >= this.birthTimestamp) {
            var1.eatAndDigestFood();
            var4.eatAndDigestFood();
            this.tryToGiveBirth(var0, var1, var4);
        } else if (var1.getRandom().nextInt(35) == 0) {
            var0.broadcastEntityEvent(var4, (byte)12);
            var0.broadcastEntityEvent(var1, (byte)12);
        }
    }

    private void tryToGiveBirth(WorldServer var0, EntityVillager var1, EntityVillager var2) {
        Optional<BlockPosition> var3 = this.takeVacantBed(var0, var1);
        if (var3.isEmpty()) {
            var0.broadcastEntityEvent(var2, (byte)13);
            var0.broadcastEntityEvent(var1, (byte)13);
        } else {
            Optional<EntityVillager> var4 = this.breed(var0, var1, var2);
            if (var4.isPresent()) {
                this.giveBedToChild(var0, var4.get(), var3.get());
            } else {
                var0.getPoiManager().release(var3.get());
                PacketDebug.sendPoiTicketCountPacket(var0, var3.get());
            }
        }
    }

    @Override
    protected void stop(WorldServer var0, EntityVillager var1, long var2) {
        var1.getBrain().eraseMemory(MemoryModuleType.BREED_TARGET);
    }

    private boolean isBreedingPossible(EntityVillager var02) {
        BehaviorController<EntityVillager> var1 = var02.getBrain();
        Optional<EntityAgeable> var2 = var1.getMemory(MemoryModuleType.BREED_TARGET).filter(var0 -> var0.getType() == EntityTypes.VILLAGER);
        if (var2.isEmpty()) {
            return false;
        }
        return BehaviorUtil.targetIsValid(var1, MemoryModuleType.BREED_TARGET, EntityTypes.VILLAGER) && var02.canBreed() && var2.get().canBreed();
    }

    private Optional<BlockPosition> takeVacantBed(WorldServer var02, EntityVillager var12) {
        return var02.getPoiManager().take(var0 -> var0.is(PoiTypes.HOME), (var1, var2) -> this.canReach(var12, (BlockPosition)var2, (Holder<VillagePlaceType>)var1), var12.blockPosition(), 48);
    }

    private boolean canReach(EntityVillager var0, BlockPosition var1, Holder<VillagePlaceType> var2) {
        PathEntity var3 = var0.getNavigation().createPath(var1, var2.value().validRange());
        return var3 != null && var3.canReach();
    }

    private Optional<EntityVillager> breed(WorldServer var0, EntityVillager var1, EntityVillager var2) {
        EntityVillager var3 = var1.getBreedOffspring(var0, var2);
        if (var3 == null) {
            return Optional.empty();
        }
        var1.setAge(6000);
        var2.setAge(6000);
        var3.setAge(-24000);
        var3.snapTo(var1.getX(), var1.getY(), var1.getZ(), 0.0f, 0.0f);
        var0.addFreshEntityWithPassengers(var3);
        var0.broadcastEntityEvent(var3, (byte)12);
        return Optional.of(var3);
    }

    private void giveBedToChild(WorldServer var0, EntityVillager var1, BlockPosition var2) {
        GlobalPos var3 = GlobalPos.of(var0.dimension(), var2);
        var1.getBrain().setMemory(MemoryModuleType.HOME, var3);
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (EntityVillager)entityLiving, l2);
    }

    @Override
    protected /* synthetic */ void start(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.start(worldServer, (EntityVillager)entityLiving, l2);
    }
}

