/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.valueproviders;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.Weighted;
import net.minecraft.util.random.WeightedList;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.util.valueproviders.IntProviderType;

public class WeightedListInt
extends IntProvider {
    public static final MapCodec<WeightedListInt> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)WeightedList.nonEmptyCodec(IntProvider.CODEC).fieldOf("distribution").forGetter(var0 -> var0.distribution)).apply((Applicative)var02, WeightedListInt::new));
    private final WeightedList<IntProvider> distribution;
    private final int minValue;
    private final int maxValue;

    public WeightedListInt(WeightedList<IntProvider> var0) {
        this.distribution = var0;
        int var1 = Integer.MAX_VALUE;
        int var2 = Integer.MIN_VALUE;
        for (Weighted<IntProvider> var4 : var0.unwrap()) {
            int var5 = var4.value().getMinValue();
            int var6 = var4.value().getMaxValue();
            var1 = Math.min(var1, var5);
            var2 = Math.max(var2, var6);
        }
        this.minValue = var1;
        this.maxValue = var2;
    }

    @Override
    public int sample(RandomSource var0) {
        return this.distribution.getRandomOrThrow(var0).sample(var0);
    }

    @Override
    public int getMinValue() {
        return this.minValue;
    }

    @Override
    public int getMaxValue() {
        return this.maxValue;
    }

    @Override
    public IntProviderType<?> getType() {
        return IntProviderType.WEIGHTED_LIST;
    }
}

