/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.debugchart;

import net.minecraft.util.debugchart.AbstractSampleLogger;
import net.minecraft.util.debugchart.SampleStorage;

public class LocalSampleLogger
extends AbstractSampleLogger
implements SampleStorage {
    public static final int CAPACITY = 240;
    private final long[][] samples;
    private int start;
    private int size;

    public LocalSampleLogger(int var0) {
        this(var0, new long[var0]);
    }

    public LocalSampleLogger(int var0, long[] var1) {
        super(var0, var1);
        this.samples = new long[240][var0];
    }

    @Override
    protected void useSample() {
        int var0 = this.wrapIndex(this.start + this.size);
        System.arraycopy(this.sample, 0, this.samples[var0], 0, this.sample.length);
        if (this.size < 240) {
            ++this.size;
        } else {
            this.start = this.wrapIndex(this.start + 1);
        }
    }

    @Override
    public int capacity() {
        return this.samples.length;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long get(int var0) {
        return this.get(var0, 0);
    }

    @Override
    public long get(int var0, int var1) {
        if (var0 < 0 || var0 >= this.size) {
            throw new IndexOutOfBoundsException(var0 + " out of bounds for length " + this.size);
        }
        long[] var2 = this.samples[this.wrapIndex(this.start + var0)];
        if (var1 < 0 || var1 >= var2.length) {
            throw new IndexOutOfBoundsException(var1 + " out of bounds for dimensions " + var2.length);
        }
        return var2[var1];
    }

    private int wrapIndex(int var0) {
        return var0 % 240;
    }

    @Override
    public void reset() {
        this.start = 0;
        this.size = 0;
    }
}

