/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Interner;
import com.google.common.collect.Interners;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.core.IRegistry;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;

public record TagKey<T>(ResourceKey<? extends IRegistry<T>> registry, MinecraftKey location) {
    private static final Interner<TagKey<?>> VALUES = Interners.newWeakInterner();

    public static <T> Codec<TagKey<T>> codec(ResourceKey<? extends IRegistry<T>> var0) {
        return MinecraftKey.CODEC.xmap(var1 -> TagKey.create(var0, var1), TagKey::location);
    }

    public static <T> Codec<TagKey<T>> hashedCodec(ResourceKey<? extends IRegistry<T>> var02) {
        return Codec.STRING.comapFlatMap(var12 -> var12.startsWith("#") ? MinecraftKey.read(var12.substring(1)).map(var1 -> TagKey.create(var02, var1)) : DataResult.error(() -> "Not a tag id"), var0 -> "#" + String.valueOf(var0.location));
    }

    public static <T> StreamCodec<ByteBuf, TagKey<T>> streamCodec(ResourceKey<? extends IRegistry<T>> var0) {
        return MinecraftKey.STREAM_CODEC.map(var1 -> TagKey.create(var0, var1), TagKey::location);
    }

    public static <T> TagKey<T> create(ResourceKey<? extends IRegistry<T>> var0, MinecraftKey var1) {
        return (TagKey)VALUES.intern(new TagKey<T>(var0, var1));
    }

    public boolean isFor(ResourceKey<? extends IRegistry<?>> var0) {
        return this.registry == var0;
    }

    public <E> Optional<TagKey<E>> cast(ResourceKey<? extends IRegistry<E>> var0) {
        return this.isFor(var0) ? Optional.of(this) : Optional.empty();
    }

    @Override
    public String toString() {
        return "TagKey[" + String.valueOf(this.registry.location()) + " / " + String.valueOf(this.location) + "]";
    }
}

