/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SystemUtils;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.arguments.ArgumentSignatures;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentGetter;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestInstance;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.HashedStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenMessagesValidator;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.network.chat.PlayerChatMessage;
import net.minecraft.network.chat.RemoteChatSession;
import net.minecraft.network.chat.SignableCommand;
import net.minecraft.network.chat.SignedMessageBody;
import net.minecraft.network.chat.SignedMessageChain;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PlayerConnectionUtils;
import net.minecraft.network.protocol.common.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.common.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.configuration.ConfigurationProtocols;
import net.minecraft.network.protocol.game.ClientboundBlockChangedAckPacket;
import net.minecraft.network.protocol.game.ClientboundDisguisedChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerChatPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundStartConfigurationPacket;
import net.minecraft.network.protocol.game.ClientboundSystemChatPacket;
import net.minecraft.network.protocol.game.ClientboundTestInstanceBlockStatus;
import net.minecraft.network.protocol.game.GameProtocols;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.network.protocol.game.PacketPlayInAbilities;
import net.minecraft.network.protocol.game.PacketPlayInAdvancements;
import net.minecraft.network.protocol.game.PacketPlayInArmAnimation;
import net.minecraft.network.protocol.game.PacketPlayInAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayInBEdit;
import net.minecraft.network.protocol.game.PacketPlayInBeacon;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayInBlockPlace;
import net.minecraft.network.protocol.game.PacketPlayInBoatMove;
import net.minecraft.network.protocol.game.PacketPlayInChat;
import net.minecraft.network.protocol.game.PacketPlayInClientCommand;
import net.minecraft.network.protocol.game.PacketPlayInCloseWindow;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyChange;
import net.minecraft.network.protocol.game.PacketPlayInDifficultyLock;
import net.minecraft.network.protocol.game.PacketPlayInEnchantItem;
import net.minecraft.network.protocol.game.PacketPlayInEntityAction;
import net.minecraft.network.protocol.game.PacketPlayInEntityNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInFlying;
import net.minecraft.network.protocol.game.PacketPlayInHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayInItemName;
import net.minecraft.network.protocol.game.PacketPlayInJigsawGenerate;
import net.minecraft.network.protocol.game.PacketPlayInRecipeDisplayed;
import net.minecraft.network.protocol.game.PacketPlayInRecipeSettings;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandBlock;
import net.minecraft.network.protocol.game.PacketPlayInSetCommandMinecart;
import net.minecraft.network.protocol.game.PacketPlayInSetCreativeSlot;
import net.minecraft.network.protocol.game.PacketPlayInSetJigsaw;
import net.minecraft.network.protocol.game.PacketPlayInSpectate;
import net.minecraft.network.protocol.game.PacketPlayInSteerVehicle;
import net.minecraft.network.protocol.game.PacketPlayInStruct;
import net.minecraft.network.protocol.game.PacketPlayInTabComplete;
import net.minecraft.network.protocol.game.PacketPlayInTeleportAccept;
import net.minecraft.network.protocol.game.PacketPlayInTileNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayInTrSel;
import net.minecraft.network.protocol.game.PacketPlayInUpdateSign;
import net.minecraft.network.protocol.game.PacketPlayInUseEntity;
import net.minecraft.network.protocol.game.PacketPlayInUseItem;
import net.minecraft.network.protocol.game.PacketPlayInVehicleMove;
import net.minecraft.network.protocol.game.PacketPlayInWindowClick;
import net.minecraft.network.protocol.game.PacketPlayOutAutoRecipe;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.network.protocol.game.PacketPlayOutHeldItemSlot;
import net.minecraft.network.protocol.game.PacketPlayOutNBTQuery;
import net.minecraft.network.protocol.game.PacketPlayOutPosition;
import net.minecraft.network.protocol.game.PacketPlayOutTabComplete;
import net.minecraft.network.protocol.game.PacketPlayOutVehicleMove;
import net.minecraft.network.protocol.game.ServerboundChangeGameModePacket;
import net.minecraft.network.protocol.game.ServerboundChatAckPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandPacket;
import net.minecraft.network.protocol.game.ServerboundChatCommandSignedPacket;
import net.minecraft.network.protocol.game.ServerboundChatSessionUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundChunkBatchReceivedPacket;
import net.minecraft.network.protocol.game.ServerboundClientTickEndPacket;
import net.minecraft.network.protocol.game.ServerboundConfigurationAcknowledgedPacket;
import net.minecraft.network.protocol.game.ServerboundContainerSlotStateChangedPacket;
import net.minecraft.network.protocol.game.ServerboundDebugSampleSubscriptionPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromBlockPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemFromEntityPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerLoadedPacket;
import net.minecraft.network.protocol.game.ServerboundSelectBundleItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetTestBlockPacket;
import net.minecraft.network.protocol.game.ServerboundTestInstanceBlockActionPacket;
import net.minecraft.network.protocol.ping.ClientboundPongResponsePacket;
import net.minecraft.network.protocol.ping.ServerboundPingRequestPacket;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.Filterable;
import net.minecraft.server.network.FilteredText;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.PlayerChunkSender;
import net.minecraft.server.network.ServerCommonPacketListenerImpl;
import net.minecraft.server.network.ServerConfigurationPacketListenerImpl;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.FutureChain;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TickThrottler;
import net.minecraft.util.UtilColor;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityExperienceOrb;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.IJumpable;
import net.minecraft.world.entity.PositionMoveRotation;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.EnumChatVisibility;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.entity.player.ProfilePublicKey;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.vehicle.AbstractBoat;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.ContainerBeacon;
import net.minecraft.world.inventory.ContainerMerchant;
import net.minecraft.world.inventory.ContainerRecipeBook;
import net.minecraft.world.inventory.CrafterMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.CommandBlockListenerAbstract;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockCommand;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.CrafterBlockEntity;
import net.minecraft.world.level.block.entity.TestBlockEntity;
import net.minecraft.world.level.block.entity.TestInstanceBlockEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityCommand;
import net.minecraft.world.level.block.entity.TileEntityJigsaw;
import net.minecraft.world.level.block.entity.TileEntitySign;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;
import org.slf4j.Logger;

public class PlayerConnection
extends ServerCommonPacketListenerImpl
implements GameProtocols.a,
PacketListenerPlayIn,
ServerPlayerConnection,
TickablePacketListener {
    static final Logger LOGGER = LogUtils.getLogger();
    private static final int NO_BLOCK_UPDATES_TO_ACK = -1;
    private static final int TRACKED_MESSAGE_DISCONNECT_THRESHOLD = 4096;
    private static final int MAXIMUM_FLYING_TICKS = 80;
    private static final IChatBaseComponent CHAT_VALIDATION_FAILED = IChatBaseComponent.translatable("multiplayer.disconnect.chat_validation_failed");
    private static final IChatBaseComponent INVALID_COMMAND_SIGNATURE = IChatBaseComponent.translatable("chat.disabled.invalid_command_signature").withStyle(EnumChatFormat.RED);
    private static final int MAX_COMMAND_SUGGESTIONS = 1000;
    public EntityPlayer player;
    public final PlayerChunkSender chunkSender;
    private int tickCount;
    private int ackBlockChangesUpTo = -1;
    private final TickThrottler chatSpamThrottler = new TickThrottler(20, 200);
    private final TickThrottler dropSpamThrottler = new TickThrottler(20, 1480);
    private double firstGoodX;
    private double firstGoodY;
    private double firstGoodZ;
    private double lastGoodX;
    private double lastGoodY;
    private double lastGoodZ;
    @Nullable
    private Entity lastVehicle;
    private double vehicleFirstGoodX;
    private double vehicleFirstGoodY;
    private double vehicleFirstGoodZ;
    private double vehicleLastGoodX;
    private double vehicleLastGoodY;
    private double vehicleLastGoodZ;
    @Nullable
    private Vec3D awaitingPositionFromClient;
    private int awaitingTeleport;
    private int awaitingTeleportTime;
    private boolean clientIsFloating;
    private int aboveGroundTickCount;
    private boolean clientVehicleIsFloating;
    private int aboveGroundVehicleTickCount;
    private int receivedMovePacketCount;
    private int knownMovePacketCount;
    private boolean receivedMovementThisTick;
    @Nullable
    private RemoteChatSession chatSession;
    private SignedMessageChain.b signedMessageDecoder;
    private final LastSeenMessagesValidator lastSeenMessages = new LastSeenMessagesValidator(20);
    private int nextChatIndex;
    private final MessageSignatureCache messageSignatureCache = MessageSignatureCache.createDefault();
    private final FutureChain chatMessageChain;
    private boolean waitingForSwitchToConfig;

    public PlayerConnection(MinecraftServer var0, NetworkManager var1, EntityPlayer var2, CommonListenerCookie var3) {
        super(var0, var1, var3);
        this.chunkSender = new PlayerChunkSender(var1.isMemoryConnection());
        this.player = var2;
        var2.connection = this;
        var2.getTextFilter().join();
        this.signedMessageDecoder = SignedMessageChain.b.unsigned(var2.getUUID(), var0::enforceSecureProfile);
        this.chatMessageChain = new FutureChain(var0);
    }

    @Override
    public void tick() {
        if (this.ackBlockChangesUpTo > -1) {
            this.send(new ClientboundBlockChangedAckPacket(this.ackBlockChangesUpTo));
            this.ackBlockChangesUpTo = -1;
        }
        this.resetPosition();
        this.player.xo = this.player.getX();
        this.player.yo = this.player.getY();
        this.player.zo = this.player.getZ();
        this.player.doTick();
        this.player.absSnapTo(this.firstGoodX, this.firstGoodY, this.firstGoodZ, this.player.getYRot(), this.player.getXRot());
        ++this.tickCount;
        this.knownMovePacketCount = this.receivedMovePacketCount;
        if (this.clientIsFloating && !this.player.isSleeping() && !this.player.isPassenger() && !this.player.isDeadOrDying()) {
            if (++this.aboveGroundTickCount > this.getMaximumFlyingTicks(this.player)) {
                LOGGER.warn("{} was kicked for floating too long!", (Object)this.player.getName().getString());
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.clientIsFloating = false;
            this.aboveGroundTickCount = 0;
        }
        this.lastVehicle = this.player.getRootVehicle();
        if (this.lastVehicle == this.player || this.lastVehicle.getControllingPassenger() != this.player) {
            this.lastVehicle = null;
            this.clientVehicleIsFloating = false;
            this.aboveGroundVehicleTickCount = 0;
        } else {
            this.vehicleFirstGoodX = this.lastVehicle.getX();
            this.vehicleFirstGoodY = this.lastVehicle.getY();
            this.vehicleFirstGoodZ = this.lastVehicle.getZ();
            this.vehicleLastGoodX = this.lastVehicle.getX();
            this.vehicleLastGoodY = this.lastVehicle.getY();
            this.vehicleLastGoodZ = this.lastVehicle.getZ();
            if (this.clientVehicleIsFloating && this.lastVehicle.getControllingPassenger() == this.player) {
                if (++this.aboveGroundVehicleTickCount > this.getMaximumFlyingTicks(this.lastVehicle)) {
                    LOGGER.warn("{} was kicked for floating a vehicle too long!", (Object)this.player.getName().getString());
                    this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.clientVehicleIsFloating = false;
                this.aboveGroundVehicleTickCount = 0;
            }
        }
        this.keepConnectionAlive();
        this.chatSpamThrottler.tick();
        this.dropSpamThrottler.tick();
        if (this.player.getLastActionTime() > 0L && this.server.getPlayerIdleTimeout() > 0 && SystemUtils.getMillis() - this.player.getLastActionTime() > (long)this.server.getPlayerIdleTimeout() * 1000L * 60L) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.idling"));
        }
    }

    private int getMaximumFlyingTicks(Entity var0) {
        double var1 = var0.getGravity();
        if (var1 < (double)1.0E-5f) {
            return Integer.MAX_VALUE;
        }
        double var3 = 0.08 / var1;
        return MathHelper.ceil(80.0 * Math.max(var3, 1.0));
    }

    public void resetPosition() {
        this.firstGoodX = this.player.getX();
        this.firstGoodY = this.player.getY();
        this.firstGoodZ = this.player.getZ();
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    @Override
    public boolean isAcceptingMessages() {
        return this.connection.isConnected() && !this.waitingForSwitchToConfig;
    }

    @Override
    public boolean shouldHandleMessage(Packet<?> var0) {
        if (super.shouldHandleMessage(var0)) {
            return true;
        }
        return this.waitingForSwitchToConfig && this.connection.isConnected() && var0 instanceof ServerboundConfigurationAcknowledgedPacket;
    }

    @Override
    protected GameProfile playerProfile() {
        return this.player.getGameProfile();
    }

    private <T, R> CompletableFuture<R> filterTextPacket(T var02, BiFunction<ITextFilter, T, CompletableFuture<R>> var1) {
        return var1.apply(this.player.getTextFilter(), (ITextFilter)var02).thenApply(var0 -> {
            if (!this.isAcceptingMessages()) {
                LOGGER.debug("Ignoring packet due to disconnection");
                throw new CancellationException("disconnected");
            }
            return var0;
        });
    }

    private CompletableFuture<FilteredText> filterTextPacket(String var0) {
        return this.filterTextPacket(var0, ITextFilter::processStreamMessage);
    }

    private CompletableFuture<List<FilteredText>> filterTextPacket(List<String> var0) {
        return this.filterTextPacket(var0, ITextFilter::processMessageBundle);
    }

    @Override
    public void handlePlayerInput(PacketPlayInSteerVehicle var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.setLastClientInput(var0.input());
        if (this.player.hasClientLoaded()) {
            this.player.resetLastActionTime();
            this.player.setShiftKeyDown(var0.input().shift());
        }
    }

    private static boolean containsInvalidValues(double var0, double var2, double var4, float var6, float var7) {
        return Double.isNaN(var0) || Double.isNaN(var2) || Double.isNaN(var4) || !Floats.isFinite((float)var7) || !Floats.isFinite((float)var6);
    }

    private static double clampHorizontal(double var0) {
        return MathHelper.clamp(var0, -3.0E7, 3.0E7);
    }

    private static double clampVertical(double var0) {
        return MathHelper.clamp(var0, -2.0E7, 2.0E7);
    }

    @Override
    public void handleMoveVehicle(PacketPlayInVehicleMove var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (PlayerConnection.containsInvalidValues(var0.position().x(), var0.position().y(), var0.position().z(), var0.yRot(), var0.xRot())) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_vehicle_movement"));
            return;
        }
        if (this.updateAwaitingTeleport() || !this.player.hasClientLoaded()) {
            return;
        }
        Entity var1 = this.player.getRootVehicle();
        if (var1 != this.player && var1.getControllingPassenger() == this.player && var1 == this.lastVehicle) {
            EntityLiving var29;
            WorldServer var2 = this.player.level();
            double var3 = var1.getX();
            double var5 = var1.getY();
            double var7 = var1.getZ();
            double var9 = PlayerConnection.clampHorizontal(var0.position().x());
            double var11 = PlayerConnection.clampVertical(var0.position().y());
            double var13 = PlayerConnection.clampHorizontal(var0.position().z());
            float var15 = MathHelper.wrapDegrees(var0.yRot());
            float var16 = MathHelper.wrapDegrees(var0.xRot());
            double var17 = var9 - this.vehicleFirstGoodX;
            double var19 = var11 - this.vehicleFirstGoodY;
            double var21 = var13 - this.vehicleFirstGoodZ;
            double var25 = var17 * var17 + var19 * var19 + var21 * var21;
            double var23 = var1.getDeltaMovement().lengthSqr();
            if (var25 - var23 > 100.0 && !this.isSingleplayerOwner()) {
                LOGGER.warn("{} (vehicle of {}) moved too quickly! {},{},{}", new Object[]{var1.getName().getString(), this.player.getName().getString(), var17, var19, var21});
                this.send(PacketPlayOutVehicleMove.fromEntity(var1));
                return;
            }
            AxisAlignedBB var27 = var1.getBoundingBox();
            var17 = var9 - this.vehicleLastGoodX;
            var19 = var11 - this.vehicleLastGoodY;
            var21 = var13 - this.vehicleLastGoodZ;
            boolean var28 = var1.verticalCollisionBelow;
            if (var1 instanceof EntityLiving && (var29 = (EntityLiving)var1).onClimbable()) {
                var29.resetFallDistance();
            }
            var1.move(EnumMoveType.PLAYER, new Vec3D(var17, var19, var21));
            double var292 = var19;
            var17 = var9 - var1.getX();
            var19 = var11 - var1.getY();
            if (var19 > -0.5 || var19 < 0.5) {
                var19 = 0.0;
            }
            var21 = var13 - var1.getZ();
            var25 = var17 * var17 + var19 * var19 + var21 * var21;
            boolean var31 = false;
            if (var25 > 0.0625) {
                var31 = true;
                LOGGER.warn("{} (vehicle of {}) moved wrongly! {}", new Object[]{var1.getName().getString(), this.player.getName().getString(), Math.sqrt(var25)});
            }
            if (var31 && var2.noCollision(var1, var27) || this.isEntityCollidingWithAnythingNew(var2, var1, var27, var9, var11, var13)) {
                var1.absSnapTo(var3, var5, var7, var15, var16);
                this.send(PacketPlayOutVehicleMove.fromEntity(var1));
                var1.removeLatestMovementRecording();
                return;
            }
            var1.absSnapTo(var9, var11, var13, var15, var16);
            this.player.level().getChunkSource().move(this.player);
            Vec3D var32 = new Vec3D(var1.getX() - var3, var1.getY() - var5, var1.getZ() - var7);
            this.handlePlayerKnownMovement(var32);
            var1.setOnGroundWithMovement(var0.onGround(), var32);
            var1.doCheckFallDamage(var32.x, var32.y, var32.z, var0.onGround());
            this.player.checkMovementStatistics(var32.x, var32.y, var32.z);
            this.clientVehicleIsFloating = var292 >= -0.03125 && !var28 && !this.server.isFlightAllowed() && !var1.isFlyingVehicle() && !var1.isNoGravity() && this.noBlocksAround(var1);
            this.vehicleLastGoodX = var1.getX();
            this.vehicleLastGoodY = var1.getY();
            this.vehicleLastGoodZ = var1.getZ();
        }
    }

    private boolean noBlocksAround(Entity var0) {
        return var0.level().getBlockStates(var0.getBoundingBox().inflate(0.0625).expandTowards(0.0, -0.55, 0.0)).allMatch(BlockBase.BlockData::isAir);
    }

    @Override
    public void handleAcceptTeleportPacket(PacketPlayInTeleportAccept var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (var0.getId() == this.awaitingTeleport) {
            if (this.awaitingPositionFromClient == null) {
                this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_movement"));
                return;
            }
            this.player.absSnapTo(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            this.lastGoodX = this.awaitingPositionFromClient.x;
            this.lastGoodY = this.awaitingPositionFromClient.y;
            this.lastGoodZ = this.awaitingPositionFromClient.z;
            this.player.hasChangedDimension();
            this.awaitingPositionFromClient = null;
        }
    }

    @Override
    public void handleAcceptPlayerLoad(ServerboundPlayerLoadedPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.setClientLoaded(true);
    }

    @Override
    public void handleRecipeBookSeenRecipePacket(PacketPlayInRecipeDisplayed var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        CraftingManager.d var1 = this.server.getRecipeManager().getRecipeFromDisplay(var0.recipe());
        if (var1 != null) {
            this.player.getRecipeBook().removeHighlight(var1.parent().id());
        }
    }

    @Override
    public void handleBundleItemSelectedPacket(ServerboundSelectBundleItemPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.containerMenu.setSelectedBundleItemIndex(var0.slotId(), var0.selectedItemIndex());
    }

    @Override
    public void handleRecipeBookChangeSettingsPacket(PacketPlayInRecipeSettings var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.getRecipeBook().setBookSetting(var0.getBookType(), var0.isOpen(), var0.isFiltering());
    }

    @Override
    public void handleSeenAdvancements(PacketPlayInAdvancements var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (var0.getAction() == PacketPlayInAdvancements.Status.OPENED_TAB) {
            MinecraftKey var1 = Objects.requireNonNull(var0.getTab());
            AdvancementHolder var2 = this.server.getAdvancements().get(var1);
            if (var2 != null) {
                this.player.getAdvancements().setSelectedTab(var2);
            }
        }
    }

    @Override
    public void handleCustomCommandSuggestions(PacketPlayInTabComplete var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        StringReader var12 = new StringReader(var0.getCommand());
        if (var12.canRead() && var12.peek() == '/') {
            var12.skip();
        }
        ParseResults var2 = this.server.getCommands().getDispatcher().parse(var12, (Object)this.player.createCommandSourceStack());
        this.server.getCommands().getDispatcher().getCompletionSuggestions(var2).thenAccept(var1 -> {
            Suggestions var2 = var1.getList().size() <= 1000 ? var1 : new Suggestions(var1.getRange(), var1.getList().subList(0, 1000));
            this.send(new PacketPlayOutTabComplete(var0.getId(), var2));
        });
    }

    @Override
    public void handleSetCommandBlock(PacketPlayInSetCommandBlock var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled"));
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notAllowed"));
            return;
        }
        CommandBlockListenerAbstract var1 = null;
        TileEntityCommand var2 = null;
        BlockPosition var3 = var0.getPos();
        TileEntity var4 = this.player.level().getBlockEntity(var3);
        if (var4 instanceof TileEntityCommand) {
            var2 = (TileEntityCommand)var4;
            var1 = var2.getCommandBlock();
        }
        String var5 = var0.getCommand();
        boolean var6 = var0.isTrackOutput();
        if (var1 != null) {
            TileEntityCommand.Type var7 = var2.getMode();
            IBlockData var8 = this.player.level().getBlockState(var3);
            EnumDirection var9 = var8.getValue(BlockCommand.FACING);
            IBlockData var10 = switch (var0.getMode()) {
                case TileEntityCommand.Type.SEQUENCE -> Blocks.CHAIN_COMMAND_BLOCK.defaultBlockState();
                case TileEntityCommand.Type.AUTO -> Blocks.REPEATING_COMMAND_BLOCK.defaultBlockState();
                default -> Blocks.COMMAND_BLOCK.defaultBlockState();
            };
            IBlockData var11 = (IBlockData)((IBlockData)var10.setValue(BlockCommand.FACING, var9)).setValue(BlockCommand.CONDITIONAL, var0.isConditional());
            if (var11 != var8) {
                this.player.level().setBlock(var3, var11, 2);
                var4.setBlockState(var11);
                this.player.level().getChunkAt(var3).setBlockEntity(var4);
            }
            var1.setCommand(var5);
            var1.setTrackOutput(var6);
            if (!var6) {
                var1.setLastOutput(null);
            }
            var2.setAutomatic(var0.isAutomatic());
            if (var7 != var0.getMode()) {
                var2.onModeSwitch();
            }
            var1.onUpdated();
            if (!UtilColor.isNullOrEmpty(var5)) {
                this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.setCommand.success", var5));
            }
        }
    }

    @Override
    public void handleSetCommandMinecart(PacketPlayInSetCommandMinecart var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.server.isCommandBlockEnabled()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notEnabled"));
            return;
        }
        if (!this.player.canUseGameMasterBlocks()) {
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.notAllowed"));
            return;
        }
        CommandBlockListenerAbstract var1 = var0.getCommandBlock(this.player.level());
        if (var1 != null) {
            var1.setCommand(var0.getCommand());
            var1.setTrackOutput(var0.isTrackOutput());
            if (!var0.isTrackOutput()) {
                var1.setLastOutput(null);
            }
            var1.onUpdated();
            this.player.sendSystemMessage(IChatBaseComponent.translatable("advMode.setCommand.success", var0.getCommand()));
        }
    }

    @Override
    public void handlePickItemFromBlock(ServerboundPickItemFromBlockPacket var0) {
        boolean var4;
        WorldServer var1 = this.player.level();
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, var1);
        BlockPosition var2 = var0.pos();
        if (!this.player.canInteractWithBlock(var2, 1.0)) {
            return;
        }
        if (!var1.isLoaded(var2)) {
            return;
        }
        IBlockData var3 = var1.getBlockState(var2);
        ItemStack var5 = var3.getCloneItemStack(var1, var2, var4 = this.player.hasInfiniteMaterials() && var0.includeData());
        if (var5.isEmpty()) {
            return;
        }
        if (var4) {
            PlayerConnection.addBlockDataToItem(var3, var1, var2, var5);
        }
        this.tryPickItem(var5);
    }

    private static void addBlockDataToItem(IBlockData var0, WorldServer var1, BlockPosition var2, ItemStack var3) {
        TileEntity var4;
        TileEntity tileEntity = var4 = var0.hasBlockEntity() ? var1.getBlockEntity(var2) : null;
        if (var4 != null) {
            try (ProblemReporter.j var5 = new ProblemReporter.j(var4.problemPath(), LOGGER);){
                TagValueOutput var6 = TagValueOutput.createWithContext(var5, var1.registryAccess());
                var4.saveCustomOnly(var6);
                var4.removeComponentsFromTag(var6);
                ItemBlock.setBlockEntityData(var3, var4.getType(), var6);
                var3.applyComponents(var4.collectComponents());
            }
        }
    }

    @Override
    public void handlePickItemFromEntity(ServerboundPickItemFromEntityPacket var0) {
        WorldServer var1 = this.player.level();
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, var1);
        Entity var2 = var1.getEntityOrPart(var0.id());
        if (var2 == null || !this.player.canInteractWithEntity(var2, 3.0)) {
            return;
        }
        ItemStack var3 = var2.getPickResult();
        if (var3 != null && !var3.isEmpty()) {
            this.tryPickItem(var3);
        }
    }

    private void tryPickItem(ItemStack var0) {
        if (!var0.isItemEnabled(this.player.level().enabledFeatures())) {
            return;
        }
        PlayerInventory var1 = this.player.getInventory();
        int var2 = var1.findSlotMatchingItem(var0);
        if (var2 != -1) {
            if (PlayerInventory.isHotbarSlot(var2)) {
                var1.setSelectedSlot(var2);
            } else {
                var1.pickSlot(var2);
            }
        } else if (this.player.hasInfiniteMaterials()) {
            var1.addAndPickItem(var0);
        }
        this.send(new PacketPlayOutHeldItemSlot(var1.getSelectedSlot()));
        this.player.inventoryMenu.broadcastChanges();
    }

    @Override
    public void handleRenameItem(PacketPlayInItemName var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        Container container = this.player.containerMenu;
        if (container instanceof ContainerAnvil) {
            ContainerAnvil var1 = (ContainerAnvil)container;
            if (!var1.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)var1);
                return;
            }
            var1.setItemName(var0.getName());
        }
    }

    @Override
    public void handleSetBeaconPacket(PacketPlayInBeacon var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        Container container = this.player.containerMenu;
        if (container instanceof ContainerBeacon) {
            ContainerBeacon var1 = (ContainerBeacon)container;
            if (!this.player.containerMenu.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
                return;
            }
            var1.updateEffects(var0.primary(), var0.secondary());
        }
    }

    @Override
    public void handleSetStructureBlock(PacketPlayInStruct var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        IBlockData var2 = this.player.level().getBlockState(var1);
        TileEntity var3 = this.player.level().getBlockEntity(var1);
        if (var3 instanceof TileEntityStructure) {
            TileEntityStructure var4 = (TileEntityStructure)var3;
            var4.setMode(var0.getMode());
            var4.setStructureName(var0.getName());
            var4.setStructurePos(var0.getOffset());
            var4.setStructureSize(var0.getSize());
            var4.setMirror(var0.getMirror());
            var4.setRotation(var0.getRotation());
            var4.setMetaData(var0.getData());
            var4.setIgnoreEntities(var0.isIgnoreEntities());
            var4.setStrict(var0.isStrict());
            var4.setShowAir(var0.isShowAir());
            var4.setShowBoundingBox(var0.isShowBoundingBox());
            var4.setIntegrity(var0.getIntegrity());
            var4.setSeed(var0.getSeed());
            if (var4.hasStructureName()) {
                String var5 = var4.getStructureName();
                if (var0.getUpdateType() == TileEntityStructure.UpdateType.SAVE_AREA) {
                    if (var4.saveStructure()) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.save_success", var5), false);
                    } else {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.save_failure", var5), false);
                    }
                } else if (var0.getUpdateType() == TileEntityStructure.UpdateType.LOAD_AREA) {
                    if (!var4.isStructureLoadable()) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_not_found", var5), false);
                    } else if (var4.placeStructureIfSameSize(this.player.level())) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_success", var5), false);
                    } else {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.load_prepare", var5), false);
                    }
                } else if (var0.getUpdateType() == TileEntityStructure.UpdateType.SCAN_AREA) {
                    if (var4.detectSize()) {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.size_success", var5), false);
                    } else {
                        this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.size_failure"), false);
                    }
                }
            } else {
                this.player.displayClientMessage(IChatBaseComponent.translatable("structure_block.invalid_structure_name", var0.getName()), false);
            }
            var4.setChanged();
            this.player.level().sendBlockUpdated(var1, var2, var2, 3);
        }
    }

    @Override
    public void handleSetTestBlock(ServerboundSetTestBlockPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.position();
        IBlockData var2 = this.player.level().getBlockState(var1);
        TileEntity var3 = this.player.level().getBlockEntity(var1);
        if (var3 instanceof TestBlockEntity) {
            TestBlockEntity var4 = (TestBlockEntity)var3;
            var4.setMode(var0.mode());
            var4.setMessage(var0.message());
            var4.setChanged();
            this.player.level().sendBlockUpdated(var1, var2, var4.getBlockState(), 3);
        }
    }

    @Override
    public void handleTestInstanceBlockAction(ServerboundTestInstanceBlockActionPacket var02) {
        TileEntity tileEntity;
        PlayerConnectionUtils.ensureRunningOnSameThread(var02, this, this.player.level());
        BlockPosition var1 = var02.pos();
        if (!this.player.canUseGameMasterBlocks() || !((tileEntity = this.player.level().getBlockEntity(var1)) instanceof TestInstanceBlockEntity)) {
            return;
        }
        TestInstanceBlockEntity var2 = (TestInstanceBlockEntity)tileEntity;
        if (var02.action() == ServerboundTestInstanceBlockActionPacket.a.QUERY || var02.action() == ServerboundTestInstanceBlockActionPacket.a.INIT) {
            var3 = this.player.registryAccess().lookupOrThrow(Registries.TEST_INSTANCE);
            Optional var4 = var02.data().test().flatMap(((IRegistry)var3)::get);
            IChatBaseComponent var5 = var4.isPresent() ? ((GameTestInstance)((Holder.c)var4.get()).value()).describe() : IChatBaseComponent.translatable("test_instance.description.no_test").withStyle(EnumChatFormat.RED);
            Optional<Object> var6 = var02.action() == ServerboundTestInstanceBlockActionPacket.a.QUERY ? var02.data().test().flatMap(var0 -> TestInstanceBlockEntity.getStructureSize(this.player.level(), var0)) : Optional.empty();
            this.connection.send(new ClientboundTestInstanceBlockStatus(var5, var6));
        } else {
            var2.set(var02.data());
            if (var02.action() == ServerboundTestInstanceBlockActionPacket.a.RESET) {
                var2.resetTest(this.player::sendSystemMessage);
            } else if (var02.action() == ServerboundTestInstanceBlockActionPacket.a.SAVE) {
                var2.saveTest(this.player::sendSystemMessage);
            } else if (var02.action() == ServerboundTestInstanceBlockActionPacket.a.EXPORT) {
                var2.exportTest(this.player::sendSystemMessage);
            } else if (var02.action() == ServerboundTestInstanceBlockActionPacket.a.RUN) {
                var2.runTest(this.player::sendSystemMessage);
            }
            var3 = this.player.level().getBlockState(var1);
            this.player.level().sendBlockUpdated(var1, Blocks.AIR.defaultBlockState(), (IBlockData)var3, 3);
        }
    }

    @Override
    public void handleSetJigsawBlock(PacketPlayInSetJigsaw var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        IBlockData var2 = this.player.level().getBlockState(var1);
        TileEntity var3 = this.player.level().getBlockEntity(var1);
        if (var3 instanceof TileEntityJigsaw) {
            TileEntityJigsaw var4 = (TileEntityJigsaw)var3;
            var4.setName(var0.getName());
            var4.setTarget(var0.getTarget());
            var4.setPool(ResourceKey.create(Registries.TEMPLATE_POOL, var0.getPool()));
            var4.setFinalState(var0.getFinalState());
            var4.setJoint(var0.getJoint());
            var4.setPlacementPriority(var0.getPlacementPriority());
            var4.setSelectionPriority(var0.getSelectionPriority());
            var4.setChanged();
            this.player.level().sendBlockUpdated(var1, var2, var2, 3);
        }
    }

    @Override
    public void handleJigsawGenerate(PacketPlayInJigsawGenerate var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.canUseGameMasterBlocks()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        TileEntity var2 = this.player.level().getBlockEntity(var1);
        if (var2 instanceof TileEntityJigsaw) {
            TileEntityJigsaw var3 = (TileEntityJigsaw)var2;
            var3.generate(this.player.level(), var0.levels(), var0.keepJigsaws());
        }
    }

    @Override
    public void handleSelectTrade(PacketPlayInTrSel var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        int var1 = var0.getItem();
        Container container = this.player.containerMenu;
        if (container instanceof ContainerMerchant) {
            ContainerMerchant var2 = (ContainerMerchant)container;
            if (!var2.stillValid(this.player)) {
                LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)var2);
                return;
            }
            var2.setSelectionHint(var1);
            var2.tryMoveItems(var1);
        }
    }

    @Override
    public void handleEditBook(PacketPlayInBEdit var0) {
        int var12 = var0.slot();
        if (!PlayerInventory.isHotbarSlot(var12) && var12 != 40) {
            return;
        }
        ArrayList var2 = Lists.newArrayList();
        Optional<String> var3 = var0.title();
        var3.ifPresent(var2::add);
        var2.addAll(var0.pages());
        Consumer<List> var4 = var3.isPresent() ? var1 -> this.signBook((FilteredText)var1.get(0), var1.subList(1, var1.size()), var12) : var1 -> this.updateBookContents((List<FilteredText>)var1, var12);
        this.filterTextPacket(var2).thenAcceptAsync(var4, (Executor)this.server);
    }

    private void updateBookContents(List<FilteredText> var0, int var1) {
        ItemStack var2 = this.player.getInventory().getItem(var1);
        if (!var2.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            return;
        }
        List<Filterable<String>> var3 = var0.stream().map(this::filterableFromOutgoing).toList();
        var2.set(DataComponents.WRITABLE_BOOK_CONTENT, new WritableBookContent(var3));
    }

    private void signBook(FilteredText var02, List<FilteredText> var1, int var2) {
        ItemStack var3 = this.player.getInventory().getItem(var2);
        if (!var3.has(DataComponents.WRITABLE_BOOK_CONTENT)) {
            return;
        }
        ItemStack var4 = var3.transmuteCopy(Items.WRITTEN_BOOK);
        var4.remove(DataComponents.WRITABLE_BOOK_CONTENT);
        List<Filterable<IChatBaseComponent>> var5 = var1.stream().map(var0 -> this.filterableFromOutgoing((FilteredText)var0).map(IChatBaseComponent::literal)).toList();
        var4.set(DataComponents.WRITTEN_BOOK_CONTENT, new WrittenBookContent(this.filterableFromOutgoing(var02), this.player.getName().getString(), 0, var5, true));
        this.player.getInventory().setItem(var2, var4);
    }

    private Filterable<String> filterableFromOutgoing(FilteredText var0) {
        if (this.player.isTextFilteringEnabled()) {
            return Filterable.passThrough(var0.filteredOrEmpty());
        }
        return Filterable.from(var0);
    }

    @Override
    public void handleEntityTagQuery(PacketPlayInEntityNBTQuery var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        Entity var1 = this.player.level().getEntity(var0.getEntityId());
        if (var1 != null) {
            try (ProblemReporter.j var2 = new ProblemReporter.j(var1.problemPath(), LOGGER);){
                TagValueOutput var3 = TagValueOutput.createWithContext(var2, var1.registryAccess());
                var1.saveWithoutId(var3);
                NBTTagCompound var4 = var3.buildResult();
                this.send(new PacketPlayOutNBTQuery(var0.getTransactionId(), var4));
            }
        }
    }

    @Override
    public void handleContainerSlotStateChanged(ServerboundContainerSlotStateChangedPacket var0) {
        CrafterMenu var1;
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (this.player.isSpectator() || var0.containerId() != this.player.containerMenu.containerId) {
            return;
        }
        Object object = this.player.containerMenu;
        if (object instanceof CrafterMenu && (object = (var1 = (CrafterMenu)object).getContainer()) instanceof CrafterBlockEntity) {
            CrafterBlockEntity var2 = (CrafterBlockEntity)object;
            var2.setSlotState(var0.slotId(), var0.newState());
        }
    }

    @Override
    public void handleBlockEntityTagQuery(PacketPlayInTileNBTQuery var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasPermissions(2)) {
            return;
        }
        TileEntity var1 = this.player.level().getBlockEntity(var0.getPos());
        NBTTagCompound var2 = var1 != null ? var1.saveWithoutMetadata(this.player.registryAccess()) : null;
        this.send(new PacketPlayOutNBTQuery(var0.getTransactionId(), var2));
    }

    @Override
    public void handleMovePlayer(PacketPlayInFlying var0) {
        boolean var28;
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (PlayerConnection.containsInvalidValues(var0.getX(0.0), var0.getY(0.0), var0.getZ(0.0), var0.getYRot(0.0f), var0.getXRot(0.0f))) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_player_movement"));
            return;
        }
        WorldServer var1 = this.player.level();
        if (this.player.wonGame) {
            return;
        }
        if (this.tickCount == 0) {
            this.resetPosition();
        }
        if (!this.player.hasClientLoaded()) {
            return;
        }
        float var2 = MathHelper.wrapDegrees(var0.getYRot(this.player.getYRot()));
        float var3 = MathHelper.wrapDegrees(var0.getXRot(this.player.getXRot()));
        if (this.updateAwaitingTeleport()) {
            this.player.absSnapRotationTo(var2, var3);
            return;
        }
        double var4 = PlayerConnection.clampHorizontal(var0.getX(this.player.getX()));
        double var6 = PlayerConnection.clampVertical(var0.getY(this.player.getY()));
        double var8 = PlayerConnection.clampHorizontal(var0.getZ(this.player.getZ()));
        if (this.player.isPassenger()) {
            this.player.absSnapTo(this.player.getX(), this.player.getY(), this.player.getZ(), var2, var3);
            this.player.level().getChunkSource().move(this.player);
            return;
        }
        double var10 = this.player.getX();
        double var12 = this.player.getY();
        double var14 = this.player.getZ();
        double var16 = var4 - this.firstGoodX;
        double var18 = var6 - this.firstGoodY;
        double var20 = var8 - this.firstGoodZ;
        double var22 = this.player.getDeltaMovement().lengthSqr();
        double var24 = var16 * var16 + var18 * var18 + var20 * var20;
        if (this.player.isSleeping()) {
            if (var24 > 1.0) {
                this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), var2, var3);
            }
            return;
        }
        boolean var26 = this.player.isFallFlying();
        if (var1.tickRateManager().runsNormally()) {
            ++this.receivedMovePacketCount;
            int var27 = this.receivedMovePacketCount - this.knownMovePacketCount;
            if (var27 > 5) {
                LOGGER.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.player.getName().getString(), (Object)var27);
                var27 = 1;
            }
            if (this.shouldCheckPlayerMovement(var26)) {
                float var282;
                float f2 = var282 = var26 ? 300.0f : 100.0f;
                if (var24 - var22 > (double)(var282 * (float)var27)) {
                    LOGGER.warn("{} moved too quickly! {},{},{}", new Object[]{this.player.getName().getString(), var16, var18, var20});
                    this.teleport(this.player.getX(), this.player.getY(), this.player.getZ(), this.player.getYRot(), this.player.getXRot());
                    return;
                }
            }
        }
        AxisAlignedBB var27 = this.player.getBoundingBox();
        var16 = var4 - this.lastGoodX;
        var18 = var6 - this.lastGoodY;
        var20 = var8 - this.lastGoodZ;
        boolean bl = var28 = var18 > 0.0;
        if (this.player.onGround() && !var0.isOnGround() && var28) {
            this.player.jumpFromGround();
        }
        boolean var29 = this.player.verticalCollisionBelow;
        this.player.move(EnumMoveType.PLAYER, new Vec3D(var16, var18, var20));
        double var30 = var18;
        var16 = var4 - this.player.getX();
        var18 = var6 - this.player.getY();
        if (var18 > -0.5 || var18 < 0.5) {
            var18 = 0.0;
        }
        var20 = var8 - this.player.getZ();
        var24 = var16 * var16 + var18 * var18 + var20 * var20;
        boolean var32 = false;
        if (!(this.player.isChangingDimension() || !(var24 > 0.0625) || this.player.isSleeping() || this.player.isCreative() || this.player.isSpectator())) {
            var32 = true;
            LOGGER.warn("{} moved wrongly!", (Object)this.player.getName().getString());
        }
        if (!this.player.noPhysics && !this.player.isSleeping() && (var32 && var1.noCollision(this.player, var27) || this.isEntityCollidingWithAnythingNew(var1, this.player, var27, var4, var6, var8))) {
            this.teleport(var10, var12, var14, var2, var3);
            this.player.doCheckFallDamage(this.player.getX() - var10, this.player.getY() - var12, this.player.getZ() - var14, var0.isOnGround());
            this.player.removeLatestMovementRecording();
            return;
        }
        this.player.absSnapTo(var4, var6, var8, var2, var3);
        boolean var33 = this.player.isAutoSpinAttack();
        this.clientIsFloating = var30 >= -0.03125 && !var29 && !this.player.isSpectator() && !this.server.isFlightAllowed() && !this.player.getAbilities().mayfly && !this.player.hasEffect(MobEffects.LEVITATION) && !var26 && !var33 && this.noBlocksAround(this.player);
        this.player.level().getChunkSource().move(this.player);
        Vec3D var34 = new Vec3D(this.player.getX() - var10, this.player.getY() - var12, this.player.getZ() - var14);
        this.player.setOnGroundWithMovement(var0.isOnGround(), var0.horizontalCollision(), var34);
        this.player.doCheckFallDamage(var34.x, var34.y, var34.z, var0.isOnGround());
        this.handlePlayerKnownMovement(var34);
        if (var28) {
            this.player.resetFallDistance();
        }
        if (var0.isOnGround() || this.player.hasLandedInLiquid() || this.player.onClimbable() || this.player.isSpectator() || var26 || var33) {
            this.player.tryResetCurrentImpulseContext();
        }
        this.player.checkMovementStatistics(this.player.getX() - var10, this.player.getY() - var12, this.player.getZ() - var14);
        this.lastGoodX = this.player.getX();
        this.lastGoodY = this.player.getY();
        this.lastGoodZ = this.player.getZ();
    }

    private boolean shouldCheckPlayerMovement(boolean var0) {
        if (this.isSingleplayerOwner()) {
            return false;
        }
        if (this.player.isChangingDimension()) {
            return false;
        }
        GameRules var1 = this.player.level().getGameRules();
        if (var1.getBoolean(GameRules.RULE_DISABLE_PLAYER_MOVEMENT_CHECK)) {
            return false;
        }
        return !var0 || !var1.getBoolean(GameRules.RULE_DISABLE_ELYTRA_MOVEMENT_CHECK);
    }

    private boolean updateAwaitingTeleport() {
        if (this.awaitingPositionFromClient != null) {
            if (this.tickCount - this.awaitingTeleportTime > 20) {
                this.awaitingTeleportTime = this.tickCount;
                this.teleport(this.awaitingPositionFromClient.x, this.awaitingPositionFromClient.y, this.awaitingPositionFromClient.z, this.player.getYRot(), this.player.getXRot());
            }
            return true;
        }
        this.awaitingTeleportTime = this.tickCount;
        return false;
    }

    private boolean isEntityCollidingWithAnythingNew(IWorldReader var0, Entity var1, AxisAlignedBB var2, double var3, double var5, double var7) {
        AxisAlignedBB var9 = var1.getBoundingBox().move(var3 - var1.getX(), var5 - var1.getY(), var7 - var1.getZ());
        Iterable<VoxelShape> var10 = var0.getPreMoveCollisions(var1, var9.deflate(1.0E-5f), var2.getBottomCenter());
        VoxelShape var11 = VoxelShapes.create(var2.deflate(1.0E-5f));
        for (VoxelShape var13 : var10) {
            if (VoxelShapes.joinIsNotEmpty(var13, var11, OperatorBoolean.AND)) continue;
            return true;
        }
        return false;
    }

    public void teleport(double var0, double var2, double var4, float var6, float var7) {
        this.teleport(new PositionMoveRotation(new Vec3D(var0, var2, var4), Vec3D.ZERO, var6, var7), Collections.emptySet());
    }

    public void teleport(PositionMoveRotation var0, Set<Relative> var1) {
        this.awaitingTeleportTime = this.tickCount;
        if (++this.awaitingTeleport == Integer.MAX_VALUE) {
            this.awaitingTeleport = 0;
        }
        this.player.teleportSetPosition(var0, var1);
        this.awaitingPositionFromClient = this.player.position();
        this.send(PacketPlayOutPosition.of(this.awaitingTeleport, var0, var1));
    }

    @Override
    public void handlePlayerAction(PacketPlayInBlockDig var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasClientLoaded()) {
            return;
        }
        BlockPosition var1 = var0.getPos();
        this.player.resetLastActionTime();
        PacketPlayInBlockDig.EnumPlayerDigType var2 = var0.getAction();
        switch (var2) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.player.isSpectator()) {
                    ItemStack var3 = this.player.getItemInHand(EnumHand.OFF_HAND);
                    this.player.setItemInHand(EnumHand.OFF_HAND, this.player.getItemInHand(EnumHand.MAIN_HAND));
                    this.player.setItemInHand(EnumHand.MAIN_HAND, var3);
                    this.player.stopUsingItem();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.player.isSpectator()) {
                    this.player.drop(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.player.isSpectator()) {
                    this.player.drop(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.player.releaseUsingItem();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.player.gameMode.handleBlockBreakAction(var1, var2, var0.getDirection(), this.player.level().getMaxY(), var0.getSequence());
                this.ackBlockChangesUpTo(var0.getSequence());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean wasBlockPlacementAttempt(EntityPlayer var0, ItemStack var1) {
        if (var1.isEmpty()) {
            return false;
        }
        Item var2 = var1.getItem();
        return (var2 instanceof ItemBlock || var2 instanceof ItemBucket) && !var0.getCooldowns().isOnCooldown(var1);
    }

    @Override
    public void handleUseItemOn(PacketPlayInUseItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasClientLoaded()) {
            return;
        }
        this.ackBlockChangesUpTo(var0.getSequence());
        WorldServer var1 = this.player.level();
        EnumHand var2 = var0.getHand();
        ItemStack var3 = this.player.getItemInHand(var2);
        if (!var3.isItemEnabled(var1.enabledFeatures())) {
            return;
        }
        MovingObjectPositionBlock var4 = var0.getHitResult();
        Vec3D var5 = var4.getLocation();
        BlockPosition var6 = var4.getBlockPos();
        if (!this.player.canInteractWithBlock(var6, 1.0)) {
            return;
        }
        Vec3D var7 = var5.subtract(Vec3D.atCenterOf(var6));
        double var8 = 1.0000001;
        if (!(Math.abs(var7.x()) < 1.0000001 && Math.abs(var7.y()) < 1.0000001 && Math.abs(var7.z()) < 1.0000001)) {
            LOGGER.warn("Rejecting UseItemOnPacket from {}: Location {} too far away from hit block {}.", new Object[]{this.player.getGameProfile().getName(), var5, var6});
            return;
        }
        EnumDirection var10 = var4.getDirection();
        this.player.resetLastActionTime();
        int var11 = this.player.level().getMaxY();
        if (var6.getY() <= var11) {
            if (this.awaitingPositionFromClient == null && var1.mayInteract(this.player, var6)) {
                EnumInteractionResult.d var13;
                EnumInteractionResult var12 = this.player.gameMode.useItemOn(this.player, var1, var3, var2, var4);
                if (var12.consumesAction()) {
                    CriterionTriggers.ANY_BLOCK_USE.trigger(this.player, var4.getBlockPos(), var3.copy());
                }
                if (var10 == EnumDirection.UP && !var12.consumesAction() && var6.getY() >= var11 && PlayerConnection.wasBlockPlacementAttempt(this.player, var3)) {
                    IChatMutableComponent var14 = IChatBaseComponent.translatable("build.tooHigh", var11).withStyle(EnumChatFormat.RED);
                    this.player.sendSystemMessage(var14, true);
                } else if (var12 instanceof EnumInteractionResult.d && (var13 = (EnumInteractionResult.d)var12).swingSource() == EnumInteractionResult.e.SERVER) {
                    this.player.swing(var2, true);
                }
            }
        } else {
            IChatMutableComponent var12 = IChatBaseComponent.translatable("build.tooHigh", var11).withStyle(EnumChatFormat.RED);
            this.player.sendSystemMessage(var12, true);
        }
        this.send(new PacketPlayOutBlockChange(var1, var6));
        this.send(new PacketPlayOutBlockChange(var1, var6.relative(var10)));
    }

    @Override
    public void handleUseItem(PacketPlayInBlockPlace var0) {
        EnumInteractionResult.d var7;
        EnumInteractionResult var6;
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasClientLoaded()) {
            return;
        }
        this.ackBlockChangesUpTo(var0.getSequence());
        WorldServer var1 = this.player.level();
        EnumHand var2 = var0.getHand();
        ItemStack var3 = this.player.getItemInHand(var2);
        this.player.resetLastActionTime();
        if (var3.isEmpty() || !var3.isItemEnabled(var1.enabledFeatures())) {
            return;
        }
        float var4 = MathHelper.wrapDegrees(var0.getYRot());
        float var5 = MathHelper.wrapDegrees(var0.getXRot());
        if (var5 != this.player.getXRot() || var4 != this.player.getYRot()) {
            this.player.absSnapRotationTo(var4, var5);
        }
        if ((var6 = this.player.gameMode.useItem(this.player, var1, var3, var2)) instanceof EnumInteractionResult.d && (var7 = (EnumInteractionResult.d)var6).swingSource() == EnumInteractionResult.e.SERVER) {
            this.player.swing(var2, true);
        }
    }

    @Override
    public void handleTeleportToEntityPacket(PacketPlayInSpectate var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (this.player.isSpectator()) {
            for (WorldServer var2 : this.server.getAllLevels()) {
                Entity var3 = var0.getEntity(var2);
                if (var3 == null) continue;
                this.player.teleportTo(var2, var3.getX(), var3.getY(), var3.getZ(), Set.of(), var3.getYRot(), var3.getXRot(), true);
                return;
            }
        }
    }

    @Override
    public void handlePaddleBoat(PacketPlayInBoatMove var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        Entity var1 = this.player.getControlledVehicle();
        if (var1 instanceof AbstractBoat) {
            AbstractBoat var2 = (AbstractBoat)var1;
            var2.setPaddleState(var0.getLeft(), var0.getRight());
        }
    }

    @Override
    public void onDisconnect(DisconnectionDetails var0) {
        LOGGER.info("{} lost connection: {}", (Object)this.player.getName().getString(), (Object)var0.reason().getString());
        this.removePlayerFromWorld();
        super.onDisconnect(var0);
    }

    private void removePlayerFromWorld() {
        this.chatMessageChain.close();
        this.server.invalidateStatus();
        this.server.getPlayerList().broadcastSystemMessage(IChatBaseComponent.translatable("multiplayer.player.left", this.player.getDisplayName()).withStyle(EnumChatFormat.YELLOW), false);
        this.player.disconnect();
        this.server.getPlayerList().remove(this.player);
        this.player.getTextFilter().leave();
    }

    public void ackBlockChangesUpTo(int var0) {
        if (var0 < 0) {
            throw new IllegalArgumentException("Expected packet sequence nr >= 0");
        }
        this.ackBlockChangesUpTo = Math.max(var0, this.ackBlockChangesUpTo);
    }

    @Override
    public void handleSetCarriedItem(PacketPlayInHeldItemSlot var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (var0.getSlot() < 0 || var0.getSlot() >= PlayerInventory.getSelectionSize()) {
            LOGGER.warn("{} tried to set an invalid carried item", (Object)this.player.getName().getString());
            return;
        }
        if (this.player.getInventory().getSelectedSlot() != var0.getSlot() && this.player.getUsedItemHand() == EnumHand.MAIN_HAND) {
            this.player.stopUsingItem();
        }
        this.player.getInventory().setSelectedSlot(var0.getSlot());
        this.player.resetLastActionTime();
    }

    @Override
    public void handleChat(PacketPlayInChat var0) {
        Optional<LastSeenMessages> var1 = this.unpackAndApplyLastSeen(var0.lastSeenMessages());
        if (var1.isEmpty()) {
            return;
        }
        this.tryHandleChat(var0.message(), () -> {
            PlayerChatMessage var22;
            try {
                var22 = this.getSignedMessage(var0, (LastSeenMessages)var1.get());
            }
            catch (SignedMessageChain.a var3) {
                this.handleMessageDecodeFailure(var3);
                return;
            }
            CompletableFuture<FilteredText> var3 = this.filterTextPacket(var22.signedContent());
            IChatBaseComponent var4 = this.server.getChatDecorator().decorate(this.player, var22.decoratedContent());
            this.chatMessageChain.append(var3, var2 -> {
                PlayerChatMessage var3 = var22.withUnsignedContent(var4).filter(var2.mask());
                this.broadcastChatMessage(var3);
            });
        });
    }

    @Override
    public void handleChatCommand(ServerboundChatCommandPacket var0) {
        this.tryHandleChat(var0.command(), () -> {
            this.performUnsignedChatCommand(var0.command());
            this.detectRateSpam();
        });
    }

    private void performUnsignedChatCommand(String var0) {
        ParseResults<CommandListenerWrapper> var1 = this.parseCommand(var0);
        if (this.server.enforceSecureProfile() && SignableCommand.hasSignableArguments(var1)) {
            LOGGER.error("Received unsigned command packet from {}, but the command requires signable arguments: {}", (Object)this.player.getGameProfile().getName(), (Object)var0);
            this.player.sendSystemMessage(INVALID_COMMAND_SIGNATURE);
            return;
        }
        this.server.getCommands().performCommand(var1, var0);
    }

    @Override
    public void handleSignedChatCommand(ServerboundChatCommandSignedPacket var0) {
        Optional<LastSeenMessages> var1 = this.unpackAndApplyLastSeen(var0.lastSeenMessages());
        if (var1.isEmpty()) {
            return;
        }
        this.tryHandleChat(var0.command(), () -> {
            this.performSignedChatCommand(var0, (LastSeenMessages)var1.get());
            this.detectRateSpam();
        });
    }

    private void performSignedChatCommand(ServerboundChatCommandSignedPacket var0, LastSeenMessages var12) {
        Map<String, PlayerChatMessage> var3;
        ParseResults<CommandListenerWrapper> var2 = this.parseCommand(var0.command());
        try {
            var3 = this.collectSignedArguments(var0, SignableCommand.of(var2), var12);
        }
        catch (SignedMessageChain.a var4) {
            this.handleMessageDecodeFailure(var4);
            return;
        }
        CommandSigningContext.a var4 = new CommandSigningContext.a(var3);
        var2 = net.minecraft.commands.CommandDispatcher.mapSource(var2, var1 -> var1.withSigningContext(var4, this.chatMessageChain));
        this.server.getCommands().performCommand(var2, var0.command());
    }

    private void handleMessageDecodeFailure(SignedMessageChain.a var0) {
        LOGGER.warn("Failed to update secure chat state for {}: '{}'", (Object)this.player.getGameProfile().getName(), (Object)var0.getComponent().getString());
        this.player.sendSystemMessage(var0.getComponent().copy().withStyle(EnumChatFormat.RED));
    }

    private <S> Map<String, PlayerChatMessage> collectSignedArguments(ServerboundChatCommandSignedPacket var0, SignableCommand<S> var1, LastSeenMessages var2) throws SignedMessageChain.a {
        List<ArgumentSignatures.a> var3 = var0.argumentSignatures().entries();
        List<SignableCommand.a<S>> var4 = var1.arguments();
        if (var3.isEmpty()) {
            return this.collectUnsignedArguments(var4);
        }
        Object2ObjectOpenHashMap var5 = new Object2ObjectOpenHashMap();
        for (ArgumentSignatures.a a2 : var3) {
            SignableCommand.a<S> var8 = var1.getArgument(a2.name());
            if (var8 == null) {
                this.signedMessageDecoder.setChainBroken();
                throw PlayerConnection.createSignedArgumentMismatchException(var0.command(), var3, var4);
            }
            SignedMessageBody var9 = new SignedMessageBody(var8.value(), var0.timeStamp(), var0.salt(), var2);
            var5.put(var8.name(), this.signedMessageDecoder.unpack(a2.signature(), var9));
        }
        for (SignableCommand.a a3 : var4) {
            if (var5.containsKey(a3.name())) continue;
            throw PlayerConnection.createSignedArgumentMismatchException(var0.command(), var3, var4);
        }
        return var5;
    }

    private <S> Map<String, PlayerChatMessage> collectUnsignedArguments(List<SignableCommand.a<S>> var0) throws SignedMessageChain.a {
        HashMap<String, PlayerChatMessage> var1 = new HashMap<String, PlayerChatMessage>();
        for (SignableCommand.a<S> var3 : var0) {
            SignedMessageBody var4 = SignedMessageBody.unsigned(var3.value());
            var1.put(var3.name(), this.signedMessageDecoder.unpack(null, var4));
        }
        return var1;
    }

    private static <S> SignedMessageChain.a createSignedArgumentMismatchException(String var0, List<ArgumentSignatures.a> var1, List<SignableCommand.a<S>> var2) {
        String var3 = var1.stream().map(ArgumentSignatures.a::name).collect(Collectors.joining(", "));
        String var4 = var2.stream().map(SignableCommand.a::name).collect(Collectors.joining(", "));
        LOGGER.error("Signed command mismatch between server and client ('{}'): got [{}] from client, but expected [{}]", new Object[]{var0, var3, var4});
        return new SignedMessageChain.a(INVALID_COMMAND_SIGNATURE);
    }

    private ParseResults<CommandListenerWrapper> parseCommand(String var0) {
        CommandDispatcher<CommandListenerWrapper> var1 = this.server.getCommands().getDispatcher();
        return var1.parse(var0, (Object)this.player.createCommandSourceStack());
    }

    private void tryHandleChat(String var0, Runnable var1) {
        if (PlayerConnection.isChatMessageIllegal(var0)) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.illegal_characters"));
            return;
        }
        if (this.player.getChatVisibility() == EnumChatVisibility.HIDDEN) {
            this.send(new ClientboundSystemChatPacket(IChatBaseComponent.translatable("chat.disabled.options").withStyle(EnumChatFormat.RED), false));
            return;
        }
        this.player.resetLastActionTime();
        this.server.execute(var1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<LastSeenMessages> unpackAndApplyLastSeen(LastSeenMessages.b var0) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            try {
                LastSeenMessages var2 = this.lastSeenMessages.applyUpdate(var0);
                return Optional.of(var2);
            }
            catch (LastSeenMessagesValidator.a var2) {
                LOGGER.error("Failed to validate message acknowledgements from {}: {}", (Object)this.player.getName().getString(), (Object)var2.getMessage());
                this.disconnect(CHAT_VALIDATION_FAILED);
                return Optional.empty();
            }
        }
    }

    private static boolean isChatMessageIllegal(String var0) {
        for (int var1 = 0; var1 < var0.length(); ++var1) {
            if (UtilColor.isAllowedChatCharacter(var0.charAt(var1))) continue;
            return true;
        }
        return false;
    }

    private PlayerChatMessage getSignedMessage(PacketPlayInChat var0, LastSeenMessages var1) throws SignedMessageChain.a {
        SignedMessageBody var2 = new SignedMessageBody(var0.message(), var0.timeStamp(), var0.salt(), var1);
        return this.signedMessageDecoder.unpack(var0.signature(), var2);
    }

    private void broadcastChatMessage(PlayerChatMessage var0) {
        this.server.getPlayerList().broadcastChatMessage(var0, this.player, ChatMessageType.bind(ChatMessageType.CHAT, this.player));
        this.detectRateSpam();
    }

    private void detectRateSpam() {
        this.chatSpamThrottler.increment();
        if (!(this.chatSpamThrottler.isUnderThreshold() || this.server.getPlayerList().isOp(this.player.getGameProfile()) || this.server.isSingleplayerOwner(this.player.getGameProfile()))) {
            this.disconnect(IChatBaseComponent.translatable("disconnect.spam"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleChatAck(ServerboundChatAckPacket var0) {
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            try {
                this.lastSeenMessages.applyOffset(var0.offset());
            }
            catch (LastSeenMessagesValidator.a var2) {
                LOGGER.error("Failed to validate message acknowledgement offset from {}: {}", (Object)this.player.getName().getString(), (Object)var2.getMessage());
                this.disconnect(CHAT_VALIDATION_FAILED);
            }
        }
    }

    @Override
    public void handleAnimate(PacketPlayInArmAnimation var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.resetLastActionTime();
        this.player.swing(var0.getHand());
    }

    @Override
    public void handlePlayerCommand(PacketPlayInEntityAction var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasClientLoaded()) {
            return;
        }
        this.player.resetLastActionTime();
        switch (var0.getAction()) {
            case START_SPRINTING: {
                this.player.setSprinting(true);
                break;
            }
            case STOP_SPRINTING: {
                this.player.setSprinting(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.player.isSleeping()) break;
                this.player.stopSleepInBed(false, true);
                this.awaitingPositionFromClient = this.player.position();
                break;
            }
            case START_RIDING_JUMP: {
                Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof IJumpable)) break;
                IJumpable var1 = (IJumpable)((Object)entity);
                int var2 = var0.getData();
                if (!var1.canJump() || var2 <= 0) break;
                var1.handleStartJump(var2);
                break;
            }
            case STOP_RIDING_JUMP: {
                Entity entity = this.player.getControlledVehicle();
                if (!(entity instanceof IJumpable)) break;
                IJumpable var1 = (IJumpable)((Object)entity);
                var1.handleStopJump();
                break;
            }
            case OPEN_INVENTORY: {
                Entity entity = this.player.getVehicle();
                if (!(entity instanceof HasCustomInventoryScreen)) break;
                HasCustomInventoryScreen var1 = (HasCustomInventoryScreen)((Object)entity);
                var1.openCustomInventoryScreen(this.player);
                break;
            }
            case START_FALL_FLYING: {
                if (this.player.tryToStartFallFlying()) break;
                this.player.stopFallFlying();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPlayerChatMessage(PlayerChatMessage var0, ChatMessageType.a var1) {
        int var3;
        this.send(new ClientboundPlayerChatPacket(this.nextChatIndex++, var0.link().sender(), var0.link().index(), var0.signature(), var0.signedBody().pack(this.messageSignatureCache), var0.unsignedContent(), var0.filterMask(), var1));
        MessageSignature var2 = var0.signature();
        if (var2 == null) {
            return;
        }
        this.messageSignatureCache.push(var0.signedBody(), var0.signature());
        LastSeenMessagesValidator lastSeenMessagesValidator = this.lastSeenMessages;
        synchronized (lastSeenMessagesValidator) {
            this.lastSeenMessages.addPending(var2);
            var3 = this.lastSeenMessages.trackedMessagesCount();
        }
        if (var3 > 4096) {
            this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.too_many_pending_chats"));
        }
    }

    public void sendDisguisedChatMessage(IChatBaseComponent var0, ChatMessageType.a var1) {
        this.send(new ClientboundDisguisedChatPacket(var0, var1));
    }

    public SocketAddress getRemoteAddress() {
        return this.connection.getRemoteAddress();
    }

    public void switchToConfig() {
        this.waitingForSwitchToConfig = true;
        this.removePlayerFromWorld();
        this.send(ClientboundStartConfigurationPacket.INSTANCE);
        this.connection.setupOutboundProtocol(ConfigurationProtocols.CLIENTBOUND);
    }

    @Override
    public void handlePingRequest(ServerboundPingRequestPacket var0) {
        this.connection.send(new ClientboundPongResponsePacket(var0.getTime()));
    }

    @Override
    public void handleInteract(PacketPlayInUseEntity var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasClientLoaded()) {
            return;
        }
        final WorldServer var1 = this.player.level();
        final Entity var2 = var0.getTarget(var1);
        this.player.resetLastActionTime();
        this.player.setShiftKeyDown(var0.isUsingSecondaryAction());
        if (var2 != null) {
            if (!var1.getWorldBorder().isWithinBounds(var2.blockPosition())) {
                return;
            }
            AxisAlignedBB var3 = var2.getBoundingBox();
            if (this.player.canInteractWithEntity(var3, 3.0)) {
                var0.dispatch(new PacketPlayInUseEntity.c(){

                    private void performInteraction(EnumHand var0, a var12) {
                        ItemStack var22 = PlayerConnection.this.player.getItemInHand(var0);
                        if (!var22.isItemEnabled(var1.enabledFeatures())) {
                            return;
                        }
                        ItemStack var3 = var22.copy();
                        EnumInteractionResult var4 = var12.run(PlayerConnection.this.player, var2, var0);
                        if (var4 instanceof EnumInteractionResult.d) {
                            EnumInteractionResult.d var5 = (EnumInteractionResult.d)var4;
                            ItemStack var6 = var5.wasItemInteraction() ? var3 : ItemStack.EMPTY;
                            CriterionTriggers.PLAYER_INTERACTED_WITH_ENTITY.trigger(PlayerConnection.this.player, var6, var2);
                            if (var5.swingSource() == EnumInteractionResult.e.SERVER) {
                                PlayerConnection.this.player.swing(var0, true);
                            }
                        }
                    }

                    @Override
                    public void onInteraction(EnumHand var0) {
                        this.performInteraction(var0, EntityHuman::interactOn);
                    }

                    @Override
                    public void onInteraction(EnumHand var0, Vec3D var12) {
                        this.performInteraction(var0, (var1, var2, var3) -> var2.interactAt(var1, var12, var3));
                    }

                    @Override
                    public void onAttack() {
                        DataComponentGetter var0;
                        if (var2 instanceof EntityItem || var2 instanceof EntityExperienceOrb || var2 == PlayerConnection.this.player || var2 instanceof EntityArrow && !((EntityArrow)(var0 = (EntityArrow)var2)).isAttackable()) {
                            PlayerConnection.this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_entity_attacked"));
                            LOGGER.warn("Player {} tried to attack an invalid entity", (Object)PlayerConnection.this.player.getName().getString());
                            return;
                        }
                        var0 = PlayerConnection.this.player.getItemInHand(EnumHand.MAIN_HAND);
                        if (!((ItemStack)var0).isItemEnabled(var1.enabledFeatures())) {
                            return;
                        }
                        PlayerConnection.this.player.attack(var2);
                    }
                });
            }
        }
    }

    @Override
    public void handleClientCommand(PacketPlayInClientCommand var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.resetLastActionTime();
        PacketPlayInClientCommand.EnumClientCommand var1 = var0.getAction();
        switch (var1) {
            case PERFORM_RESPAWN: {
                if (this.player.wonGame) {
                    this.player.wonGame = false;
                    this.player = this.server.getPlayerList().respawn(this.player, true, Entity.RemovalReason.CHANGED_DIMENSION);
                    this.resetPosition();
                    CriterionTriggers.CHANGED_DIMENSION.trigger(this.player, World.END, World.OVERWORLD);
                    break;
                }
                if (this.player.getHealth() > 0.0f) {
                    return;
                }
                this.player = this.server.getPlayerList().respawn(this.player, false, Entity.RemovalReason.KILLED);
                this.resetPosition();
                if (!this.server.isHardcore()) break;
                this.player.setGameMode(EnumGamemode.SPECTATOR);
                this.player.level().getGameRules().getRule(GameRules.RULE_SPECTATORSGENERATECHUNKS).set(false, this.server);
                break;
            }
            case REQUEST_STATS: {
                this.player.getStats().sendStats(this.player);
            }
        }
    }

    @Override
    public void handleContainerClose(PacketPlayInCloseWindow var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.doCloseContainer();
    }

    @Override
    public void handleContainerClick(PacketPlayInWindowClick var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId != var0.containerId()) {
            return;
        }
        if (this.player.isSpectator()) {
            this.player.containerMenu.sendAllDataToRemote();
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        short var1 = var0.slotNum();
        if (!this.player.containerMenu.isValidSlotIndex(var1)) {
            LOGGER.debug("Player {} clicked invalid slot index: {}, available slots: {}", new Object[]{this.player.getName(), (int)var1, this.player.containerMenu.slots.size()});
            return;
        }
        boolean var2 = var0.stateId() != this.player.containerMenu.getStateId();
        this.player.containerMenu.suppressRemoteUpdates();
        this.player.containerMenu.clicked(var1, var0.buttonNum(), var0.clickType(), this.player);
        for (Int2ObjectMap.Entry var4 : Int2ObjectMaps.fastIterable(var0.changedSlots())) {
            this.player.containerMenu.setRemoteSlotUnsafe(var4.getIntKey(), (HashedStack)var4.getValue());
        }
        this.player.containerMenu.setRemoteCarried(var0.carriedItem());
        this.player.containerMenu.resumeRemoteUpdates();
        if (var2) {
            this.player.containerMenu.broadcastFullState();
        } else {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handlePlaceRecipe(PacketPlayInAutoRecipe var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.resetLastActionTime();
        if (this.player.isSpectator() || this.player.containerMenu.containerId != var0.containerId()) {
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        CraftingManager.d var1 = this.server.getRecipeManager().getRecipeFromDisplay(var0.recipe());
        if (var1 == null) {
            return;
        }
        RecipeHolder<?> var2 = var1.parent();
        if (!this.player.getRecipeBook().contains(var2.id())) {
            return;
        }
        Container container = this.player.containerMenu;
        if (container instanceof ContainerRecipeBook) {
            ContainerRecipeBook var3 = (ContainerRecipeBook)container;
            if (var2.value().placementInfo().isImpossibleToPlace()) {
                LOGGER.debug("Player {} tried to place impossible recipe {}", (Object)this.player, (Object)var2.id().location());
                return;
            }
            ContainerRecipeBook.a var4 = var3.handlePlacement(var0.useMaxItems(), this.player.isCreative(), var2, this.player.level(), this.player.getInventory());
            if (var4 == ContainerRecipeBook.a.PLACE_GHOST_RECIPE) {
                this.send(new PacketPlayOutAutoRecipe(this.player.containerMenu.containerId, var1.display().display()));
            }
        }
    }

    @Override
    public void handleContainerButtonClick(PacketPlayInEnchantItem var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.resetLastActionTime();
        if (this.player.containerMenu.containerId != var0.containerId() || this.player.isSpectator()) {
            return;
        }
        if (!this.player.containerMenu.stillValid(this.player)) {
            LOGGER.debug("Player {} interacted with invalid menu {}", (Object)this.player, (Object)this.player.containerMenu);
            return;
        }
        boolean var1 = this.player.containerMenu.clickMenuButton(this.player, var0.buttonId());
        if (var1) {
            this.player.containerMenu.broadcastChanges();
        }
    }

    @Override
    public void handleSetCreativeModeSlot(PacketPlayInSetCreativeSlot var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (this.player.hasInfiniteMaterials()) {
            boolean var4;
            boolean var1 = var0.slotNum() < 0;
            ItemStack var2 = var0.itemStack();
            if (!var2.isItemEnabled(this.player.level().enabledFeatures())) {
                return;
            }
            boolean var3 = var0.slotNum() >= 1 && var0.slotNum() <= 45;
            boolean bl = var4 = var2.isEmpty() || var2.getCount() <= var2.getMaxStackSize();
            if (var3 && var4) {
                this.player.inventoryMenu.getSlot(var0.slotNum()).setByPlayer(var2);
                this.player.inventoryMenu.setRemoteSlot(var0.slotNum(), var2);
                this.player.inventoryMenu.broadcastChanges();
            } else if (var1 && var4) {
                if (this.dropSpamThrottler.isUnderThreshold()) {
                    this.dropSpamThrottler.increment();
                    this.player.drop(var2, true);
                } else {
                    LOGGER.warn("Player {} was dropping items too fast in creative mode, ignoring.", (Object)this.player.getName().getString());
                }
            }
        }
    }

    @Override
    public void handleSignUpdate(PacketPlayInUpdateSign var0) {
        List<String> var12 = Stream.of(var0.getLines()).map(EnumChatFormat::stripFormatting).collect(Collectors.toList());
        this.filterTextPacket(var12).thenAcceptAsync(var1 -> this.updateSignText(var0, (List<FilteredText>)var1), (Executor)this.server);
    }

    private void updateSignText(PacketPlayInUpdateSign var0, List<FilteredText> var1) {
        this.player.resetLastActionTime();
        WorldServer var2 = this.player.level();
        BlockPosition var3 = var0.getPos();
        if (var2.hasChunkAt(var3)) {
            TileEntity var4 = var2.getBlockEntity(var3);
            if (!(var4 instanceof TileEntitySign)) {
                return;
            }
            TileEntitySign var5 = (TileEntitySign)var4;
            var5.updateSignText(this.player, var0.isFrontText(), var1);
        }
    }

    @Override
    public void handlePlayerAbilities(PacketPlayInAbilities var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.player.getAbilities().flying = var0.isFlying() && this.player.getAbilities().mayfly;
    }

    @Override
    public void handleClientInformation(ServerboundClientInformationPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        boolean var1 = this.player.isModelPartShown(PlayerModelPart.HAT);
        this.player.updateOptions(var0.information());
        if (this.player.isModelPartShown(PlayerModelPart.HAT) != var1) {
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.UPDATE_HAT, this.player));
        }
    }

    @Override
    public void handleChangeDifficulty(PacketPlayInDifficultyChange var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            LOGGER.warn("Player {} tried to change difficulty to {} without required permissions", (Object)this.player.getGameProfile().getName(), (Object)var0.difficulty().getDisplayName());
            return;
        }
        this.server.setDifficulty(var0.difficulty(), false);
    }

    @Override
    public void handleChangeGameMode(ServerboundChangeGameModePacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasPermissions(2)) {
            LOGGER.warn("Player {} tried to change game mode to {} without required permissions", (Object)this.player.getGameProfile().getName(), (Object)var0.mode().getShortDisplayName());
            return;
        }
        CommandGamemode.setGameMode(this.player, var0.mode());
    }

    @Override
    public void handleLockDifficulty(PacketPlayInDifficultyLock var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.player.hasPermissions(2) && !this.isSingleplayerOwner()) {
            return;
        }
        this.server.setDifficultyLocked(var0.isLocked());
    }

    @Override
    public void handleChatSessionUpdate(ServerboundChatSessionUpdatePacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        RemoteChatSession.a var1 = var0.chatSession();
        ProfilePublicKey.a var2 = this.chatSession != null ? this.chatSession.profilePublicKey().data() : null;
        ProfilePublicKey.a var3 = var1.profilePublicKey();
        if (Objects.equals(var2, var3)) {
            return;
        }
        if (var2 != null && var3.expiresAt().isBefore(var2.expiresAt())) {
            this.disconnect(ProfilePublicKey.EXPIRED_PROFILE_PUBLIC_KEY);
            return;
        }
        try {
            SignatureValidator var4 = this.server.getProfileKeySignatureValidator();
            if (var4 == null) {
                LOGGER.warn("Ignoring chat session from {} due to missing Services public key", (Object)this.player.getGameProfile().getName());
                return;
            }
            this.resetPlayerChatState(var1.validate(this.player.getGameProfile(), var4));
        }
        catch (ProfilePublicKey.b var4) {
            LOGGER.error("Failed to validate profile key: {}", (Object)var4.getMessage());
            this.disconnect(var4.getComponent());
        }
    }

    @Override
    public void handleConfigurationAcknowledged(ServerboundConfigurationAcknowledgedPacket var0) {
        if (!this.waitingForSwitchToConfig) {
            throw new IllegalStateException("Client acknowledged config, but none was requested");
        }
        this.connection.setupInboundProtocol(ConfigurationProtocols.SERVERBOUND, new ServerConfigurationPacketListenerImpl(this.server, this.connection, this.createCookie(this.player.clientInformation())));
    }

    @Override
    public void handleChunkBatchReceived(ServerboundChunkBatchReceivedPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.chunkSender.onChunkBatchReceivedByClient(var0.desiredChunksPerTick());
    }

    @Override
    public void handleDebugSampleSubscription(ServerboundDebugSampleSubscriptionPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        this.server.subscribeToDebugSample(this.player, var0.sampleType());
    }

    private void resetPlayerChatState(RemoteChatSession var0) {
        this.chatSession = var0;
        this.signedMessageDecoder = var0.createMessageDecoder(this.player.getUUID());
        this.chatMessageChain.append(() -> {
            this.player.setChatSession(var0);
            this.server.getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(EnumSet.of(ClientboundPlayerInfoUpdatePacket.a.INITIALIZE_CHAT), List.of(this.player)));
        });
    }

    @Override
    public void handleCustomPayload(ServerboundCustomPayloadPacket var0) {
    }

    @Override
    public void handleClientTickEnd(ServerboundClientTickEndPacket var0) {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, this, this.player.level());
        if (!this.receivedMovementThisTick) {
            this.player.setKnownMovement(Vec3D.ZERO);
        }
        this.receivedMovementThisTick = false;
    }

    private void handlePlayerKnownMovement(Vec3D var0) {
        if (var0.lengthSqr() > (double)1.0E-5f) {
            this.player.resetLastActionTime();
        }
        this.player.setKnownMovement(var0);
        this.receivedMovementThisTick = true;
    }

    @Override
    public boolean hasInfiniteMaterials() {
        return this.player.hasInfiniteMaterials();
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @FunctionalInterface
    static interface a {
        public EnumInteractionResult run(EntityPlayer var1, Entity var2, EnumHand var3);
    }
}

