/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import java.util.List;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.common.ClientboundTransferPacket;
import net.minecraft.server.level.EntityPlayer;

public class TransferCommand {
    private static final SimpleCommandExceptionType ERROR_NO_PLAYERS = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.transfer.error.no_players"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("transfer").requires(net.minecraft.commands.CommandDispatcher.hasPermission(3))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("hostname", StringArgumentType.string()).executes(var0 -> TransferCommand.transfer((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"hostname"), 25565, List.of(((CommandListenerWrapper)var0.getSource()).getPlayerOrException())))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("port", IntegerArgumentType.integer((int)1, (int)65535)).executes(var0 -> TransferCommand.transfer((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"hostname"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port"), List.of(((CommandListenerWrapper)var0.getSource()).getPlayerOrException())))).then(net.minecraft.commands.CommandDispatcher.argument("players", ArgumentEntity.players()).executes(var0 -> TransferCommand.transfer((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"hostname"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"port"), ArgumentEntity.getPlayers((CommandContext<CommandListenerWrapper>)var0, "players")))))));
    }

    private static int transfer(CommandListenerWrapper var0, String var1, int var2, Collection<EntityPlayer> var3) throws CommandSyntaxException {
        if (var3.isEmpty()) {
            throw ERROR_NO_PLAYERS.create();
        }
        for (EntityPlayer var5 : var3) {
            var5.connection.send(new ClientboundTransferPacket(var1, var2));
        }
        if (var3.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.transfer.success.single", ((EntityPlayer)var3.iterator().next()).getDisplayName(), var1, var2), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.transfer.success.multiple", var3.size(), var1, var2), true);
        }
        return var3.size();
    }
}

