/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.ArgumentInventorySlot;
import net.minecraft.commands.arguments.ResourceOrIdArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.commands.arguments.item.ArgumentItemStack;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameters;

public class ItemCommands {
    static final Dynamic3CommandExceptionType ERROR_TARGET_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatableEscape("commands.item.target.not_a_container", var0, var1, var2));
    static final Dynamic3CommandExceptionType ERROR_SOURCE_NOT_A_CONTAINER = new Dynamic3CommandExceptionType((var0, var1, var2) -> IChatBaseComponent.translatableEscape("commands.item.source.not_a_container", var0, var1, var2));
    static final DynamicCommandExceptionType ERROR_TARGET_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.item.target.no_such_slot", var0));
    private static final DynamicCommandExceptionType ERROR_SOURCE_INAPPLICABLE_SLOT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.item.source.no_such_slot", var0));
    private static final DynamicCommandExceptionType ERROR_TARGET_NO_CHANGES = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.item.target.no_changes", var0));
    private static final Dynamic2CommandExceptionType ERROR_TARGET_NO_CHANGES_KNOWN_ITEM = new Dynamic2CommandExceptionType((var0, var1) -> IChatBaseComponent.translatableEscape("commands.item.target.no_changed.known_item", var0, var1));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var1) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("item").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("replace").then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()).then(net.minecraft.commands.CommandDispatcher.literal("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item", ArgumentItemStack.item(var1)).executes(var0 -> ItemCommands.setBlockItem((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.getItem(var0, "item").createItemStack(1, false)))).then(net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)1, (int)99)).executes(var0 -> ItemCommands.setBlockItem((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.getItem(var0, "item").createItemStack(IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sourceSlot", ArgumentInventorySlot.slot()).executes(var0 -> ItemCommands.blockToBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.argument("modifier", ResourceOrIdArgument.lootModifier(var1)).executes(var0 -> ItemCommands.blockToBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentEntity.entity()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sourceSlot", ArgumentInventorySlot.slot()).executes(var0 -> ItemCommands.entityToBlock((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.argument("modifier", ResourceOrIdArgument.lootModifier(var1)).executes(var0 -> ItemCommands.entityToBlock((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))))))).then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()).then(net.minecraft.commands.CommandDispatcher.literal("with").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("item", ArgumentItemStack.item(var1)).executes(var0 -> ItemCommands.setEntityItem((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.getItem(var0, "item").createItemStack(1, false)))).then(net.minecraft.commands.CommandDispatcher.argument("count", IntegerArgumentType.integer((int)1, (int)99)).executes(var0 -> ItemCommands.setEntityItem((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ArgumentItemStack.getItem(var0, "item").createItemStack(IntegerArgumentType.getInteger((CommandContext)var0, (String)"count"), true))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("from").then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sourceSlot", ArgumentInventorySlot.slot()).executes(var0 -> ItemCommands.blockToEntities((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.argument("modifier", ResourceOrIdArgument.lootModifier(var1)).executes(var0 -> ItemCommands.blockToEntities((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("source", ArgumentEntity.entity()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("sourceSlot", ArgumentInventorySlot.slot()).executes(var0 -> ItemCommands.entityToEntities((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot")))).then(net.minecraft.commands.CommandDispatcher.argument("modifier", ResourceOrIdArgument.lootModifier(var1)).executes(var0 -> ItemCommands.entityToEntities((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntity((CommandContext<CommandListenerWrapper>)var0, "source"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "sourceSlot"), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandListenerWrapper>)var0, "modifier"))))))))))))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("modify").then(net.minecraft.commands.CommandDispatcher.literal("block").then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()).then(net.minecraft.commands.CommandDispatcher.argument("modifier", ResourceOrIdArgument.lootModifier(var1)).executes(var0 -> ItemCommands.modifyBlockItem((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))).then(net.minecraft.commands.CommandDispatcher.literal("entity").then(net.minecraft.commands.CommandDispatcher.argument("targets", ArgumentEntity.entities()).then(net.minecraft.commands.CommandDispatcher.argument("slot", ArgumentInventorySlot.slot()).then(net.minecraft.commands.CommandDispatcher.argument("modifier", ResourceOrIdArgument.lootModifier(var1)).executes(var0 -> ItemCommands.modifyEntityItem((CommandListenerWrapper)var0.getSource(), ArgumentEntity.getEntities((CommandContext<CommandListenerWrapper>)var0, "targets"), ArgumentInventorySlot.getSlot((CommandContext<CommandListenerWrapper>)var0, "slot"), ResourceOrIdArgument.getLootModifier((CommandContext<CommandListenerWrapper>)var0, "modifier")))))))));
    }

    private static int modifyBlockItem(CommandListenerWrapper var0, BlockPosition var1, int var2, Holder<LootItemFunction> var3) throws CommandSyntaxException {
        IInventory var4 = ItemCommands.getContainer(var0, var1, ERROR_TARGET_NOT_A_CONTAINER);
        if (var2 < 0 || var2 >= var4.getContainerSize()) {
            throw ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)var2);
        }
        ItemStack var5 = ItemCommands.applyModifier(var0, var3, var4.getItem(var2));
        var4.setItem(var2, var5);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.item.block.set.success", var1.getX(), var1.getY(), var1.getZ(), var5.getDisplayName()), true);
        return 1;
    }

    private static int modifyEntityItem(CommandListenerWrapper var0, Collection<? extends Entity> var1, int var2, Holder<LootItemFunction> var3) throws CommandSyntaxException {
        HashMap var4 = Maps.newHashMapWithExpectedSize((int)var1.size());
        for (Entity entity : var1) {
            ItemStack var8;
            SlotAccess var7 = entity.getSlot(var2);
            if (var7 == SlotAccess.NULL || !var7.set(var8 = ItemCommands.applyModifier(var0, var3, var7.get().copy()))) continue;
            var4.put(entity, var8);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).containerMenu.broadcastChanges();
        }
        if (var4.isEmpty()) {
            throw ERROR_TARGET_NO_CHANGES.create((Object)var2);
        }
        if (var4.size() == 1) {
            Map.Entry var5 = var4.entrySet().iterator().next();
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.item.entity.set.success.single", ((Entity)var5.getKey()).getDisplayName(), ((ItemStack)var5.getValue()).getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.item.entity.set.success.multiple", var4.size()), true);
        }
        return var4.size();
    }

    private static int setBlockItem(CommandListenerWrapper var0, BlockPosition var1, int var2, ItemStack var3) throws CommandSyntaxException {
        IInventory var4 = ItemCommands.getContainer(var0, var1, ERROR_TARGET_NOT_A_CONTAINER);
        if (var2 < 0 || var2 >= var4.getContainerSize()) {
            throw ERROR_TARGET_INAPPLICABLE_SLOT.create((Object)var2);
        }
        var4.setItem(var2, var3);
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.item.block.set.success", var1.getX(), var1.getY(), var1.getZ(), var3.getDisplayName()), true);
        return 1;
    }

    static IInventory getContainer(CommandListenerWrapper var0, BlockPosition var1, Dynamic3CommandExceptionType var2) throws CommandSyntaxException {
        TileEntity var3 = var0.getLevel().getBlockEntity(var1);
        if (!(var3 instanceof IInventory)) {
            throw var2.create((Object)var1.getX(), (Object)var1.getY(), (Object)var1.getZ());
        }
        return (IInventory)((Object)var3);
    }

    private static int setEntityItem(CommandListenerWrapper var0, Collection<? extends Entity> var1, int var2, ItemStack var3) throws CommandSyntaxException {
        ArrayList var4 = Lists.newArrayListWithCapacity((int)var1.size());
        for (Entity entity : var1) {
            SlotAccess var7 = entity.getSlot(var2);
            if (var7 == SlotAccess.NULL || !var7.set(var3.copy())) continue;
            var4.add(entity);
            if (!(entity instanceof EntityPlayer)) continue;
            ((EntityPlayer)entity).containerMenu.broadcastChanges();
        }
        if (var4.isEmpty()) {
            throw ERROR_TARGET_NO_CHANGES_KNOWN_ITEM.create((Object)var3.getDisplayName(), (Object)var2);
        }
        if (var4.size() == 1) {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.item.entity.set.success.single", ((Entity)var4.iterator().next()).getDisplayName(), var3.getDisplayName()), true);
        } else {
            var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.item.entity.set.success.multiple", var4.size(), var3.getDisplayName()), true);
        }
        return var4.size();
    }

    private static int blockToEntities(CommandListenerWrapper var0, BlockPosition var1, int var2, Collection<? extends Entity> var3, int var4) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(var0, var3, var4, ItemCommands.getBlockItem(var0, var1, var2));
    }

    private static int blockToEntities(CommandListenerWrapper var0, BlockPosition var1, int var2, Collection<? extends Entity> var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(var0, var3, var4, ItemCommands.applyModifier(var0, var5, ItemCommands.getBlockItem(var0, var1, var2)));
    }

    private static int blockToBlock(CommandListenerWrapper var0, BlockPosition var1, int var2, BlockPosition var3, int var4) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(var0, var3, var4, ItemCommands.getBlockItem(var0, var1, var2));
    }

    private static int blockToBlock(CommandListenerWrapper var0, BlockPosition var1, int var2, BlockPosition var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(var0, var3, var4, ItemCommands.applyModifier(var0, var5, ItemCommands.getBlockItem(var0, var1, var2)));
    }

    private static int entityToBlock(CommandListenerWrapper var0, Entity var1, int var2, BlockPosition var3, int var4) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(var0, var3, var4, ItemCommands.getEntityItem(var1, var2));
    }

    private static int entityToBlock(CommandListenerWrapper var0, Entity var1, int var2, BlockPosition var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.setBlockItem(var0, var3, var4, ItemCommands.applyModifier(var0, var5, ItemCommands.getEntityItem(var1, var2)));
    }

    private static int entityToEntities(CommandListenerWrapper var0, Entity var1, int var2, Collection<? extends Entity> var3, int var4) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(var0, var3, var4, ItemCommands.getEntityItem(var1, var2));
    }

    private static int entityToEntities(CommandListenerWrapper var0, Entity var1, int var2, Collection<? extends Entity> var3, int var4, Holder<LootItemFunction> var5) throws CommandSyntaxException {
        return ItemCommands.setEntityItem(var0, var3, var4, ItemCommands.applyModifier(var0, var5, ItemCommands.getEntityItem(var1, var2)));
    }

    private static ItemStack applyModifier(CommandListenerWrapper var0, Holder<LootItemFunction> var1, ItemStack var2) {
        WorldServer var3 = var0.getLevel();
        LootParams var4 = new LootParams.a(var3).withParameter(LootContextParameters.ORIGIN, var0.getPosition()).withOptionalParameter(LootContextParameters.THIS_ENTITY, var0.getEntity()).create(LootContextParameterSets.COMMAND);
        LootTableInfo var5 = new LootTableInfo.Builder(var4).create(Optional.empty());
        var5.pushVisitedElement(LootTableInfo.createVisitedEntry(var1.value()));
        ItemStack var6 = (ItemStack)var1.value().apply(var2, var5);
        var6.limitSize(var6.getMaxStackSize());
        return var6;
    }

    private static ItemStack getEntityItem(Entity var0, int var1) throws CommandSyntaxException {
        SlotAccess var2 = var0.getSlot(var1);
        if (var2 == SlotAccess.NULL) {
            throw ERROR_SOURCE_INAPPLICABLE_SLOT.create((Object)var1);
        }
        return var2.get().copy();
    }

    private static ItemStack getBlockItem(CommandListenerWrapper var0, BlockPosition var1, int var2) throws CommandSyntaxException {
        IInventory var3 = ItemCommands.getContainer(var0, var1, ERROR_SOURCE_NOT_A_CONTAINER);
        if (var2 < 0 || var2 >= var3.getContainerSize()) {
            throw ERROR_SOURCE_INAPPLICABLE_SLOT.create((Object)var2);
        }
        return var3.getItem(var2).copy();
    }
}

