/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.blocks.ArgumentTile;
import net.minecraft.commands.arguments.blocks.ArgumentTileLocation;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public class CommandSetBlock {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandListenerWrapper> var02, CommandBuildContext var12) {
        Predicate<ShapeDetectorBlock> var2 = var0 -> var0.getLevel().isEmptyBlock(var0.getPos());
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("setblock").requires(net.minecraft.commands.CommandDispatcher.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("block", ArgumentTile.block(var12)).executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null, false))).then(net.minecraft.commands.CommandDispatcher.literal("destroy").executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.DESTROY, null, false)))).then(net.minecraft.commands.CommandDispatcher.literal("keep").executes(var1 -> CommandSetBlock.setBlock((CommandListenerWrapper)var1.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var1, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var1, "block"), Mode.REPLACE, var2, false)))).then(net.minecraft.commands.CommandDispatcher.literal("replace").executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null, false)))).then(net.minecraft.commands.CommandDispatcher.literal("strict").executes(var0 -> CommandSetBlock.setBlock((CommandListenerWrapper)var0.getSource(), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), ArgumentTile.getBlock((CommandContext<CommandListenerWrapper>)var0, "block"), Mode.REPLACE, null, true))))));
    }

    private static int setBlock(CommandListenerWrapper var0, BlockPosition var1, ArgumentTileLocation var2, Mode var3, @Nullable Predicate<ShapeDetectorBlock> var4, boolean var5) throws CommandSyntaxException {
        boolean var7;
        WorldServer var6 = var0.getLevel();
        if (var6.isDebug()) {
            throw ERROR_FAILED.create();
        }
        if (var4 != null && !var4.test(new ShapeDetectorBlock(var6, var1, true))) {
            throw ERROR_FAILED.create();
        }
        if (var3 == Mode.DESTROY) {
            var6.destroyBlock(var1, true);
            var7 = !var2.getState().isAir() || !var6.getBlockState(var1).isAir();
        } else {
            var7 = true;
        }
        IBlockData var8 = var6.getBlockState(var1);
        if (var7 && !var2.place(var6, var1, 2 | (var5 ? 816 : 256))) {
            throw ERROR_FAILED.create();
        }
        if (!var5) {
            var6.updateNeighboursOnBlockSet(var1, var8);
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.setblock.success", var1.getX(), var1.getY(), var1.getZ()), true);
        return 1;
    }

    public static final class Mode
    extends Enum<Mode> {
        public static final /* enum */ Mode REPLACE = new Mode();
        public static final /* enum */ Mode DESTROY = new Mode();
        private static final /* synthetic */ Mode[] c;

        public static Mode[] values() {
            return (Mode[])c.clone();
        }

        public static Mode valueOf(String var0) {
            return Enum.valueOf(Mode.class, var0);
        }

        private static /* synthetic */ Mode[] a() {
            return new Mode[]{REPLACE, DESTROY};
        }

        static {
            c = Mode.a();
        }
    }
}

