/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import joptsimple.ValueConverter;
import joptsimple.util.PathConverter;
import joptsimple.util.PathProperties;
import net.minecraft.CrashReport;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.SharedConstants;
import net.minecraft.SuppressForbidden;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.nbt.NbtException;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.server.DispenserRegistry;
import net.minecraft.server.EULA;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Services;
import net.minecraft.server.WorldLoader;
import net.minecraft.server.WorldStem;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.dedicated.DedicatedServerSettings;
import net.minecraft.server.level.progress.WorldLoadListenerLogger;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceVanilla;
import net.minecraft.util.MathHelper;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.profiling.jfr.Environment;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.worldupdate.WorldUpgrader;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.chunk.storage.RegionFileCompression;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.WorldDimensions;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.presets.WorldPresets;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.LevelDataAndDimensions;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.WorldDataServer;
import net.minecraft.world.level.storage.WorldInfo;
import org.slf4j.Logger;

public class Main {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SuppressForbidden(a="System.out needed before bootstrap")
    @DontObfuscate
    public static void main(String[] var0) {
        SharedConstants.tryDetectVersion();
        OptionParser var1 = new OptionParser();
        OptionSpecBuilder var2 = var1.accepts("nogui");
        OptionSpecBuilder var3 = var1.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder var4 = var1.accepts("demo");
        OptionSpecBuilder var5 = var1.accepts("bonusChest");
        OptionSpecBuilder var6 = var1.accepts("forceUpgrade");
        OptionSpecBuilder var7 = var1.accepts("eraseCache");
        OptionSpecBuilder var8 = var1.accepts("recreateRegionFiles");
        OptionSpecBuilder var9 = var1.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec var10 = var1.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec var11 = var1.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec var12 = var1.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec var13 = var1.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec var14 = var1.accepts("serverId").withRequiredArg();
        OptionSpecBuilder var15 = var1.accepts("jfrProfile");
        ArgumentAcceptingOptionSpec var16 = var1.accepts("pidFile").withRequiredArg().withValuesConvertedBy((ValueConverter)new PathConverter(new PathProperties[0]));
        NonOptionArgumentSpec var17 = var1.nonOptions();
        try {
            WorldStem var33;
            Object var34;
            Object var32;
            Object var30;
            Dynamic<?> var29;
            OptionSet var18 = var1.parse(var0);
            if (var18.has((OptionSpec)var10)) {
                var1.printHelpOn((OutputStream)System.err);
                return;
            }
            Path var19 = (Path)var18.valueOf((OptionSpec)var16);
            if (var19 != null) {
                Main.writePidFile(var19);
            }
            CrashReport.preload();
            if (var18.has((OptionSpec)var15)) {
                JvmProfiler.INSTANCE.start(Environment.SERVER);
            }
            DispenserRegistry.bootStrap();
            DispenserRegistry.validate();
            SystemUtils.startTimerHackThread();
            Path var20 = Paths.get("server.properties", new String[0]);
            DedicatedServerSettings var21 = new DedicatedServerSettings(var20);
            var21.forceSave();
            RegionFileCompression.configure(var21.getProperties().regionFileComression);
            Path var22 = Paths.get("eula.txt", new String[0]);
            EULA var23 = new EULA(var22);
            if (var18.has((OptionSpec)var3)) {
                LOGGER.info("Initialized '{}' and '{}'", (Object)var20.toAbsolutePath(), (Object)var22.toAbsolutePath());
                return;
            }
            if (!var23.hasAgreedToEULA()) {
                LOGGER.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File var24 = new File((String)var18.valueOf((OptionSpec)var11));
            Services var25 = Services.create(new YggdrasilAuthenticationService(Proxy.NO_PROXY), var24);
            String var26 = Optional.ofNullable((String)var18.valueOf((OptionSpec)var12)).orElse(var21.getProperties().levelName);
            Convertable var27 = Convertable.createDefault(var24.toPath());
            Convertable.ConversionSession var28 = var27.validateAndCreateAccess(var26);
            if (var28.hasWorldData()) {
                try {
                    var29 = var28.getDataTag();
                    var30 = var28.getSummary(var29);
                }
                catch (IOException | NbtException | ReportedNbtException var31) {
                    var32 = var28.getLevelDirectory();
                    LOGGER.warn("Failed to load world data from {}", (Object)((Convertable.b)var32).dataFile(), (Object)var31);
                    LOGGER.info("Attempting to use fallback");
                    try {
                        var29 = var28.getDataTagFallback();
                        var30 = var28.getSummary(var29);
                    }
                    catch (IOException | NbtException | ReportedNbtException var332) {
                        LOGGER.error("Failed to load world data from {}", (Object)((Convertable.b)var32).oldDataFile(), (Object)var332);
                        LOGGER.error("Failed to load world data from {} and {}. World files may be corrupted. Shutting down.", (Object)((Convertable.b)var32).dataFile(), (Object)((Convertable.b)var32).oldDataFile());
                        return;
                    }
                    var28.restoreLevelDataFromOld();
                }
                if (((WorldInfo)var30).requiresManualConversion()) {
                    LOGGER.info("This world must be opened in an older version (like 1.6.4) to be safely converted");
                    return;
                }
                if (!((WorldInfo)var30).isCompatible()) {
                    LOGGER.info("This world was created by an incompatible version.");
                    return;
                }
            } else {
                var29 = null;
            }
            var30 = var29;
            boolean var31 = var18.has((OptionSpec)var9);
            if (var31) {
                LOGGER.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            var32 = ResourcePackSourceVanilla.createPackRepository(var28);
            try {
                var34 = Main.loadOrCreateConfig(var21.getProperties(), var30, var31, (ResourcePackRepository)var32);
                var33 = (WorldStem)SystemUtils.blockUntilDone(arg_0 -> Main.a((WorldLoader.c)var34, (Dynamic)var30, var18, (OptionSpec)var4, var21, (OptionSpec)var5, arg_0)).get();
            }
            catch (Exception var342) {
                LOGGER.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)var342);
                return;
            }
            var34 = var33.registries().compositeAccess();
            SaveData var35 = var33.worldData();
            boolean var36 = var18.has((OptionSpec)var8);
            if (var18.has((OptionSpec)var6) || var36) {
                Main.forceUpgrade(var28, var35, DataConverterRegistry.getDataFixer(), var18.has((OptionSpec)var7), () -> true, (IRegistryCustom)var34, var36);
            }
            var28.saveDataTag((IRegistryCustom)var34, var35);
            final DedicatedServer var37 = MinecraftServer.spin(arg_0 -> Main.a(var28, (ResourcePackRepository)var32, var33, var21, var25, var18, (OptionSpec)var13, (OptionSpec)var4, (OptionSpec)var14, (OptionSpec)var2, (OptionSpec)var17, arg_0));
            Thread var38 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    var37.halt(true);
                }
            };
            var38.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(LOGGER));
            Runtime.getRuntime().addShutdownHook(var38);
        }
        catch (Exception var18) {
            LOGGER.error(LogUtils.FATAL_MARKER, "Failed to start the minecraft server", (Throwable)var18);
        }
    }

    private static void writePidFile(Path var0) {
        try {
            long var1 = ProcessHandle.current().pid();
            Files.writeString(var0, (CharSequence)Long.toString(var1), new OpenOption[0]);
        }
        catch (IOException var1) {
            throw new UncheckedIOException(var1);
        }
    }

    private static WorldLoader.c loadOrCreateConfig(DedicatedServerProperties var0, @Nullable Dynamic<?> var1, boolean var2, ResourcePackRepository var3) {
        WorldDataConfiguration var5;
        boolean var4;
        Record var6;
        if (var1 != null) {
            var6 = Convertable.readDataConfig(var1);
            var4 = false;
            var5 = var6;
        } else {
            var4 = true;
            var5 = new WorldDataConfiguration(var0.initialDataPackConfiguration, FeatureFlags.DEFAULT_FLAGS);
        }
        var6 = new WorldLoader.d(var3, var5, var2, var4);
        return new WorldLoader.c((WorldLoader.d)var6, CommandDispatcher.ServerType.DEDICATED, var0.functionPermissionLevel);
    }

    public static void forceUpgrade(Convertable.ConversionSession var0, SaveData var1, DataFixer var2, boolean var3, BooleanSupplier var4, IRegistryCustom var5, boolean var6) {
        LOGGER.info("Forcing world upgrade!");
        try (WorldUpgrader var7 = new WorldUpgrader(var0, var2, var1, var5, var3, var6);){
            IChatBaseComponent var8 = null;
            while (!var7.isFinished()) {
                int var10;
                IChatBaseComponent var9 = var7.getStatus();
                if (var8 != var9) {
                    var8 = var9;
                    LOGGER.info(var7.getStatus().getString());
                }
                if ((var10 = var7.getTotalChunks()) > 0) {
                    int var11 = var7.getConverted() + var7.getSkipped();
                    LOGGER.info("{}% completed ({} / {} chunks)...", new Object[]{MathHelper.floor((float)var11 / (float)var10 * 100.0f), var11, var10});
                }
                if (!var4.getAsBoolean()) {
                    var7.cancel();
                    continue;
                }
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    private static /* synthetic */ DedicatedServer a(Convertable.ConversionSession var0, ResourcePackRepository var1, WorldStem var2, DedicatedServerSettings var3, Services var4, OptionSet var5, OptionSpec var6, OptionSpec var7, OptionSpec var8, OptionSpec var9, OptionSpec var10, Thread var11) {
        boolean var13;
        DedicatedServer var12 = new DedicatedServer(var11, var0, var1, var2, var3, DataConverterRegistry.getDataFixer(), var4, WorldLoadListenerLogger::createFromGameruleRadius);
        var12.setPort((Integer)var5.valueOf(var6));
        var12.setDemo(var5.has(var7));
        var12.setId((String)var5.valueOf(var8));
        boolean bl = var13 = !var5.has(var9) && !var5.valuesOf(var10).contains("nogui");
        if (var13 && !GraphicsEnvironment.isHeadless()) {
            var12.showGui();
        }
        GameTestHarnessTicker.SINGLETON.startTicking();
        return var12;
    }

    private static /* synthetic */ CompletableFuture a(WorldLoader.c var0, Dynamic var1, OptionSet var2, OptionSpec var3, DedicatedServerSettings var4, OptionSpec var52, Executor var6) {
        return WorldLoader.load(var0, var5 -> {
            Object var10;
            WorldDimensions var9;
            WorldOptions var8;
            WorldSettings var7;
            HolderLookup.b var6 = var5.datapackDimensions().lookupOrThrow(Registries.LEVEL_STEM);
            if (var1 != null) {
                LevelDataAndDimensions var72 = Convertable.getLevelDataAndDimensions(var1, var5.dataConfiguration(), (IRegistry<WorldDimension>)var6, var5.datapackWorldgen());
                return new WorldLoader.b<SaveData>(var72.worldData(), var72.dimensions().dimensionsRegistryAccess());
            }
            LOGGER.info("No existing world data, creating new world");
            if (var2.has(var3)) {
                var7 = MinecraftServer.DEMO_SETTINGS;
                var8 = WorldOptions.DEMO_OPTIONS;
                var9 = WorldPresets.createNormalWorldDimensions(var5.datapackWorldgen());
            } else {
                var10 = var4.getProperties();
                var7 = new WorldSettings(((DedicatedServerProperties)var10).levelName, ((DedicatedServerProperties)var10).gamemode, ((DedicatedServerProperties)var10).hardcore, ((DedicatedServerProperties)var10).difficulty, false, new GameRules(var5.dataConfiguration().enabledFeatures()), var5.dataConfiguration());
                var8 = var2.has(var52) ? ((DedicatedServerProperties)var10).worldOptions.withBonusChest(true) : ((DedicatedServerProperties)var10).worldOptions;
                var9 = ((DedicatedServerProperties)var10).createDimensions(var5.datapackWorldgen());
            }
            var10 = var9.bake((IRegistry<WorldDimension>)var6);
            Lifecycle var11 = ((WorldDimensions.b)var10).lifecycle().add(var5.datapackWorldgen().allRegistriesLifecycle());
            return new WorldLoader.b<WorldDataServer>(new WorldDataServer(var7, var8, ((WorldDimensions.b)var10).specialWorldProperty(), var11), ((WorldDimensions.b)var10).dimensionsRegistryAccess());
        }, WorldStem::new, SystemUtils.backgroundExecutor(), var6);
    }
}

