/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;

public class PacketPlayOutAdvancements
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutAdvancements> STREAM_CODEC = Packet.codec(PacketPlayOutAdvancements::write, PacketPlayOutAdvancements::new);
    private final boolean reset;
    private final List<AdvancementHolder> added;
    private final Set<MinecraftKey> removed;
    private final Map<MinecraftKey, AdvancementProgress> progress;
    private final boolean showAdvancements;

    public PacketPlayOutAdvancements(boolean var0, Collection<AdvancementHolder> var1, Set<MinecraftKey> var2, Map<MinecraftKey, AdvancementProgress> var3, boolean var4) {
        this.reset = var0;
        this.added = List.copyOf(var1);
        this.removed = Set.copyOf(var2);
        this.progress = Map.copyOf(var3);
        this.showAdvancements = var4;
    }

    private PacketPlayOutAdvancements(RegistryFriendlyByteBuf var0) {
        this.reset = var0.readBoolean();
        this.added = (List)AdvancementHolder.LIST_STREAM_CODEC.decode(var0);
        this.removed = var0.readCollection(Sets::newLinkedHashSetWithExpectedSize, PacketDataSerializer::readResourceLocation);
        this.progress = var0.readMap(PacketDataSerializer::readResourceLocation, AdvancementProgress::fromNetwork);
        this.showAdvancements = var0.readBoolean();
    }

    private void write(RegistryFriendlyByteBuf var02) {
        var02.writeBoolean(this.reset);
        AdvancementHolder.LIST_STREAM_CODEC.encode(var02, this.added);
        var02.writeCollection(this.removed, PacketDataSerializer::writeResourceLocation);
        var02.writeMap(this.progress, PacketDataSerializer::writeResourceLocation, (var0, var1) -> var1.serializeToNetwork((PacketDataSerializer)((Object)var0)));
        var02.writeBoolean(this.showAdvancements);
    }

    @Override
    public PacketType<PacketPlayOutAdvancements> type() {
        return GamePacketTypes.CLIENTBOUND_UPDATE_ADVANCEMENTS;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateAdvancementsPacket(this);
    }

    public List<AdvancementHolder> getAdded() {
        return this.added;
    }

    public Set<MinecraftKey> getRemoved() {
        return this.removed;
    }

    public Map<MinecraftKey, AdvancementProgress> getProgress() {
        return this.progress;
    }

    public boolean shouldReset() {
        return this.reset;
    }

    public boolean shouldShowAdvancements() {
        return this.showAdvancements;
    }
}

