/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.AxisAlignedBB;

public class StructureGridSpawner
implements GameTestHarnessRunner.c {
    private static final int SPACE_BETWEEN_COLUMNS = 5;
    private static final int SPACE_BETWEEN_ROWS = 6;
    private final int testsPerRow;
    private int currentRowCount;
    private AxisAlignedBB rowBounds;
    private final BlockPosition.MutableBlockPosition nextTestNorthWestCorner;
    private final BlockPosition firstTestNorthWestCorner;
    private final boolean clearOnBatch;
    private float maxX = -1.0f;
    private final Collection<GameTestHarnessInfo> testInLastBatch = new ArrayList<GameTestHarnessInfo>();

    public StructureGridSpawner(BlockPosition var0, int var1, boolean var2) {
        this.testsPerRow = var1;
        this.nextTestNorthWestCorner = var0.mutable();
        this.rowBounds = new AxisAlignedBB(this.nextTestNorthWestCorner);
        this.firstTestNorthWestCorner = var0;
        this.clearOnBatch = var2;
    }

    @Override
    public void onBatchStart(WorldServer var0) {
        if (this.clearOnBatch) {
            this.testInLastBatch.forEach(var1 -> {
                StructureBoundingBox var2 = var1.getTestInstanceBlockEntity().getStructureBoundingBox();
                GameTestHarnessStructures.clearSpaceForStructure(var2, var0);
            });
            this.testInLastBatch.clear();
            this.rowBounds = new AxisAlignedBB(this.firstTestNorthWestCorner);
            this.nextTestNorthWestCorner.set(this.firstTestNorthWestCorner);
        }
    }

    @Override
    public Optional<GameTestHarnessInfo> spawnStructure(GameTestHarnessInfo var0) {
        BlockPosition var1 = new BlockPosition(this.nextTestNorthWestCorner);
        var0.setTestBlockPos(var1);
        GameTestHarnessInfo var2 = var0.prepareTestStructure();
        if (var2 == null) {
            return Optional.empty();
        }
        var2.startExecution(1);
        AxisAlignedBB var3 = var0.getTestInstanceBlockEntity().getStructureBounds();
        this.rowBounds = this.rowBounds.minmax(var3);
        this.nextTestNorthWestCorner.move((int)var3.getXsize() + 5, 0, 0);
        if ((float)this.nextTestNorthWestCorner.getX() > this.maxX) {
            this.maxX = this.nextTestNorthWestCorner.getX();
        }
        if (++this.currentRowCount >= this.testsPerRow) {
            this.currentRowCount = 0;
            this.nextTestNorthWestCorner.move(0, 0, (int)this.rowBounds.getZsize() + 6);
            this.nextTestNorthWestCorner.setX(this.firstTestNorthWestCorner.getX());
            this.rowBounds = new AxisAlignedBB(this.nextTestNorthWestCorner);
        }
        this.testInLastBatch.add(var0);
        return Optional.of(var0);
    }
}

