/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class VectorPosition
implements IVectorPosition {
    private final ArgumentParserPosition x;
    private final ArgumentParserPosition y;
    private final ArgumentParserPosition z;

    public VectorPosition(ArgumentParserPosition var0, ArgumentParserPosition var1, ArgumentParserPosition var2) {
        this.x = var0;
        this.y = var1;
        this.z = var2;
    }

    @Override
    public Vec3D getPosition(CommandListenerWrapper var0) {
        Vec3D var1 = var0.getPosition();
        return new Vec3D(this.x.get(var1.x), this.y.get(var1.y), this.z.get(var1.z));
    }

    @Override
    public Vec2F getRotation(CommandListenerWrapper var0) {
        Vec2F var1 = var0.getRotation();
        return new Vec2F((float)this.x.get(var1.x), (float)this.y.get(var1.y));
    }

    @Override
    public boolean isXRelative() {
        return this.x.isRelative();
    }

    @Override
    public boolean isYRelative() {
        return this.y.isRelative();
    }

    @Override
    public boolean isZRelative() {
        return this.z.isRelative();
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof VectorPosition)) {
            return false;
        }
        VectorPosition var1 = (VectorPosition)var0;
        if (!this.x.equals(var1.x)) {
            return false;
        }
        if (!this.y.equals(var1.y)) {
            return false;
        }
        return this.z.equals(var1.z);
    }

    public static VectorPosition parseInt(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        ArgumentParserPosition var2 = ArgumentParserPosition.parseInt(var0);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var3 = ArgumentParserPosition.parseInt(var0);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var4 = ArgumentParserPosition.parseInt(var0);
        return new VectorPosition(var2, var3, var4);
    }

    public static VectorPosition parseDouble(StringReader var0, boolean var1) throws CommandSyntaxException {
        int var2 = var0.getCursor();
        ArgumentParserPosition var3 = ArgumentParserPosition.parseDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var2);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var4 = ArgumentParserPosition.parseDouble(var0, false);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var2);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        ArgumentParserPosition var5 = ArgumentParserPosition.parseDouble(var0, var1);
        return new VectorPosition(var3, var4, var5);
    }

    public static VectorPosition absolute(double var0, double var2, double var4) {
        return new VectorPosition(new ArgumentParserPosition(false, var0), new ArgumentParserPosition(false, var2), new ArgumentParserPosition(false, var4));
    }

    public static VectorPosition absolute(Vec2F var0) {
        return new VectorPosition(new ArgumentParserPosition(false, var0.x), new ArgumentParserPosition(false, var0.y), new ArgumentParserPosition(true, 0.0));
    }

    public int hashCode() {
        int var0 = this.x.hashCode();
        var0 = 31 * var0 + this.y.hashCode();
        var0 = 31 * var0 + this.z.hashCode();
        return var0;
    }
}

