/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.coordinates;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Objects;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.arguments.coordinates.ArgumentParserPosition;
import net.minecraft.commands.arguments.coordinates.ArgumentVec3;
import net.minecraft.commands.arguments.coordinates.IVectorPosition;
import net.minecraft.util.MathHelper;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;

public class ArgumentVectorPosition
implements IVectorPosition {
    public static final char PREFIX_LOCAL_COORDINATE = '^';
    private final double left;
    private final double up;
    private final double forwards;

    public ArgumentVectorPosition(double var0, double var2, double var4) {
        this.left = var0;
        this.up = var2;
        this.forwards = var4;
    }

    @Override
    public Vec3D getPosition(CommandListenerWrapper var0) {
        Vec2F var1 = var0.getRotation();
        Vec3D var2 = var0.getAnchor().apply(var0);
        float var3 = MathHelper.cos((var1.y + 90.0f) * ((float)Math.PI / 180));
        float var4 = MathHelper.sin((var1.y + 90.0f) * ((float)Math.PI / 180));
        float var5 = MathHelper.cos(-var1.x * ((float)Math.PI / 180));
        float var6 = MathHelper.sin(-var1.x * ((float)Math.PI / 180));
        float var7 = MathHelper.cos((-var1.x + 90.0f) * ((float)Math.PI / 180));
        float var8 = MathHelper.sin((-var1.x + 90.0f) * ((float)Math.PI / 180));
        Vec3D var9 = new Vec3D(var3 * var5, var6, var4 * var5);
        Vec3D var10 = new Vec3D(var3 * var7, var8, var4 * var7);
        Vec3D var11 = var9.cross(var10).scale(-1.0);
        double var12 = var9.x * this.forwards + var10.x * this.up + var11.x * this.left;
        double var14 = var9.y * this.forwards + var10.y * this.up + var11.y * this.left;
        double var16 = var9.z * this.forwards + var10.z * this.up + var11.z * this.left;
        return new Vec3D(var2.x + var12, var2.y + var14, var2.z + var16);
    }

    @Override
    public Vec2F getRotation(CommandListenerWrapper var0) {
        return Vec2F.ZERO;
    }

    @Override
    public boolean isXRelative() {
        return true;
    }

    @Override
    public boolean isYRelative() {
        return true;
    }

    @Override
    public boolean isZRelative() {
        return true;
    }

    public static ArgumentVectorPosition parse(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        double var2 = ArgumentVectorPosition.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var4 = ArgumentVectorPosition.readDouble(var0, var1);
        if (!var0.canRead() || var0.peek() != ' ') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_NOT_COMPLETE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        double var6 = ArgumentVectorPosition.readDouble(var0, var1);
        return new ArgumentVectorPosition(var2, var4, var6);
    }

    private static double readDouble(StringReader var0, int var1) throws CommandSyntaxException {
        if (!var0.canRead()) {
            throw ArgumentParserPosition.ERROR_EXPECTED_DOUBLE.createWithContext((ImmutableStringReader)var0);
        }
        if (var0.peek() != '^') {
            var0.setCursor(var1);
            throw ArgumentVec3.ERROR_MIXED_TYPE.createWithContext((ImmutableStringReader)var0);
        }
        var0.skip();
        return var0.canRead() && var0.peek() != ' ' ? var0.readDouble() : 0.0;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (!(var0 instanceof ArgumentVectorPosition)) {
            return false;
        }
        ArgumentVectorPosition var1 = (ArgumentVectorPosition)var0;
        return this.left == var1.left && this.up == var1.up && this.forwards == var1.forwards;
    }

    public int hashCode() {
        return Objects.hash(this.left, this.up, this.forwards);
    }
}

