/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import org.slf4j.Logger;

public record LootItemConditionReference(ResourceKey<LootItemCondition> name) implements LootItemCondition
{
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final MapCodec<LootItemConditionReference> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)ResourceKey.codec(Registries.PREDICATE).fieldOf("name").forGetter(LootItemConditionReference::name)).apply((Applicative)var0, LootItemConditionReference::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.REFERENCE;
    }

    @Override
    public void validate(LootCollector var0) {
        if (!var0.allowsReferences()) {
            var0.reportProblem(new LootCollector.d(this.name));
            return;
        }
        if (var0.hasVisitedElement(this.name)) {
            var0.reportProblem(new LootCollector.c(this.name));
            return;
        }
        LootItemCondition.super.validate(var0);
        var0.resolver().get(this.name).ifPresentOrElse(var1 -> ((LootItemCondition)var1.value()).validate(var0.enterElement(new ProblemReporter.b(this.name), this.name)), () -> var0.reportProblem(new LootCollector.a(this.name)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean test(LootTableInfo var0) {
        LootItemCondition var1 = var0.getResolver().get(this.name).map(Holder.c::value).orElse(null);
        if (var1 == null) {
            LOGGER.warn("Tried using unknown condition table called {}", (Object)this.name.location());
            return false;
        }
        LootTableInfo.c<LootItemCondition> var2 = LootTableInfo.createVisitedEntry(var1);
        if (var0.pushVisitedElement(var2)) {
            try {
                boolean bl = var1.test(var0);
                return bl;
            }
            finally {
                var0.popVisitedElement(var2);
            }
        }
        LOGGER.warn("Detected infinite loop in loot tables");
        return false;
    }

    public static LootItemCondition.a conditionReference(ResourceKey<LootItemCondition> var0) {
        return () -> new LootItemConditionReference(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }
}

