/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.commands.arguments.ArgumentNBTKey;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.INamable;
import net.minecraft.util.context.ContextKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.nbt.ContextNbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProvider;
import net.minecraft.world.level.storage.loot.providers.nbt.NbtProviders;
import org.apache.commons.lang3.mutable.MutableObject;

public class CopyCustomDataFunction
extends LootItemFunctionConditional {
    public static final MapCodec<CopyCustomDataFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> CopyCustomDataFunction.commonFields(var02).and(var02.group((App)NbtProviders.CODEC.fieldOf("source").forGetter(var0 -> var0.source), (App)b.CODEC.listOf().fieldOf("ops").forGetter(var0 -> var0.operations))).apply((Applicative)var02, CopyCustomDataFunction::new));
    private final NbtProvider source;
    private final List<b> operations;

    CopyCustomDataFunction(List<LootItemCondition> var0, NbtProvider var1, List<b> var2) {
        super(var0);
        this.source = var1;
        this.operations = List.copyOf(var2);
    }

    public LootItemFunctionType<CopyCustomDataFunction> getType() {
        return LootItemFunctions.COPY_CUSTOM_DATA;
    }

    @Override
    public Set<ContextKey<?>> getReferencedContextParams() {
        return this.source.getReferencedContextParams();
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTBase var22 = this.source.get(var1);
        if (var22 == null) {
            return var0;
        }
        MutableObject var3 = new MutableObject();
        Supplier<NBTBase> var4 = () -> {
            if (var3.getValue() == null) {
                var3.setValue((Object)var0.getOrDefault(DataComponents.CUSTOM_DATA, CustomData.EMPTY).copyTag());
            }
            return (NBTBase)var3.getValue();
        };
        this.operations.forEach(var2 -> var2.apply(var4, var22));
        NBTTagCompound var5 = (NBTTagCompound)var3.getValue();
        if (var5 != null) {
            CustomData.set(DataComponents.CUSTOM_DATA, var0, var5);
        }
        return var0;
    }

    @Deprecated
    public static a copyData(NbtProvider var0) {
        return new a(var0);
    }

    public static a copyData(LootTableInfo.EntityTarget var0) {
        return new a(ContextNbtProvider.forContextEntity(var0));
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final NbtProvider source;
        private final List<b> ops = Lists.newArrayList();

        a(NbtProvider var0) {
            this.source = var0;
        }

        public a copy(String var0, String var1, c var2) {
            try {
                this.ops.add(new b(ArgumentNBTKey.g.of(var0), ArgumentNBTKey.g.of(var1), var2));
            }
            catch (CommandSyntaxException var3) {
                throw new IllegalArgumentException(var3);
            }
            return this;
        }

        public a copy(String var0, String var1) {
            return this.copy(var0, var1, c.REPLACE);
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new CopyCustomDataFunction(this.getConditions(), this.source, this.ops);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }

    record b(ArgumentNBTKey.g sourcePath, ArgumentNBTKey.g targetPath, c op) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ArgumentNBTKey.g.CODEC.fieldOf("source").forGetter(b::sourcePath), (App)ArgumentNBTKey.g.CODEC.fieldOf("target").forGetter(b::targetPath), (App)c.CODEC.fieldOf("op").forGetter(b::op)).apply((Applicative)var0, b::new));

        public void apply(Supplier<NBTBase> var0, NBTBase var1) {
            try {
                List<NBTBase> var2 = this.sourcePath.get(var1);
                if (!var2.isEmpty()) {
                    this.op.merge(var0.get(), this.targetPath, var2);
                }
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
        }
    }

    public static abstract sealed class c
    extends Enum<c>
    implements INamable {
        public static final /* enum */ c REPLACE = new c("replace"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                var1.set(var0, (NBTBase)Iterables.getLast(var2));
            }
        };
        public static final /* enum */ c APPEND = new c("append"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                List<NBTBase> var3 = var1.getOrCreate(var0, NBTTagList::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof NBTTagList) {
                        var2.forEach(var1 -> ((NBTTagList)var12).add(var1.copy()));
                    }
                });
            }
        };
        public static final /* enum */ c MERGE = new c("merge"){

            @Override
            public void merge(NBTBase var0, ArgumentNBTKey.g var1, List<NBTBase> var2) throws CommandSyntaxException {
                List<NBTBase> var3 = var1.getOrCreate(var0, NBTTagCompound::new);
                var3.forEach(var12 -> {
                    if (var12 instanceof NBTTagCompound) {
                        var2.forEach(var1 -> {
                            if (var1 instanceof NBTTagCompound) {
                                ((NBTTagCompound)var12).merge((NBTTagCompound)var1);
                            }
                        });
                    }
                });
            }
        };
        public static final Codec<c> CODEC;
        private final String name;
        private static final /* synthetic */ c[] f;

        public static c[] values() {
            return (c[])f.clone();
        }

        public static c valueOf(String var0) {
            return Enum.valueOf(c.class, var0);
        }

        public abstract void merge(NBTBase var1, ArgumentNBTKey.g var2, List<NBTBase> var3) throws CommandSyntaxException;

        c(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ c[] a() {
            return new c[]{REPLACE, APPEND, MERGE};
        }

        static {
            f = c.a();
            CODEC = INamable.fromEnum(c::values);
        }
    }
}

