/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.entries.LootEntries;
import net.minecraft.world.level.storage.loot.entries.LootEntry;
import net.minecraft.world.level.storage.loot.entries.LootEntryAbstract;
import net.minecraft.world.level.storage.loot.entries.LootEntryChildren;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class LootEntryChildrenAbstract
extends LootEntryAbstract {
    public static final ProblemReporter.g NO_CHILDREN_PROBLEM = new ProblemReporter.g(){

        @Override
        public String description() {
            return "Empty children list";
        }
    };
    protected final List<LootEntryAbstract> children;
    private final LootEntryChildren composedChildren;

    protected LootEntryChildrenAbstract(List<LootEntryAbstract> var0, List<LootItemCondition> var1) {
        super(var1);
        this.children = var0;
        this.composedChildren = this.compose(var0);
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        if (this.children.isEmpty()) {
            var0.reportProblem(NO_CHILDREN_PROBLEM);
        }
        for (int var1 = 0; var1 < this.children.size(); ++var1) {
            this.children.get(var1).validate(var0.forChild(new ProblemReporter.d("children", var1)));
        }
    }

    protected abstract LootEntryChildren compose(List<? extends LootEntryChildren> var1);

    @Override
    public final boolean expand(LootTableInfo var0, Consumer<LootEntry> var1) {
        if (!this.canRun(var0)) {
            return false;
        }
        return this.composedChildren.expand(var0, var1);
    }

    public static <T extends LootEntryChildrenAbstract> MapCodec<T> createCodec(a<T> var0) {
        return RecordCodecBuilder.mapCodec(var1 -> var1.group((App)LootEntries.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(var0 -> var0.children)).and(LootEntryChildrenAbstract.commonFields(var1).t1()).apply((Applicative)var1, var0::create));
    }

    @FunctionalInterface
    public static interface a<T extends LootEntryChildrenAbstract> {
        public T create(List<LootEntryAbstract> var1, List<LootItemCondition> var2);
    }
}

