/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.levelgen.structure.pools.alias;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.worldgen.WorldGenFeaturePieces;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedList;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.pools.alias.DirectPoolAlias;
import net.minecraft.world.level.levelgen.structure.pools.alias.RandomGroupPoolAlias;
import net.minecraft.world.level.levelgen.structure.pools.alias.RandomPoolAlias;

public interface PoolAliasBinding {
    public static final Codec<PoolAliasBinding> CODEC = BuiltInRegistries.POOL_ALIAS_BINDING_TYPE.byNameCodec().dispatch(PoolAliasBinding::codec, Function.identity());

    public void forEachResolved(RandomSource var1, BiConsumer<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> var2);

    public Stream<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> allTargets();

    public static DirectPoolAlias direct(String var0, String var1) {
        return PoolAliasBinding.direct(WorldGenFeaturePieces.createKey(var0), WorldGenFeaturePieces.createKey(var1));
    }

    public static DirectPoolAlias direct(ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var0, ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var1) {
        return new DirectPoolAlias(var0, var1);
    }

    public static RandomPoolAlias random(String var0, WeightedList<String> var12) {
        WeightedList.a var2 = WeightedList.builder();
        var12.unwrap().forEach(var1 -> var2.add(WorldGenFeaturePieces.createKey((String)var1.value()), var1.weight()));
        return PoolAliasBinding.random(WorldGenFeaturePieces.createKey(var0), var2.build());
    }

    public static RandomPoolAlias random(ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate> var0, WeightedList<ResourceKey<WorldGenFeatureDefinedStructurePoolTemplate>> var1) {
        return new RandomPoolAlias(var0, var1);
    }

    public static RandomGroupPoolAlias randomGroup(WeightedList<List<PoolAliasBinding>> var0) {
        return new RandomGroupPoolAlias(var0);
    }

    public MapCodec<? extends PoolAliasBinding> codec();
}

