/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block.entity.trialspawner;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.Particles;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ProblemReporter;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawnerData;
import net.minecraft.world.level.RayTrace;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.TrialSpawnerBlock;
import net.minecraft.world.level.block.entity.trialspawner.PlayerDetector;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerConfig;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerData;
import net.minecraft.world.level.block.entity.trialspawner.TrialSpawnerState;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.storage.TagValueInput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.slf4j.Logger;

public final class TrialSpawner {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int DETECT_PLAYER_SPAWN_BUFFER = 40;
    private static final int DEFAULT_TARGET_COOLDOWN_LENGTH = 36000;
    private static final int DEFAULT_PLAYER_SCAN_RANGE = 14;
    private static final int MAX_MOB_TRACKING_DISTANCE = 47;
    private static final int MAX_MOB_TRACKING_DISTANCE_SQR = MathHelper.square(47);
    private static final float SPAWNING_AMBIENT_SOUND_CHANCE = 0.02f;
    private final TrialSpawnerData data = new TrialSpawnerData();
    public b config;
    public final c stateAccessor;
    private PlayerDetector playerDetector;
    private final PlayerDetector.a entitySelector;
    private boolean overridePeacefulAndMobSpawnRule;
    public boolean isOminous;

    public TrialSpawner(b var0, c var1, PlayerDetector var2, PlayerDetector.a var3) {
        this.config = var0;
        this.stateAccessor = var1;
        this.playerDetector = var2;
        this.entitySelector = var3;
    }

    public TrialSpawnerConfig activeConfig() {
        return this.isOminous ? this.config.ominous().value() : this.config.normal.value();
    }

    public TrialSpawnerConfig normalConfig() {
        return this.config.normal.value();
    }

    public TrialSpawnerConfig ominousConfig() {
        return this.config.ominous.value();
    }

    public void load(ValueInput var0) {
        var0.read(TrialSpawnerData.a.MAP_CODEC).ifPresent(this.data::apply);
        this.config = var0.read(b.MAP_CODEC).orElse(b.DEFAULT);
    }

    public void store(ValueOutput var0) {
        var0.store(TrialSpawnerData.a.MAP_CODEC, this.data.pack());
        var0.store(b.MAP_CODEC, this.config);
    }

    public void applyOminous(WorldServer var0, BlockPosition var1) {
        var0.setBlock(var1, (IBlockData)var0.getBlockState(var1).setValue(TrialSpawnerBlock.OMINOUS, true), 3);
        var0.levelEvent(3020, var1, 1);
        this.isOminous = true;
        this.data.resetAfterBecomingOminous(this, var0);
    }

    public void removeOminous(WorldServer var0, BlockPosition var1) {
        var0.setBlock(var1, (IBlockData)var0.getBlockState(var1).setValue(TrialSpawnerBlock.OMINOUS, false), 3);
        this.isOminous = false;
    }

    public boolean isOminous() {
        return this.isOminous;
    }

    public int getTargetCooldownLength() {
        return this.config.targetCooldownLength;
    }

    public int getRequiredPlayerRange() {
        return this.config.requiredPlayerRange;
    }

    public TrialSpawnerState getState() {
        return this.stateAccessor.getState();
    }

    public TrialSpawnerData getStateData() {
        return this.data;
    }

    public void setState(World var0, TrialSpawnerState var1) {
        this.stateAccessor.setState(var0, var1);
    }

    public void markUpdated() {
        this.stateAccessor.markUpdated();
    }

    public PlayerDetector getPlayerDetector() {
        return this.playerDetector;
    }

    public PlayerDetector.a getEntitySelector() {
        return this.entitySelector;
    }

    public boolean canSpawnInLevel(WorldServer var0) {
        if (this.overridePeacefulAndMobSpawnRule) {
            return true;
        }
        if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
            return false;
        }
        return var0.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING);
    }

    public Optional<UUID> spawnMob(WorldServer var0, BlockPosition var1) {
        RandomSource var22 = var0.getRandom();
        MobSpawnerData var3 = this.data.getOrCreateNextSpawnData(this, var0.getRandom());
        try (ProblemReporter.j var4 = new ProblemReporter.j(() -> "spawner@" + String.valueOf(var1), LOGGER);){
            Object var10;
            Object var9;
            ValueInput var5 = TagValueInput.create((ProblemReporter)var4, (HolderLookup.a)var0.registryAccess(), var3.entityToSpawn());
            Optional<EntityTypes<?>> var6 = EntityTypes.by(var5);
            if (var6.isEmpty()) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            Vec3D var7 = var5.read("Pos", Vec3D.CODEC).orElseGet(() -> {
                TrialSpawnerConfig var2 = this.activeConfig();
                return new Vec3D((double)var1.getX() + (var22.nextDouble() - var22.nextDouble()) * (double)var2.spawnRange() + 0.5, var1.getY() + var22.nextInt(3) - 1, (double)var1.getZ() + (var22.nextDouble() - var22.nextDouble()) * (double)var2.spawnRange() + 0.5);
            });
            if (!var0.noCollision(var6.get().getSpawnAABB(var7.x, var7.y, var7.z))) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            if (!TrialSpawner.inLineOfSight(var0, var1.getCenter(), var7)) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            BlockPosition var8 = BlockPosition.containing(var7);
            if (!EntityPositionTypes.checkSpawnRules(var6.get(), var0, EntitySpawnReason.TRIAL_SPAWNER, var8, var0.getRandom())) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            if (var3.getCustomSpawnRules().isPresent() && !((MobSpawnerData.a)(var9 = var3.getCustomSpawnRules().get())).isValidPosition(var8, var0)) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            var9 = EntityTypes.loadEntityRecursive(var5, (World)var0, EntitySpawnReason.TRIAL_SPAWNER, var2 -> {
                var2.snapTo(var0.x, var0.y, var0.z, var22.nextFloat() * 360.0f, 0.0f);
                return var2;
            });
            if (var9 == null) {
                Optional<UUID> optional = Optional.empty();
                return optional;
            }
            if (var9 instanceof EntityInsentient) {
                boolean var11;
                var10 = (EntityInsentient)var9;
                if (!((EntityInsentient)var10).checkSpawnObstruction(var0)) {
                    Optional<UUID> optional = Optional.empty();
                    return optional;
                }
                boolean bl = var11 = var3.getEntityToSpawn().size() == 1 && var3.getEntityToSpawn().getString("id").isPresent();
                if (var11) {
                    ((EntityInsentient)var10).finalizeSpawn(var0, var0.getCurrentDifficultyAt(((Entity)var10).blockPosition()), EntitySpawnReason.TRIAL_SPAWNER, null);
                }
                ((EntityInsentient)var10).setPersistenceRequired();
                var3.getEquipment().ifPresent(((EntityInsentient)var10)::equip);
            }
            if (!var0.tryAddFreshEntityWithPassengers((Entity)var9)) {
                var10 = Optional.empty();
                return var10;
            }
            var10 = this.isOminous ? a.OMINOUS : a.NORMAL;
            var0.levelEvent(3011, var1, ((a)((Object)var10)).encode());
            var0.levelEvent(3012, var8, ((a)((Object)var10)).encode());
            var0.gameEvent((Entity)var9, GameEvent.ENTITY_PLACE, var8);
            Optional<UUID> optional = Optional.of(((Entity)var9).getUUID());
            return optional;
        }
    }

    public void ejectReward(WorldServer var0, BlockPosition var1, ResourceKey<LootTable> var2) {
        LootParams var4;
        LootTable var3 = var0.getServer().reloadableRegistries().getLootTable(var2);
        ObjectArrayList<ItemStack> var5 = var3.getRandomItems(var4 = new LootParams.a(var0).create(LootContextParameterSets.EMPTY));
        if (!var5.isEmpty()) {
            for (ItemStack var7 : var5) {
                DispenseBehaviorItem.spawnItem(var0, var7, 2, EnumDirection.UP, Vec3D.atBottomCenterOf(var1).relative(EnumDirection.UP, 1.2));
            }
            var0.levelEvent(3014, var1, 0);
        }
    }

    public void tickClient(World var0, BlockPosition var1, boolean var2) {
        RandomSource var4;
        TrialSpawnerState var3 = this.getState();
        var3.emitParticles(var0, var1, var2);
        if (var3.hasSpinningMob()) {
            double var42 = Math.max(0L, this.data.nextMobSpawnsAt - var0.getGameTime());
            this.data.oSpin = this.data.spin;
            this.data.spin = (this.data.spin + var3.spinningMobSpeed() / (var42 + 200.0)) % 360.0;
        }
        if (var3.isCapableOfSpawning() && (var4 = var0.getRandom()).nextFloat() <= 0.02f) {
            SoundEffect var5 = var2 ? SoundEffects.TRIAL_SPAWNER_AMBIENT_OMINOUS : SoundEffects.TRIAL_SPAWNER_AMBIENT;
            var0.playLocalSound(var1, var5, SoundCategory.BLOCKS, var4.nextFloat() * 0.25f + 0.75f, var4.nextFloat() + 0.5f, false);
        }
    }

    public void tickServer(WorldServer var0, BlockPosition var1, boolean var22) {
        TrialSpawnerState var4;
        this.isOminous = var22;
        TrialSpawnerState var3 = this.getState();
        if (this.data.currentMobs.removeIf(var2 -> TrialSpawner.shouldMobBeUntracked(var0, var1, var2))) {
            this.data.nextMobSpawnsAt = var0.getGameTime() + (long)this.activeConfig().ticksBetweenSpawn();
        }
        if ((var4 = var3.tickAndGetNext(var1, this, var0)) != var3) {
            this.setState(var0, var4);
        }
    }

    private static boolean shouldMobBeUntracked(WorldServer var0, BlockPosition var1, UUID var2) {
        Entity var3 = var0.getEntity(var2);
        return var3 == null || !var3.isAlive() || !var3.level().dimension().equals(var0.dimension()) || var3.blockPosition().distSqr(var1) > (double)MAX_MOB_TRACKING_DISTANCE_SQR;
    }

    private static boolean inLineOfSight(World var0, Vec3D var1, Vec3D var2) {
        MovingObjectPositionBlock var3 = var0.clip(new RayTrace(var2, var1, RayTrace.BlockCollisionOption.VISUAL, RayTrace.FluidCollisionOption.NONE, VoxelShapeCollision.empty()));
        return var3.getBlockPos().equals(BlockPosition.containing(var1)) || var3.getType() == MovingObjectPosition.EnumMovingObjectType.MISS;
    }

    public static void addSpawnParticles(World var0, BlockPosition var1, RandomSource var2, ParticleType var3) {
        for (int var4 = 0; var4 < 20; ++var4) {
            double var5 = (double)var1.getX() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var7 = (double)var1.getY() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var9 = (double)var1.getZ() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            var0.addParticle(Particles.SMOKE, var5, var7, var9, 0.0, 0.0, 0.0);
            var0.addParticle(var3, var5, var7, var9, 0.0, 0.0, 0.0);
        }
    }

    public static void addBecomeOminousParticles(World var0, BlockPosition var1, RandomSource var2) {
        for (int var3 = 0; var3 < 20; ++var3) {
            double var4 = (double)var1.getX() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var6 = (double)var1.getY() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var8 = (double)var1.getZ() + 0.5 + (var2.nextDouble() - 0.5) * 2.0;
            double var10 = var2.nextGaussian() * 0.02;
            double var12 = var2.nextGaussian() * 0.02;
            double var14 = var2.nextGaussian() * 0.02;
            var0.addParticle(Particles.TRIAL_OMEN, var4, var6, var8, var10, var12, var14);
            var0.addParticle(Particles.SOUL_FIRE_FLAME, var4, var6, var8, var10, var12, var14);
        }
    }

    public static void addDetectPlayerParticles(World var0, BlockPosition var1, RandomSource var2, int var3, ParticleParam var4) {
        for (int var5 = 0; var5 < 30 + Math.min(var3, 10) * 5; ++var5) {
            double var6 = (double)(2.0f * var2.nextFloat() - 1.0f) * 0.65;
            double var8 = (double)(2.0f * var2.nextFloat() - 1.0f) * 0.65;
            double var10 = (double)var1.getX() + 0.5 + var6;
            double var12 = (double)var1.getY() + 0.1 + (double)var2.nextFloat() * 0.8;
            double var14 = (double)var1.getZ() + 0.5 + var8;
            var0.addParticle(var4, var10, var12, var14, 0.0, 0.0, 0.0);
        }
    }

    public static void addEjectItemParticles(World var0, BlockPosition var1, RandomSource var2) {
        for (int var3 = 0; var3 < 20; ++var3) {
            double var4 = (double)var1.getX() + 0.4 + var2.nextDouble() * 0.2;
            double var6 = (double)var1.getY() + 0.4 + var2.nextDouble() * 0.2;
            double var8 = (double)var1.getZ() + 0.4 + var2.nextDouble() * 0.2;
            double var10 = var2.nextGaussian() * 0.02;
            double var12 = var2.nextGaussian() * 0.02;
            double var14 = var2.nextGaussian() * 0.02;
            var0.addParticle(Particles.SMALL_FLAME, var4, var6, var8, var10, var12, var14 * 0.25);
            var0.addParticle(Particles.SMOKE, var4, var6, var8, var10, var12, var14);
        }
    }

    public void overrideEntityToSpawn(EntityTypes<?> var0, World var1) {
        this.data.reset();
        this.config = this.config.overrideEntity(var0);
        this.setState(var1, TrialSpawnerState.INACTIVE);
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void setPlayerDetector(PlayerDetector var0) {
        this.playerDetector = var0;
    }

    @Deprecated(forRemoval=true)
    @VisibleForTesting
    public void overridePeacefulAndMobSpawnRule() {
        this.overridePeacefulAndMobSpawnRule = true;
    }

    public static final class b
    extends Record {
        final Holder<TrialSpawnerConfig> normal;
        final Holder<TrialSpawnerConfig> ominous;
        final int targetCooldownLength;
        final int requiredPlayerRange;
        public static final MapCodec<b> MAP_CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)TrialSpawnerConfig.CODEC.optionalFieldOf("normal_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(b::normal), (App)TrialSpawnerConfig.CODEC.optionalFieldOf("ominous_config", Holder.direct(TrialSpawnerConfig.DEFAULT)).forGetter(b::ominous), (App)ExtraCodecs.NON_NEGATIVE_INT.optionalFieldOf("target_cooldown_length", (Object)36000).forGetter(b::targetCooldownLength), (App)Codec.intRange((int)1, (int)128).optionalFieldOf("required_player_range", (Object)14).forGetter(b::requiredPlayerRange)).apply((Applicative)var0, b::new));
        public static final b DEFAULT = new b(Holder.direct(TrialSpawnerConfig.DEFAULT), Holder.direct(TrialSpawnerConfig.DEFAULT), 36000, 14);

        public b(Holder<TrialSpawnerConfig> var0, Holder<TrialSpawnerConfig> var1, int var2, int var3) {
            this.normal = var0;
            this.ominous = var1;
            this.targetCooldownLength = var2;
            this.requiredPlayerRange = var3;
        }

        public b overrideEntity(EntityTypes<?> var0) {
            return new b(Holder.direct(this.normal.value().withSpawning(var0)), Holder.direct(this.ominous.value().withSpawning(var0)), this.targetCooldownLength, this.requiredPlayerRange);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "normal", "ominous", "targetCooldownLength", "requiredPlayerRange"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "normal", "ominous", "targetCooldownLength", "requiredPlayerRange"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{b.class, "normal;ominous;targetCooldownLength;requiredPlayerRange", "normal", "ominous", "targetCooldownLength", "requiredPlayerRange"}, this, var0);
        }

        public Holder<TrialSpawnerConfig> normal() {
            return this.normal;
        }

        public Holder<TrialSpawnerConfig> ominous() {
            return this.ominous;
        }

        public int targetCooldownLength() {
            return this.targetCooldownLength;
        }

        public int requiredPlayerRange() {
            return this.requiredPlayerRange;
        }
    }

    public static interface c {
        public void setState(World var1, TrialSpawnerState var2);

        public TrialSpawnerState getState();

        public void markUpdated();
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NORMAL = new a(Particles.FLAME);
        public static final /* enum */ a OMINOUS = new a(Particles.SOUL_FIRE_FLAME);
        public final ParticleType particleType;
        private static final /* synthetic */ a[] d;

        public static a[] values() {
            return (a[])d.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(ParticleType var2) {
            this.particleType = var2;
        }

        public static a decode(int var0) {
            a[] var1 = a.values();
            if (var0 > var1.length || var0 < 0) {
                return NORMAL;
            }
            return var1[var0];
        }

        public int encode() {
            return this.ordinal();
        }

        private static /* synthetic */ a[] b() {
            return new a[]{NORMAL, OMINOUS};
        }

        static {
            d = a.b();
        }
    }
}

