/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.state.IBlockData;

public interface IBlockFragilePlantElement {
    public boolean isValidBonemealTarget(IWorldReader var1, BlockPosition var2, IBlockData var3);

    public boolean isBonemealSuccess(World var1, RandomSource var2, BlockPosition var3, IBlockData var4);

    public void performBonemeal(WorldServer var1, RandomSource var2, BlockPosition var3, IBlockData var4);

    public static boolean hasSpreadableNeighbourPos(IWorldReader var0, BlockPosition var1, IBlockData var2) {
        return IBlockFragilePlantElement.getSpreadableNeighbourPos(EnumDirection.EnumDirectionLimit.HORIZONTAL.stream().toList(), var0, var1, var2).isPresent();
    }

    public static Optional<BlockPosition> findSpreadableNeighbourPos(World var0, BlockPosition var1, IBlockData var2) {
        return IBlockFragilePlantElement.getSpreadableNeighbourPos(EnumDirection.EnumDirectionLimit.HORIZONTAL.shuffledCopy(var0.random), var0, var1, var2);
    }

    private static Optional<BlockPosition> getSpreadableNeighbourPos(List<EnumDirection> var0, IWorldReader var1, BlockPosition var2, IBlockData var3) {
        for (EnumDirection var5 : var0) {
            BlockPosition var6 = var2.relative(var5);
            if (!var1.isEmptyBlock(var6) || !var3.canSurvive(var1, var6)) continue;
            return Optional.of(var6);
        }
        return Optional.empty();
    }

    default public BlockPosition getParticlePos(BlockPosition var0) {
        return switch (this.getType().ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> var0.above();
            case 1 -> var0;
        };
    }

    default public a getType() {
        return a.GROWER;
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a NEIGHBOR_SPREADER = new a();
        public static final /* enum */ a GROWER = new a();
        private static final /* synthetic */ a[] c;

        public static a[] values() {
            return (a[])c.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private static /* synthetic */ a[] a() {
            return new a[]{NEIGHBOR_SPREADER, GROWER};
        }

        static {
            c = a.a();
        }
    }
}

