/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.TrailParticleOption;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.util.RandomSource;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.animal.EntityBee;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockFlowers;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CreakingHeartBlock;
import net.minecraft.world.level.block.state.BlockBase;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3D;

public class EyeblossomBlock
extends BlockFlowers {
    public static final MapCodec<EyeblossomBlock> CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("open").forGetter(var0 -> var0.type.open), EyeblossomBlock.propertiesCodec()).apply((Applicative)var02, EyeblossomBlock::new));
    private static final int EYEBLOSSOM_XZ_RANGE = 3;
    private static final int EYEBLOSSOM_Y_RANGE = 2;
    private final a type;

    public MapCodec<? extends EyeblossomBlock> codec() {
        return CODEC;
    }

    public EyeblossomBlock(a var0, BlockBase.Info var1) {
        super(var0.effect, var0.effectDuration, var1);
        this.type = var0;
    }

    public EyeblossomBlock(boolean var0, BlockBase.Info var1) {
        super(a.fromBoolean((boolean)var0).effect, a.fromBoolean((boolean)var0).effectDuration, var1);
        this.type = a.fromBoolean(var0);
    }

    @Override
    public void animateTick(IBlockData var0, World var1, BlockPosition var2, RandomSource var3) {
        IBlockData var4;
        if (this.type.emitSounds() && var3.nextInt(700) == 0 && (var4 = var1.getBlockState(var2.below())).is(Blocks.PALE_MOSS_BLOCK)) {
            var1.playLocalSound(var2.getX(), var2.getY(), var2.getZ(), SoundEffects.EYEBLOSSOM_IDLE, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
        }
    }

    @Override
    protected void randomTick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (this.tryChangingState(var0, var1, var2, var3)) {
            var1.playSound(null, var2, this.type.transform().longSwitchSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        super.randomTick(var0, var1, var2, var3);
    }

    @Override
    protected void tick(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (this.tryChangingState(var0, var1, var2, var3)) {
            var1.playSound(null, var2, this.type.transform().shortSwitchSound, SoundCategory.BLOCKS, 1.0f, 1.0f);
        }
        super.tick(var0, var1, var2, var3);
    }

    private boolean tryChangingState(IBlockData var0, WorldServer var1, BlockPosition var2, RandomSource var3) {
        if (!var1.dimensionType().natural()) {
            return false;
        }
        if (CreakingHeartBlock.isNaturalNight(var1) == this.type.open) {
            return false;
        }
        a var42 = this.type.transform();
        var1.setBlock(var2, var42.state(), 3);
        var1.gameEvent(GameEvent.BLOCK_CHANGE, var2, GameEvent.a.of(var0));
        var42.spawnTransformParticle(var1, var2, var3);
        BlockPosition.betweenClosed(var2.offset(-3, -2, -3), var2.offset(3, 2, 3)).forEach(var4 -> {
            IBlockData var5 = var1.getBlockState((BlockPosition)var4);
            if (var5 == var0) {
                double var6 = Math.sqrt(var2.distSqr((BaseBlockPosition)var4));
                int var8 = var3.nextIntBetweenInclusive((int)(var6 * 5.0), (int)(var6 * 10.0));
                var1.scheduleTick((BlockPosition)var4, var0.getBlock(), var8);
            }
        });
        return true;
    }

    @Override
    protected void entityInside(IBlockData var0, World var1, BlockPosition var2, Entity var3, InsideBlockEffectApplier var4) {
        if (!var1.isClientSide() && var1.getDifficulty() != EnumDifficulty.PEACEFUL && var3 instanceof EntityBee) {
            EntityBee var5 = (EntityBee)var3;
            if (EntityBee.attractsBees(var0) && !var5.hasEffect(MobEffects.POISON)) {
                var5.addEffect(this.getBeeInteractionEffect());
            }
        }
    }

    @Override
    public MobEffect getBeeInteractionEffect() {
        return new MobEffect(MobEffects.POISON, 25);
    }

    public static final class a
    extends Enum<a> {
        public static final /* enum */ a OPEN = new a(true, MobEffects.BLINDNESS, 11.0f, SoundEffects.EYEBLOSSOM_OPEN_LONG, SoundEffects.EYEBLOSSOM_OPEN, 16545810);
        public static final /* enum */ a CLOSED = new a(false, MobEffects.NAUSEA, 7.0f, SoundEffects.EYEBLOSSOM_CLOSE_LONG, SoundEffects.EYEBLOSSOM_CLOSE, 0x5F5F5F);
        final boolean open;
        final Holder<MobEffectList> effect;
        final float effectDuration;
        final SoundEffect longSwitchSound;
        final SoundEffect shortSwitchSound;
        private final int particleColor;
        private static final /* synthetic */ a[] i;

        public static a[] values() {
            return (a[])i.clone();
        }

        public static a valueOf(String var0) {
            return Enum.valueOf(a.class, var0);
        }

        private a(boolean var2, Holder var3, float var4, SoundEffect var5, SoundEffect var6, int var7) {
            this.open = var2;
            this.effect = var3;
            this.effectDuration = var4;
            this.longSwitchSound = var5;
            this.shortSwitchSound = var6;
            this.particleColor = var7;
        }

        public Block block() {
            return this.open ? Blocks.OPEN_EYEBLOSSOM : Blocks.CLOSED_EYEBLOSSOM;
        }

        public IBlockData state() {
            return this.block().defaultBlockState();
        }

        public a transform() {
            return a.fromBoolean(!this.open);
        }

        public boolean emitSounds() {
            return this.open;
        }

        public static a fromBoolean(boolean var0) {
            return var0 ? OPEN : CLOSED;
        }

        public void spawnTransformParticle(WorldServer var0, BlockPosition var1, RandomSource var2) {
            Vec3D var3 = var1.getCenter();
            double var4 = 0.5 + var2.nextDouble();
            Vec3D var6 = new Vec3D(var2.nextDouble() - 0.5, var2.nextDouble() + 1.0, var2.nextDouble() - 0.5);
            Vec3D var7 = var3.add(var6.scale(var4));
            TrailParticleOption var8 = new TrailParticleOption(var7, this.particleColor, (int)(20.0 * var4));
            var0.sendParticles(var8, var3.x, var3.y, var3.z, 1, 0.0, 0.0, 0.0, 0.0);
        }

        public SoundEffect longSwitchSound() {
            return this.longSwitchSound;
        }

        private static /* synthetic */ a[] f() {
            return new a[]{OPEN, CLOSED};
        }

        static {
            i = a.f();
        }
    }
}

