/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.inventory;

import net.minecraft.resources.MinecraftKey;
import net.minecraft.tags.TagsEntity;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.player.PlayerInventory;
import net.minecraft.world.inventory.ArmorSlot;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class ContainerHorse
extends Container {
    private static final MinecraftKey SADDLE_SLOT_SPRITE = MinecraftKey.withDefaultNamespace("container/slot/saddle");
    private static final MinecraftKey LLAMA_ARMOR_SLOT_SPRITE = MinecraftKey.withDefaultNamespace("container/slot/llama_armor");
    private static final MinecraftKey ARMOR_SLOT_SPRITE = MinecraftKey.withDefaultNamespace("container/slot/horse_armor");
    private final IInventory horseContainer;
    private final EntityHorseAbstract horse;
    private static final int SLOT_SADDLE = 0;
    private static final int SLOT_BODY_ARMOR = 1;
    private static final int SLOT_HORSE_INVENTORY_START = 2;

    public ContainerHorse(int var0, PlayerInventory var1, IInventory var2, final EntityHorseAbstract var3, int var4) {
        super(null, var0);
        this.horseContainer = var2;
        this.horse = var3;
        var2.startOpen(var1.player);
        IInventory var5 = var3.createEquipmentSlotContainer(EnumItemSlot.SADDLE);
        this.addSlot(new ArmorSlot(this, var5, var3, EnumItemSlot.SADDLE, 0, 8, 18, SADDLE_SLOT_SPRITE){

            @Override
            public boolean isActive() {
                return var3.canUseSlot(EnumItemSlot.SADDLE) && var3.getType().is(TagsEntity.CAN_EQUIP_SADDLE);
            }
        });
        final boolean var6 = var3 instanceof EntityLlama;
        MinecraftKey var7 = var6 ? LLAMA_ARMOR_SLOT_SPRITE : ARMOR_SLOT_SPRITE;
        IInventory var8 = var3.createEquipmentSlotContainer(EnumItemSlot.BODY);
        this.addSlot(new ArmorSlot(this, var8, var3, EnumItemSlot.BODY, 0, 8, 36, var7){

            @Override
            public boolean isActive() {
                return var3.canUseSlot(EnumItemSlot.BODY) && (var3.getType().is(TagsEntity.CAN_WEAR_HORSE_ARMOR) || var6);
            }
        });
        if (var4 > 0) {
            for (int var9 = 0; var9 < 3; ++var9) {
                for (int var10 = 0; var10 < var4; ++var10) {
                    this.addSlot(new Slot(var2, var10 + var9 * var4, 80 + var10 * 18, 18 + var9 * 18));
                }
            }
        }
        this.addStandardInventorySlots(var1, 8, 84);
    }

    @Override
    public boolean stillValid(EntityHuman var0) {
        return !this.horse.hasInventoryChanged(this.horseContainer) && this.horseContainer.stillValid(var0) && this.horse.isAlive() && var0.canInteractWithEntity(this.horse, 4.0);
    }

    @Override
    public ItemStack quickMoveStack(EntityHuman var0, int var1) {
        ItemStack var2 = ItemStack.EMPTY;
        Slot var3 = (Slot)this.slots.get(var1);
        if (var3 != null && var3.hasItem()) {
            ItemStack var4 = var3.getItem();
            var2 = var4.copy();
            int var5 = 2 + this.horseContainer.getContainerSize();
            if (var1 < var5) {
                if (!this.moveItemStackTo(var4, var5, this.slots.size(), true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(1).mayPlace(var4) && !this.getSlot(1).hasItem()) {
                if (!this.moveItemStackTo(var4, 1, 2, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.getSlot(0).mayPlace(var4) && !this.getSlot(0).hasItem()) {
                if (!this.moveItemStackTo(var4, 0, 1, false)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.horseContainer.getContainerSize() == 0 || !this.moveItemStackTo(var4, 2, var5, false)) {
                int var6;
                int var7 = var6 = var5 + 27;
                int var8 = var7 + 9;
                if (var1 >= var7 && var1 < var8 ? !this.moveItemStackTo(var4, var5, var6, false) : (var1 >= var5 && var1 < var6 ? !this.moveItemStackTo(var4, var7, var8, false) : !this.moveItemStackTo(var4, var7, var6, false))) {
                    return ItemStack.EMPTY;
                }
                return ItemStack.EMPTY;
            }
            if (var4.isEmpty()) {
                var3.setByPlayer(ItemStack.EMPTY);
            } else {
                var3.setChanged();
            }
        }
        return var2;
    }

    @Override
    public void removed(EntityHuman var0) {
        super.removed(var0);
        this.horseContainer.stopOpen(var0);
    }
}

