/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.raid;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutNamedSoundEffect;
import net.minecraft.server.level.BossBattleServer;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.stats.StatisticList;
import net.minecraft.util.INamable;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossBattle;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPositionTypes;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.SpawnPlacementType;
import net.minecraft.world.entity.raid.EntityRaider;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.TooltipDisplay;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.phys.Vec3D;

public class Raid {
    public static final SpawnPlacementType RAVAGER_SPAWN_PLACEMENT_TYPE = EntityPositionTypes.getPlacementType(EntityTypes.RAVAGER);
    public static final MapCodec<Raid> MAP_CODEC = RecordCodecBuilder.mapCodec(var02 -> var02.group((App)Codec.BOOL.fieldOf("started").forGetter(var0 -> var0.started), (App)Codec.BOOL.fieldOf("active").forGetter(var0 -> var0.active), (App)Codec.LONG.fieldOf("ticks_active").forGetter(var0 -> var0.ticksActive), (App)Codec.INT.fieldOf("raid_omen_level").forGetter(var0 -> var0.raidOmenLevel), (App)Codec.INT.fieldOf("groups_spawned").forGetter(var0 -> var0.groupsSpawned), (App)Codec.INT.fieldOf("cooldown_ticks").forGetter(var0 -> var0.raidCooldownTicks), (App)Codec.INT.fieldOf("post_raid_ticks").forGetter(var0 -> var0.postRaidTicks), (App)Codec.FLOAT.fieldOf("total_health").forGetter(var0 -> Float.valueOf(var0.totalHealth)), (App)Codec.INT.fieldOf("group_count").forGetter(var0 -> var0.numGroups), (App)Status.CODEC.fieldOf("status").forGetter(var0 -> var0.status), (App)BlockPosition.CODEC.fieldOf("center").forGetter(var0 -> var0.center), (App)UUIDUtil.CODEC_SET.fieldOf("heroes_of_the_village").forGetter(var0 -> var0.heroesOfTheVillage)).apply((Applicative)var02, Raid::new));
    private static final int ALLOW_SPAWNING_WITHIN_VILLAGE_SECONDS_THRESHOLD = 7;
    private static final int SECTION_RADIUS_FOR_FINDING_NEW_VILLAGE_CENTER = 2;
    private static final int VILLAGE_SEARCH_RADIUS = 32;
    private static final int RAID_TIMEOUT_TICKS = 48000;
    private static final int NUM_SPAWN_ATTEMPTS = 5;
    private static final IChatBaseComponent OMINOUS_BANNER_PATTERN_NAME = IChatBaseComponent.translatable("block.minecraft.ominous_banner");
    private static final String RAIDERS_REMAINING = "event.minecraft.raid.raiders_remaining";
    public static final int VILLAGE_RADIUS_BUFFER = 16;
    private static final int POST_RAID_TICK_LIMIT = 40;
    private static final int DEFAULT_PRE_RAID_TICKS = 300;
    public static final int MAX_NO_ACTION_TIME = 2400;
    public static final int MAX_CELEBRATION_TICKS = 600;
    private static final int OUTSIDE_RAID_BOUNDS_TIMEOUT = 30;
    public static final int TICKS_PER_DAY = 24000;
    public static final int DEFAULT_MAX_RAID_OMEN_LEVEL = 5;
    private static final int LOW_MOB_THRESHOLD = 2;
    private static final IChatBaseComponent RAID_NAME_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid");
    private static final IChatBaseComponent RAID_BAR_VICTORY_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid.victory.full");
    private static final IChatBaseComponent RAID_BAR_DEFEAT_COMPONENT = IChatBaseComponent.translatable("event.minecraft.raid.defeat.full");
    private static final int HERO_OF_THE_VILLAGE_DURATION = 48000;
    private static final int VALID_RAID_RADIUS = 96;
    public static final int VALID_RAID_RADIUS_SQR = 9216;
    public static final int RAID_REMOVAL_THRESHOLD_SQR = 12544;
    private final Map<Integer, EntityRaider> groupToLeaderMap = Maps.newHashMap();
    private final Map<Integer, Set<EntityRaider>> groupRaiderMap = Maps.newHashMap();
    public final Set<UUID> heroesOfTheVillage = Sets.newHashSet();
    public long ticksActive;
    private BlockPosition center;
    private boolean started;
    public float totalHealth;
    public int raidOmenLevel;
    private boolean active;
    private int groupsSpawned;
    private final BossBattleServer raidEvent = new BossBattleServer(RAID_NAME_COMPONENT, BossBattle.BarColor.RED, BossBattle.BarStyle.NOTCHED_10);
    private int postRaidTicks;
    private int raidCooldownTicks;
    private final RandomSource random = RandomSource.create();
    public final int numGroups;
    private Status status;
    private int celebrationTicks;
    private Optional<BlockPosition> waveSpawnPos = Optional.empty();

    public Raid(BlockPosition var0, EnumDifficulty var1) {
        this.active = true;
        this.raidCooldownTicks = 300;
        this.raidEvent.setProgress(0.0f);
        this.center = var0;
        this.numGroups = this.getNumGroups(var1);
        this.status = Status.ONGOING;
    }

    private Raid(boolean var0, boolean var1, long var2, int var4, int var5, int var6, int var7, float var8, int var9, Status var10, BlockPosition var11, Set<UUID> var12) {
        this.started = var0;
        this.active = var1;
        this.ticksActive = var2;
        this.raidOmenLevel = var4;
        this.groupsSpawned = var5;
        this.raidCooldownTicks = var6;
        this.postRaidTicks = var7;
        this.totalHealth = var8;
        this.center = var11;
        this.numGroups = var9;
        this.status = var10;
        this.heroesOfTheVillage.addAll(var12);
    }

    public boolean isOver() {
        return this.isVictory() || this.isLoss();
    }

    public boolean isBetweenWaves() {
        return this.hasFirstWaveSpawned() && this.getTotalRaidersAlive() == 0 && this.raidCooldownTicks > 0;
    }

    public boolean hasFirstWaveSpawned() {
        return this.groupsSpawned > 0;
    }

    public boolean isStopped() {
        return this.status == Status.STOPPED;
    }

    public boolean isVictory() {
        return this.status == Status.VICTORY;
    }

    public boolean isLoss() {
        return this.status == Status.LOSS;
    }

    public float getTotalHealth() {
        return this.totalHealth;
    }

    public Set<EntityRaider> getAllRaiders() {
        HashSet var0 = Sets.newHashSet();
        for (Set<EntityRaider> var2 : this.groupRaiderMap.values()) {
            var0.addAll(var2);
        }
        return var0;
    }

    public boolean isStarted() {
        return this.started;
    }

    public int getGroupsSpawned() {
        return this.groupsSpawned;
    }

    private Predicate<EntityPlayer> validPlayer() {
        return var0 -> {
            BlockPosition var1 = var0.blockPosition();
            return var0.isAlive() && var0.level().getRaidAt(var1) == this;
        };
    }

    private void updatePlayers(WorldServer var0) {
        HashSet var1 = Sets.newHashSet(this.raidEvent.getPlayers());
        List<EntityPlayer> var2 = var0.getPlayers(this.validPlayer());
        for (EntityPlayer var4 : var2) {
            if (var1.contains(var4)) continue;
            this.raidEvent.addPlayer(var4);
        }
        for (EntityPlayer var4 : var1) {
            if (var2.contains(var4)) continue;
            this.raidEvent.removePlayer(var4);
        }
    }

    public int getMaxRaidOmenLevel() {
        return 5;
    }

    public int getRaidOmenLevel() {
        return this.raidOmenLevel;
    }

    public void setRaidOmenLevel(int var0) {
        this.raidOmenLevel = var0;
    }

    public boolean absorbRaidOmen(EntityPlayer var0) {
        MobEffect var1 = var0.getEffect(MobEffects.RAID_OMEN);
        if (var1 == null) {
            return false;
        }
        this.raidOmenLevel += var1.getAmplifier() + 1;
        this.raidOmenLevel = MathHelper.clamp(this.raidOmenLevel, 0, this.getMaxRaidOmenLevel());
        if (!this.hasFirstWaveSpawned()) {
            var0.awardStat(StatisticList.RAID_TRIGGER);
            CriterionTriggers.RAID_OMEN.trigger(var0);
        }
        return true;
    }

    public void stop() {
        this.active = false;
        this.raidEvent.removeAllPlayers();
        this.status = Status.STOPPED;
    }

    public void tick(WorldServer var0) {
        if (this.isStopped()) {
            return;
        }
        if (this.status == Status.ONGOING) {
            int var4;
            boolean var3;
            boolean var1 = this.active;
            this.active = var0.hasChunkAt(this.center);
            if (var0.getDifficulty() == EnumDifficulty.PEACEFUL) {
                this.stop();
                return;
            }
            if (var1 != this.active) {
                this.raidEvent.setVisible(this.active);
            }
            if (!this.active) {
                return;
            }
            if (!var0.isVillage(this.center)) {
                this.moveRaidCenterToNearbyVillageSection(var0);
            }
            if (!var0.isVillage(this.center)) {
                if (this.groupsSpawned > 0) {
                    this.status = Status.LOSS;
                } else {
                    this.stop();
                }
            }
            ++this.ticksActive;
            if (this.ticksActive >= 48000L) {
                this.stop();
                return;
            }
            int var2 = this.getTotalRaidersAlive();
            if (var2 == 0 && this.hasMoreWaves()) {
                if (this.raidCooldownTicks > 0) {
                    var3 = this.waveSpawnPos.isPresent();
                    int n2 = var4 = !var3 && this.raidCooldownTicks % 5 == 0 ? 1 : 0;
                    if (var3 && !var0.isPositionEntityTicking(this.waveSpawnPos.get())) {
                        var4 = 1;
                    }
                    if (var4 != 0) {
                        this.waveSpawnPos = this.getValidSpawnPos(var0);
                    }
                    if (this.raidCooldownTicks == 300 || this.raidCooldownTicks % 20 == 0) {
                        this.updatePlayers(var0);
                    }
                    --this.raidCooldownTicks;
                    this.raidEvent.setProgress(MathHelper.clamp((float)(300 - this.raidCooldownTicks) / 300.0f, 0.0f, 1.0f));
                } else if (this.raidCooldownTicks == 0 && this.groupsSpawned > 0) {
                    this.raidCooldownTicks = 300;
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                    return;
                }
            }
            if (this.ticksActive % 20L == 0L) {
                this.updatePlayers(var0);
                this.updateRaiders(var0);
                if (var2 > 0) {
                    if (var2 <= 2) {
                        this.raidEvent.setName(RAID_NAME_COMPONENT.copy().append(" - ").append(IChatBaseComponent.translatable(RAIDERS_REMAINING, var2)));
                    } else {
                        this.raidEvent.setName(RAID_NAME_COMPONENT);
                    }
                } else {
                    this.raidEvent.setName(RAID_NAME_COMPONENT);
                }
            }
            var3 = false;
            var4 = 0;
            while (this.shouldSpawnGroup()) {
                BlockPosition var5 = this.waveSpawnPos.orElseGet(() -> this.findRandomSpawnPos(var0, 20));
                if (var5 != null) {
                    this.started = true;
                    this.spawnGroup(var0, var5);
                    if (!var3) {
                        this.playSound(var0, var5);
                        var3 = true;
                    }
                } else {
                    ++var4;
                }
                if (var4 <= 5) continue;
                this.stop();
                break;
            }
            if (this.isStarted() && !this.hasMoreWaves() && var2 == 0) {
                if (this.postRaidTicks < 40) {
                    ++this.postRaidTicks;
                } else {
                    this.status = Status.VICTORY;
                    for (UUID var6 : this.heroesOfTheVillage) {
                        Entity var7 = var0.getEntity(var6);
                        if (!(var7 instanceof EntityLiving)) continue;
                        EntityLiving var8 = (EntityLiving)var7;
                        if (var7.isSpectator()) continue;
                        var8.addEffect(new MobEffect(MobEffects.HERO_OF_THE_VILLAGE, 48000, this.raidOmenLevel - 1, false, false, true));
                        if (!(var8 instanceof EntityPlayer)) continue;
                        EntityPlayer var9 = (EntityPlayer)var8;
                        var9.awardStat(StatisticList.RAID_WIN);
                        CriterionTriggers.RAID_WIN.trigger(var9);
                    }
                }
            }
            this.setDirty(var0);
        } else if (this.isOver()) {
            ++this.celebrationTicks;
            if (this.celebrationTicks >= 600) {
                this.stop();
                return;
            }
            if (this.celebrationTicks % 20 == 0) {
                this.updatePlayers(var0);
                this.raidEvent.setVisible(true);
                if (this.isVictory()) {
                    this.raidEvent.setProgress(0.0f);
                    this.raidEvent.setName(RAID_BAR_VICTORY_COMPONENT);
                } else {
                    this.raidEvent.setName(RAID_BAR_DEFEAT_COMPONENT);
                }
            }
        }
    }

    private void moveRaidCenterToNearbyVillageSection(WorldServer var02) {
        Stream<SectionPosition> var1 = SectionPosition.cube(SectionPosition.of(this.center), 2);
        var1.filter(var02::isVillage).map(SectionPosition::center).min(Comparator.comparingDouble(var0 -> var0.distSqr(this.center))).ifPresent(this::setCenter);
    }

    private Optional<BlockPosition> getValidSpawnPos(WorldServer var0) {
        BlockPosition var1 = this.findRandomSpawnPos(var0, 8);
        if (var1 != null) {
            return Optional.of(var1);
        }
        return Optional.empty();
    }

    private boolean hasMoreWaves() {
        if (this.hasBonusWave()) {
            return !this.hasSpawnedBonusWave();
        }
        return !this.isFinalWave();
    }

    private boolean isFinalWave() {
        return this.getGroupsSpawned() == this.numGroups;
    }

    private boolean hasBonusWave() {
        return this.raidOmenLevel > 1;
    }

    private boolean hasSpawnedBonusWave() {
        return this.getGroupsSpawned() > this.numGroups;
    }

    private boolean shouldSpawnBonusGroup() {
        return this.isFinalWave() && this.getTotalRaidersAlive() == 0 && this.hasBonusWave();
    }

    private void updateRaiders(WorldServer var0) {
        Iterator<Set<EntityRaider>> var1 = this.groupRaiderMap.values().iterator();
        HashSet var2 = Sets.newHashSet();
        while (var1.hasNext()) {
            Set<EntityRaider> var3 = var1.next();
            for (EntityRaider var5 : var3) {
                BlockPosition var6 = var5.blockPosition();
                if (var5.isRemoved() || var5.level().dimension() != var0.dimension() || this.center.distSqr(var6) >= 12544.0) {
                    var2.add(var5);
                    continue;
                }
                if (var5.tickCount <= 600) continue;
                if (var0.getEntity(var5.getUUID()) == null) {
                    var2.add(var5);
                }
                if (!var0.isVillage(var6) && var5.getNoActionTime() > 2400) {
                    var5.setTicksOutsideRaid(var5.getTicksOutsideRaid() + 1);
                }
                if (var5.getTicksOutsideRaid() < 30) continue;
                var2.add(var5);
            }
        }
        for (EntityRaider var4 : var2) {
            this.removeFromRaid(var0, var4, true);
            if (!var4.isPatrolLeader()) continue;
            this.removeLeader(var4.getWave());
        }
    }

    private void playSound(WorldServer var0, BlockPosition var1) {
        float var2 = 13.0f;
        int var3 = 64;
        Collection<EntityPlayer> var4 = this.raidEvent.getPlayers();
        long var5 = this.random.nextLong();
        for (EntityPlayer var8 : var0.players()) {
            Vec3D var9 = var8.position();
            Vec3D var10 = Vec3D.atCenterOf(var1);
            double var11 = Math.sqrt((var10.x - var9.x) * (var10.x - var9.x) + (var10.z - var9.z) * (var10.z - var9.z));
            double var13 = var9.x + 13.0 / var11 * (var10.x - var9.x);
            double var15 = var9.z + 13.0 / var11 * (var10.z - var9.z);
            if (!(var11 <= 64.0) && !var4.contains(var8)) continue;
            var8.connection.send(new PacketPlayOutNamedSoundEffect(SoundEffects.RAID_HORN, SoundCategory.NEUTRAL, var13, var8.getY(), var15, 64.0f, 1.0f, var5));
        }
    }

    private void spawnGroup(WorldServer var0, BlockPosition var1) {
        boolean var2 = false;
        int var3 = this.groupsSpawned + 1;
        this.totalHealth = 0.0f;
        DifficultyDamageScaler var4 = var0.getCurrentDifficultyAt(var1);
        boolean var5 = this.shouldSpawnBonusGroup();
        for (Wave var9 : Wave.VALUES) {
            EntityRaider var13;
            int var10 = this.getDefaultNumSpawns(var9, var3, var5) + this.getPotentialBonusSpawns(var9, this.random, var3, var4, var5);
            int var11 = 0;
            for (int var12 = 0; var12 < var10 && (var13 = var9.entityType.create(var0, EntitySpawnReason.EVENT)) != null; ++var12) {
                if (!var2 && var13.canBeLeader()) {
                    var13.setPatrolLeader(true);
                    this.setLeader(var3, var13);
                    var2 = true;
                }
                this.joinRaid(var0, var3, var13, var1, false);
                if (var9.entityType != EntityTypes.RAVAGER) continue;
                EntityRaider var14 = null;
                if (var3 == this.getNumGroups(EnumDifficulty.NORMAL)) {
                    var14 = EntityTypes.PILLAGER.create(var0, EntitySpawnReason.EVENT);
                } else if (var3 >= this.getNumGroups(EnumDifficulty.HARD)) {
                    var14 = var11 == 0 ? (EntityRaider)EntityTypes.EVOKER.create(var0, EntitySpawnReason.EVENT) : (EntityRaider)EntityTypes.VINDICATOR.create(var0, EntitySpawnReason.EVENT);
                }
                ++var11;
                if (var14 == null) continue;
                this.joinRaid(var0, var3, var14, var1, false);
                var14.snapTo(var1, 0.0f, 0.0f);
                var14.startRiding(var13);
            }
        }
        this.waveSpawnPos = Optional.empty();
        ++this.groupsSpawned;
        this.updateBossbar();
        this.setDirty(var0);
    }

    public void joinRaid(WorldServer var0, int var1, EntityRaider var2, @Nullable BlockPosition var3, boolean var4) {
        boolean var5 = this.addWaveMob(var0, var1, var2);
        if (var5) {
            var2.setCurrentRaid(this);
            var2.setWave(var1);
            var2.setCanJoinRaid(true);
            var2.setTicksOutsideRaid(0);
            if (!var4 && var3 != null) {
                var2.setPos((double)var3.getX() + 0.5, (double)var3.getY() + 1.0, (double)var3.getZ() + 0.5);
                var2.finalizeSpawn(var0, var0.getCurrentDifficultyAt(var3), EntitySpawnReason.EVENT, null);
                var2.applyRaidBuffs(var0, var1, false);
                var2.setOnGround(true);
                var0.addFreshEntityWithPassengers(var2);
            }
        }
    }

    public void updateBossbar() {
        this.raidEvent.setProgress(MathHelper.clamp(this.getHealthOfLivingRaiders() / this.totalHealth, 0.0f, 1.0f));
    }

    public float getHealthOfLivingRaiders() {
        float var0 = 0.0f;
        for (Set<EntityRaider> var2 : this.groupRaiderMap.values()) {
            for (EntityRaider var4 : var2) {
                var0 += var4.getHealth();
            }
        }
        return var0;
    }

    private boolean shouldSpawnGroup() {
        return this.raidCooldownTicks == 0 && (this.groupsSpawned < this.numGroups || this.shouldSpawnBonusGroup()) && this.getTotalRaidersAlive() == 0;
    }

    public int getTotalRaidersAlive() {
        return this.groupRaiderMap.values().stream().mapToInt(Set::size).sum();
    }

    public void removeFromRaid(WorldServer var0, EntityRaider var1, boolean var2) {
        boolean var4;
        Set<EntityRaider> var3 = this.groupRaiderMap.get(var1.getWave());
        if (var3 != null && (var4 = var3.remove(var1))) {
            if (var2) {
                this.totalHealth -= var1.getHealth();
            }
            var1.setCurrentRaid(null);
            this.updateBossbar();
            this.setDirty(var0);
        }
    }

    private void setDirty(WorldServer var0) {
        var0.getRaids().setDirty();
    }

    public static ItemStack getOminousBannerInstance(HolderGetter<EnumBannerPatternType> var0) {
        ItemStack var1 = new ItemStack(Items.WHITE_BANNER);
        BannerPatternLayers var2 = new BannerPatternLayers.a().addIfRegistered(var0, BannerPatterns.RHOMBUS_MIDDLE, EnumColor.CYAN).addIfRegistered(var0, BannerPatterns.STRIPE_BOTTOM, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.STRIPE_CENTER, EnumColor.GRAY).addIfRegistered(var0, BannerPatterns.BORDER, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.STRIPE_MIDDLE, EnumColor.BLACK).addIfRegistered(var0, BannerPatterns.HALF_HORIZONTAL, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.CIRCLE_MIDDLE, EnumColor.LIGHT_GRAY).addIfRegistered(var0, BannerPatterns.BORDER, EnumColor.BLACK).build();
        var1.set(DataComponents.BANNER_PATTERNS, var2);
        var1.set(DataComponents.TOOLTIP_DISPLAY, TooltipDisplay.DEFAULT.withHidden(DataComponents.BANNER_PATTERNS, true));
        var1.set(DataComponents.ITEM_NAME, OMINOUS_BANNER_PATTERN_NAME);
        var1.set(DataComponents.RARITY, EnumItemRarity.UNCOMMON);
        return var1;
    }

    @Nullable
    public EntityRaider getLeader(int var0) {
        return this.groupToLeaderMap.get(var0);
    }

    @Nullable
    private BlockPosition findRandomSpawnPos(WorldServer var0, int var1) {
        int var2 = this.raidCooldownTicks / 20;
        float var3 = 0.22f * (float)var2 - 0.24f;
        BlockPosition.MutableBlockPosition var7 = new BlockPosition.MutableBlockPosition();
        float var8 = var0.random.nextFloat() * ((float)Math.PI * 2);
        for (int var9 = 0; var9 < var1; ++var9) {
            int var6;
            float var10 = var8 + (float)Math.PI * (float)var9 / 8.0f;
            int var4 = this.center.getX() + MathHelper.floor(MathHelper.cos(var10) * 32.0f * var3) + var0.random.nextInt(3) * MathHelper.floor(var3);
            int var5 = var0.getHeight(HeightMap.Type.WORLD_SURFACE, var4, var6 = this.center.getZ() + MathHelper.floor(MathHelper.sin(var10) * 32.0f * var3) + var0.random.nextInt(3) * MathHelper.floor(var3));
            if (MathHelper.abs(var5 - this.center.getY()) > 96) continue;
            var7.set(var4, var5, var6);
            if (var0.isVillage(var7) && var2 > 7) continue;
            int var11 = 10;
            if (!var0.hasChunksAt(var7.getX() - 10, var7.getZ() - 10, var7.getX() + 10, var7.getZ() + 10) || !var0.isPositionEntityTicking(var7) || !RAVAGER_SPAWN_PLACEMENT_TYPE.isSpawnPositionOk(var0, var7, EntityTypes.RAVAGER) && (!var0.getBlockState((BlockPosition)var7.below()).is(Blocks.SNOW) || !var0.getBlockState(var7).isAir())) continue;
            return var7;
        }
        return null;
    }

    private boolean addWaveMob(WorldServer var0, int var1, EntityRaider var2) {
        return this.addWaveMob(var0, var1, var2, true);
    }

    public boolean addWaveMob(WorldServer var02, int var1, EntityRaider var2, boolean var3) {
        this.groupRaiderMap.computeIfAbsent(var1, var0 -> Sets.newHashSet());
        Set<EntityRaider> var4 = this.groupRaiderMap.get(var1);
        EntityRaider var5 = null;
        for (EntityRaider var7 : var4) {
            if (!var7.getUUID().equals(var2.getUUID())) continue;
            var5 = var7;
            break;
        }
        if (var5 != null) {
            var4.remove(var5);
            var4.add(var2);
        }
        var4.add(var2);
        if (var3) {
            this.totalHealth += var2.getHealth();
        }
        this.updateBossbar();
        this.setDirty(var02);
        return true;
    }

    public void setLeader(int var0, EntityRaider var1) {
        this.groupToLeaderMap.put(var0, var1);
        var1.setItemSlot(EnumItemSlot.HEAD, Raid.getOminousBannerInstance(var1.registryAccess().lookupOrThrow(Registries.BANNER_PATTERN)));
        var1.setDropChance(EnumItemSlot.HEAD, 2.0f);
    }

    public void removeLeader(int var0) {
        this.groupToLeaderMap.remove(var0);
    }

    public BlockPosition getCenter() {
        return this.center;
    }

    private void setCenter(BlockPosition var0) {
        this.center = var0;
    }

    private int getDefaultNumSpawns(Wave var0, int var1, boolean var2) {
        return var2 ? var0.spawnsPerWaveBeforeBonus[this.numGroups] : var0.spawnsPerWaveBeforeBonus[var1];
    }

    private int getPotentialBonusSpawns(Wave var0, RandomSource var1, int var2, DifficultyDamageScaler var3, boolean var4) {
        int var8;
        EnumDifficulty var5 = var3.getDifficulty();
        boolean var6 = var5 == EnumDifficulty.EASY;
        boolean var7 = var5 == EnumDifficulty.NORMAL;
        switch (var0.ordinal()) {
            case 3: {
                if (!var6 && var2 > 2 && var2 != 4) {
                    var8 = 1;
                    break;
                }
                return 0;
            }
            case 0: 
            case 2: {
                if (var6) {
                    var8 = var1.nextInt(2);
                    break;
                }
                if (var7) {
                    var8 = 1;
                    break;
                }
                var8 = 2;
                break;
            }
            case 4: {
                var8 = !var6 && var4 ? 1 : 0;
                break;
            }
            default: {
                return 0;
            }
        }
        return var8 > 0 ? var1.nextInt(var8 + 1) : 0;
    }

    public boolean isActive() {
        return this.active;
    }

    public int getNumGroups(EnumDifficulty var0) {
        return switch (var0) {
            default -> throw new MatchException(null, null);
            case EnumDifficulty.PEACEFUL -> 0;
            case EnumDifficulty.EASY -> 3;
            case EnumDifficulty.NORMAL -> 5;
            case EnumDifficulty.HARD -> 7;
        };
    }

    public float getEnchantOdds() {
        int var0 = this.getRaidOmenLevel();
        if (var0 == 2) {
            return 0.1f;
        }
        if (var0 == 3) {
            return 0.25f;
        }
        if (var0 == 4) {
            return 0.5f;
        }
        if (var0 == 5) {
            return 0.75f;
        }
        return 0.0f;
    }

    public void addHeroOfTheVillage(Entity var0) {
        this.heroesOfTheVillage.add(var0.getUUID());
    }

    static final class Status
    extends Enum<Status>
    implements INamable {
        public static final /* enum */ Status ONGOING = new Status("ongoing");
        public static final /* enum */ Status VICTORY = new Status("victory");
        public static final /* enum */ Status LOSS = new Status("loss");
        public static final /* enum */ Status STOPPED = new Status("stopped");
        public static final Codec<Status> CODEC;
        private final String name;
        private static final /* synthetic */ Status[] g;

        public static Status[] values() {
            return (Status[])g.clone();
        }

        public static Status valueOf(String var0) {
            return Enum.valueOf(Status.class, var0);
        }

        private Status(String var2) {
            this.name = var2;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        private static /* synthetic */ Status[] a() {
            return new Status[]{ONGOING, VICTORY, LOSS, STOPPED};
        }

        static {
            g = Status.a();
            CODEC = INamable.fromEnum(Status::values);
        }
    }

    static final class Wave
    extends Enum<Wave> {
        public static final /* enum */ Wave VINDICATOR = new Wave(EntityTypes.VINDICATOR, new int[]{0, 0, 2, 0, 1, 4, 2, 5});
        public static final /* enum */ Wave EVOKER = new Wave(EntityTypes.EVOKER, new int[]{0, 0, 0, 0, 0, 1, 1, 2});
        public static final /* enum */ Wave PILLAGER = new Wave(EntityTypes.PILLAGER, new int[]{0, 4, 3, 3, 4, 4, 4, 2});
        public static final /* enum */ Wave WITCH = new Wave(EntityTypes.WITCH, new int[]{0, 0, 0, 0, 3, 0, 0, 1});
        public static final /* enum */ Wave RAVAGER = new Wave(EntityTypes.RAVAGER, new int[]{0, 0, 0, 1, 0, 1, 0, 2});
        static final Wave[] VALUES;
        final EntityTypes<? extends EntityRaider> entityType;
        final int[] spawnsPerWaveBeforeBonus;
        private static final /* synthetic */ Wave[] i;

        public static Wave[] values() {
            return (Wave[])i.clone();
        }

        public static Wave valueOf(String var0) {
            return Enum.valueOf(Wave.class, var0);
        }

        private Wave(EntityTypes var2, int[] var3) {
            this.entityType = var2;
            this.spawnsPerWaveBeforeBonus = var3;
        }

        private static /* synthetic */ Wave[] a() {
            return new Wave[]{VINDICATOR, EVOKER, PILLAGER, WITCH, RAVAGER};
        }

        static {
            i = Wave.a();
            VALUES = Wave.values();
        }
    }
}

