/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.Relative;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionEntity;
import net.minecraft.world.phys.Vec3D;

public class EntityEnderPearl
extends EntityProjectileThrowable {
    private long ticketTimer = 0L;

    public EntityEnderPearl(EntityTypes<? extends EntityEnderPearl> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityEnderPearl(World var0, EntityLiving var1, ItemStack var2) {
        super(EntityTypes.ENDER_PEARL, var1, var0, var2);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.ENDER_PEARL;
    }

    @Override
    protected void setOwner(@Nullable EntityReference<Entity> var0) {
        this.deregisterFromCurrentOwner();
        super.setOwner(var0);
        this.registerToCurrentOwner();
    }

    private void deregisterFromCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entity;
            var0.deregisterEnderPearl(this);
        }
    }

    private void registerToCurrentOwner() {
        Entity entity = this.getOwner();
        if (entity instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entity;
            var0.registerEnderPearl(this);
        }
    }

    @Override
    @Nullable
    public Entity getOwner() {
        World world;
        if (this.owner == null || !((world = this.level()) instanceof WorldServer)) {
            return super.getOwner();
        }
        WorldServer var0 = (WorldServer)world;
        return this.owner.getEntity(var1 -> EntityEnderPearl.findOwnerInAnyDimension(var0, var1), Entity.class);
    }

    @Nullable
    private static Entity findOwnerInAnyDimension(WorldServer var0, UUID var1) {
        Entity var2 = var0.getEntity(var1);
        if (var2 != null) {
            return var2;
        }
        for (WorldServer var4 : var0.getServer().getAllLevels()) {
            if (var4 == var0 || (var2 = var4.getEntity(var1)) == null) continue;
            return var2;
        }
        return null;
    }

    @Override
    protected void onHitEntity(MovingObjectPositionEntity var0) {
        super.onHitEntity(var0);
        var0.getEntity().hurt(this.damageSources().thrown(this, this.getOwner()), 0.0f);
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        WorldServer var1;
        block14: {
            block13: {
                super.onHit(var0);
                for (int var12 = 0; var12 < 32; ++var12) {
                    this.level().addParticle(Particles.PORTAL, this.getX(), this.getY() + this.random.nextDouble() * 2.0, this.getZ(), this.random.nextGaussian(), 0.0, this.random.nextGaussian());
                }
                World world = this.level();
                if (!(world instanceof WorldServer)) break block13;
                var1 = (WorldServer)world;
                if (!this.isRemoved()) break block14;
            }
            return;
        }
        Entity var2 = this.getOwner();
        if (var2 == null || !EntityEnderPearl.isAllowedToTeleportOwner(var2, var1)) {
            this.discard();
            return;
        }
        Vec3D var3 = this.oldPosition();
        if (var2 instanceof EntityPlayer) {
            EntityPlayer var4 = (EntityPlayer)var2;
            if (var4.connection.isAcceptingMessages()) {
                EntityLiving var5;
                if (this.random.nextFloat() < 0.05f && var1.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) && (var5 = EntityTypes.ENDERMITE.create(var1, EntitySpawnReason.TRIGGERED)) != null) {
                    var5.snapTo(var2.getX(), var2.getY(), var2.getZ(), var2.getYRot(), var2.getXRot());
                    var1.addFreshEntity(var5);
                }
                if (this.isOnPortalCooldown()) {
                    var2.setPortalCooldown();
                }
                if ((var5 = var4.teleport(new TeleportTransition(var1, var3, Vec3D.ZERO, 0.0f, 0.0f, Relative.union(Relative.ROTATION, Relative.DELTA), TeleportTransition.DO_NOTHING))) != null) {
                    ((EntityPlayer)var5).resetFallDistance();
                    ((EntityHuman)var5).resetCurrentImpulseContext();
                    ((EntityPlayer)var5).hurtServer(var4.level(), this.damageSources().enderPearl(), 5.0f);
                }
                this.playSound(var1, var3);
            }
        } else {
            Entity var5 = var2.teleport(new TeleportTransition(var1, var3, var2.getDeltaMovement(), var2.getYRot(), var2.getXRot(), TeleportTransition.DO_NOTHING));
            if (var5 != null) {
                var5.resetFallDistance();
            }
            this.playSound(var1, var3);
        }
        this.discard();
    }

    private static boolean isAllowedToTeleportOwner(Entity var0, World var1) {
        if (var0.level().dimension() == var1.dimension()) {
            if (var0 instanceof EntityLiving) {
                EntityLiving var2 = (EntityLiving)var0;
                return var2.isAlive() && !var2.isSleeping();
            }
            return var0.isAlive();
        }
        return var0.canUsePortal(true);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void tick() {
        var0 = SectionPosition.blockToSectionCoord(this.position().x());
        var1 = SectionPosition.blockToSectionCoord(this.position().z());
        var2 = this.getOwner();
        if (!(var2 instanceof EntityPlayer)) ** GOTO lbl-1000
        var3 = (EntityPlayer)var2;
        if (!var2.isAlive() && var3.level().getGameRules().getBoolean(GameRules.RULE_ENDER_PEARLS_VANISH_ON_DEATH)) {
            this.discard();
        } else lbl-1000:
        // 2 sources

        {
            super.tick();
        }
        if (!this.isAlive()) {
            return;
        }
        var3 = BlockPosition.containing(this.position());
        if ((--this.ticketTimer <= 0L || var0 != SectionPosition.blockToSectionCoord(var3.getX()) || var1 != SectionPosition.blockToSectionCoord(var3.getZ())) && var2 instanceof EntityPlayer) {
            var4 = (EntityPlayer)var2;
            this.ticketTimer = var4.registerAndUpdateEnderPearlTicket(this);
        }
    }

    private void playSound(World var0, Vec3D var1) {
        var0.playSound(null, var1.x, var1.y, var1.z, SoundEffects.PLAYER_TELEPORT, SoundCategory.PLAYERS);
    }

    @Override
    @Nullable
    public Entity teleport(TeleportTransition var0) {
        Entity var1 = super.teleport(var0);
        if (var1 != null) {
            var1.placePortalTicket(BlockPosition.containing(var1.position()));
        }
        return var1;
    }

    @Override
    public boolean canTeleport(World var0, World var1) {
        Entity entity;
        if (var0.dimension() == World.END && var1.dimension() == World.OVERWORLD && (entity = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer var2 = (EntityPlayer)entity;
            return super.canTeleport(var0, var1) && var2.seenCredits;
        }
        return super.canTeleport(var0, var1);
    }

    @Override
    protected void onInsideBlock(IBlockData var0) {
        Entity entity;
        super.onInsideBlock(var0);
        if (var0.is(Blocks.END_GATEWAY) && (entity = this.getOwner()) instanceof EntityPlayer) {
            EntityPlayer var1 = (EntityPlayer)entity;
            var1.onInsideBlock(var0);
        }
    }

    @Override
    public void onRemoval(Entity.RemovalReason var0) {
        if (var0 != Entity.RemovalReason.UNLOADED_WITH_PLAYER) {
            this.deregisterFromCurrentOwner();
        }
        super.onRemoval(var0);
    }

    @Override
    public void onAboveBubbleColumn(boolean var0, BlockPosition var1) {
        Entity.handleOnAboveBubbleColumn(this, var0, var1);
    }

    @Override
    public void onInsideBubbleColumn(boolean var0) {
        Entity.handleOnInsideBubbleColumn(this, var0);
    }
}

