/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import com.google.common.annotations.VisibleForTesting;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.ConversionParams;
import net.minecraft.world.entity.ConversionType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerMove;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityIronGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccess;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.levelgen.SeededRandom;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.scores.ScoreboardTeam;

public class EntitySlime
extends EntityInsentient
implements IMonster {
    private static final DataWatcherObject<Integer> ID_SIZE = DataWatcher.defineId(EntitySlime.class, DataWatcherRegistry.INT);
    public static final int MIN_SIZE = 1;
    public static final int MAX_SIZE = 127;
    public static final int MAX_NATURAL_SIZE = 4;
    private static final boolean DEFAULT_WAS_ON_GROUND = false;
    public float targetSquish;
    public float squish;
    public float oSquish;
    private boolean wasOnGround = false;

    public EntitySlime(EntityTypes<? extends EntitySlime> var0, World var1) {
        super((EntityTypes<? extends EntityInsentient>)var0, var1);
        this.fixupDimensions();
        this.moveControl = new ControllerMoveSlime(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalSlimeRandomJump(this));
        this.goalSelector.addGoal(2, new PathfinderGoalSlimeNearestPlayer(this));
        this.goalSelector.addGoal(3, new PathfinderGoalSlimeRandomDirection(this));
        this.goalSelector.addGoal(5, new PathfinderGoalSlimeIdle(this));
        this.targetSelector.addGoal(1, new PathfinderGoalNearestAttackableTarget<EntityHuman>(this, EntityHuman.class, 10, true, false, (var0, var1) -> Math.abs(var0.getY() - this.getY()) <= 4.0));
        this.targetSelector.addGoal(3, new PathfinderGoalNearestAttackableTarget<EntityIronGolem>((EntityInsentient)this, EntityIronGolem.class, true));
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(ID_SIZE, 1);
    }

    @VisibleForTesting
    public void setSize(int var0, boolean var1) {
        int var2 = MathHelper.clamp(var0, 1, 127);
        this.entityData.set(ID_SIZE, var2);
        this.reapplyPosition();
        this.refreshDimensions();
        this.getAttribute(GenericAttributes.MAX_HEALTH).setBaseValue(var2 * var2);
        this.getAttribute(GenericAttributes.MOVEMENT_SPEED).setBaseValue(0.2f + 0.1f * (float)var2);
        this.getAttribute(GenericAttributes.ATTACK_DAMAGE).setBaseValue(var2);
        if (var1) {
            this.setHealth(this.getMaxHealth());
        }
        this.xpReward = var2;
    }

    public int getSize() {
        return this.entityData.get(ID_SIZE);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt("Size", this.getSize() - 1);
        var0.putBoolean("wasOnGround", this.wasOnGround);
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        this.setSize(var0.getIntOr("Size", 0) + 1, false);
        super.readAdditionalSaveData(var0);
        this.wasOnGround = var0.getBooleanOr("wasOnGround", false);
    }

    public boolean isTiny() {
        return this.getSize() <= 1;
    }

    protected ParticleParam getParticleType() {
        return Particles.ITEM_SLIME;
    }

    @Override
    protected boolean shouldDespawnInPeaceful() {
        return this.getSize() > 0;
    }

    @Override
    public void tick() {
        this.oSquish = this.squish;
        this.squish += (this.targetSquish - this.squish) * 0.5f;
        super.tick();
        if (this.onGround() && !this.wasOnGround) {
            float var0 = this.getDimensions(this.getPose()).width() * 2.0f;
            float var1 = var0 / 2.0f;
            int var2 = 0;
            while ((float)var2 < var0 * 16.0f) {
                float var3 = this.random.nextFloat() * ((float)Math.PI * 2);
                float var4 = this.random.nextFloat() * 0.5f + 0.5f;
                float var5 = MathHelper.sin(var3) * var1 * var4;
                float var6 = MathHelper.cos(var3) * var1 * var4;
                this.level().addParticle(this.getParticleType(), this.getX() + (double)var5, this.getY(), this.getZ() + (double)var6, 0.0, 0.0, 0.0);
                ++var2;
            }
            this.playSound(this.getSquishSound(), this.getSoundVolume(), ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) / 0.8f);
            this.targetSquish = -0.5f;
        } else if (!this.onGround() && this.wasOnGround) {
            this.targetSquish = 1.0f;
        }
        this.wasOnGround = this.onGround();
        this.decreaseSquish();
    }

    protected void decreaseSquish() {
        this.targetSquish *= 0.6f;
    }

    protected int getJumpDelay() {
        return this.random.nextInt(20) + 10;
    }

    @Override
    public void refreshDimensions() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.refreshDimensions();
        this.setPos(var0, var2, var4);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (ID_SIZE.equals(var0)) {
            this.refreshDimensions();
            this.setYRot(this.yHeadRot);
            this.yBodyRot = this.yHeadRot;
            if (this.isInWater() && this.random.nextInt(20) == 0) {
                this.doWaterSplashEffect();
            }
        }
        super.onSyncedDataUpdated(var0);
    }

    public EntityTypes<? extends EntitySlime> getType() {
        return super.getType();
    }

    @Override
    public void remove(Entity.RemovalReason var0) {
        int var1 = this.getSize();
        if (!this.level().isClientSide && var1 > 1 && this.isDeadOrDying()) {
            float var2 = this.getDimensions(this.getPose()).width();
            float var32 = var2 / 2.0f;
            int var4 = var1 / 2;
            int var5 = 2 + this.random.nextInt(3);
            ScoreboardTeam var6 = this.getTeam();
            for (int var7 = 0; var7 < var5; ++var7) {
                float var8 = ((float)(var7 % 2) - 0.5f) * var32;
                float var9 = ((float)(var7 / 2) - 0.5f) * var32;
                this.convertTo(this.getType(), new ConversionParams(ConversionType.SPLIT_ON_DEATH, false, false, var6), EntitySpawnReason.TRIGGERED, var3 -> {
                    var3.setSize(var4, true);
                    var3.snapTo(this.getX() + (double)var8, this.getY() + 0.5, this.getZ() + (double)var9, this.random.nextFloat() * 360.0f, 0.0f);
                });
            }
        }
        super.remove(var0);
    }

    @Override
    public void push(Entity var0) {
        super.push(var0);
        if (var0 instanceof EntityIronGolem && this.isDealsDamage()) {
            this.dealDamage((EntityLiving)var0);
        }
    }

    @Override
    public void playerTouch(EntityHuman var0) {
        if (this.isDealsDamage()) {
            this.dealDamage(var0);
        }
    }

    protected void dealDamage(EntityLiving var0) {
        World world = this.level();
        if (world instanceof WorldServer) {
            DamageSource var2;
            WorldServer var1 = (WorldServer)world;
            if (this.isAlive() && this.isWithinMeleeAttackRange(var0) && this.hasLineOfSight(var0) && var0.hurtServer(var1, var2 = this.damageSources().mobAttack(this), this.getAttackDamage())) {
                this.playSound(SoundEffects.SLIME_ATTACK, 1.0f, (this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f);
                EnchantmentManager.doPostAttackEffects(var1, var0, var2);
            }
        }
    }

    @Override
    protected Vec3D getPassengerAttachmentPoint(Entity var0, EntitySize var1, float var2) {
        return new Vec3D(0.0, (double)var1.height() - 0.015625 * (double)this.getSize() * (double)var2, 0.0);
    }

    protected boolean isDealsDamage() {
        return !this.isTiny() && this.isEffectiveAi();
    }

    protected float getAttackDamage() {
        return (float)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE);
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isTiny()) {
            return SoundEffects.SLIME_HURT_SMALL;
        }
        return SoundEffects.SLIME_HURT;
    }

    @Override
    protected SoundEffect getDeathSound() {
        if (this.isTiny()) {
            return SoundEffects.SLIME_DEATH_SMALL;
        }
        return SoundEffects.SLIME_DEATH;
    }

    protected SoundEffect getSquishSound() {
        if (this.isTiny()) {
            return SoundEffects.SLIME_SQUISH_SMALL;
        }
        return SoundEffects.SLIME_SQUISH;
    }

    public static boolean checkSlimeSpawnRules(EntityTypes<EntitySlime> var0, GeneratorAccess var1, EntitySpawnReason var2, BlockPosition var3, RandomSource var4) {
        if (var1.getDifficulty() != EnumDifficulty.PEACEFUL) {
            boolean var6;
            if (EntitySpawnReason.isSpawner(var2)) {
                return EntitySlime.checkMobSpawnRules(var0, var1, var2, var3, var4);
            }
            if (var1.getBiome(var3).is(BiomeTags.ALLOWS_SURFACE_SLIME_SPAWNS) && var3.getY() > 50 && var3.getY() < 70 && var4.nextFloat() < 0.5f && var4.nextFloat() < var1.getMoonBrightness() && var1.getMaxLocalRawBrightness(var3) <= var4.nextInt(8)) {
                return EntitySlime.checkMobSpawnRules(var0, var1, var2, var3, var4);
            }
            if (!(var1 instanceof GeneratorAccessSeed)) {
                return false;
            }
            ChunkCoordIntPair var5 = new ChunkCoordIntPair(var3);
            boolean bl = var6 = SeededRandom.seedSlimeChunk(var5.x, var5.z, ((GeneratorAccessSeed)var1).getSeed(), 987234911L).nextInt(10) == 0;
            if (var4.nextInt(10) == 0 && var6 && var3.getY() < 40) {
                return EntitySlime.checkMobSpawnRules(var0, var1, var2, var3, var4);
            }
        }
        return false;
    }

    @Override
    protected float getSoundVolume() {
        return 0.4f * (float)this.getSize();
    }

    @Override
    public int getMaxHeadXRot() {
        return 0;
    }

    protected boolean doPlayJumpSound() {
        return this.getSize() > 0;
    }

    @Override
    public void jumpFromGround() {
        Vec3D var0 = this.getDeltaMovement();
        this.setDeltaMovement(var0.x, this.getJumpPower(), var0.z);
        this.hasImpulse = true;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EntitySpawnReason var2, @Nullable GroupDataEntity var3) {
        RandomSource var4 = var0.getRandom();
        int var5 = var4.nextInt(3);
        if (var5 < 2 && var4.nextFloat() < 0.5f * var1.getSpecialMultiplier()) {
            ++var5;
        }
        int var6 = 1 << var5;
        this.setSize(var6, true);
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    float getSoundPitch() {
        float var0 = this.isTiny() ? 1.4f : 0.8f;
        return ((this.random.nextFloat() - this.random.nextFloat()) * 0.2f + 1.0f) * var0;
    }

    protected SoundEffect getJumpSound() {
        return this.isTiny() ? SoundEffects.SLIME_JUMP_SMALL : SoundEffects.SLIME_JUMP;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return super.getDefaultDimensions(var0).scale(this.getSize());
    }

    static class ControllerMoveSlime
    extends ControllerMove {
        private float yRot;
        private int jumpDelay;
        private final EntitySlime slime;
        private boolean isAggressive;

        public ControllerMoveSlime(EntitySlime var0) {
            super(var0);
            this.slime = var0;
            this.yRot = 180.0f * var0.getYRot() / (float)Math.PI;
        }

        public void setDirection(float var0, boolean var1) {
            this.yRot = var0;
            this.isAggressive = var1;
        }

        public void setWantedMovement(double var0) {
            this.speedModifier = var0;
            this.operation = ControllerMove.Operation.MOVE_TO;
        }

        @Override
        public void tick() {
            this.mob.setYRot(this.rotlerp(this.mob.getYRot(), this.yRot, 90.0f));
            this.mob.yHeadRot = this.mob.getYRot();
            this.mob.yBodyRot = this.mob.getYRot();
            if (this.operation != ControllerMove.Operation.MOVE_TO) {
                this.mob.setZza(0.0f);
                return;
            }
            this.operation = ControllerMove.Operation.WAIT;
            if (this.mob.onGround()) {
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(GenericAttributes.MOVEMENT_SPEED)));
                if (this.jumpDelay-- <= 0) {
                    this.jumpDelay = this.slime.getJumpDelay();
                    if (this.isAggressive) {
                        this.jumpDelay /= 3;
                    }
                    this.slime.getJumpControl().jump();
                    if (this.slime.doPlayJumpSound()) {
                        this.slime.playSound(this.slime.getJumpSound(), this.slime.getSoundVolume(), this.slime.getSoundPitch());
                    }
                } else {
                    this.slime.xxa = 0.0f;
                    this.slime.zza = 0.0f;
                    this.mob.setSpeed(0.0f);
                }
            } else {
                this.mob.setSpeed((float)(this.speedModifier * this.mob.getAttributeValue(GenericAttributes.MOVEMENT_SPEED)));
            }
        }
    }

    static class PathfinderGoalSlimeRandomJump
    extends PathfinderGoal {
        private final EntitySlime slime;

        public PathfinderGoalSlimeRandomJump(EntitySlime var0) {
            this.slime = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
            var0.getNavigation().setCanFloat(true);
        }

        @Override
        public boolean canUse() {
            return (this.slime.isInWater() || this.slime.isInLava()) && this.slime.getMoveControl() instanceof ControllerMoveSlime;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            ControllerMove controllerMove;
            if (this.slime.getRandom().nextFloat() < 0.8f) {
                this.slime.getJumpControl().jump();
            }
            if ((controllerMove = this.slime.getMoveControl()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime var0 = (ControllerMoveSlime)controllerMove;
                var0.setWantedMovement(1.2);
            }
        }
    }

    static class PathfinderGoalSlimeNearestPlayer
    extends PathfinderGoal {
        private final EntitySlime slime;
        private int growTiredTimer;

        public PathfinderGoalSlimeNearestPlayer(EntitySlime var0) {
            this.slime = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = this.slime.getTarget();
            if (var0 == null) {
                return false;
            }
            if (!this.slime.canAttack(var0)) {
                return false;
            }
            return this.slime.getMoveControl() instanceof ControllerMoveSlime;
        }

        @Override
        public void start() {
            this.growTiredTimer = PathfinderGoalSlimeNearestPlayer.reducedTickDelay(300);
            super.start();
        }

        @Override
        public boolean canContinueToUse() {
            EntityLiving var0 = this.slime.getTarget();
            if (var0 == null) {
                return false;
            }
            if (!this.slime.canAttack(var0)) {
                return false;
            }
            return --this.growTiredTimer > 0;
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            ControllerMove controllerMove;
            EntityLiving var0 = this.slime.getTarget();
            if (var0 != null) {
                this.slime.lookAt(var0, 10.0f, 10.0f);
            }
            if ((controllerMove = this.slime.getMoveControl()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime var1 = (ControllerMoveSlime)controllerMove;
                var1.setDirection(this.slime.getYRot(), this.slime.isDealsDamage());
            }
        }
    }

    static class PathfinderGoalSlimeRandomDirection
    extends PathfinderGoal {
        private final EntitySlime slime;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public PathfinderGoalSlimeRandomDirection(EntitySlime var0) {
            this.slime = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            return this.slime.getTarget() == null && (this.slime.onGround() || this.slime.isInWater() || this.slime.isInLava() || this.slime.hasEffect(MobEffects.LEVITATION)) && this.slime.getMoveControl() instanceof ControllerMoveSlime;
        }

        @Override
        public void tick() {
            ControllerMove controllerMove;
            if (--this.nextRandomizeTime <= 0) {
                this.nextRandomizeTime = this.adjustedTickDelay(40 + this.slime.getRandom().nextInt(60));
                this.chosenDegrees = this.slime.getRandom().nextInt(360);
            }
            if ((controllerMove = this.slime.getMoveControl()) instanceof ControllerMoveSlime) {
                ControllerMoveSlime var0 = (ControllerMoveSlime)controllerMove;
                var0.setDirection(this.chosenDegrees, false);
            }
        }
    }

    static class PathfinderGoalSlimeIdle
    extends PathfinderGoal {
        private final EntitySlime slime;

        public PathfinderGoalSlimeIdle(EntitySlime var0) {
            this.slime = var0;
            this.setFlags(EnumSet.of(PathfinderGoal.Type.JUMP, PathfinderGoal.Type.MOVE));
        }

        @Override
        public boolean canUse() {
            return !this.slime.isPassenger();
        }

        @Override
        public void tick() {
            ControllerMove controllerMove = this.slime.getMoveControl();
            if (controllerMove instanceof ControllerMoveSlime) {
                ControllerMoveSlime var0 = (ControllerMoveSlime)controllerMove;
                var0.setWantedMovement(1.0);
            }
        }
    }
}

