/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.decoration;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Vector3f;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLightning;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMainHand;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.EnumSkyBlock;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;

public class EntityArmorStand
extends EntityLiving {
    public static final int WOBBLE_TIME = 5;
    private static final boolean ENABLE_ARMS = true;
    public static final Vector3f DEFAULT_HEAD_POSE = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f DEFAULT_BODY_POSE = new Vector3f(0.0f, 0.0f, 0.0f);
    public static final Vector3f DEFAULT_LEFT_ARM_POSE = new Vector3f(-10.0f, 0.0f, -10.0f);
    public static final Vector3f DEFAULT_RIGHT_ARM_POSE = new Vector3f(-15.0f, 0.0f, 10.0f);
    public static final Vector3f DEFAULT_LEFT_LEG_POSE = new Vector3f(-1.0f, 0.0f, -1.0f);
    public static final Vector3f DEFAULT_RIGHT_LEG_POSE = new Vector3f(1.0f, 0.0f, 1.0f);
    private static final EntitySize MARKER_DIMENSIONS = EntitySize.fixed(0.0f, 0.0f);
    private static final EntitySize BABY_DIMENSIONS = EntityTypes.ARMOR_STAND.getDimensions().scale(0.5f).withEyeHeight(0.9875f);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final DataWatcherObject<Byte> DATA_CLIENT_FLAGS = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Vector3f> DATA_HEAD_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_BODY_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_LEFT_ARM_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_RIGHT_ARM_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_LEFT_LEG_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    public static final DataWatcherObject<Vector3f> DATA_RIGHT_LEG_POSE = DataWatcher.defineId(EntityArmorStand.class, DataWatcherRegistry.ROTATIONS);
    private static final Predicate<Entity> RIDABLE_MINECARTS = var0 -> {
        EntityMinecartAbstract var1;
        return var0 instanceof EntityMinecartAbstract && (var1 = (EntityMinecartAbstract)var0).isRideable();
    };
    private static final boolean DEFAULT_INVISIBLE = false;
    private static final int DEFAULT_DISABLED_SLOTS = 0;
    private static final boolean DEFAULT_SMALL = false;
    private static final boolean DEFAULT_SHOW_ARMS = false;
    private static final boolean DEFAULT_NO_BASE_PLATE = false;
    private static final boolean DEFAULT_MARKER = false;
    private boolean invisible = false;
    public long lastHit;
    public int disabledSlots = 0;

    public EntityArmorStand(EntityTypes<? extends EntityArmorStand> var0, World var1) {
        super((EntityTypes<? extends EntityLiving>)var0, var1);
    }

    public EntityArmorStand(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityArmorStand>)EntityTypes.ARMOR_STAND, var0);
        this.setPos(var1, var3, var5);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityArmorStand.createLivingAttributes().add(GenericAttributes.STEP_HEIGHT, 0.0);
    }

    @Override
    public void refreshDimensions() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.refreshDimensions();
        this.setPos(var0, var2, var4);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.isNoGravity();
    }

    @Override
    public boolean isEffectiveAi() {
        return super.isEffectiveAi() && this.hasPhysics();
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_CLIENT_FLAGS, (byte)0);
        var0.define(DATA_HEAD_POSE, DEFAULT_HEAD_POSE);
        var0.define(DATA_BODY_POSE, DEFAULT_BODY_POSE);
        var0.define(DATA_LEFT_ARM_POSE, DEFAULT_LEFT_ARM_POSE);
        var0.define(DATA_RIGHT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE);
        var0.define(DATA_LEFT_LEG_POSE, DEFAULT_LEFT_LEG_POSE);
        var0.define(DATA_RIGHT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
    }

    @Override
    public boolean canUseSlot(EnumItemSlot var0) {
        return var0 != EnumItemSlot.BODY && var0 != EnumItemSlot.SADDLE && !this.isDisabled(var0);
    }

    @Override
    protected void addAdditionalSaveData(ValueOutput var0) {
        super.addAdditionalSaveData(var0);
        var0.putBoolean("Invisible", this.isInvisible());
        var0.putBoolean("Small", this.isSmall());
        var0.putBoolean("ShowArms", this.showArms());
        var0.putInt("DisabledSlots", this.disabledSlots);
        var0.putBoolean("NoBasePlate", !this.showBasePlate());
        if (this.isMarker()) {
            var0.putBoolean("Marker", this.isMarker());
        }
        var0.store("Pose", a.CODEC, this.getArmorStandPose());
    }

    @Override
    protected void readAdditionalSaveData(ValueInput var0) {
        super.readAdditionalSaveData(var0);
        this.setInvisible(var0.getBooleanOr("Invisible", false));
        this.setSmall(var0.getBooleanOr("Small", false));
        this.setShowArms(var0.getBooleanOr("ShowArms", false));
        this.disabledSlots = var0.getIntOr("DisabledSlots", 0);
        this.setNoBasePlate(var0.getBooleanOr("NoBasePlate", false));
        this.setMarker(var0.getBooleanOr("Marker", false));
        this.noPhysics = !this.hasPhysics();
        var0.read("Pose", a.CODEC).ifPresent(this::setArmorStandPose);
    }

    @Override
    public boolean isPushable() {
        return false;
    }

    @Override
    protected void doPush(Entity var0) {
    }

    @Override
    protected void pushEntities() {
        List<Entity> var0 = this.level().getEntities(this, this.getBoundingBox(), RIDABLE_MINECARTS);
        for (Entity var2 : var0) {
            if (!(this.distanceToSqr(var2) <= 0.2)) continue;
            var2.push(this);
        }
    }

    @Override
    public EnumInteractionResult interactAt(EntityHuman var0, Vec3D var1, EnumHand var2) {
        ItemStack var3 = var0.getItemInHand(var2);
        if (this.isMarker() || var3.is(Items.NAME_TAG)) {
            return EnumInteractionResult.PASS;
        }
        if (var0.isSpectator()) {
            return EnumInteractionResult.SUCCESS;
        }
        if (var0.level().isClientSide) {
            return EnumInteractionResult.SUCCESS_SERVER;
        }
        EnumItemSlot var4 = this.getEquipmentSlotForItem(var3);
        if (var3.isEmpty()) {
            EnumItemSlot var6;
            EnumItemSlot var5 = this.getClickedSlot(var1);
            EnumItemSlot enumItemSlot = var6 = this.isDisabled(var5) ? var4 : var5;
            if (this.hasItemInSlot(var6) && this.swapItem(var0, var6, var3, var2)) {
                return EnumInteractionResult.SUCCESS_SERVER;
            }
        } else {
            if (this.isDisabled(var4)) {
                return EnumInteractionResult.FAIL;
            }
            if (var4.getType() == EnumItemSlot.Function.HAND && !this.showArms()) {
                return EnumInteractionResult.FAIL;
            }
            if (this.swapItem(var0, var4, var3, var2)) {
                return EnumInteractionResult.SUCCESS_SERVER;
            }
        }
        return EnumInteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EnumItemSlot getClickedSlot(Vec3D var0) {
        EnumItemSlot var1 = EnumItemSlot.MAINHAND;
        boolean var2 = this.isSmall();
        double var3 = var0.y / (double)(this.getScale() * this.getAgeScale());
        EnumItemSlot var5 = EnumItemSlot.FEET;
        if (var3 >= 0.1) {
            double d2 = var2 ? 0.8 : 0.45;
            if (var3 < 0.1 + d2 && this.hasItemInSlot(var5)) {
                return EnumItemSlot.FEET;
            }
        }
        double d3 = var2 ? 0.3 : 0.0;
        if (var3 >= 0.9 + d3) {
            double d4 = var2 ? 1.0 : 0.7;
            if (var3 < 0.9 + d4 && this.hasItemInSlot(EnumItemSlot.CHEST)) {
                return EnumItemSlot.CHEST;
            }
        }
        if (var3 >= 0.4) {
            double d5 = var2 ? 1.0 : 0.8;
            if (var3 < 0.4 + d5 && this.hasItemInSlot(EnumItemSlot.LEGS)) {
                return EnumItemSlot.LEGS;
            }
        }
        if (var3 >= 1.6 && this.hasItemInSlot(EnumItemSlot.HEAD)) {
            return EnumItemSlot.HEAD;
        }
        if (this.hasItemInSlot(EnumItemSlot.MAINHAND)) return var1;
        if (!this.hasItemInSlot(EnumItemSlot.OFFHAND)) return var1;
        return EnumItemSlot.OFFHAND;
    }

    private boolean isDisabled(EnumItemSlot var0) {
        return (this.disabledSlots & 1 << var0.getFilterBit(0)) != 0 || var0.getType() == EnumItemSlot.Function.HAND && !this.showArms();
    }

    private boolean swapItem(EntityHuman var0, EnumItemSlot var1, ItemStack var2, EnumHand var3) {
        ItemStack var4 = this.getItemBySlot(var1);
        if (!var4.isEmpty() && (this.disabledSlots & 1 << var1.getFilterBit(8)) != 0) {
            return false;
        }
        if (var4.isEmpty() && (this.disabledSlots & 1 << var1.getFilterBit(16)) != 0) {
            return false;
        }
        if (var0.hasInfiniteMaterials() && var4.isEmpty() && !var2.isEmpty()) {
            this.setItemSlot(var1, var2.copyWithCount(1));
            return true;
        }
        if (!var2.isEmpty() && var2.getCount() > 1) {
            if (!var4.isEmpty()) {
                return false;
            }
            this.setItemSlot(var1, var2.split(1));
            return true;
        }
        this.setItemSlot(var1, var2);
        var0.setItemInHand(var3, var4);
        return true;
    }

    @Override
    public boolean hurtServer(WorldServer var0, DamageSource var1, float var2) {
        if (this.isRemoved()) {
            return false;
        }
        if (!var0.getGameRules().getBoolean(GameRules.RULE_MOBGRIEFING) && var1.getEntity() instanceof EntityInsentient) {
            return false;
        }
        if (var1.is(DamageTypeTags.BYPASSES_INVULNERABILITY)) {
            this.kill(var0);
            return false;
        }
        if (this.isInvulnerableTo(var0, var1) || this.invisible || this.isMarker()) {
            return false;
        }
        if (var1.is(DamageTypeTags.IS_EXPLOSION)) {
            this.brokenByAnything(var0, var1);
            this.kill(var0);
            return false;
        }
        if (var1.is(DamageTypeTags.IGNITES_ARMOR_STANDS)) {
            if (this.isOnFire()) {
                this.causeDamage(var0, var1, 0.15f);
            } else {
                this.igniteForSeconds(5.0f);
            }
            return false;
        }
        if (var1.is(DamageTypeTags.BURNS_ARMOR_STANDS) && this.getHealth() > 0.5f) {
            this.causeDamage(var0, var1, 4.0f);
            return false;
        }
        boolean var3 = var1.is(DamageTypeTags.CAN_BREAK_ARMOR_STAND);
        boolean var4 = var1.is(DamageTypeTags.ALWAYS_KILLS_ARMOR_STANDS);
        if (!var3 && !var4) {
            return false;
        }
        Entity entity = var1.getEntity();
        if (entity instanceof EntityHuman) {
            EntityHuman var5 = (EntityHuman)entity;
            if (!var5.getAbilities().mayBuild) {
                return false;
            }
        }
        if (var1.isCreativePlayer()) {
            this.playBrokenSound();
            this.showBreakingParticles();
            this.kill(var0);
            return true;
        }
        long var5 = var0.getGameTime();
        if (var5 - this.lastHit <= 5L || var4) {
            this.brokenByPlayer(var0, var1);
            this.showBreakingParticles();
            this.kill(var0);
        } else {
            var0.broadcastEntityEvent(this, (byte)32);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, var1.getEntity());
            this.lastHit = var5;
        }
        return true;
    }

    @Override
    public void handleEntityEvent(byte var0) {
        if (var0 == 32) {
            if (this.level().isClientSide) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.ARMOR_STAND_HIT, this.getSoundSource(), 0.3f, 1.0f, false);
                this.lastHit = this.level().getGameTime();
            }
        } else {
            super.handleEntityEvent(var0);
        }
    }

    @Override
    public boolean shouldRenderAtSqrDistance(double var0) {
        double var2 = this.getBoundingBox().getSize() * 4.0;
        if (Double.isNaN(var2) || var2 == 0.0) {
            var2 = 4.0;
        }
        return var0 < (var2 *= 64.0) * var2;
    }

    private void showBreakingParticles() {
        if (this.level() instanceof WorldServer) {
            ((WorldServer)this.level()).sendParticles(new ParticleParamBlock(Particles.BLOCK, Blocks.OAK_PLANKS.defaultBlockState()), this.getX(), this.getY(0.6666666666666666), this.getZ(), 10, this.getBbWidth() / 4.0f, this.getBbHeight() / 4.0f, this.getBbWidth() / 4.0f, 0.05);
        }
    }

    private void causeDamage(WorldServer var0, DamageSource var1, float var2) {
        float var3 = this.getHealth();
        if ((var3 -= var2) <= 0.5f) {
            this.brokenByAnything(var0, var1);
            this.kill(var0);
        } else {
            this.setHealth(var3);
            this.gameEvent(GameEvent.ENTITY_DAMAGE, var1.getEntity());
        }
    }

    private void brokenByPlayer(WorldServer var0, DamageSource var1) {
        ItemStack var2 = new ItemStack(Items.ARMOR_STAND);
        var2.set(DataComponents.CUSTOM_NAME, this.getCustomName());
        Block.popResource(this.level(), this.blockPosition(), var2);
        this.brokenByAnything(var0, var1);
    }

    private void brokenByAnything(WorldServer var0, DamageSource var1) {
        this.playBrokenSound();
        this.dropAllDeathLoot(var0, var1);
        for (EnumItemSlot var3 : EnumItemSlot.VALUES) {
            ItemStack var4 = this.equipment.set(var3, ItemStack.EMPTY);
            if (var4.isEmpty()) continue;
            Block.popResource(this.level(), this.blockPosition().above(), var4);
        }
    }

    private void playBrokenSound() {
        this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEffects.ARMOR_STAND_BREAK, this.getSoundSource(), 1.0f, 1.0f);
    }

    @Override
    protected void tickHeadTurn(float var0) {
        this.yBodyRotO = this.yRotO;
        this.yBodyRot = this.getYRot();
    }

    @Override
    public void travel(Vec3D var0) {
        if (!this.hasPhysics()) {
            return;
        }
        super.travel(var0);
    }

    @Override
    public void setYBodyRot(float var0) {
        this.yBodyRotO = this.yRotO = var0;
        this.yHeadRotO = this.yHeadRot = var0;
    }

    @Override
    public void setYHeadRot(float var0) {
        this.yBodyRotO = this.yRotO = var0;
        this.yHeadRotO = this.yHeadRot = var0;
    }

    @Override
    protected void updateInvisibilityStatus() {
        this.setInvisible(this.invisible);
    }

    @Override
    public void setInvisible(boolean var0) {
        this.invisible = var0;
        super.setInvisible(var0);
    }

    @Override
    public boolean isBaby() {
        return this.isSmall();
    }

    @Override
    public void kill(WorldServer var0) {
        this.remove(Entity.RemovalReason.KILLED);
        this.gameEvent(GameEvent.ENTITY_DIE);
    }

    @Override
    public boolean ignoreExplosion(Explosion var0) {
        if (var0.shouldAffectBlocklikeEntities()) {
            return this.isInvisible();
        }
        return true;
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        if (this.isMarker()) {
            return EnumPistonReaction.IGNORE;
        }
        return super.getPistonPushReaction();
    }

    @Override
    public boolean isIgnoringBlockTriggers() {
        return this.isMarker();
    }

    public void setSmall(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 1, var0));
    }

    public boolean isSmall() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public void setShowArms(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 4, var0));
    }

    public boolean showArms() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    public void setNoBasePlate(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 8, var0));
    }

    public boolean showBasePlate() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 8) == 0;
    }

    public void setMarker(boolean var0) {
        this.entityData.set(DATA_CLIENT_FLAGS, this.setBit(this.entityData.get(DATA_CLIENT_FLAGS), 16, var0));
    }

    public boolean isMarker() {
        return (this.entityData.get(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    private byte setBit(byte var0, int var1, boolean var2) {
        var0 = var2 ? (byte)(var0 | var1) : (byte)(var0 & ~var1);
        return var0;
    }

    public void setHeadPose(Vector3f var0) {
        this.entityData.set(DATA_HEAD_POSE, var0);
    }

    public void setBodyPose(Vector3f var0) {
        this.entityData.set(DATA_BODY_POSE, var0);
    }

    public void setLeftArmPose(Vector3f var0) {
        this.entityData.set(DATA_LEFT_ARM_POSE, var0);
    }

    public void setRightArmPose(Vector3f var0) {
        this.entityData.set(DATA_RIGHT_ARM_POSE, var0);
    }

    public void setLeftLegPose(Vector3f var0) {
        this.entityData.set(DATA_LEFT_LEG_POSE, var0);
    }

    public void setRightLegPose(Vector3f var0) {
        this.entityData.set(DATA_RIGHT_LEG_POSE, var0);
    }

    public Vector3f getHeadPose() {
        return this.entityData.get(DATA_HEAD_POSE);
    }

    public Vector3f getBodyPose() {
        return this.entityData.get(DATA_BODY_POSE);
    }

    public Vector3f getLeftArmPose() {
        return this.entityData.get(DATA_LEFT_ARM_POSE);
    }

    public Vector3f getRightArmPose() {
        return this.entityData.get(DATA_RIGHT_ARM_POSE);
    }

    public Vector3f getLeftLegPose() {
        return this.entityData.get(DATA_LEFT_LEG_POSE);
    }

    public Vector3f getRightLegPose() {
        return this.entityData.get(DATA_RIGHT_LEG_POSE);
    }

    @Override
    public boolean isPickable() {
        return super.isPickable() && !this.isMarker();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean skipAttackInteraction(Entity var0) {
        if (!(var0 instanceof EntityHuman)) return false;
        EntityHuman var1 = (EntityHuman)var0;
        if (this.level().mayInteract(var1, this.blockPosition())) return false;
        return true;
    }

    @Override
    public EnumMainHand getMainArm() {
        return EnumMainHand.RIGHT;
    }

    @Override
    public EntityLiving.a getFallSounds() {
        return new EntityLiving.a(SoundEffects.ARMOR_STAND_FALL, SoundEffects.ARMOR_STAND_FALL);
    }

    @Override
    @Nullable
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.ARMOR_STAND_HIT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.ARMOR_STAND_BREAK;
    }

    @Override
    public void thunderHit(WorldServer var0, EntityLightning var1) {
    }

    @Override
    public boolean isAffectedByPotions() {
        return false;
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_CLIENT_FLAGS.equals(var0)) {
            this.refreshDimensions();
            this.blocksBuilding = !this.isMarker();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public boolean attackable() {
        return false;
    }

    @Override
    public EntitySize getDefaultDimensions(EntityPose var0) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntitySize getDimensionsMarker(boolean var0) {
        if (var0) {
            return MARKER_DIMENSIONS;
        }
        return this.isBaby() ? BABY_DIMENSIONS : this.getType().getDimensions();
    }

    @Override
    public Vec3D getLightProbePosition(float var0) {
        if (this.isMarker()) {
            AxisAlignedBB var1 = this.getDimensionsMarker(false).makeBoundingBox(this.position());
            BlockPosition var2 = this.blockPosition();
            int var3 = Integer.MIN_VALUE;
            for (BlockPosition var5 : BlockPosition.betweenClosed(BlockPosition.containing(var1.minX, var1.minY, var1.minZ), BlockPosition.containing(var1.maxX, var1.maxY, var1.maxZ))) {
                int var6 = Math.max(this.level().getBrightness(EnumSkyBlock.BLOCK, var5), this.level().getBrightness(EnumSkyBlock.SKY, var5));
                if (var6 == 15) {
                    return Vec3D.atCenterOf(var5);
                }
                if (var6 <= var3) continue;
                var3 = var6;
                var2 = var5.immutable();
            }
            return Vec3D.atCenterOf(var2);
        }
        return super.getLightProbePosition(var0);
    }

    @Override
    public ItemStack getPickResult() {
        return new ItemStack(Items.ARMOR_STAND);
    }

    @Override
    public boolean canBeSeenByAnyone() {
        return !this.isInvisible() && !this.isMarker();
    }

    public void setArmorStandPose(a var0) {
        this.setHeadPose(var0.head());
        this.setBodyPose(var0.body());
        this.setLeftArmPose(var0.leftArm());
        this.setRightArmPose(var0.rightArm());
        this.setLeftLegPose(var0.leftLeg());
        this.setRightLegPose(var0.rightLeg());
    }

    public a getArmorStandPose() {
        return new a(this.getHeadPose(), this.getBodyPose(), this.getLeftArmPose(), this.getRightArmPose(), this.getLeftLegPose(), this.getRightLegPose());
    }

    public record a(Vector3f head, Vector3f body, Vector3f leftArm, Vector3f rightArm, Vector3f leftLeg, Vector3f rightLeg) {
        public static final a DEFAULT = new a(DEFAULT_HEAD_POSE, DEFAULT_BODY_POSE, DEFAULT_LEFT_ARM_POSE, DEFAULT_RIGHT_ARM_POSE, DEFAULT_LEFT_LEG_POSE, DEFAULT_RIGHT_LEG_POSE);
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Vector3f.CODEC.optionalFieldOf("Head", (Object)DEFAULT_HEAD_POSE).forGetter(a::head), (App)Vector3f.CODEC.optionalFieldOf("Body", (Object)DEFAULT_BODY_POSE).forGetter(a::body), (App)Vector3f.CODEC.optionalFieldOf("LeftArm", (Object)DEFAULT_LEFT_ARM_POSE).forGetter(a::leftArm), (App)Vector3f.CODEC.optionalFieldOf("RightArm", (Object)DEFAULT_RIGHT_ARM_POSE).forGetter(a::rightArm), (App)Vector3f.CODEC.optionalFieldOf("LeftLeg", (Object)DEFAULT_LEFT_LEG_POSE).forGetter(a::leftLeg), (App)Vector3f.CODEC.optionalFieldOf("RightLeg", (Object)DEFAULT_RIGHT_LEG_POSE).forGetter(a::rightLeg)).apply((Applicative)var0, a::new));
    }
}

