/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon.phases;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.AbstractDragonControllerLanded;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.phys.Vec3D;

public class DragonControllerLandedFlame
extends AbstractDragonControllerLanded {
    private static final int FLAME_DURATION = 200;
    private static final int SITTING_FLAME_ATTACKS_COUNT = 4;
    private static final int WARMUP_TIME = 10;
    private int flameTicks;
    private int flameCount;
    @Nullable
    private EntityAreaEffectCloud flame;

    public DragonControllerLandedFlame(EntityEnderDragon var0) {
        super(var0);
    }

    @Override
    public void doClientTick() {
        ++this.flameTicks;
        if (this.flameTicks % 2 == 0 && this.flameTicks < 10) {
            Vec3D var0 = this.dragon.getHeadLookVector(1.0f).normalize();
            var0.yRot(-0.7853982f);
            double var1 = this.dragon.head.getX();
            double var3 = this.dragon.head.getY(0.5);
            double var5 = this.dragon.head.getZ();
            for (int var7 = 0; var7 < 8; ++var7) {
                double var8 = var1 + this.dragon.getRandom().nextGaussian() / 2.0;
                double var10 = var3 + this.dragon.getRandom().nextGaussian() / 2.0;
                double var12 = var5 + this.dragon.getRandom().nextGaussian() / 2.0;
                for (int var14 = 0; var14 < 6; ++var14) {
                    this.dragon.level().addParticle(Particles.DRAGON_BREATH, var8, var10, var12, -var0.x * (double)0.08f * (double)var14, -var0.y * (double)0.6f, -var0.z * (double)0.08f * (double)var14);
                }
                var0.yRot(0.19634955f);
            }
        }
    }

    @Override
    public void doServerTick(WorldServer var0) {
        ++this.flameTicks;
        if (this.flameTicks >= 200) {
            if (this.flameCount >= 4) {
                this.dragon.getPhaseManager().setPhase(DragonControllerPhase.TAKEOFF);
            } else {
                this.dragon.getPhaseManager().setPhase(DragonControllerPhase.SITTING_SCANNING);
            }
        } else if (this.flameTicks == 10) {
            double var7;
            Vec3D var1 = new Vec3D(this.dragon.head.getX() - this.dragon.getX(), 0.0, this.dragon.head.getZ() - this.dragon.getZ()).normalize();
            float var2 = 5.0f;
            double var3 = this.dragon.head.getX() + var1.x * 5.0 / 2.0;
            double var5 = this.dragon.head.getZ() + var1.z * 5.0 / 2.0;
            double var9 = var7 = this.dragon.head.getY(0.5);
            BlockPosition.MutableBlockPosition var11 = new BlockPosition.MutableBlockPosition(var3, var9, var5);
            while (var0.isEmptyBlock(var11)) {
                if ((var9 -= 1.0) < 0.0) {
                    var9 = var7;
                    break;
                }
                var11.set(var3, var9, var5);
            }
            var9 = MathHelper.floor(var9) + 1;
            this.flame = new EntityAreaEffectCloud(var0, var3, var9, var5);
            this.flame.setOwner(this.dragon);
            this.flame.setRadius(5.0f);
            this.flame.setDuration(200);
            this.flame.setCustomParticle(Particles.DRAGON_BREATH);
            this.flame.setPotionDurationScale(0.25f);
            this.flame.addEffect(new MobEffect(MobEffects.INSTANT_DAMAGE));
            var0.addFreshEntity(this.flame);
        }
    }

    @Override
    public void begin() {
        this.flameTicks = 0;
        ++this.flameCount;
    }

    @Override
    public void end() {
        if (this.flame != null) {
            this.flame.discard();
            this.flame = null;
        }
    }

    public DragonControllerPhase<DragonControllerLandedFlame> getPhase() {
        return DragonControllerPhase.SITTING_FLAMING;
    }

    public void resetFlameCount() {
        this.flameCount = 0;
    }
}

