/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.PigVariant;
import net.minecraft.world.entity.animal.TemperatureVariants;
import net.minecraft.world.entity.variant.BiomeCheck;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.entity.variant.SpawnPrioritySelectors;
import net.minecraft.world.level.biome.BiomeBase;

public class PigVariants {
    public static final ResourceKey<PigVariant> TEMPERATE = PigVariants.createKey(TemperatureVariants.TEMPERATE);
    public static final ResourceKey<PigVariant> WARM = PigVariants.createKey(TemperatureVariants.WARM);
    public static final ResourceKey<PigVariant> COLD = PigVariants.createKey(TemperatureVariants.COLD);
    public static final ResourceKey<PigVariant> DEFAULT = TEMPERATE;

    private static ResourceKey<PigVariant> createKey(MinecraftKey var0) {
        return ResourceKey.create(Registries.PIG_VARIANT, var0);
    }

    public static void bootstrap(BootstrapContext<PigVariant> var0) {
        PigVariants.register(var0, TEMPERATE, PigVariant.a.NORMAL, "temperate_pig", SpawnPrioritySelectors.fallback(0));
        PigVariants.register(var0, WARM, PigVariant.a.NORMAL, "warm_pig", BiomeTags.SPAWNS_WARM_VARIANT_FARM_ANIMALS);
        PigVariants.register(var0, COLD, PigVariant.a.COLD, "cold_pig", BiomeTags.SPAWNS_COLD_VARIANT_FARM_ANIMALS);
    }

    private static void register(BootstrapContext<PigVariant> var0, ResourceKey<PigVariant> var1, PigVariant.a var2, String var3, TagKey<BiomeBase> var4) {
        HolderSet.Named<BiomeBase> var5 = var0.lookup(Registries.BIOME).getOrThrow(var4);
        PigVariants.register(var0, var1, var2, var3, SpawnPrioritySelectors.single(new BiomeCheck(var5), 1));
    }

    private static void register(BootstrapContext<PigVariant> var0, ResourceKey<PigVariant> var1, PigVariant.a var2, String var3, SpawnPrioritySelectors var4) {
        MinecraftKey var5 = MinecraftKey.withDefaultNamespace("entity/pig/" + var3);
        var0.register(var1, new PigVariant(new ModelAndTexture<PigVariant.a>(var2, var5), var4));
    }
}

