/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal.target;

import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalTarget;
import net.minecraft.world.entity.ai.targeting.PathfinderTargetCondition;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.phys.AxisAlignedBB;

public class PathfinderGoalNearestAttackableTarget<T extends EntityLiving>
extends PathfinderGoalTarget {
    private static final int DEFAULT_RANDOM_INTERVAL = 10;
    protected final Class<T> targetType;
    protected final int randomInterval;
    @Nullable
    protected EntityLiving target;
    protected PathfinderTargetCondition targetConditions;

    public PathfinderGoalNearestAttackableTarget(EntityInsentient var0, Class<T> var1, boolean var2) {
        this(var0, var1, 10, var2, false, null);
    }

    public PathfinderGoalNearestAttackableTarget(EntityInsentient var0, Class<T> var1, boolean var2, PathfinderTargetCondition.a var3) {
        this(var0, var1, 10, var2, false, var3);
    }

    public PathfinderGoalNearestAttackableTarget(EntityInsentient var0, Class<T> var1, boolean var2, boolean var3) {
        this(var0, var1, 10, var2, var3, null);
    }

    public PathfinderGoalNearestAttackableTarget(EntityInsentient var0, Class<T> var1, int var2, boolean var3, boolean var4, @Nullable PathfinderTargetCondition.a var5) {
        super(var0, var3, var4);
        this.targetType = var1;
        this.randomInterval = PathfinderGoalNearestAttackableTarget.reducedTickDelay(var2);
        this.setFlags(EnumSet.of(PathfinderGoal.Type.TARGET));
        this.targetConditions = PathfinderTargetCondition.forCombat().range(this.getFollowDistance()).selector(var5);
    }

    @Override
    public boolean canUse() {
        if (this.randomInterval > 0 && this.mob.getRandom().nextInt(this.randomInterval) != 0) {
            return false;
        }
        this.findTarget();
        return this.target != null;
    }

    protected AxisAlignedBB getTargetSearchArea(double var0) {
        return this.mob.getBoundingBox().inflate(var0, var0, var0);
    }

    protected void findTarget() {
        WorldServer var02 = PathfinderGoalNearestAttackableTarget.getServerLevel(this.mob);
        this.target = this.targetType == EntityHuman.class || this.targetType == EntityPlayer.class ? var02.getNearestPlayer(this.getTargetConditions(), this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ()) : var02.getNearestEntity(this.mob.level().getEntitiesOfClass(this.targetType, this.getTargetSearchArea(this.getFollowDistance()), var0 -> true), this.getTargetConditions(), this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
    }

    @Override
    public void start() {
        this.mob.setTarget(this.target);
        super.start();
    }

    public void setTarget(@Nullable EntityLiving var0) {
        this.target = var0;
    }

    private PathfinderTargetCondition getTargetConditions() {
        return this.targetConditions.range(this.getFollowDistance());
    }
}

