/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.navigation.Navigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.util.PathfinderGoalUtil;

public class PathfinderGoalRestrictSun
extends PathfinderGoal {
    private final EntityCreature mob;

    public PathfinderGoalRestrictSun(EntityCreature var0) {
        this.mob = var0;
    }

    @Override
    public boolean canUse() {
        return this.mob.level().isBrightOutside() && this.mob.getItemBySlot(EnumItemSlot.HEAD).isEmpty() && PathfinderGoalUtil.hasGroundPathNavigation(this.mob);
    }

    @Override
    public void start() {
        NavigationAbstract navigationAbstract = this.mob.getNavigation();
        if (navigationAbstract instanceof Navigation) {
            Navigation var0 = (Navigation)navigationAbstract;
            var0.setAvoidSun(true);
        }
    }

    @Override
    public void stop() {
        NavigationAbstract navigationAbstract;
        if (PathfinderGoalUtil.hasGroundPathNavigation(this.mob) && (navigationAbstract = this.mob.getNavigation()) instanceof Navigation) {
            Navigation var0 = (Navigation)navigationAbstract;
            var0.setAvoidSun(false);
        }
    }
}

