/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.goal;

import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.animal.EntityPerchable;

public class PathfinderGoalPerch
extends PathfinderGoal {
    private final EntityPerchable entity;
    private boolean isSittingOnShoulder;

    public PathfinderGoalPerch(EntityPerchable var0) {
        this.entity = var0;
    }

    @Override
    public boolean canUse() {
        EntityLiving entityLiving = this.entity.getOwner();
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entityLiving;
            boolean var1 = !var0.isSpectator() && !var0.getAbilities().flying && !var0.isInWater() && !var0.isInPowderSnow;
            return !this.entity.isOrderedToSit() && var1 && this.entity.canSitOnShoulder();
        }
        return false;
    }

    @Override
    public boolean isInterruptable() {
        return !this.isSittingOnShoulder;
    }

    @Override
    public void start() {
        this.isSittingOnShoulder = false;
    }

    @Override
    public void tick() {
        if (this.isSittingOnShoulder || this.entity.isInSittingPose() || this.entity.isLeashed()) {
            return;
        }
        EntityLiving entityLiving = this.entity.getOwner();
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer var0 = (EntityPlayer)entityLiving;
            if (this.entity.getBoundingBox().intersects(var0.getBoundingBox())) {
                this.isSittingOnShoulder = this.entity.setEntityOnShoulder(var0);
            }
        }
    }
}

