/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Holder;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.village.poi.VillagePlaceType;
import net.minecraft.world.entity.npc.EntityVillager;
import net.minecraft.world.level.block.BlockBed;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;

public class BehaviorPositionValidate {
    private static final int MAX_DISTANCE = 16;

    public static BehaviorControl<EntityLiving> create(Predicate<Holder<VillagePlaceType>> var0, MemoryModuleType<GlobalPos> var1) {
        return BehaviorBuilder.create(var22 -> var22.group(var22.present(var1)).apply((Applicative)var22, var2 -> (var3, var4, var5) -> {
            GlobalPos var7 = (GlobalPos)var22.get(var2);
            BlockPosition var8 = var7.pos();
            if (var3.dimension() != var7.dimension() || !var8.closerToCenterThan(var4.position(), 16.0)) {
                return false;
            }
            WorldServer var9 = var3.getServer().getLevel(var7.dimension());
            if (var9 == null || !var9.getPoiManager().exists(var8, var0)) {
                var2.erase();
            } else if (BehaviorPositionValidate.bedIsOccupied(var9, var8, var4)) {
                var2.erase();
                if (!BehaviorPositionValidate.bedIsOccupiedByVillager(var9, var8)) {
                    var3.getPoiManager().release(var8);
                    PacketDebug.sendPoiTicketCountPacket(var3, var8);
                }
            }
            return true;
        }));
    }

    private static boolean bedIsOccupied(WorldServer var0, BlockPosition var1, EntityLiving var2) {
        IBlockData var3 = var0.getBlockState(var1);
        return var3.is(TagsBlock.BEDS) && var3.getValue(BlockBed.OCCUPIED) != false && !var2.isSleeping();
    }

    private static boolean bedIsOccupiedByVillager(WorldServer var0, BlockPosition var1) {
        List<EntityVillager> var2 = var0.getEntitiesOfClass(EntityVillager.class, new AxisAlignedBB(var1), EntityLiving::isSleeping);
        return !var2.isEmpty();
    }
}

