/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.parsing.packrat;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.util.parsing.packrat.Atom;
import net.minecraft.util.parsing.packrat.Control;
import net.minecraft.util.parsing.packrat.ErrorCollector;
import net.minecraft.util.parsing.packrat.NamedRule;
import net.minecraft.util.parsing.packrat.ParseState;
import net.minecraft.util.parsing.packrat.Scope;

public abstract class CachedParseState<S>
implements ParseState<S> {
    private b[] positionCache = new b[256];
    private final ErrorCollector<S> errorCollector;
    private final Scope scope = new Scope();
    private d[] controlCache = new d[16];
    private int nextControlToReturn;
    private final c silent = new c();

    protected CachedParseState(ErrorCollector<S> var0) {
        this.errorCollector = var0;
    }

    @Override
    public Scope scope() {
        return this.scope;
    }

    @Override
    public ErrorCollector<S> errorCollector() {
        return this.errorCollector;
    }

    @Override
    @Nullable
    public <T> T parse(NamedRule<S, T> var0) {
        a<Object> var5;
        a var4;
        int var1 = this.mark();
        b var2 = this.getCacheForPosition(var1);
        int var3 = var2.findKeyIndex(var0.name());
        if (var3 != -1) {
            var4 = var2.getValue(var3);
            if (var4 != null) {
                if (var4 == a.NEGATIVE) {
                    return null;
                }
                this.restore(var4.markAfterParse);
                return var4.value;
            }
        } else {
            var3 = var2.allocateNewEntry(var0.name());
        }
        if ((var4 = var0.value().parse(this)) == null) {
            var5 = a.negativeEntry();
        } else {
            int var6 = this.mark();
            var5 = new a(var4, var6);
        }
        var2.setValue(var3, var5);
        return (T)var4;
    }

    private b getCacheForPosition(int var0) {
        b var2;
        int var1 = this.positionCache.length;
        if (var0 >= var1) {
            int var22 = SystemUtils.growByHalf(var1, var0 + 1);
            b[] var3 = new b[var22];
            System.arraycopy(this.positionCache, 0, var3, 0, var1);
            this.positionCache = var3;
        }
        if ((var2 = this.positionCache[var0]) == null) {
            this.positionCache[var0] = var2 = new b();
        }
        return var2;
    }

    @Override
    public Control acquireControl() {
        Object var2;
        int var1;
        int var0 = this.controlCache.length;
        if (this.nextControlToReturn >= var0) {
            var1 = SystemUtils.growByHalf(var0, this.nextControlToReturn + 1);
            var2 = new d[var1];
            System.arraycopy(this.controlCache, 0, var2, 0, var0);
            this.controlCache = var2;
        }
        if ((var2 = this.controlCache[var1 = this.nextControlToReturn++]) == null) {
            this.controlCache[var1] = var2 = new d();
        } else {
            ((d)var2).reset();
        }
        return var2;
    }

    @Override
    public void releaseControl() {
        --this.nextControlToReturn;
    }

    @Override
    public ParseState<S> silent() {
        return this.silent;
    }

    static class b {
        public static final int ENTRY_STRIDE = 2;
        private static final int NOT_FOUND = -1;
        private Object[] atomCache = new Object[16];
        private int nextKey;

        b() {
        }

        public int findKeyIndex(Atom<?> var0) {
            for (int var1 = 0; var1 < this.nextKey; var1 += 2) {
                if (this.atomCache[var1] != var0) continue;
                return var1;
            }
            return -1;
        }

        public int allocateNewEntry(Atom<?> var0) {
            int var1 = this.nextKey;
            this.nextKey += 2;
            int var2 = var1 + 1;
            int var3 = this.atomCache.length;
            if (var2 >= var3) {
                int var4 = SystemUtils.growByHalf(var3, var2 + 1);
                Object[] var5 = new Object[var4];
                System.arraycopy(this.atomCache, 0, var5, 0, var3);
                this.atomCache = var5;
            }
            this.atomCache[var1] = var0;
            return var1;
        }

        @Nullable
        public <T> a<T> getValue(int var0) {
            return (a)this.atomCache[var0 + 1];
        }

        public void setValue(int var0, a<?> var1) {
            this.atomCache[var0 + 1] = var1;
        }
    }

    static class d
    implements Control {
        private boolean hasCut;

        d() {
        }

        @Override
        public void cut() {
            this.hasCut = true;
        }

        @Override
        public boolean hasCut() {
            return this.hasCut;
        }

        public void reset() {
            this.hasCut = false;
        }
    }

    class c
    implements ParseState<S> {
        private final ErrorCollector<S> silentCollector = new ErrorCollector.b();

        c() {
        }

        @Override
        public ErrorCollector<S> errorCollector() {
            return this.silentCollector;
        }

        @Override
        public Scope scope() {
            return CachedParseState.this.scope();
        }

        @Override
        @Nullable
        public <T> T parse(NamedRule<S, T> var0) {
            return CachedParseState.this.parse(var0);
        }

        @Override
        public S input() {
            return CachedParseState.this.input();
        }

        @Override
        public int mark() {
            return CachedParseState.this.mark();
        }

        @Override
        public void restore(int var0) {
            CachedParseState.this.restore(var0);
        }

        @Override
        public Control acquireControl() {
            return CachedParseState.this.acquireControl();
        }

        @Override
        public void releaseControl() {
            CachedParseState.this.releaseControl();
        }

        @Override
        public ParseState<S> silent() {
            return this;
        }
    }

    static final class a<T>
    extends Record {
        @Nullable
        final T value;
        final int markAfterParse;
        public static final a<?> NEGATIVE = new a<Object>(null, -1);

        a(@Nullable T var0, int var1) {
            this.value = var0;
            this.markAfterParse = var1;
        }

        public static <T> a<T> negativeEntry() {
            return NEGATIVE;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "value;markAfterParse", "value", "markAfterParse"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "value;markAfterParse", "value", "markAfterParse"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "value;markAfterParse", "value", "markAfterParse"}, this, var0);
        }

        @Nullable
        public T value() {
            return this.value;
        }

        public int markAfterParse() {
            return this.markAfterParse;
        }
    }
}

