/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.DataConverterAddChoices;
import net.minecraft.util.datafix.fixes.DataConverterLeaves;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.slf4j.Logger;

public class DataConverterTrappedChest
extends DataFix {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int SIZE = 4096;
    private static final short SIZE_BITS = 12;

    public DataConverterTrappedChest(Schema var0, boolean var1) {
        super(var0, var1);
    }

    public TypeRewriteRule makeRule() {
        Type var0 = this.getOutputSchema().getType(DataConverterTypes.CHUNK);
        Type var1 = var0.findFieldType("Level");
        Type var2 = var1.findFieldType("TileEntities");
        if (!(var2 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType var3 = (List.ListType)var2;
        OpticFinder var42 = DSL.fieldFinder((String)"TileEntities", (Type)var3);
        Type var5 = this.getInputSchema().getType(DataConverterTypes.CHUNK);
        OpticFinder var6 = var5.findField("Level");
        OpticFinder var7 = var6.type().findField("Sections");
        Type var8 = var7.type();
        if (!(var8 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        Type var9 = ((List.ListType)var8).getElement();
        OpticFinder var10 = DSL.typeFinder((Type)var9);
        return TypeRewriteRule.seq((TypeRewriteRule)new DataConverterAddChoices(this.getOutputSchema(), "AddTrappedChestFix", DataConverterTypes.BLOCK_ENTITY).makeRule(), (TypeRewriteRule)this.fixTypeEverywhereTyped("Trapped Chest fix", var5, var4 -> var4.updateTyped(var6, var3 -> {
            Object var4 = var3.getOptionalTyped(var7);
            if (var4.isEmpty()) {
                return var3;
            }
            List var5 = ((Typed)var4.get()).getAllTyped(var10);
            IntOpenHashSet var6 = new IntOpenHashSet();
            for (Typed var8 : var5) {
                a var9 = new a(var8, this.getInputSchema());
                if (var9.isSkippable()) continue;
                for (int var10 = 0; var10 < 4096; ++var10) {
                    int var11 = var9.getBlock(var10);
                    if (!var9.isTrappedChest(var11)) continue;
                    var6.add(var9.getIndex() << 12 | var10);
                }
            }
            Dynamic var7 = (Dynamic)var3.get(DSL.remainderFinder());
            int var8 = var7.get("xPos").asInt(0);
            int var9 = var7.get("zPos").asInt(0);
            TaggedChoice.TaggedChoiceType var10 = this.getInputSchema().findChoiceType(DataConverterTypes.BLOCK_ENTITY);
            return var3.updateTyped(var42, arg_0 -> DataConverterTrappedChest.a(var10, var8, var9, (IntSet)var6, arg_0));
        })));
    }

    private static /* synthetic */ Typed a(TaggedChoice.TaggedChoiceType var0, int var1, int var2, IntSet var3, Typed var42) {
        return var42.updateTyped(var0.finder(), var4 -> {
            int var8;
            int var7;
            Dynamic var5 = (Dynamic)var4.getOrCreate(DSL.remainderFinder());
            int var6 = var5.get("x").asInt(0) - (var1 << 4);
            if (var3.contains(DataConverterLeaves.getIndex(var6, var7 = var5.get("y").asInt(0), var8 = var5.get("z").asInt(0) - (var2 << 4)))) {
                return var4.update(var0.finder(), var02 -> var02.mapFirst(var0 -> {
                    if (!Objects.equals(var0, "minecraft:chest")) {
                        LOGGER.warn("Block Entity was expected to be a chest");
                    }
                    return "minecraft:trapped_chest";
                }));
            }
            return var4;
        });
    }

    public static final class a
    extends DataConverterLeaves.b {
        @Nullable
        private IntSet chestIds;

        public a(Typed<?> var0, Schema var1) {
            super(var0, var1);
        }

        @Override
        protected boolean skippable() {
            this.chestIds = new IntOpenHashSet();
            for (int var0 = 0; var0 < this.palette.size(); ++var0) {
                Dynamic var1 = (Dynamic)this.palette.get(var0);
                String var2 = var1.get("Name").asString("");
                if (!Objects.equals(var2, "minecraft:trapped_chest")) continue;
                this.chestIds.add(var0);
            }
            return this.chestIds.isEmpty();
        }

        public boolean isTrappedChest(int var0) {
            return this.chestIds.contains(var0);
        }
    }
}

