/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.TicketStorage;

public class SimulationChunkTracker
extends ChunkMap {
    public static final int MAX_LEVEL = 33;
    protected final Long2ByteMap chunks = new Long2ByteOpenHashMap();
    private final TicketStorage ticketStorage;

    public SimulationChunkTracker(TicketStorage var0) {
        super(34, 16, 256);
        this.ticketStorage = var0;
        var0.setSimulationChunkUpdatedListener(this::update);
        this.chunks.defaultReturnValue((byte)33);
    }

    @Override
    protected int getLevelFromSource(long var0) {
        return this.ticketStorage.getTicketLevelAt(var0, true);
    }

    public int getLevel(ChunkCoordIntPair var0) {
        return this.getLevel(var0.toLong());
    }

    @Override
    protected int getLevel(long var0) {
        return this.chunks.get(var0);
    }

    @Override
    protected void setLevel(long var0, int var2) {
        if (var2 >= 33) {
            this.chunks.remove(var0);
        } else {
            this.chunks.put(var0, (byte)var2);
        }
    }

    public void runAllUpdates() {
        this.runUpdates(Integer.MAX_VALUE);
    }
}

