/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggers;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoUpdatePacket;
import net.minecraft.network.protocol.game.PacketPlayInBlockDig;
import net.minecraft.network.protocol.game.PacketPlayOutBlockChange;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.item.enchantment.EnchantmentManager;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.GameMasterBlock;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public class PlayerInteractManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    protected WorldServer level;
    protected final EntityPlayer player;
    private EnumGamemode gameModeForPlayer = EnumGamemode.DEFAULT_MODE;
    @Nullable
    private EnumGamemode previousGameModeForPlayer;
    private boolean isDestroyingBlock;
    private int destroyProgressStart;
    private BlockPosition destroyPos = BlockPosition.ZERO;
    private int gameTicks;
    private boolean hasDelayedDestroy;
    private BlockPosition delayedDestroyPos = BlockPosition.ZERO;
    private int delayedTickStart;
    private int lastSentState = -1;

    public PlayerInteractManager(EntityPlayer var0) {
        this.player = var0;
        this.level = var0.level();
    }

    public boolean changeGameModeForPlayer(EnumGamemode var0) {
        if (var0 == this.gameModeForPlayer) {
            return false;
        }
        this.setGameModeForPlayer(var0, this.previousGameModeForPlayer);
        this.player.onUpdateAbilities();
        this.level.getServer().getPlayerList().broadcastAll(new ClientboundPlayerInfoUpdatePacket(ClientboundPlayerInfoUpdatePacket.a.UPDATE_GAME_MODE, this.player));
        this.level.updateSleepingPlayerList();
        if (var0 == EnumGamemode.CREATIVE) {
            this.player.resetCurrentImpulseContext();
        }
        return true;
    }

    protected void setGameModeForPlayer(EnumGamemode var0, @Nullable EnumGamemode var1) {
        this.previousGameModeForPlayer = var1;
        this.gameModeForPlayer = var0;
        var0.updatePlayerAbilities(this.player.getAbilities());
    }

    public EnumGamemode getGameModeForPlayer() {
        return this.gameModeForPlayer;
    }

    @Nullable
    public EnumGamemode getPreviousGameModeForPlayer() {
        return this.previousGameModeForPlayer;
    }

    public boolean isSurvival() {
        return this.gameModeForPlayer.isSurvival();
    }

    public boolean isCreative() {
        return this.gameModeForPlayer.isCreative();
    }

    public void tick() {
        ++this.gameTicks;
        if (this.hasDelayedDestroy) {
            IBlockData var0 = this.level.getBlockState(this.delayedDestroyPos);
            if (var0.isAir()) {
                this.hasDelayedDestroy = false;
            } else {
                float var1 = this.incrementDestroyProgress(var0, this.delayedDestroyPos, this.delayedTickStart);
                if (var1 >= 1.0f) {
                    this.hasDelayedDestroy = false;
                    this.destroyBlock(this.delayedDestroyPos);
                }
            }
        } else if (this.isDestroyingBlock) {
            IBlockData var0 = this.level.getBlockState(this.destroyPos);
            if (var0.isAir()) {
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.lastSentState = -1;
                this.isDestroyingBlock = false;
            } else {
                this.incrementDestroyProgress(var0, this.destroyPos, this.destroyProgressStart);
            }
        }
    }

    private float incrementDestroyProgress(IBlockData var0, BlockPosition var1, int var2) {
        int var3 = this.gameTicks - var2;
        float var4 = var0.getDestroyProgress(this.player, this.player.level(), var1) * (float)(var3 + 1);
        int var5 = (int)(var4 * 10.0f);
        if (var5 != this.lastSentState) {
            this.level.destroyBlockProgress(this.player.getId(), var1, var5);
            this.lastSentState = var5;
        }
        return var4;
    }

    private void debugLogging(BlockPosition var0, boolean var1, int var2, String var3) {
    }

    public void handleBlockBreakAction(BlockPosition var02, PacketPlayInBlockDig.EnumPlayerDigType var1, EnumDirection var2, int var3, int var4) {
        if (!this.player.canInteractWithBlock(var02, 1.0)) {
            this.debugLogging(var02, false, var4, "too far");
            return;
        }
        if (var02.getY() > var3) {
            this.player.connection.send(new PacketPlayOutBlockChange(var02, this.level.getBlockState(var02)));
            this.debugLogging(var02, false, var4, "too high");
            return;
        }
        if (var1 == PacketPlayInBlockDig.EnumPlayerDigType.START_DESTROY_BLOCK) {
            if (!this.level.mayInteract(this.player, var02)) {
                this.player.connection.send(new PacketPlayOutBlockChange(var02, this.level.getBlockState(var02)));
                this.debugLogging(var02, false, var4, "may not interact");
                return;
            }
            if (this.player.getAbilities().instabuild) {
                this.destroyAndAck(var02, var4, "creative destroy");
                return;
            }
            if (this.player.blockActionRestricted(this.level, var02, this.gameModeForPlayer)) {
                this.player.connection.send(new PacketPlayOutBlockChange(var02, this.level.getBlockState(var02)));
                this.debugLogging(var02, false, var4, "block action restricted");
                return;
            }
            this.destroyProgressStart = this.gameTicks;
            float var5 = 1.0f;
            IBlockData var6 = this.level.getBlockState(var02);
            if (!var6.isAir()) {
                EnchantmentManager.onHitBlock(this.level, this.player.getMainHandItem(), this.player, this.player, EnumItemSlot.MAINHAND, Vec3D.atCenterOf(var02), var6, var0 -> this.player.onEquippedItemBroken((Item)var0, EnumItemSlot.MAINHAND));
                var6.attack(this.level, var02, this.player);
                var5 = var6.getDestroyProgress(this.player, this.player.level(), var02);
            }
            if (!var6.isAir() && var5 >= 1.0f) {
                this.destroyAndAck(var02, var4, "insta mine");
            } else {
                if (this.isDestroyingBlock) {
                    this.player.connection.send(new PacketPlayOutBlockChange(this.destroyPos, this.level.getBlockState(this.destroyPos)));
                    this.debugLogging(var02, false, var4, "abort destroying since another started (client insta mine, server disagreed)");
                }
                this.isDestroyingBlock = true;
                this.destroyPos = var02.immutable();
                int var7 = (int)(var5 * 10.0f);
                this.level.destroyBlockProgress(this.player.getId(), var02, var7);
                this.debugLogging(var02, true, var4, "actual start of destroying");
                this.lastSentState = var7;
            }
        } else if (var1 == PacketPlayInBlockDig.EnumPlayerDigType.STOP_DESTROY_BLOCK) {
            if (var02.equals(this.destroyPos)) {
                int var5 = this.gameTicks - this.destroyProgressStart;
                IBlockData var6 = this.level.getBlockState(var02);
                if (!var6.isAir()) {
                    float var7 = var6.getDestroyProgress(this.player, this.player.level(), var02) * (float)(var5 + 1);
                    if (var7 >= 0.7f) {
                        this.isDestroyingBlock = false;
                        this.level.destroyBlockProgress(this.player.getId(), var02, -1);
                        this.destroyAndAck(var02, var4, "destroyed");
                        return;
                    }
                    if (!this.hasDelayedDestroy) {
                        this.isDestroyingBlock = false;
                        this.hasDelayedDestroy = true;
                        this.delayedDestroyPos = var02;
                        this.delayedTickStart = this.destroyProgressStart;
                    }
                }
            }
            this.debugLogging(var02, true, var4, "stopped destroying");
        } else if (var1 == PacketPlayInBlockDig.EnumPlayerDigType.ABORT_DESTROY_BLOCK) {
            this.isDestroyingBlock = false;
            if (!Objects.equals(this.destroyPos, var02)) {
                LOGGER.warn("Mismatch in destroy block pos: {} {}", (Object)this.destroyPos, (Object)var02);
                this.level.destroyBlockProgress(this.player.getId(), this.destroyPos, -1);
                this.debugLogging(var02, true, var4, "aborted mismatched destroying");
            }
            this.level.destroyBlockProgress(this.player.getId(), var02, -1);
            this.debugLogging(var02, true, var4, "aborted destroying");
        }
    }

    public void destroyAndAck(BlockPosition var0, int var1, String var2) {
        if (this.destroyBlock(var0)) {
            this.debugLogging(var0, true, var1, var2);
        } else {
            this.player.connection.send(new PacketPlayOutBlockChange(var0, this.level.getBlockState(var0)));
            this.debugLogging(var0, false, var1, var2);
        }
    }

    public boolean destroyBlock(BlockPosition var0) {
        IBlockData var4 = this.level.getBlockState(var0);
        if (!this.player.getMainHandItem().canDestroyBlock(var4, this.level, var0, this.player)) {
            return false;
        }
        TileEntity var1 = this.level.getBlockEntity(var0);
        Block var2 = var4.getBlock();
        if (var2 instanceof GameMasterBlock && !this.player.canUseGameMasterBlocks()) {
            this.level.sendBlockUpdated(var0, var4, var4, 3);
            return false;
        }
        if (this.player.blockActionRestricted(this.level, var0, this.gameModeForPlayer)) {
            return false;
        }
        IBlockData var3 = var2.playerWillDestroy(this.level, var0, var4, this.player);
        boolean var8 = this.level.removeBlock(var0, false);
        if (var8) {
            var2.destroy(this.level, var0, var3);
        }
        if (this.player.preventsBlockDrops()) {
            return true;
        }
        ItemStack var5 = this.player.getMainHandItem();
        ItemStack var6 = var5.copy();
        boolean var7 = this.player.hasCorrectToolForDrops(var3);
        var5.mineBlock(this.level, var3, var0, this.player);
        if (var8 && var7) {
            var2.playerDestroy(this.level, this.player, var0, var3, var1, var6);
        }
        return true;
    }

    public EnumInteractionResult useItem(EntityPlayer var0, World var1, ItemStack var2, EnumHand var3) {
        ItemStack var7;
        if (this.gameModeForPlayer == EnumGamemode.SPECTATOR) {
            return EnumInteractionResult.PASS;
        }
        if (var0.getCooldowns().isOnCooldown(var2)) {
            return EnumInteractionResult.PASS;
        }
        int var4 = var2.getCount();
        int var5 = var2.getDamageValue();
        EnumInteractionResult var6 = var2.use(var1, var0, var3);
        if (var6 instanceof EnumInteractionResult.d) {
            EnumInteractionResult.d var8 = (EnumInteractionResult.d)var6;
            var7 = Objects.requireNonNullElse(var8.heldItemTransformedTo(), var0.getItemInHand(var3));
        } else {
            var7 = var0.getItemInHand(var3);
        }
        if (var7 == var2 && var7.getCount() == var4 && var7.getUseDuration(var0) <= 0 && var7.getDamageValue() == var5) {
            return var6;
        }
        if (var6 instanceof EnumInteractionResult.a && var7.getUseDuration(var0) > 0 && !var0.isUsingItem()) {
            return var6;
        }
        if (var2 != var7) {
            var0.setItemInHand(var3, var7);
        }
        if (var7.isEmpty()) {
            var0.setItemInHand(var3, ItemStack.EMPTY);
        }
        if (!var0.isUsingItem()) {
            var0.inventoryMenu.sendAllDataToRemote();
        }
        return var6;
    }

    public EnumInteractionResult useItemOn(EntityPlayer var0, World var1, ItemStack var2, EnumHand var3, MovingObjectPositionBlock var4) {
        EnumInteractionResult var11;
        Object var10;
        BlockPosition var5 = var4.getBlockPos();
        IBlockData var6 = var1.getBlockState(var5);
        if (!var6.getBlock().isEnabled(var1.enabledFeatures())) {
            return EnumInteractionResult.FAIL;
        }
        if (this.gameModeForPlayer == EnumGamemode.SPECTATOR) {
            ITileInventory var7 = var6.getMenuProvider(var1, var5);
            if (var7 != null) {
                var0.openMenu(var7);
                return EnumInteractionResult.CONSUME;
            }
            return EnumInteractionResult.PASS;
        }
        boolean var7 = !var0.getMainHandItem().isEmpty() || !var0.getOffhandItem().isEmpty();
        boolean var8 = var0.isSecondaryUseActive() && var7;
        ItemStack var9 = var2.copy();
        if (!var8) {
            var10 = var6.useItemOn(var0.getItemInHand(var3), var1, var0, var3, var4);
            if (var10.consumesAction()) {
                CriterionTriggers.ITEM_USED_ON_BLOCK.trigger(var0, var5, var9);
                return var10;
            }
            if (var10 instanceof EnumInteractionResult.f && var3 == EnumHand.MAIN_HAND && (var11 = var6.useWithoutItem(var1, var0, var4)).consumesAction()) {
                CriterionTriggers.DEFAULT_BLOCK_USE.trigger(var0, var5);
                return var11;
            }
        }
        if (var2.isEmpty() || var0.getCooldowns().isOnCooldown(var2)) {
            return EnumInteractionResult.PASS;
        }
        var10 = new ItemActionContext(var0, var3, var4);
        if (var0.hasInfiniteMaterials()) {
            int var12 = var2.getCount();
            var11 = var2.useOn((ItemActionContext)var10);
            var2.setCount(var12);
        } else {
            var11 = var2.useOn((ItemActionContext)var10);
        }
        if (var11.consumesAction()) {
            CriterionTriggers.ITEM_USED_ON_BLOCK.trigger(var0, var5, var9);
        }
        return var11;
    }

    public void setLevel(WorldServer var0) {
        this.level = var0;
    }
}

