/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import javax.annotation.Nullable;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.entity.Entity;

public class PacketPlayOutAttachEntity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutAttachEntity> STREAM_CODEC = Packet.codec(PacketPlayOutAttachEntity::write, PacketPlayOutAttachEntity::new);
    private final int sourceId;
    private final int destId;

    public PacketPlayOutAttachEntity(Entity var0, @Nullable Entity var1) {
        this.sourceId = var0.getId();
        this.destId = var1 != null ? var1.getId() : 0;
    }

    private PacketPlayOutAttachEntity(PacketDataSerializer var0) {
        this.sourceId = var0.readInt();
        this.destId = var0.readInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeInt(this.sourceId);
        var0.writeInt(this.destId);
    }

    @Override
    public PacketType<PacketPlayOutAttachEntity> type() {
        return GamePacketTypes.CLIENTBOUND_SET_ENTITY_LINK;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleEntityLinkPacket(this);
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getDestId() {
        return this.destId;
    }
}

