/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Either;
import io.netty.channel.ChannelHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessAssertionPosition;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessSequence;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.context.ItemActionContext;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockButtonAbstract;
import net.minecraft.world.level.block.BlockLever;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityContainer;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;

public class GameTestHarnessHelper {
    private final GameTestHarnessInfo testInfo;
    private boolean finalCheckAdded;

    public GameTestHarnessHelper(GameTestHarnessInfo var0) {
        this.testInfo = var0;
    }

    public GameTestHarnessAssertion assertionException(IChatBaseComponent var0) {
        return new GameTestHarnessAssertion(var0, this.testInfo.getTick());
    }

    public GameTestHarnessAssertion assertionException(String var0, Object ... var1) {
        return this.assertionException(IChatBaseComponent.translatableEscape(var0, var1));
    }

    public GameTestHarnessAssertionPosition assertionException(BlockPosition var0, IChatBaseComponent var1) {
        return new GameTestHarnessAssertionPosition(var1, this.absolutePos(var0), var0, this.testInfo.getTick());
    }

    public GameTestHarnessAssertionPosition assertionException(BlockPosition var0, String var1, Object ... var2) {
        return this.assertionException(var0, IChatBaseComponent.translatableEscape(var1, var2));
    }

    public WorldServer getLevel() {
        return this.testInfo.getLevel();
    }

    public IBlockData getBlockState(BlockPosition var0) {
        return this.getLevel().getBlockState(this.absolutePos(var0));
    }

    public <T extends TileEntity> T getBlockEntity(BlockPosition var0, Class<T> var1) {
        TileEntity var2 = this.getLevel().getBlockEntity(this.absolutePos(var0));
        if (var2 == null) {
            throw this.assertionException(var0, "test.error.missing_block_entity", new Object[0]);
        }
        if (var1.isInstance(var2)) {
            return (T)((TileEntity)var1.cast(var2));
        }
        throw this.assertionException(var0, "test.error.wrong_block_entity", var2.getType().builtInRegistryHolder().getRegisteredName());
    }

    public void killAllEntities() {
        this.killAllEntitiesOfClass(Entity.class);
    }

    public void killAllEntitiesOfClass(Class<? extends Entity> var02) {
        AxisAlignedBB var1 = this.getBounds();
        List<Entity> var2 = this.getLevel().getEntitiesOfClass(var02, var1.inflate(1.0), var0 -> !(var0 instanceof EntityHuman));
        var2.forEach(var0 -> var0.kill(this.getLevel()));
    }

    public EntityItem spawnItem(Item var0, Vec3D var1) {
        WorldServer var2 = this.getLevel();
        Vec3D var3 = this.absoluteVec(var1);
        EntityItem var4 = new EntityItem(var2, var3.x, var3.y, var3.z, new ItemStack(var0, 1));
        var4.setDeltaMovement(0.0, 0.0, 0.0);
        var2.addFreshEntity(var4);
        return var4;
    }

    public EntityItem spawnItem(Item var0, float var1, float var2, float var3) {
        return this.spawnItem(var0, new Vec3D(var1, var2, var3));
    }

    public EntityItem spawnItem(Item var0, BlockPosition var1) {
        return this.spawnItem(var0, var1.getX(), var1.getY(), var1.getZ());
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, BlockPosition var1) {
        return this.spawn(var0, Vec3D.atBottomCenterOf(var1));
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, Vec3D var1) {
        Object var4;
        WorldServer var2 = this.getLevel();
        E var3 = var0.create(var2, EntitySpawnReason.STRUCTURE);
        if (var3 == null) {
            throw this.assertionException(BlockPosition.containing(var1), "test.error.spawn_failure", var0.builtInRegistryHolder().getRegisteredName());
        }
        if (var3 instanceof EntityInsentient) {
            var4 = (EntityInsentient)var3;
            ((EntityInsentient)var4).setPersistenceRequired();
        }
        var4 = this.absoluteVec(var1);
        ((Entity)var3).snapTo(((Vec3D)var4).x, ((Vec3D)var4).y, ((Vec3D)var4).z, ((Entity)var3).getYRot(), ((Entity)var3).getXRot());
        var2.addFreshEntity((Entity)var3);
        return var3;
    }

    public void hurt(Entity var0, DamageSource var1, float var2) {
        var0.hurtServer(this.getLevel(), var1, var2);
    }

    public void kill(Entity var0) {
        var0.kill(this.getLevel());
    }

    public <E extends Entity> E findOneEntity(EntityTypes<E> var0) {
        return this.findClosestEntity(var0, 0, 0, 0, 2.147483647E9);
    }

    public <E extends Entity> E findClosestEntity(EntityTypes<E> var0, int var12, int var22, int var3, double var4) {
        List<E> var6 = this.findEntities(var0, var12, var22, var3, var4);
        if (var6.isEmpty()) {
            throw this.assertionException("test.error.expected_entity_around", var0.getDescription(), var12, var22, var3);
        }
        if (var6.size() > 1) {
            throw this.assertionException("test.error.too_many_entities", var0.toShortString(), var12, var22, var3, var6.size());
        }
        Vec3D var7 = this.absoluteVec(new Vec3D(var12, var22, var3));
        var6.sort((var1, var2) -> {
            double var3 = var1.position().distanceTo(var7);
            double var5 = var2.position().distanceTo(var7);
            return Double.compare(var3, var5);
        });
        return (E)((Entity)var6.get(0));
    }

    public <E extends Entity> List<E> findEntities(EntityTypes<E> var0, int var1, int var2, int var3, double var4) {
        return this.findEntities(var0, Vec3D.atBottomCenterOf(new BlockPosition(var1, var2, var3)), var4);
    }

    public <E extends Entity> List<E> findEntities(EntityTypes<E> var0, Vec3D var12, double var2) {
        WorldServer var4 = this.getLevel();
        Vec3D var5 = this.absoluteVec(var12);
        AxisAlignedBB var6 = this.testInfo.getStructureBounds();
        AxisAlignedBB var7 = new AxisAlignedBB(var5.add(-var2, -var2, -var2), var5.add(var2, var2, var2));
        return var4.getEntities(var0, var6, var1 -> var1.getBoundingBox().intersects(var7) && var1.isAlive());
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, int var1, int var2, int var3) {
        return this.spawn(var0, new BlockPosition(var1, var2, var3));
    }

    public <E extends Entity> E spawn(EntityTypes<E> var0, float var1, float var2, float var3) {
        return this.spawn(var0, new Vec3D(var1, var2, var3));
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, BlockPosition var1) {
        EntityInsentient var2 = (EntityInsentient)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, int var1, int var2, int var3) {
        return this.spawnWithNoFreeWill(var0, new BlockPosition(var1, var2, var3));
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, Vec3D var1) {
        EntityInsentient var2 = (EntityInsentient)this.spawn(var0, var1);
        var2.removeFreeWill();
        return (E)var2;
    }

    public <E extends EntityInsentient> E spawnWithNoFreeWill(EntityTypes<E> var0, float var1, float var2, float var3) {
        return this.spawnWithNoFreeWill(var0, new Vec3D(var1, var2, var3));
    }

    public void moveTo(EntityInsentient var0, float var1, float var2, float var3) {
        Vec3D var4 = this.absoluteVec(new Vec3D(var1, var2, var3));
        var0.snapTo(var4.x, var4.y, var4.z, var0.getYRot(), var0.getXRot());
    }

    public GameTestHarnessSequence walkTo(EntityInsentient var0, BlockPosition var1, float var2) {
        return this.startSequence().thenExecuteAfter(2, () -> {
            PathEntity var3 = var0.getNavigation().createPath(this.absolutePos(var1), 0);
            var0.getNavigation().moveTo(var3, (double)var2);
        });
    }

    public void pressButton(int var0, int var1, int var2) {
        this.pressButton(new BlockPosition(var0, var1, var2));
    }

    public void pressButton(BlockPosition var0) {
        this.assertBlockTag(TagsBlock.BUTTONS, var0);
        BlockPosition var1 = this.absolutePos(var0);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        BlockButtonAbstract var3 = (BlockButtonAbstract)var2.getBlock();
        var3.press(var2, this.getLevel(), var1, null);
    }

    public void useBlock(BlockPosition var0) {
        this.useBlock(var0, this.makeMockPlayer(EnumGamemode.CREATIVE));
    }

    public void useBlock(BlockPosition var0, EntityHuman var1) {
        BlockPosition var2 = this.absolutePos(var0);
        this.useBlock(var0, var1, new MovingObjectPositionBlock(Vec3D.atCenterOf(var2), EnumDirection.NORTH, var2, true));
    }

    public void useBlock(BlockPosition var0, EntityHuman var1, MovingObjectPositionBlock var2) {
        EnumHand var5;
        BlockPosition var3 = this.absolutePos(var0);
        IBlockData var4 = this.getLevel().getBlockState(var3);
        EnumInteractionResult var6 = var4.useItemOn(var1.getItemInHand(var5 = EnumHand.MAIN_HAND), this.getLevel(), var1, var5, var2);
        if (var6.consumesAction()) {
            return;
        }
        if (var6 instanceof EnumInteractionResult.f && var4.useWithoutItem(this.getLevel(), var1, var2).consumesAction()) {
            return;
        }
        ItemActionContext var7 = new ItemActionContext(var1, var5, var2);
        var1.getItemInHand(var5).useOn(var7);
    }

    public EntityLiving makeAboutToDrown(EntityLiving var0) {
        var0.setAirSupply(0);
        var0.setHealth(0.25f);
        return var0;
    }

    public EntityLiving withLowHealth(EntityLiving var0) {
        var0.setHealth(0.25f);
        return var0;
    }

    public EntityHuman makeMockPlayer(final EnumGamemode var0) {
        return new EntityHuman(this, this.getLevel(), new GameProfile(UUID.randomUUID(), "test-mock-player")){

            @Override
            @Nonnull
            public EnumGamemode gameMode() {
                return var0;
            }

            @Override
            public boolean isClientAuthoritative() {
                return false;
            }
        };
    }

    @Deprecated(forRemoval=true)
    public EntityPlayer makeMockServerPlayerInLevel() {
        CommonListenerCookie var0 = CommonListenerCookie.createInitial(new GameProfile(UUID.randomUUID(), "test-mock-player"), false);
        EntityPlayer var1 = new EntityPlayer(this, this.getLevel().getServer(), this.getLevel(), var0.gameProfile(), var0.clientInformation()){

            @Override
            public EnumGamemode gameMode() {
                return EnumGamemode.CREATIVE;
            }
        };
        NetworkManager var2 = new NetworkManager(EnumProtocolDirection.SERVERBOUND);
        EmbeddedChannel var3 = new EmbeddedChannel(new ChannelHandler[]{var2});
        this.getLevel().getServer().getPlayerList().placeNewPlayer(var2, var1, var0);
        return var1;
    }

    public void pullLever(int var0, int var1, int var2) {
        this.pullLever(new BlockPosition(var0, var1, var2));
    }

    public void pullLever(BlockPosition var0) {
        this.assertBlockPresent(Blocks.LEVER, var0);
        BlockPosition var1 = this.absolutePos(var0);
        IBlockData var2 = this.getLevel().getBlockState(var1);
        BlockLever var3 = (BlockLever)var2.getBlock();
        var3.pull(var2, this.getLevel(), var1, null);
    }

    public void pulseRedstone(BlockPosition var0, long var1) {
        this.setBlock(var0, Blocks.REDSTONE_BLOCK);
        this.runAfterDelay(var1, () -> this.setBlock(var0, Blocks.AIR));
    }

    public void destroyBlock(BlockPosition var0) {
        this.getLevel().destroyBlock(this.absolutePos(var0), false, null);
    }

    public void setBlock(int var0, int var1, int var2, Block var3) {
        this.setBlock(new BlockPosition(var0, var1, var2), var3);
    }

    public void setBlock(int var0, int var1, int var2, IBlockData var3) {
        this.setBlock(new BlockPosition(var0, var1, var2), var3);
    }

    public void setBlock(BlockPosition var0, Block var1) {
        this.setBlock(var0, var1.defaultBlockState());
    }

    public void setBlock(BlockPosition var0, IBlockData var1) {
        this.getLevel().setBlock(this.absolutePos(var0), var1, 3);
    }

    public void setNight() {
        this.setDayTime(13000);
    }

    public void setDayTime(int var0) {
        this.getLevel().setDayTime(var0);
    }

    public void assertBlockPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertBlockPresent(Block var0, BlockPosition var12) {
        IBlockData var22 = this.getBlockState(var12);
        this.assertBlock(var12, var2 -> var22.is(var0), var1 -> IChatBaseComponent.translatable("test.error.expected_block", var0.getName(), var1.getName()));
    }

    public void assertBlockNotPresent(Block var0, int var1, int var2, int var3) {
        this.assertBlockNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertBlockNotPresent(Block var0, BlockPosition var12) {
        this.assertBlock(var12, var2 -> !this.getBlockState(var12).is(var0), var1 -> IChatBaseComponent.translatable("test.error.unexpected_block", var0.getName()));
    }

    public void assertBlockTag(TagKey<Block> var0, BlockPosition var12) {
        this.assertBlockState(var12, var1 -> var1.is(var0), var1 -> IChatBaseComponent.translatable("test.error.expected_block_tag", IChatBaseComponent.translationArg(var0.location()), var1.getBlock().getName()));
    }

    public void succeedWhenBlockPresent(Block var0, int var1, int var2, int var3) {
        this.succeedWhenBlockPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenBlockPresent(Block var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertBlockPresent(var0, var1));
    }

    public void assertBlock(BlockPosition var0, Predicate<Block> var12, Function<Block, IChatBaseComponent> var2) {
        this.assertBlockState(var0, var1 -> var12.test(var1.getBlock()), var1 -> (IChatBaseComponent)var2.apply(var1.getBlock()));
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPosition var0, IBlockState<T> var1, T var2) {
        IBlockData var3 = this.getBlockState(var0);
        boolean var4 = var3.hasProperty(var1);
        if (!var4) {
            throw this.assertionException(var0, "test.error.block_property_missing", var1.getName(), var2);
        }
        if (!var3.getValue(var1).equals(var2)) {
            throw this.assertionException(var0, "test.error.block_property_mismatch", var1.getName(), var2, var3.getValue(var1));
        }
    }

    public <T extends Comparable<T>> void assertBlockProperty(BlockPosition var0, IBlockState<T> var12, Predicate<T> var22, IChatBaseComponent var3) {
        this.assertBlockState(var0, var2 -> {
            if (!var2.hasProperty(var12)) {
                return false;
            }
            Object var3 = var2.getValue(var12);
            return var22.test(var3);
        }, var1 -> var3);
    }

    public void assertBlockState(BlockPosition var0, IBlockData var1) {
        IBlockData var2 = this.getBlockState(var0);
        if (!var2.equals(var1)) {
            throw this.assertionException(var0, "test.error.state_not_equal", var1, var2);
        }
    }

    public void assertBlockState(BlockPosition var0, Predicate<IBlockData> var1, Function<IBlockData, IChatBaseComponent> var2) {
        IBlockData var3 = this.getBlockState(var0);
        if (!var1.test(var3)) {
            throw this.assertionException(var0, var2.apply(var3));
        }
    }

    public <T extends TileEntity> void assertBlockEntityData(BlockPosition var0, Class<T> var1, Predicate<T> var2, Supplier<IChatBaseComponent> var3) {
        T var4 = this.getBlockEntity(var0, var1);
        if (!var2.test(var4)) {
            throw this.assertionException(var0, var3.get());
        }
    }

    public void assertRedstoneSignal(BlockPosition var0, EnumDirection var1, IntPredicate var2, Supplier<IChatBaseComponent> var3) {
        BlockPosition var4 = this.absolutePos(var0);
        WorldServer var5 = this.getLevel();
        IBlockData var6 = var5.getBlockState(var4);
        int var7 = var6.getSignal(var5, var4, var1);
        if (!var2.test(var7)) {
            throw this.assertionException(var0, var3.get());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (var1.isEmpty()) {
            throw this.assertionException("test.error.expected_entity_in_test", var0.getDescription());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.assertEntityPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityPresent(EntityTypes<?> var0, BlockPosition var1) {
        BlockPosition var2 = this.absolutePos(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var2), Entity::isAlive);
        if (var3.isEmpty()) {
            throw this.assertionException(var1, "test.error.expected_entity", var0.getDescription());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, AxisAlignedBB var1) {
        AxisAlignedBB var2 = this.absoluteAABB(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, var2, Entity::isAlive);
        if (var3.isEmpty()) {
            throw this.assertionException(BlockPosition.containing(var1.getCenter()), "test.error.expected_entity", var0.getDescription());
        }
    }

    public void assertEntitiesPresent(EntityTypes<?> var0, int var1) {
        List<Entity> var2 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (var2.size() != var1) {
            throw this.assertionException("test.error.expected_entity_count", var1, var0.getDescription(), var2.size());
        }
    }

    public void assertEntitiesPresent(EntityTypes<?> var0, BlockPosition var1, int var2, double var3) {
        BlockPosition var5 = this.absolutePos(var1);
        List<?> var6 = this.getEntities(var0, var1, var3);
        if (var6.size() != var2) {
            throw this.assertionException(var1, "test.error.expected_entity_count", var2, var0.getDescription(), var6.size());
        }
    }

    public void assertEntityPresent(EntityTypes<?> var0, BlockPosition var1, double var2) {
        List<?> var4 = this.getEntities(var0, var1, var2);
        if (var4.isEmpty()) {
            BlockPosition var5 = this.absolutePos(var1);
            throw this.assertionException(var1, "test.error.expected_entity", var0.getDescription());
        }
    }

    public <T extends Entity> List<T> getEntities(EntityTypes<T> var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        return this.getLevel().getEntities(var0, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
    }

    public <T extends Entity> List<T> getEntities(EntityTypes<T> var0) {
        return this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
    }

    public void assertEntityInstancePresent(Entity var0, int var1, int var2, int var3) {
        this.assertEntityInstancePresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityInstancePresent(Entity var0, BlockPosition var12) {
        BlockPosition var2 = this.absolutePos(var12);
        List<Entity> var3 = this.getLevel().getEntities(var0.getType(), new AxisAlignedBB(var2), Entity::isAlive);
        var3.stream().filter(var1 -> var1 == var0).findFirst().orElseThrow(() -> this.assertionException(var12, "test.error.expected_entity", var0.getType().getDescription()));
    }

    public void assertItemEntityCountIs(Item var0, BlockPosition var1, double var2, int var4) {
        BlockPosition var5 = this.absolutePos(var1);
        List<EntityItem> var6 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var5).inflate(var2), Entity::isAlive);
        int var7 = 0;
        for (EntityItem var9 : var6) {
            ItemStack var10 = var9.getItem();
            if (!var10.is(var0)) continue;
            var7 += var10.getCount();
        }
        if (var7 != var4) {
            throw this.assertionException(var1, "test.error.expected_items_count", var4, var0.getName(), var7);
        }
    }

    public void assertItemEntityPresent(Item var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        List<EntityItem> var5 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
        for (Entity entity : var5) {
            EntityItem var8 = (EntityItem)entity;
            if (!var8.getItem().getItem().equals(var0)) continue;
            return;
        }
        throw this.assertionException(var1, "test.error.expected_item", var0.getName());
    }

    public void assertItemEntityNotPresent(Item var0, BlockPosition var1, double var2) {
        BlockPosition var4 = this.absolutePos(var1);
        List<EntityItem> var5 = this.getLevel().getEntities(EntityTypes.ITEM, new AxisAlignedBB(var4).inflate(var2), Entity::isAlive);
        for (Entity entity : var5) {
            EntityItem var8 = (EntityItem)entity;
            if (!var8.getItem().getItem().equals(var0)) continue;
            throw this.assertionException(var1, "test.error.unexpected_item", var0.getName());
        }
    }

    public void assertItemEntityPresent(Item var0) {
        List<EntityItem> var1 = this.getLevel().getEntities(EntityTypes.ITEM, this.getBounds(), Entity::isAlive);
        for (Entity entity : var1) {
            EntityItem var4 = (EntityItem)entity;
            if (!var4.getItem().getItem().equals(var0)) continue;
            return;
        }
        throw this.assertionException("test.error.expected_item", var0.getName());
    }

    public void assertItemEntityNotPresent(Item var0) {
        List<EntityItem> var1 = this.getLevel().getEntities(EntityTypes.ITEM, this.getBounds(), Entity::isAlive);
        for (Entity entity : var1) {
            EntityItem var4 = (EntityItem)entity;
            if (!var4.getItem().getItem().equals(var0)) continue;
            throw this.assertionException("test.error.unexpected_item", var0.getName());
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0) {
        List<Entity> var1 = this.getLevel().getEntities(var0, this.getBounds(), Entity::isAlive);
        if (!var1.isEmpty()) {
            throw this.assertionException(var1.getFirst().blockPosition(), "test.error.unexpected_entity", var0.getDescription());
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.assertEntityNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, BlockPosition var1) {
        BlockPosition var2 = this.absolutePos(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, new AxisAlignedBB(var2), Entity::isAlive);
        if (!var3.isEmpty()) {
            throw this.assertionException(var1, "test.error.unexpected_entity", var0.getDescription());
        }
    }

    public void assertEntityNotPresent(EntityTypes<?> var0, AxisAlignedBB var1) {
        AxisAlignedBB var2 = this.absoluteAABB(var1);
        List<Entity> var3 = this.getLevel().getEntities(var0, var2, Entity::isAlive);
        if (!var3.isEmpty()) {
            throw this.assertionException(var3.getFirst().blockPosition(), "test.error.unexpected_entity", var0.getDescription());
        }
    }

    public void assertEntityTouching(EntityTypes<?> var0, double var12, double var3, double var5) {
        Vec3D var7 = new Vec3D(var12, var3, var5);
        Vec3D var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> var1.getBoundingBox().intersects(var8, var8);
        List<Entity> var10 = this.getLevel().getEntities(var0, this.getBounds(), var9);
        if (var10.isEmpty()) {
            throw this.assertionException("test.error.expected_entity_touching", var0.getDescription(), var8.x(), var8.y(), var8.z(), var12, var3, var5);
        }
    }

    public void assertEntityNotTouching(EntityTypes<?> var0, double var12, double var3, double var5) {
        Vec3D var7 = new Vec3D(var12, var3, var5);
        Vec3D var8 = this.absoluteVec(var7);
        Predicate<Entity> var9 = var1 -> !var1.getBoundingBox().intersects(var8, var8);
        List<Entity> var10 = this.getLevel().getEntities(var0, this.getBounds(), var9);
        if (var10.isEmpty()) {
            throw this.assertionException("test.error.expected_entity_not_touching", var0.getDescription(), var8.x(), var8.y(), var8.z(), var12, var3, var5);
        }
    }

    public <E extends Entity, T> void assertEntityData(BlockPosition var0, EntityTypes<E> var1, Predicate<E> var2) {
        BlockPosition var3 = this.absolutePos(var0);
        List<Entity> var4 = this.getLevel().getEntities(var1, new AxisAlignedBB(var3), Entity::isAlive);
        if (var4.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_entity", var1.getDescription());
        }
        for (Entity var6 : var4) {
            if (var2.test(var6)) continue;
            throw this.assertionException(var6.blockPosition(), "test.error.expected_entity_data_predicate", var6.getName());
        }
    }

    public <E extends Entity, T> void assertEntityData(BlockPosition var0, EntityTypes<E> var1, Function<? super E, T> var2, @Nullable T var3) {
        BlockPosition var4 = this.absolutePos(var0);
        List<Entity> var5 = this.getLevel().getEntities(var1, new AxisAlignedBB(var4), Entity::isAlive);
        if (var5.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_entity", var1.getDescription());
        }
        for (Entity var7 : var5) {
            T var8 = var2.apply(var7);
            if (Objects.equals(var8, var3)) continue;
            throw this.assertionException(var0, "test.error.expected_entity_data", var3, var8);
        }
    }

    public <E extends EntityLiving> void assertEntityIsHolding(BlockPosition var0, EntityTypes<E> var1, Item var2) {
        BlockPosition var3 = this.absolutePos(var0);
        List<EntityLiving> var4 = this.getLevel().getEntities(var1, new AxisAlignedBB(var3), Entity::isAlive);
        if (var4.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_entity", var1.getDescription());
        }
        for (EntityLiving var6 : var4) {
            if (!var6.isHolding(var2)) continue;
            return;
        }
        throw this.assertionException(var0, "test.error.expected_entity_holding", var2.getName());
    }

    public <E extends Entity> void assertEntityInventoryContains(BlockPosition var02, EntityTypes<E> var12, Item var2) {
        BlockPosition var3 = this.absolutePos(var02);
        List<Entity> var4 = this.getLevel().getEntities(var12, new AxisAlignedBB(var3), var0 -> ((Entity)var0).isAlive());
        if (var4.isEmpty()) {
            throw this.assertionException(var02, "test.error.expected_entity", var12.getDescription());
        }
        for (Entity var6 : var4) {
            if (!((InventoryCarrier)((Object)var6)).getInventory().hasAnyMatching(var1 -> var1.is(var2))) continue;
            return;
        }
        throw this.assertionException(var02, "test.error.expected_entity_having", var2.getName());
    }

    public void assertContainerEmpty(BlockPosition var0) {
        TileEntityContainer var1 = this.getBlockEntity(var0, TileEntityContainer.class);
        if (!var1.isEmpty()) {
            throw this.assertionException(var0, "test.error.expected_empty_container", new Object[0]);
        }
    }

    public void assertContainerContainsSingle(BlockPosition var0, Item var1) {
        TileEntityContainer var2 = this.getBlockEntity(var0, TileEntityContainer.class);
        if (var2.countItem(var1) != 1) {
            throw this.assertionException(var0, "test.error.expected_container_contents_single", var1.getName());
        }
    }

    public void assertContainerContains(BlockPosition var0, Item var1) {
        TileEntityContainer var2 = this.getBlockEntity(var0, TileEntityContainer.class);
        if (var2.countItem(var1) == 0) {
            throw this.assertionException(var0, "test.error.expected_container_contents", var1.getName());
        }
    }

    public void assertSameBlockStates(StructureBoundingBox var0, BlockPosition var1) {
        BlockPosition.betweenClosedStream(var0).forEach(var2 -> {
            BlockPosition var3 = var1.offset(var2.getX() - var0.minX(), var2.getY() - var0.minY(), var2.getZ() - var0.minZ());
            this.assertSameBlockState((BlockPosition)var2, var3);
        });
    }

    public void assertSameBlockState(BlockPosition var0, BlockPosition var1) {
        IBlockData var3;
        IBlockData var2 = this.getBlockState(var0);
        if (var2 != (var3 = this.getBlockState(var1))) {
            throw this.assertionException(var0, "test.error.state_not_equal", var3, var2);
        }
    }

    public void assertAtTickTimeContainerContains(long var0, BlockPosition var2, Item var3) {
        this.runAtTickTime(var0, () -> this.assertContainerContainsSingle(var2, var3));
    }

    public void assertAtTickTimeContainerEmpty(long var0, BlockPosition var2) {
        this.runAtTickTime(var0, () -> this.assertContainerEmpty(var2));
    }

    public <E extends Entity, T> void succeedWhenEntityData(BlockPosition var0, EntityTypes<E> var1, Function<E, T> var2, T var3) {
        this.succeedWhen(() -> this.assertEntityData(var0, var1, var2, var3));
    }

    public void assertEntityPosition(Entity var0, AxisAlignedBB var1, IChatBaseComponent var2) {
        if (!var1.contains(this.relativeVec(var0.position()))) {
            throw this.assertionException(var2);
        }
    }

    public <E extends Entity> void assertEntityProperty(E var0, Predicate<E> var1, IChatBaseComponent var2) {
        if (!var1.test(var0)) {
            throw this.assertionException(var0.blockPosition(), "test.error.entity_property", var0.getName(), var2);
        }
    }

    public <E extends Entity, T> void assertEntityProperty(E var0, Function<E, T> var1, T var2, IChatBaseComponent var3) {
        T var4 = var1.apply(var0);
        if (!var4.equals(var2)) {
            throw this.assertionException(var0.blockPosition(), "test.error.entity_property_details", var0.getName(), var3, var4, var2);
        }
    }

    public void assertLivingEntityHasMobEffect(EntityLiving var0, Holder<MobEffectList> var1, int var2) {
        MobEffect var3 = var0.getEffect(var1);
        if (var3 == null || var3.getAmplifier() != var2) {
            throw this.assertionException("test.error.expected_entity_effect", var0.getName(), PotionContents.getPotionDescription(var1, var2));
        }
    }

    public void succeedWhenEntityPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenEntityPresent(EntityTypes<?> var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertEntityPresent(var0, var1));
    }

    public void succeedWhenEntityNotPresent(EntityTypes<?> var0, int var1, int var2, int var3) {
        this.succeedWhenEntityNotPresent(var0, new BlockPosition(var1, var2, var3));
    }

    public void succeedWhenEntityNotPresent(EntityTypes<?> var0, BlockPosition var1) {
        this.succeedWhen(() -> this.assertEntityNotPresent(var0, var1));
    }

    public void succeed() {
        this.testInfo.succeed();
    }

    private void ensureSingleFinalCheck() {
        if (this.finalCheckAdded) {
            throw new IllegalStateException("This test already has final clause");
        }
        this.finalCheckAdded = true;
    }

    public void succeedIf(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(0L, var0).thenSucceed();
    }

    public void succeedWhen(Runnable var0) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0).thenSucceed();
    }

    public void succeedOnTickWhen(int var0, Runnable var1) {
        this.ensureSingleFinalCheck();
        this.testInfo.createSequence().thenWaitUntil(var0, var1).thenSucceed();
    }

    public void runAtTickTime(long var0, Runnable var2) {
        this.testInfo.setRunAtTickTime(var0, var2);
    }

    public void runAfterDelay(long var0, Runnable var2) {
        this.runAtTickTime((long)this.testInfo.getTick() + var0, var2);
    }

    public void randomTick(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        WorldServer var2 = this.getLevel();
        var2.getBlockState(var1).randomTick(var2, var1, var2.random);
    }

    public void tickBlock(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        WorldServer var2 = this.getLevel();
        var2.getBlockState(var1).tick(var2, var1, var2.random);
    }

    public void tickPrecipitation(BlockPosition var0) {
        BlockPosition var1 = this.absolutePos(var0);
        WorldServer var2 = this.getLevel();
        var2.tickPrecipitation(var1);
    }

    public void tickPrecipitation() {
        AxisAlignedBB var0 = this.getRelativeBounds();
        int var1 = (int)Math.floor(var0.maxX);
        int var2 = (int)Math.floor(var0.maxZ);
        int var3 = (int)Math.floor(var0.maxY);
        for (int var4 = (int)Math.floor(var0.minX); var4 < var1; ++var4) {
            for (int var5 = (int)Math.floor(var0.minZ); var5 < var2; ++var5) {
                this.tickPrecipitation(new BlockPosition(var4, var3, var5));
            }
        }
    }

    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        BlockPosition var3 = this.absolutePos(new BlockPosition(var1, 0, var2));
        return this.relativePos(this.getLevel().getHeightmapPos(var0, var3)).getY();
    }

    public void fail(IChatBaseComponent var0, BlockPosition var1) {
        throw this.assertionException(var1, var0);
    }

    public void fail(IChatBaseComponent var0, Entity var1) {
        throw this.assertionException(var1.blockPosition(), var0);
    }

    public void fail(IChatBaseComponent var0) {
        throw this.assertionException(var0);
    }

    public void failIf(Runnable var0) {
        this.testInfo.createSequence().thenWaitUntil(var0).thenFail(() -> this.assertionException("test.error.fail", new Object[0]));
    }

    public void failIfEver(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public GameTestHarnessSequence startSequence() {
        return this.testInfo.createSequence();
    }

    public BlockPosition absolutePos(BlockPosition var0) {
        BlockPosition var1 = this.testInfo.getTestOrigin();
        BlockPosition var2 = var1.offset(var0);
        return DefinedStructure.transform(var2, EnumBlockMirror.NONE, this.testInfo.getRotation(), var1);
    }

    public BlockPosition relativePos(BlockPosition var0) {
        BlockPosition var1 = this.testInfo.getTestOrigin();
        EnumBlockRotation var2 = this.testInfo.getRotation().getRotated(EnumBlockRotation.CLOCKWISE_180);
        BlockPosition var3 = DefinedStructure.transform(var0, EnumBlockMirror.NONE, var2, var1);
        return var3.subtract(var1);
    }

    public AxisAlignedBB absoluteAABB(AxisAlignedBB var0) {
        Vec3D var1 = this.absoluteVec(var0.getMinPosition());
        Vec3D var2 = this.absoluteVec(var0.getMaxPosition());
        return new AxisAlignedBB(var1, var2);
    }

    public AxisAlignedBB relativeAABB(AxisAlignedBB var0) {
        Vec3D var1 = this.relativeVec(var0.getMinPosition());
        Vec3D var2 = this.relativeVec(var0.getMaxPosition());
        return new AxisAlignedBB(var1, var2);
    }

    public Vec3D absoluteVec(Vec3D var0) {
        Vec3D var1 = Vec3D.atLowerCornerOf(this.testInfo.getTestOrigin());
        return DefinedStructure.transform(var1.add(var0), EnumBlockMirror.NONE, this.testInfo.getRotation(), this.testInfo.getTestOrigin());
    }

    public Vec3D relativeVec(Vec3D var0) {
        Vec3D var1 = Vec3D.atLowerCornerOf(this.testInfo.getTestOrigin());
        return DefinedStructure.transform(var0.subtract(var1), EnumBlockMirror.NONE, this.testInfo.getRotation(), this.testInfo.getTestOrigin());
    }

    public EnumBlockRotation getTestRotation() {
        return this.testInfo.getRotation();
    }

    public void assertTrue(boolean var0, IChatBaseComponent var1) {
        if (!var0) {
            throw this.assertionException(var1);
        }
    }

    public <N> void assertValueEqual(N var0, N var1, IChatBaseComponent var2) {
        if (!var0.equals(var1)) {
            throw this.assertionException("test.error.value_not_equal", var2, var0, var1);
        }
    }

    public void assertFalse(boolean var0, IChatBaseComponent var1) {
        this.assertTrue(!var0, var1);
    }

    public long getTick() {
        return this.testInfo.getTick();
    }

    public AxisAlignedBB getBounds() {
        return this.testInfo.getStructureBounds();
    }

    private AxisAlignedBB getRelativeBounds() {
        AxisAlignedBB var0 = this.testInfo.getStructureBounds();
        EnumBlockRotation var1 = this.testInfo.getRotation();
        switch (var1) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                return new AxisAlignedBB(0.0, 0.0, 0.0, var0.getZsize(), var0.getYsize(), var0.getXsize());
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.0, var0.getXsize(), var0.getYsize(), var0.getZsize());
    }

    public void forEveryBlockInStructure(Consumer<BlockPosition> var0) {
        AxisAlignedBB var1 = this.getRelativeBounds().contract(1.0, 1.0, 1.0);
        BlockPosition.MutableBlockPosition.betweenClosedStream(var1).forEach(var0);
    }

    public void onEachTick(Runnable var0) {
        LongStream.range(this.testInfo.getTick(), this.testInfo.getTimeoutTicks()).forEach(var1 -> this.testInfo.setRunAtTickTime(var1, var0::run));
    }

    public void placeAt(EntityHuman var0, ItemStack var1, BlockPosition var2, EnumDirection var3) {
        BlockPosition var4 = this.absolutePos(var2.relative(var3));
        MovingObjectPositionBlock var5 = new MovingObjectPositionBlock(Vec3D.atCenterOf(var4), var3, var4, false);
        ItemActionContext var6 = new ItemActionContext(var0, EnumHand.MAIN_HAND, var5);
        var1.useOn(var6);
    }

    public void setBiome(ResourceKey<BiomeBase> var0) {
        AxisAlignedBB var1 = this.getBounds();
        BlockPosition var2 = BlockPosition.containing(var1.minX, var1.minY, var1.minZ);
        BlockPosition var3 = BlockPosition.containing(var1.maxX, var1.maxY, var1.maxZ);
        Either<Integer, CommandSyntaxException> var4 = FillBiomeCommand.fill(this.getLevel(), var2, var3, this.getLevel().registryAccess().lookupOrThrow(Registries.BIOME).getOrThrow(var0));
        if (var4.right().isPresent()) {
            throw this.assertionException("test.error.set_biome", new Object[0]);
        }
    }
}

